<html>
<!-- $RCSfile: MS-DALOG.TPL $ $Revision: 1.1 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Drive Array Logical Drive Information</title>

<script language="JavaScript">
   writeAccess = (2 & <!cpqDaLogDrvBlinkTime.access>) != 0;
   if (writeAccess) noAutoRefresh = 1;
</script>

<!#/COMMON/JPN/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqDaCntlrEntry>
<!cpqDaLogDrvEntry>
<!cpqDaSpareEntry>
<!cpqDaPhyDrvEntry>
<!cpqDaLogDrvPerfEntry>
<!cpqDaLogDrvPhyDrvIDs.raw>
<!cpqDaLogDrvAvailSpares.raw>

<!#/COMMON/JPN/COND.JS>
<!#/COMMON/JPN/STDITEMS.JS>
<!#/COMMON/JPN/TABLES.JS>
<!#/COMMON/JPN/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#DAENUMS.JS>
<!#MS-DACMN.JS>

postfix["cpqDaLogDrvPerfTotalIO"]        = "/b";
postfix["cpqDaLogDrvPerfReads"]          = "/b";
postfix["cpqDaLogDrvPerfWrites"]         = "/b";
postfix["cpqDaLogDrvPerfSectorsRead"]    = "/b";
postfix["cpqDaLogDrvPerfSectorsWritten"] = "/b";
postfix["cpqDaLogDrvSize"]               = "MB";
postfix["cpqDaLogDrvStripeSize"]         = "KB";

function getIndex(form, ctlIndex, drvIndex)
{
   form.INDEX.value = parseInt(ctlIndex) + "." + parseInt(drvIndex);
   return true;
}
function getReplacedDrive(idx, ctlIndex)
{
   var i, drive = "N/A";
   if (idx != "" && idx >= 0)
   {
      for (i = 0; i < cpqDaPhyDrvEntry.length; i++)
         if (cpqDaPhyDrvEntry[i].cpqDaPhyDrvCntlrIndex == ctlIndex &&
             cpqDaPhyDrvEntry[i].cpqDaPhyDrvIndex == idx)
         {
            drive = makeLink("CQMGSTOR/MS-DAPHY.TPL?index=" + i, phyDrvName(i), "_self");
            break;
         }
   }
   return drive;
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index");

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqDaLogDrvEntry.length)
{
   reportMissingArgs();
}
else
{
   thisDrv  = cpqDaLogDrvEntry[idx];
   driveIdx = thisDrv.cpqDaLogDrvIndex;
   cntlrIdx = thisDrv.cpqDaLogDrvCntlrIndex;
   thisPerf = null;

   for (i = 0; i < cpqDaLogDrvPerfEntry.length; i++)
   {
      if (cpqDaLogDrvPerfEntry[i].cpqDaLogDrvPerfCntlrIndex == cntlrIdx &&
          cpqDaLogDrvPerfEntry[i].cpqDaLogDrvPerfIndex == driveIdx)
      {
         thisPerf = cpqDaLogDrvPerfEntry[i];
         break;
      }
   }
   for (i = 0; i < cpqDaCntlrEntry.length; i++)
   {
      if (cpqDaCntlrEntry[i].cpqDaCntlrIndex == cntlrIdx)
      {
         cntlrName = daCntlrBoardName(i);
         thisCntlr = cpqDaCntlrEntry[i];
         break;
      }
   }
   driveCondition = new cpqCondition(thisDrv.cpqDaLogDrvCondition);
   writePageHead(cntlrName, "/WEBAGENT/IMAGES/MASSHDR.GIF", "_hCu");

   if (thisPerf == null)
   {
      totalIo = "N/A";
      reads = "N/A";
      writes = "N/A";
      sectorsRead = "N/A";
      sectorsWritten = "N/A";
   } else {
      totalIo = displayItem("cpqDaLogDrvPerfTotalIO", thisPerf.cpqDaLogDrvPerfTotalIO);
      reads = displayItem("cpqDaLogDrvPerfReads", thisPerf.cpqDaLogDrvPerfReads);
      writes = displayItem("cpqDaLogDrvPerfWrites", thisPerf.cpqDaLogDrvPerfWrites);
      sectorsRead = displayItem("cpqDaLogDrvPerfSectorsRead", thisPerf.cpqDaLogDrvPerfSectorsRead);
      sectorsWritten = displayItem("cpqDaLogDrvPerfSectorsWritten", thisPerf.cpqDaLogDrvPerfSectorsWritten);
   }
   writeTableLabel(driveCondition.image() + logDrvName(idx));
   writeTableHead();
   writeDoubleTableRow("Xe[^X:", displayItem("cpqDaLogDrvStatus", thisDrv.cpqDaLogDrvStatus),
                       "v:", totalIo);
   writeDoubleTableRow("tH[g gX:", displayItem("cpqDaLogDrvFaultTol", thisDrv.cpqDaLogDrvFaultTol),
                       "[h:", reads);
   writeDoubleTableRow("e:", daDriveCapacity("cpqDaLogDrvSize", thisDrv.cpqDaLogDrvSize),
                       "Cg:", writes);
   writeDoubleTableRow("ANZ[^:", displayItem("cpqDaLogDrvHasAccel", thisDrv.cpqDaLogDrvHasAccel),
                       "[hZN^:", sectorsRead);
   writeDoubleTableRow("XgCvTCY:", displayItem("cpqDaLogDrvStripeSize", thisDrv.cpqDaLogDrvStripeSize),
                       "CgZN^:", sectorsWritten);

   if (thisDrv.cpqDaLogDrvStatus == 12)  operation = "g";
   else  operation = "č\z";

   if (typeof(thisDrv.cpqDaLogDrvPercentRebuild != "undefined") &&
       thisDrv.cpqDaLogDrvPercentRebuild != "")
   {
      rebuildCaption = operation + "(%):";
      rebuildData = percentGraph(thisDrv.cpqDaLogDrvPercentRebuild);
   } else {
      rebuildCaption = operation + " cubN:";
      rebuildData = displayItem("cpqDaLogDrvRebuildBlks", thisDrv.cpqDaLogDrvRebuildBlks);
   }
   if (thisDrv.cpqDaLogDrvStatus != 7)
      writeDoubleTableRow(rebuildCaption, rebuildData, "", "");
   else
      writeDoubleTableRow(rebuildCaption, rebuildData,
         "č\zhCu:", getReplacedDrive(thisDrv.cpqDaLogDrvRebuildingPhyDrv, cntlrIdx));
   writeTableTail();
   document.write("<br>");

   if (thisDrv.cpqDaLogDrvBlinkTime != "" && thisDrv.cpqDaLogDrvBlinkTime < 4294967295)
   {
      writeTableLabel("hCu");
      writeTableHead();
      if (writeAccess)
      {
         if (thisDrv.cpqDaLogDrvBlinkTime > 1)
            document.write("<tr><form action='MS-DALOG.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqDaLogDrvCntlrIndex, thisDrv.cpqDaLogDrvIndex);'>",
              "<input type='hidden' name='TABLESET' value='1'><input type='hidden' name='INDEX' value=''>",
              "<input type='hidden' name='cpqDaLogDrvBlinkTime' value='1'><td align='center' width='50%'>",
              "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'></td>",
              "<td align='center'><input type='submit' value='~'></td></form></tr>");
         else  // Not blinking
            document.write("<tr><form action='MS-DALOG.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqDaLogDrvCntlrIndex, thisDrv.cpqDaLogDrvIndex);'>",
              "<td align='center' width='50%'><input type='hidden' name='TABLESET' value='1'>",
              "<input type='hidden' name='INDEX' value=''><small>hCuCg_ </small>",
              "<select name='cpqDaLogDrvBlinkTime'>",
              "<option value='600'>1 <option value='1200'>2 <option value='1800'>3 ",
              "<option value='2400'>4 <option value='3000' selected>5 <option value='6000'>10 ",
              "<option value='12000'>20 <option value='18000'>30 <option value='24000'>40 ",
              "<option value='30000'>50 <option value='36000'>1 </select></td>",
              "<td align='center'><input type='submit' value='Jn'></td>",
              "</form></tr>");
      }
      else  // Read only
      {
        if (thisDrv.cpqDaLogDrvBlinkTime > 1)
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'>";
         else
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRIVE.GIF' width='72' height='42' border='0'>";

         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small>Ǘ҂܂̓Iy[^݂̂A",
            "hCuʂ̂߂ɃhCuCg_ł邱Ƃł܂Bڂ<b>wv</b>QƂĂB</small></td></tr>");
      }
      writeTableTail();
      document.write("<br>");
   }
   writeTableLabel("hCu");
   writeTableHead();
   rawData = cpqDaLogDrvPhyDrvIDs[idx];
   phyDrvCondition = new cpqCondition(1);
   phyDrvCount = 0;

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqDaPhyDrvEntry.length; j++)
      {
         if (cpqDaPhyDrvEntry[j].cpqDaPhyDrvCntlrIndex == thisCntlr.cpqDaCntlrIndex &&
             cpqDaPhyDrvEntry[j].cpqDaPhyDrvIndex == rawData[i])
         {
            phyDrvCondition.set(cpqDaPhyDrvEntry[j].cpqDaPhyDrvCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-DAPHY.TPL?index=" + j;
            writeStatusNameTable(makeLink(phyLink, phyDrvCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, phyDrvName(j), "_self"));
            document.write("</td></tr>");
            phyDrvCount++;
            break;
         }
      }
   }
   if (phyDrvCount == 0) writeOneItemTableRow("Ȃ");
   writeTableTail();
   document.write("<br>");

   writeTableLabel("XyAhCu");
   writeTableHead();
   rawData = cpqDaLogDrvAvailSpares[idx];
   phyDrvCondition = new cpqCondition(1);
   phyDrvCount = 0;

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqDaPhyDrvEntry.length; j++)
      {
         if (cpqDaPhyDrvEntry[j].cpqDaPhyDrvCntlrIndex == thisCntlr.cpqDaCntlrIndex &&
             cpqDaPhyDrvEntry[j].cpqDaPhyDrvIndex == rawData[i])
         {
            phyDrvCondition.set(cpqDaPhyDrvEntry[j].cpqDaPhyDrvCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-DAPHY.TPL?index=" + j;
            writeStatusNameTable(makeLink(phyLink, phyDrvCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, phyDrvName(j), "_self"));
            document.write("</td></tr>");
            phyDrvCount++;
            break;
         }
      }
   }
   if (phyDrvCount == 0) writeOneItemTableRow("Ȃ");
   writeTableTail();
}
writeBodyTail();
</script>
</html>
