// $Id: NC-CMMN.JS,v 1.12 2003/08/27 22:48:27 tonycu Exp $
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->


var logicalSpeed;  // this is where i'm declaring the global variable
var ifVlanId;
var ifVlanName;

function physName( physIndex )
{
   var i, j;
   var pname = "P NIC";

   for(i=0; i<cpqNicIfPhysAdapterEntry.length; i++)
   {
      if( physIndex == cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterIndex )
      {
         break;
      }
   }

   if(i < cpqNicIfPhysAdapterEntry.length)
   {

      // create an object that mimics an entry in the nicinfotable to fake out the
      // function getModelName from the older NIC stuff
      nic = new Object;
      nic.ioaddr = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterIoAddr;
			nic.memaddr = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterMemAddr;
      nic.memtype = 2;

      if(nic.ioaddr == 0)    //=0 -> memory mapped i/o  (jo012500)
      {
        nic.ioaddr = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterMemAddr;
        nic.memtype = 3;
      }

      
      nic.slot = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterSlot;

      for(j=0;j<cpqNicIfPhysAdapterEntry.length; j++)
      {
         if( physIndex!=cpqNicIfPhysAdapterEntry[j].cpqNicIfPhysAdapterIndex &&
             nic.slot == cpqNicIfPhysAdapterEntry[j].cpqNicIfPhysAdapterSlot )
             {
               nic.needport = true;
               nic.port = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterPort;
             }
      }

      if( -1==nic.slot || 4294967295==nic.slot){  // old way was 0 for both embedded and unknown
		  nic.real_slot = nic.slot;
         nic.slot = 0;     // new way has 0 for embedded and 255 for unknown
		}
      pname = buildString( nic );
   }

   return pname;
}



function nicName( logNicIndex )
{
   var i,j;
   var logName = "s NIC";
   var ifnum;

   for(i=0; i<cpqNicIfLogMapEntry.length; i++)
   {
      if( cpqNicIfLogMapEntry[i].cpqNicIfLogMapIndex == logNicIndex )
      {
         break;
      }
   }

   if( i < cpqNicIfLogMapEntry.length )
   {
      ifnum=0;
      for(j=0; j<4 && j<cpqNicIfLogMapIfNumber[i].length; j++)
      {
         ifnum += cpqNicIfLogMapIfNumber[i][j] << 8*j;
      }
var ifnumDisplay = ifnum.toString(16);

      if( cpqNicIfLogMapEntry[i].cpqNicIfLogMapGroupType > 2 )
      {
         logName = cpqNicIfLogMapEntry[i].cpqNicIfLogMapDescription;
         if(""==logName)
         {
            logName = dispBase("cpqNicIfLogMapGroupType", cpqNicIfLogMapEntry[i].cpqNicIfLogMapGroupType);
         }

         logName = logName + " (" + ifnumDisplay + ")";
      }
      else if( 0 == cpqNicIfLogMapEntry[i].cpqNicIfLogMapAdapterCount )
      {
         logName = "z C^tF[X " + ifnumDisplay;
      }
      else
      {
         logName = physName( cpqNicIfLogMapPhysicalAdapters[i][0] );
      }

   }

   return logName;
}



function writeControllerInfo( physindex )
{
   with( cpqNicIfPhysAdapterEntry[physindex] )
   {
      var model;
      var nic = new Object;
      var label;
      var nicType;
      var ifindex;
      var i;
      var slot;

      // fake out old getModelName function by creating a nic object and
      // putting in the necessary members to have that function work
      nic.ioaddr = cpqNicIfPhysAdapterIoAddr;
			nic.memaddr = cpqNicIfPhysAdapterMemAddr;
      nic.memtype = 2;
      if(nic.ioaddr == 0)    //=0 -> memory mapped i/o  (jo012500)
      {
    nic.ioaddr = cpqNicIfPhysAdapterMemAddr;
    nic.memtype = 3;
      }
      nic.slot = -1==cpqNicIfPhysAdapterSlot || 4294967295==cpqNicIfPhysAdapterSlot ? 0 : cpqNicIfPhysAdapterSlot;  // new way is 0->embedded, -1->unknown old was 0 for both
		nic.real_slot = cpqNicIfPhysAdapterSlot;
      model = getModelName( nic );
      if(""==model)  model = "s";

      label = "Rg[";
      nicType = 1;
      if( 3 < window.cpqNicIfPhysAdapterIfNumber[physindex].length )
      {
         ifindex=0;
         for(i=0;i<4;i++)
         {
            ifindex += window.cpqNicIfPhysAdapterIfNumber[physindex][i] << (4*i);
         }
         for(i=0;i<ifEntry.length;i++)
         {
            if( ifindex == ifEntry[i].ifIndex )
            {
               nicType = ifEntry[i].ifType;
               break;
            }
         }
      }

      if(1<nicType)
      {
         label = displayItem("ifType", nicType) + " " + label;
      }

      writeTableLabel( label );
      writeTableHead();
      writeSingleTableRowInDoubleTable(
         "f:",   model
         );
      writeDoubleTableRow(
         "Xe[^X:",  displayItem( "cpqNicIfPhysAdapterStatus", cpqNicIfPhysAdapterStatus),
         "@\:",    displayItem( "cpqNicIfPhysAdapterRole",   cpqNicIfPhysAdapterRole)
         );

      slot = displayItem( "cpqNicIfPhysAdapterSlot",   cpqNicIfPhysAdapterSlot);
      if(-1==slot || 4294967295==slot)
         slot = "s";
      else if(0==slot)
         slot = "";

      writeDoubleTableRow(
         "Xbg:", slot,
         "|[g:", displayItem( "cpqNicIfPhysAdapterPort",   cpqNicIfPhysAdapterPort)
         );

//code block below must be exactly like this to work in both Netscape and IE browsers
      if(0>cpqNicIfPhysAdapterMemAddr)
      {
            cpqNicIfPhysAdapterMemAddr = - cpqNicIfPhysAdapterMemAddr;
            cpqNicIfPhysAdapterMemAddr = (0xFFFFFFFF+1) - cpqNicIfPhysAdapterMemAddr ;
      }
      upperMemAddr = (cpqNicIfPhysAdapterMemAddr >> 4) & 0xfffffff;
      lowerMemAddr = cpqNicIfPhysAdapterMemAddr & 0xf;
      hexMemAddr = upperMemAddr.toString(16).toUpperCase() + lowerMemAddr.toString(16).toUpperCase() + "h";
//end block

      writeDoubleTableRow(
         "Sd:",        displayItem( "cpqNicIfPhysAdapterDuplexState",  cpqNicIfPhysAdapterDuplexState),
         "x[X AhX:",  0==cpqNicIfPhysAdapterMemAddr ? "N/A" : hexMemAddr
         );
      writeDoubleTableRow(
         "x[XI/O AhX:", 0==cpqNicIfPhysAdapterIoAddr ? "N/A" : (cpqNicIfPhysAdapterIoAddr-0).toString(16) + "h",
         "DMA `l:",   displayItem( "cpqNicIfPhysAdapterDma",  cpqNicIfPhysAdapterDma)
         );
      writeDoubleTableRow(
         "IRQ:",              0==cpqNicIfPhysAdapterIrq ? "N/A" : cpqNicIfPhysAdapterIrq,
         "AhX:", rawToHex( window.cpqNicIfPhysAdapterMACAddress[physindex], " ")
         );

      if(1 == cpqNicIfPhysAdapterStatsValid)
      {
         writeSingleTableRowInDoubleTable( "&#160", "&#160" );
         writeDoubleTableRow( "<u>Mv</u>",  "&#160", "<u>Mv</u>",  "&#160");
         writeDoubleTableRow(
            "ǍDt[:",   displayItem("cpqNicIfPhysAdapterGoodReceives", cpqNicIfPhysAdapterGoodReceives),
            "ǍDt[:",   displayItem("cpqNicIfPhysAdapterGoodTransmits", cpqNicIfPhysAdapterGoodTransmits)
            );
         writeDoubleTableRow(
            "sǃt[:",   displayItem("cpqNicIfPhysAdapterBadReceives", cpqNicIfPhysAdapterBadReceives),
            "sǃt[:",   displayItem("cpqNicIfPhysAdapterBadTransmits", cpqNicIfPhysAdapterBadTransmits)
            );
         writeDoubleTableRow(
            "ACg G[:",   displayItem("cpqNicIfPhysAdapterAlignmentErrors", cpqNicIfPhysAdapterAlignmentErrors),
            "LAoG[:",   displayItem("cpqNicIfPhysAdapterCarrierSenseErrors", cpqNicIfPhysAdapterCarrierSenseErrors)
            );
         writeDoubleTableRow(
            "ߑt[:",   displayItem("cpqNicIfPhysAdapterFrameTooLongs", cpqNicIfPhysAdapterFrameTooLongs),
            "dՓ˃t[:",   displayItem("cpqNicIfPhysAdapterMultipleCollisionFrames", cpqNicIfPhysAdapterMultipleCollisionFrames)
            );
         writeDoubleTableRow(
            "FCS G[:",   displayItem("cpqNicIfPhysAdapterFCSErrors", cpqNicIfPhysAdapterFCSErrors),
            "xՓː:",   displayItem("cpqNicIfPhysAdapterLateCollisions", cpqNicIfPhysAdapterLateCollisions)
            );
         writeDoubleTableRow(
            "MAC MG[:",   displayItem("cpqNicIfPhysAdapterInternalMacReceiveErrors", cpqNicIfPhysAdapterInternalMacReceiveErrors),
            "PՓ˃t[:",   displayItem("cpqNicIfPhysAdapterSingleCollisionFrames", cpqNicIfPhysAdapterSingleCollisionFrames)
            );
         writeDoubleTableRow(
            "&#160", "&#160",
            "ߏՓː:",   displayItem("cpqNicIfPhysAdapterExcessiveCollisions", cpqNicIfPhysAdapterExcessiveCollisions)
            );
         writeDoubleTableRow(
            "&#160", "&#160",
            "Mx:",   displayItem("cpqNicIfPhysAdapterDeferredTransmissions", cpqNicIfPhysAdapterDeferredTransmissions)
            );
         writeDoubleTableRow(
            "&#160", "&#160",
            "MAC MG[:",   displayItem("cpqNicIfPhysAdapterInternalMacTransmitErrors", cpqNicIfPhysAdapterInternalMacTransmitErrors)
            );
      }
      writeTableTail();
   }
}


function writeIfInfo( ifindex, vlanId, vlanName,sysUpTime, logindex )
{
   var i;
   var tableindex;
   var buffer1;
   var x, i;
   var physAddress;
   var lastChange;
   var diffTimeValue, diffDays, diffHours, diffMinutes;
   var statindex, protocolindex;
   var interfaceStatus;
   var speed =  cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapSpeed;
   var ifLastChange =  cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapLastChange;

   for(tableindex=0;tableindex<ifEntry.length;tableindex++)
   {
      if(ifEntry[tableindex].ifIndex == ifindex )
      {

    //hack so that the interface description does not include the string "&#000" - problem unique to Win2000
    if((ifDescPosition =ifEntry[tableindex].ifDescr.lastIndexOf("&#000")) != -1)
    {
        ifEntry[tableindex].ifDescr = ifEntry[tableindex].ifDescr.substring(0,ifDescPosition);
    }
    //end of hack

         writeTableLabel("C^tF[X - " + displayItem("ifDescr", ifEntry[tableindex].ifDescr));

         writeTableHead();

         for(i=0; i<ipAddrEntry.length; i++)
         {
            if( ipAddrEntry[i].ipAdEntIfIndex == ifindex )
            {
               writeSingleTableRowInDoubleTable("IP AhX:", ipAdEntAddr[i][0] + "." + ipAdEntAddr[i][2] + "." +
                  ipAdEntAddr[i][4] + "." + ipAdEntAddr[i][6]);
               break;
            }
         }

        if ( vlanId > 0 )
        {
            //writeDoubleTableRow( "VLAN Id:", displayItem( "cpqNicIfVlanMapVlanId", vlanId,
            //    "VLAN Name:", displayItem( "cpqNicIfVlanMapVlanName", vlanName );

            writeDoubleTableRow( "VLAN Id:", displayItem( "cpqNicIfVlanMapVlanId", vlanId), "VLAN :", vlanName );
        }

        if ( tableindex > 0 )
        {
            if (speed >= 1000000)
                speed = (speed/1000000) + " Mrbg/b";
        }
        else if(cpqHoInfo.cpqHoOsType == 2)
        {
           if (speed >= 1000000)
               speed = (speed/1000000) + " Mrbg/b";
        }
        else
             speed = "N/A";
        if(cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapCondition == 4)
	  speed = "s";

         writeDoubleTableRow("^Cv:",  displayItem("ifType", ifEntry[tableindex].ifType),
            "x:", displayItem("ifSpeed", speed));


         buffer1 = "";
         for (x=0; x<=5; x++)
         {
            if (ifPhysAddress[tableindex][x] == null)
               buffer1 = buffer1 + "00 ";
            else
               buffer1 = buffer1 +
            hexfromdec(ifPhysAddress[tableindex][x]).substring(2, 4) + " ";
         }
         if (buffer1 == "00 00 00 00 00 00 ")
            physAddress = "N/A";
         else
            physAddress = buffer1;


	// Determine the interface status from cpqNicIfPhysAdapterStatus. A "OK" in cpqNicIfPhysAdapterStatus
	 // is treated as "Up" and everything else is treated as "Down". Assuming that the 'tableindex' used to
	 // determine index into ifEntry table can be used to get the index into cpqNicPhysAdapterEntry table.
	 // This change affects all the Operating Systems (Windows, Netware and Linux). The issue is with the
	 // Netware and Linux not updating the ifOperStatus, when link is lost on a NIC.


         writeDoubleTableRow(
              "C^tF[X :", displayItem("cpqNicIfLogMapCondition",
		 cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapCondition),
                        "AhX:",    displayItem("ifPhysAddress", physAddress)
            );

         //if (ifEntry[tableindex].ifLastChange < 0 || sysUpTime < 0)
         if (ifLastChange < 0 || sysUpTime < 0)
            lastChange = "N/A";
         else
         {
            diffTimeValue = (sysUpTime - ifLastChange) / 6000;
            diffDays = parseNicInt( diffTimeValue / 1440 ); 
            diffHours = parseNicInt( (diffTimeValue % 1440) / 60);
            diffMinutes = parseNicInt( diffTimeValue % 60);
            if (diffDays > 0)
            {
               lastChange = diffDays + "  " +
                  diffHours + "  " +
                  diffMinutes + " O";
            }
            else
            if (diffHours > 0)
            {
               lastChange = diffHours + "  " +
                  diffMinutes + " O";
            }
            else
               lastChange = diffMinutes + " O";
         }
         writeDoubleTableRow(
            "őpPbgTCY:",     displayItem("ifMtu", ifEntry[tableindex].ifMtu + " oCg"),
            "ŏIXe[^Xω:",  displayItem("ifLastChange", lastChange)
            );

         writeDoubleTableRow("<br><u>Mv</u>", "&#160", "<br><u>Mv</u>", "&#160");
         writeDoubleTableRow(
            "oCg:", displayStatItem(ifEntry[tableindex].ifInOctets),
            "oCg:", displayStatItem(ifEntry[tableindex].ifOutOctets)
            );
         writeDoubleTableRow(
            "pPbg:", displayStatItem((parseNicInt(ifEntry[tableindex].ifInUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifInNUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifInDiscards) +
               parseNicInt(ifEntry[tableindex].ifInErrors) +
               parseNicInt(ifEntry[tableindex].ifInUnknownProtos))),
            "pPbg:", displayStatItem((parseNicInt(ifEntry[tableindex].ifOutUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifOutNUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifOutDiscards) +
               parseNicInt(ifEntry[tableindex].ifOutErrors)))
               );
         writeDoubleTableRow(
            "jLXg pPbg:", displayStatItem(ifEntry[tableindex].ifInUcastPkts),
            "jLXg pPbg:",  displayStatItem(ifEntry[tableindex].ifOutUcastPkts)
            );
         writeDoubleTableRow(
            "񃆃jLXg pPbg:", displayStatItem(ifEntry[tableindex].ifInNUcastPkts),
            "񃆃jLXg pPbg:", displayStatItem(ifEntry[tableindex].ifOutNUcastPkts)
            );
         writeDoubleTableRow(
            "ppPbg:", displayStatItem(ifEntry[tableindex].ifInDiscards),
            "ppPbg:", displayStatItem(ifEntry[tableindex].ifOutDiscards)
            );
         writeDoubleTableRow(
            "G[ pPbg:", displayStatItem(ifEntry[tableindex].ifInErrors),
            "G[ pPbg:", displayStatItem(ifEntry[tableindex].ifOutErrors)
            );
         writeDoubleTableRow(
            "svgR:", displayStatItem(ifEntry[tableindex].ifInUnknownProtos),
            "L[̒:", displayStatItem(ifEntry[tableindex].ifOutQLen)
            );

         writeTableTail();

         if( 6 == ifEntry[tableindex].ifType || 7 == ifEntry[tableindex].ifType )
         {
            for(statindex=0; statindex < dot3StatsEntry.length; statindex++)
            {

               if( dot3StatsEntry[statindex].dot3StatsIndex == ifindex )
               {
                  document.write("<br>");
                  writeEthernetStats( statindex );
                  break;
               }
            }
         }
         else if( 9 == ifEntry[tableindex].ifType )
         {

            for(protocolindex=0; protocolindex<dot5Entry.length; protocolindex++)
            {
               
               if( dot5Entry[protocolindex].dot5IfIndex == ifindex )
               {

                  document.write("<br>");
                  
                  writeTokenRingInfo( protocolindex );
               }
            }

            for(statindex=0; statindex < dot5StatsEntry.length; statindex++)
            {
               
               if( dot5StatsEntry[statindex].dot5StatsIfIndex == ifindex )
               {

                  document.write("<br>");

                  writeTokenRingStats( statindex );
                  break;
               }
            }
         }
      }
   }
}


function writeEthernetStats( dot3pageindex )
{
   var   receiveTotalErrors,
         frameTooLongs,
         alignmentErrors,
         macReceiveErrors,
         fcsErrors,
         transmitTotalErrors,
         macTransmitErrors,
         carrierSenseErrors,
         multipleCollisionFrames,
         lateCollisions,
         singleCollisionFrames,
         excessiveCollisions,
         deferredTransmissions
         ;
   frameTooLongs = dot3StatsEntry[dot3pageindex].dot3StatsFrameTooLongs;
   alignmentErrors = dot3StatsEntry[dot3pageindex].dot3StatsAlignmentErrors;
   macReceiveErrors = dot3StatsEntry[dot3pageindex].dot3StatsInternalMacReceiveErrors;
   fcsErrors = dot3StatsEntry[dot3pageindex].dot3StatsFCSErrors;

   if(-1 == fcsErrors || 4294967295 == fcsErrors)
     fcsErrors = 0;

   receiveTotalErrors = displayStatItem(
      parseNicInt(alignmentErrors) +
      parseNicInt(fcsErrors) +
      parseNicInt(frameTooLongs) +
      parseNicInt(macReceiveErrors)
      );
   frameTooLongs = displayStatItem(frameTooLongs);
   alignmentErrors = displayStatItem(alignmentErrors);
   macReceiveErrors = displayStatItem(macReceiveErrors);
   fcsErrors = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsFCSErrors);
   transmitTotalErrors = displayStatItem(
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsCarrierSenseErrors) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsLateCollisions) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsExcessiveCollisions) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsInternalMacTransmitErrors) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsMultipleCollisionFrames) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsSingleCollisionFrames) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsDeferredTransmissions)
      );
   macTransmitErrors = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsInternalMacTransmitErrors);
   carrierSenseErrors = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsCarrierSenseErrors);
   multipleCollisionFrames = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsMultipleCollisionFrames);
   lateCollisions = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsLateCollisions);
   singleCollisionFrames = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsSingleCollisionFrames);
   excessiveCollisions = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsExcessiveCollisions);
   deferredTransmissions = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsDeferredTransmissions);

   writeTableLabel("C^tF[X C[Tlbgv");
   writeTableHead();
   writeDoubleTableRow("<u>MG[</u>", "", "", "");
   writeDoubleTableRow(
    "vG[:",     receiveTotalErrors,
    "ߑt[:",   frameTooLongs
    );
   writeDoubleTableRow(
      "ACg G[:", alignmentErrors,
      "MAC MG[:",    macReceiveErrors
      );
   writeDoubleTableRow(
      "FCS G[:", fcsErrors,
      "",            ""
      );

   writeDoubleTableRow("&#160<br><u>MG[</u>", "", "", "");
   writeDoubleTableRow(
     "vG[:",  transmitTotalErrors,
     "MAC MG[:", macTransmitErrors
     );
   writeDoubleTableRow(
     "LAoG[:",   carrierSenseErrors,
     "dՓ˃t[:",  multipleCollisionFrames
     );
   writeDoubleTableRow(
     "xՓː:",     lateCollisions,
     "PՓ˃t[:", singleCollisionFrames
     );
   writeDoubleTableRow(
     "ߏՓː:",   excessiveCollisions,
     "Mx:",   deferredTransmissions
     );
   writeTableTail();
}


function writeTokenRingInfo( dot5pageindex )
{
   var   ringSpeed,
         upstreamAddr,
         ringState,
         actMonParticipate,
         ringStatus,
         functionalAddr,
         ringOpenStatus
         ;

   ringSpeed = displayNicItem("dot5RingSpeed", dot5Entry[dot5pageindex].dot5RingSpeed);
   if ( "0,0,0,0,0,0" == dot5UpStream[dot5pageindex] )
        upstreamAddr = "N/A";
   else
        upstreamAddr = rawToHex( dot5UpStream[dot5pageindex], " ");
   ringState = displayNicItem("dot5RingState", dot5Entry[dot5pageindex].dot5RingState);
   actMonParticipate = displayNicItem("dot5ActMonParticipate", dot5Entry[dot5pageindex].dot5ActMonParticipate);
   //ringStatus = rawToHex( dot5RingStatus[dot5pageindex], " ");
   ringStatus = (dot5Entry[dot5pageindex].dot5RingStatus - 0).toString(16) + "h"; 
   functionalAddr = rawToHex(dot5Functional[dot5pageindex], " ");
   ringOpenStatus = displayNicItem("dot5RingOpenStatus", dot5Entry[dot5pageindex].dot5RingOpenStatus);

   writeTableLabel("C^tF[X g[NO");
   writeTableHead();
   writeDoubleTableRow(
    "Ox:",    ringSpeed,
    "AbvXg[ AhX:", upstreamAddr
    );
   writeDoubleTableRow(
    "O:",       ringState,
    "ANeBu j^:",   actMonParticipate
    );
   writeDoubleTableRow(
    "O:",      ringStatus,
    "@\AhX:",  functionalAddr
    );
   writeDoubleTableRow(
    "O I[vXe[^X:", ringOpenStatus,
    "",                  ""
    );
   writeTableTail();

}


function writeTokenRingStats( dot5statsindex )
{
   var   lostFrameErrors,
         internalErrors,
         receiveCongestions,
         tokenErrors,
         frameCopiedErrors,
         transmitBeacons,
         abortTransErrors,
         removes,
         softErrors,
         recoverys,
         hardErrors,
         lobeWires,
         lineErrors,
         signalLoss,
         burstErrors,
         freqErrors,
         acErrors,
         singles
         ;

   lostFrameErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsLostFrameErrors);
   internalErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsInternalErrors);
   receiveCongestions = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsReceiveCongestions);
   tokenErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsTokenErrors);
   frameCopiedErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsFrameCopiedErrors);
   transmitBeacons = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsTransmitBeacons);
   abortTransErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsAbortTransErrors);
   removes = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsRemoves);
   softErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsSoftErrors);
   recoverys = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsRecoverys);
   hardErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsHardErrors);
   lobeWires = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsLobeWires);
   lineErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsLineErrors);
   signalLoss = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsSignalLoss);
   burstErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsBurstErrors);
   freqErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsFreqErrors);
   acErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsACErrors);
   singles = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsSingles);

   writeTableLabel("C^tF[X g[NOv");
   writeTableHead();
   writeDoubleTableRow(
       "t[rG[:",   lostFrameErrors,
       "G[:",     internalErrors
       );
   writeDoubleTableRow(
       "ߏMG[:",  receiveCongestions,
       "g[N G[:",     tokenErrors
       );
   writeDoubleTableRow(
       "t[Rs[ G[:",   frameCopiedErrors,
       "Mr[RG[:",        transmitBeacons
       );
   writeDoubleTableRow(
       "MfG[:",   abortTransErrors,
       "폜:",             removes
       );
   writeDoubleTableRow(
       "\tg G[:",   softErrors,
       ":",    recoverys
       );
   writeDoubleTableRow(
       "n[hG[:",   hardErrors,
       "[u G[:",   lobeWires
       );
   writeDoubleTableRow(
       "G[:",   lineErrors,
       "MrG[:",   signalLoss
       );
   writeDoubleTableRow(
       "o[Xg G[:",     burstErrors,
       "gG[:",   freqErrors
       );
   writeDoubleTableRow(
       "AC G[:",        acErrors,
       "PXe[V:",   singles
       );
   writeTableTail();
}
