/***************************************************************************
* copyright 2002 Compaq Information Technologies Group, L.P.
* Hewlett-Packard Confidential
****************************************************************************
*
*  @doc
*
*  @module  cevtq.h
*  Version: 1.0
*
*  Function: 
*  This module provides the queue structure for the Legacy IML event
*  logging module
*
*  @doc
****************************************************************************
* 
*  @doc
* 
*  Change Log:
* 
*       Date    Who   Description
* 
*****************************************************************************/

#ifndef INCL_CPQEVTQ_H
#define INCL_CPQEVTQ_H


/**************************************************************************
*****************             Defines and typedefs        *****************
***************************************************************************/


/*
** @struct QELEMENT 
** This is used to hold Events to be logged to the IML log
** until the Compaq ASM / ILO driver has been loaded.
**                 
*/

typedef struct _QELEMENT {
   struct _QELEMENT     *pNext;         /* Points to the next element   */
   ULONG                 ulFlag;        /* Description about the entry  */
   LONG                  lAction;       /* What is the action to take   */
   LONG                  lMatchCode;    /* Match Code to Use            */
   LONG                  lEvtNumber;    /* Event Number                 */
   PVOID                 pEvtLogEntry;  /* Log Entry to be logged       */
} QELEMENT, *PQELEMENT;


/*
** Definitions for ulFlag above
*/
#define CEVT_RESIDENT_POOL          0x01
#define CEVT_KERNEL_POOL            0x02
#define CEVT_QELEMENT_IN_USE        0x04
#endif
