##################################################################
### copyright 2002 Compaq Information Technologies Group, L.P. ###
##################################################################

CC=gcc

EFS_VER=$(shell cat PKG_VERSION)
OS_VERSION=\"$(shell uname -r)\"
LINUX_KERN_DIR=$(shell uname -r)
OS_MODEL=LINUX
OS_SYMBOL=1

#AFLAGS=-Wall

INCLUDE= -I. 
LINUX_INCLUDE = -I/lib/modules/$(LINUX_KERN_DIR)/build/include/
DESCRIPTION="$(shell md5sum /boot/vmlinuz)"

CFLAGS = -O $(AFLAGS) -D$(OS_MODEL) -DINC_OS_HEADERS $(LINUX_INCLUDE) $(INCLUDE) -DOS_VERSION=$(OS_VERSION) -DOS_SYMBOL=$(OS_SYMBOL) -D$(OS_MODEL) -DEFS_VER=\"$(EFS_VER)\" -DCEVT_DESCRIPTION=\"$(DESCRIPTION)\"

TARGET=cpqevt.o
    
LOBJS=	cpqevt_common.o cpqevtw_linux.o


all:	$(TARGET) 

.c.o:	Makefile
	$(CC) $(CFLAGS) -c $< -o $@


$(TARGET): 	$(LOBJS) 
	$(LD) -x -r -o $(TARGET) $(LOBJS)

clean:
	echo "Recompiling cpqevt for current Linux Kernel . . ." ;\
	touch *.c *.h
	rm -f $(TARGET)



rebuild:	clean all 

