/***************************************************************************
*         Copyright 2002 Compaq Information Technologies Group, L.P.       *
****************************************************************************
*
*  @doc
*
*  @module  casmc.h 
*  Version: 1.0
*
*  Function: Provide basic support for the hp ProLiant Advanced Server
*            Management ASIC
*
*  @doc
****************************************************************************
* 
*  @doc
* 
*  Change Log:
* 
*       Date    Who   Description
* 
*****************************************************************************/

#ifndef INCL_CASMC_H
#define INCL_CASMC_H


//*************************************************************************
//  Includes needed for all files
//*************************************************************************


//*************************************************************************
//  Constants
//*************************************************************************

#ifndef SUCCESS
#define SUCCESS      0
#endif

#ifndef FAILURE
#define FAILURE      1
#endif



/*
** The following may be used by the "wrapper" code to assist with
** managing asynchronous threads of execution.  One example would
** be to store the OS Specific "timeout identifier" when a
** schedule call back function is used.  These values will be
** passed to the "casmw_timeout" functions to be used as needed.
*/
#define CASM_ONE_MINUTE_TIMER         0
#define CASM_FEATURE_POLLING_TIMER    1
#define CASM_MINUTE_POLLING_TIMER     2
#define CASM_OS_SHUTDOWN_TIMER        3


/*
** The following is used for logging errors to the screen.  We
** define these to provide a portable interface to all UNIX
** based OS's.
*/
#define CASM_KERN_INFO                 1    /* Information message         */
#define CASM_KERN_WARN                 2    /* Warning Message             */ 
#define CASM_KERN_CRITICAL             3    /* Critical Error Message      */ 
#define CASM_KERN_PANIC                4    /* Print Message and Halt      */
#define CASM_KERN_DEBUG                5    /* Debug Messages Only         */

/*
** Proc File Entry Types
*/
#define CASM_GET_TEMP_PD        1
#define CASM_GET_FAN_PD         2
#define CASM_GET_PWR_PD         3
#define CASM_GET_IML_PD         4
#define CASM_GET_PCI_PD         5
#define CASM_GET_DEBUG_PD       6


//*************************************************************************
//  Defines and typedefs
//*************************************************************************


/* The ulShutdownCnt field is a running counter of all the
** shutdowns that get issued by various devices. The counter
** is incremented every time a shutdown gets issued and
** decremented whenever that specific device is repaired.
** So, no cancellation of a shutdown gets issued unless all
** shutdowns are cancelled (or when ulShutdownCnt = 0).
*/
typedef struct _ShutDownInfo {
    ULONG                ulDelay;        /* In Seconds                   */
    ULONG                ulReason;       /* EVT Code                     */
    ULONG                ulId;
    ULONG                ulShutdownCnt;
    BOOLEAN              bReboot;        /* Blade reboot or power off    */
  } SHUTDOWNINFO, *PSHUTDOWNINFO;


typedef struct _CASMDATA {
    ULONG                ulCfgState;

    ULONG                ulFlags;        /* used to address some issues    */
    ULONG                ulOpenCount;

    ULONG                ulVendDeviceID; /* PCI Vend/ Device ID            */
    ULONG                ulSubVendDeviceID; /* PCI Vend/ Device ID            */
    ULONG                ulIRQ;
    ULONG                ulIOAddr;
    ULONG                ulMemAddr;
    ULONG                ulIOLength;      /* Len is the same for mem & IO  */

    ULONG                ulCurrLowInts;   /* Lower Order GPI Interrupts     */
    ULONG                ulPendLowInts;   /* Lower Order Pending GPI Ints   */
    ULONG                ulCurrHiInts;    /* Higher Order GPI Interrupts    */
    ULONG                ulPendHiInts;    /* Higher Order Pending GPI Ints  */
    ULONG                ulCurrIntStatus; /* ECC, FERR, other Legacy ASM    */
    ULONG                ulPendIntStatus; /* ECC, FERR, other Legacy ASM    */

    ULONG                ulPollFreq;      /* How often do we poll the ftrs  */
    ULONG                ulCpuCount;      /* Num of CPU's (Wrapper gives)   */

    LONG                 iTZOffset;       /* Seconds to add to correct time */

    SHUTDOWNINFO         SDI;             /* Holds Shutdown Information     */

    PVOID                pHData;          /* The monster of all Health      */
    PVOID                pMCACntrl;       /* MCA Data Structure             */
    PVOID                pSMBTable;       /* Pointer to SMB Table           */
    PVOID                pRomCntrl;       /* Pointer to ROM Interfaces      */
    PVOID                pRIBEntry;       /* Pointer to the Crid Driver     */
    PVOID                pOsData;         /* OS specific constructs         */
    UCHAR                szNode[30];      /* Node / hostname string         */
    UCHAR                szOsName[45];    /* OS Name string                 */
} CASMDATA, *PCASMDATA;


//*************************************************************************
//  Defines for ulCfgState
//*************************************************************************
#define CASM_LOADED               0x0001          /* Driver is loaded   */
#define CASM_INITIALIZED          0x0002          /* Common Code Ready  */
#define CASM_SHUTDOWN             0x0004          /* Stop Processing    */
#define CASM_HARD_POWEROFF        0x0008          /* And power off      */
#define CASM_HARD_RESET           0x0010          /* And RESET via ASIC */
#define CASM_ASR_RESET            0x0020          /* And RESET via ASIC */
#define CASM_NMI_IN_PROGRESS      0x0040          /* No LOCKS allowed   */
#define CASM_DAEMON_RESTARTED     0x0080          /* Daemon restarted   */
#define CASM_HDATA_INITIALIZED    0x0100          /* pHData Initialized */
#define CASM_ASIC_LOCKED          0x0200          /* ASIC Locked (DIAG) */
#define CASM_ASIC_BUSY            0x0400          /* ASIC Busy   (DIAG) */

//*************************************************************************
//  Defines for ulCurrIntStatus, ulPendIntStatus.
//*************************************************************************
#define CPQASM_GPI_INTERRUPT        0X01
#define CPQASM_ECC_INTERRUPT        0x02
#define CPQASM_FERR_INTERRUPT       0x04
#define CPQASM_POLLING_INTERRUPT    0X08
#define CPQASM_ONE_MINUTE_INTERRUPT 0X10
#define CPQASM_IIC_SLAVE_INTERRUPT  0X20

//*************************************************************************
//  Defines for lower 2 bytes of ulFlag above
//  See casmioctl.h for definitions of upper two bytes.
//*************************************************************************
#define CASM_ASR_CREATE_CRASH_DUMP         0x01
#define CASM_DEBUG_ALL                     0x02


//*************************************************************************
//  Function prototypes  (From Wrapper)
//*************************************************************************

void *casmw_map32_bit_phys( ULONG ulPhysicalAddr,
                            ULONG ulLength,
                            PCASMDATA pInstance );

VOID casmw_unmap32_bit_phys ( PVOID pVirtAddr,ULONG ulLength,
                              PCASMDATA pInstance );
PVOID casmw_malloc(ULONG ulSize);
VOID casmw_free(PVOID pVAddr, ULONG ulSize);
void casmw_lock_rom(PCASMDATA pInstance);
void casmw_unlock_rom(PCASMDATA pInstance);
void casmw_lock_queue(PCASMDATA pInstance);
void casmw_unlock_queue(PCASMDATA pInstance);
void casmw_lock_iic(PCASMDATA pInstance);
void casmw_unlock_iic(PCASMDATA pInstance);
void casmw_wait_for_event(PCASMDATA pInstance);
void casmw_event_notify(PCASMDATA pInstance);
UCHAR casmw_in_byte_mem(PULONG pulAddr, PCASMDATA pInstance);
USHORT casmw_in_word_mem(PULONG pulAddr, PCASMDATA pInstance);
ULONG casmw_in_dword_mem(PULONG pulAddr, PCASMDATA pInstance);
void casmw_out_byte_mem( PULONG pAddr, UCHAR ucData, PCASMDATA pInstance );
void casmw_out_word_mem( PULONG pAddr, USHORT usData, PCASMDATA pInstance );
void casmw_out_dword_mem( PULONG pAddr, ULONG ulData, PCASMDATA pInstance );
UCHAR casmw_read_byte(ULONG ulAddr, PCASMDATA pInstance);
USHORT casmw_read_word(ULONG ulAddr, PCASMDATA pInstance);
ULONG casmw_read_dword(ULONG ulAddr, PCASMDATA pInstance);
void casmw_write_byte( ULONG ulAddr, UCHAR ucData, PCASMDATA pInstance );
void casmw_write_word( ULONG ulAddr, USHORT usData, PCASMDATA pInstance );
void casmw_write_dword( ULONG ulAddr, ULONG ulData, PCASMDATA pInstance );
ULONG casmw_microdelay( ULONG ulUsec, PCASMDATA pInstance );
VOID casmw_timeout( PVOID pFunction, PVOID pArg, ULONG ulUsec, 
                    ULONG ulTimeOutID, PCASMDATA pInstance );
VOID casmw_cancel_timeout( ULONG ulTimeOutID, PCASMDATA pInstance );
ULONG casmw_memcpy(char *dest, char *source, int length);
char *casmw_strcpy(char *s1, char *s2);
char *casmw_strcat(char *s1, char *s2);
ULONG casmw_strlen(char *s1);
void *casmw_memzero(void *s, int n);
void *casmw_memset(void *s, register int c, register int n);
int casmw_strncmp(register char *s1, register char *s2, register int length);
VOID casmw_printf( ULONG ulErrorLevel, PCHAR pString, 
                   PULONG ppParms, PCASMDATA pInstance );
int casmw_sprintf(char *pbuf, const char *pfmt, ...);
void casmw_graceful_shutdown(PCASMDATA pInstance);
int casmw_get_ubuff( void *pUserBuff, void *pKernelBuff,
                     ULONG buffer_len, PCASMDATA pInstance );
int casmw_put_ubuff( void *pUserBuff, void *pKernelBuff,
                     ULONG buffer_len, PCASMDATA pInstance );
BOOLEAN casmw_os_mca_init(PCASMDATA pInstance, ULONG ulProcessor);
BOOLEAN casmmca_os_mca_poll(PCASMDATA pInstance, ULONG ulProcessor);

void *casmw_allocate_iic_semaphore(PCASMDATA pInstance);
void casmw_wait_iic_semaphore(PCASMDATA pInstance);
void casmw_signal_iic_semaphore(PCASMDATA pInstance);
void casmw_free_iic_semaphore(PCASMDATA pInstance);

void *casmw_allocate_iic_thread_lock(PCASMDATA pInstance);
void casmw_take_iic_thread_lock(PCASMDATA pInstance);
void casmw_release_iic_thread_lock(PCASMDATA pInstance);
void casmw_free_iic_thread_lock(PCASMDATA pInstance);

BOOLEAN casmw_pci_is_device_present(ULONG ulBus, ULONG ulDev, ULONG ulFunc);
UCHAR casmw_pci_get_subordinate_bus(ULONG ulBus, ULONG ulDev, ULONG ulFunc);



//*************************************************************************
//  Function prototypes  (For the  Wrapper)
//*************************************************************************

int casmc_common_open(PCASMDATA pInstance);
int casmc_common_close(PCASMDATA pInstance);
int casmc_common_ioctl( ULONG ulCmd, ULONG ulDevNode, void *pUserData,
                        ULONG ulKernelData, PCASMDATA pInstance );
int casmc_common_intr(PCASMDATA pInstance);
int casmc_common_nmi_hndlr(PCASMDATA pInstance);
int casmc_common_init(PCASMDATA pInstance);
int casmc_common_shutdown(PCASMDATA pInstance);
int casmc_common_poweroff(PCASMDATA pInstance);
BOOLEAN casmc_asr_timer_killed(PCASMDATA pInstance);
int casmc_common_mca_init(PCASMDATA pInstance, ULONG ulProcessor);
int casmc_common_mca_poll(PCASMDATA pInstance, ULONG ulProcessor);
VOID casmc_log_iml_msg(PCASMDATA pInstance, PUCHAR pString);

#endif 
