
################################################################
## copyright 2003 Compaq Information Technologies Group, L.P. ##
################################################################
#SLES 7

CC=gcc

EFS_VER=$(shell if [ -f PKG_VERSION ]; then cat PKG_VERSION; else echo Dangerous; fi)

LINUX_KERN=$(shell uname -r)
# BASEREV=$(shell uname -r | tr -d [=-SMP=])
OS_VERSION_UP=2.4.7-4GB
OS_VERSION_MP=2.4.7-64GB-SMP
# OS_VERSION_EP=$(BASEREV)enterprise

OS_MODEL=LINUX

INCLUDE= -I./
LINUX_INCLUDE_UP = -I/lib/modules/$(OS_VERSION_UP)/build/include/
LINUX_INCLUDE_MP = -I/lib/modules/$(OS_VERSION_MP)/build/include/
LINUX_INCLUDE_CUSTOM = -I/lib/modules/$(LINUX_KERN)/build/include

LINUX_INCLUDE_DIR_UP = /lib/modules/$(OS_VERSION_UP)/build/include/linux
LINUX_INCLUDE_DIR_MP = /lib/modules/$(OS_VERSION_MP)/build/include/linux

COMPILEROPTS=-Wall -Wstrict-prototypes -O2 -fomit-frame-pointer

CFLAGS_UP = $(COMPILEROPTS) -DMODULE -D__KERNEL__ $(LINUX_INCLUDE_UP) $(INCLUDE) -DEFS_VER=\"$(EFS_VER)\"
CFLAGS_MP = $(COMPILEROPTS) -DMODULE -D__KERNEL__ $(LINUX_INCLUDE_MP) $(INCLUDE) -DEFS_VER=\"$(EFS_VER)\"
CFLAGS_CUSTOM = $(COMPILEROPTS) -DMODULE -D__KERNEL__ -DDEBUG $(LINUX_INCLUDE_CUSTOM) $(INCLUDE) -DEFS_VER=\"$(EFS_VER)\"

LOBJS=	cmhp_lib.o cmhp.o

all:	clean cmhp.c up smp

rebuild: clean cmhp.c
	$(CC) $(CFLAGS_CUSTOM) -c cmhp.c
	$(LD) -r -o cmhp_custom.o $(LOBJS)

up:
	cp $(LINUX_INCLUDE_DIR_UP)/autoconf.h $(LINUX_INCLUDE_DIR_UP)/autoconf.h.ORIG
	cp $(LINUX_INCLUDE_DIR_UP)/version.h  $(LINUX_INCLUDE_DIR_UP)/version.h.ORIG
	cp ./vmlinuz.autoconf.h.up $(LINUX_INCLUDE_DIR_UP)/autoconf.h
	cp ./vmlinuz.version.h.up  $(LINUX_INCLUDE_DIR_UP)/version.h
	$(CC) $(CFLAGS_UP) -c cmhp.c -o cmhp.o
	$(LD) -x -r -o cmhp_up.o $(LOBJS)
	cp $(LINUX_INCLUDE_DIR_UP)/autoconf.h.ORIG $(LINUX_INCLUDE_DIR_UP)/autoconf.h
	cp $(LINUX_INCLUDE_DIR_UP)/version.h.ORIG  $(LINUX_INCLUDE_DIR_UP)/version.h

smp:
	cp $(LINUX_INCLUDE_DIR_MP)/autoconf.h $(LINUX_INCLUDE_DIR_MP)/autoconf.h.ORIG
	cp $(LINUX_INCLUDE_DIR_MP)/version.h  $(LINUX_INCLUDE_DIR_MP)/version.h.ORIG
	cp ./vmlinuz.autoconf.h.smp $(LINUX_INCLUDE_DIR_MP)/autoconf.h
	cp ./vmlinuz.version.h.smp  $(LINUX_INCLUDE_DIR_MP)/version.h
	$(CC) $(CFLAGS_MP) -c cmhp.c -o cmhp.o
	$(LD) -x -r -o cmhp_smp.o $(LOBJS)
	cp $(LINUX_INCLUDE_DIR_MP)/autoconf.h.ORIG $(LINUX_INCLUDE_DIR_MP)/autoconf.h
	cp $(LINUX_INCLUDE_DIR_MP)/version.h.ORIG  $(LINUX_INCLUDE_DIR_MP)/version.h

clean:
	rm -f cmhp.o cmhp_up.o cmhp_smp.o cmhp_ent.o cmhp_custom.o
