/***************************************************************************
* Copyright (c) 2001, 2002 Compaq Information Technologies Group, L.P., 
* ALL RIGHTS RESERVED.
****************************************************************************
*
*  @doc
*
*  @module  oswrap.h
*  Version: 1.0
*
*  Function: This include determines which OS wrapper file to include
*            for the module.  This also provides the "must have" function
*            definition.  These functions must be defined and declared
*            by the wrapper code inorder for the common code to work.
*
*  @doc
****************************************************************************
*
*  @doc
*
*  Change Log:
*
*       Date    Who   Description
*
*****************************************************************************/

#ifndef INCL_OSWRAP_H
#define INCL_OSWRAP_H

#ifdef UW700
#include "cridw_uw700.h"
#endif

#ifdef LINUX
#include "convert.h"

int printk(const char*, ...);
int sprintf(char * buf, const char * fmt, ...);
int snprintf(char * buf, unsigned int size, const char * fmt, ...);

#define STRINGIZE(lvl) #lvl 
#define LEVEL(lvl) "<" #lvl ">" 

#ifdef DEBUG
#define cridw_dbg(lvl, args...) if (((pInstance->ulInit) & CRID_DEBUG_ALL) != 0) printk(LEVEL(lvl) args)
#else
#define cridw_dbg(lvl, args...) 
#endif

#define cridw_printk(lvl, args...) printk(LEVEL(lvl) args)

#if !defined(SLES7)
#define cridw_sprintf(fmt, args...)\
if (buffer != NULL && (bufsize-buflen > 0)) buflen+=snprintf(buffer+buflen, bufsize-buflen, fmt, ##args);
#else
#define cridw_sprintf(fmt, args...)\
if (buffer != NULL && (bufsize-buflen > 256)) {\
        buflen+=sprintf(buffer+buflen, fmt, ##args);\
}
#endif

#define BUF_ORDER 3

#define MS_TO_TICKS(x)		((x)/1000*100)
#define US_TO_TICKS(x)		((x)/1000000*100)
#define TICKS_TO_MS(x)		((x)/100*1000)
#define TICKS_TO_US(x)		((x)/100*1000000)

#endif

#ifdef SCO500
#include "cridw_sco500.h"
#endif

#endif

