/***************************************************************************
* Copyright (c) 2001, 2002 Compaq Information Technologies Group, L.P., 
* ALL RIGHTS RESERVED.
****************************************************************************
*
*  @doc
*
*  @module  cridc.h 
*  Version: 1.0
*
*  Function: Provide basic support for the hp Advanced Server
*            Management ASIC
*
*  @doc
****************************************************************************
* 
*  @doc
* 
*  Change Log:
* 
*       Date    Who   Description
* 
*****************************************************************************/

#ifndef INCL_CRIDC_H
#define INCL_CRIDC_H


//*************************************************************************
//  Includes needed for all files
//*************************************************************************


//*************************************************************************
//  Constants
//*************************************************************************

#ifndef SUCCESS
#define SUCCESS      0
#endif

/* Common Error Cases */

#define CRID_FAULT	1
#define CRID_BUSY	2
#define CRID_INVAL	3
#define CRID_NOSPC	4
#define CRID_TIME	5
#define CRID_NODEV	6
#define CRID_IO		7
#define CRID_PERM	8
#define CRID_CPY	9
#define CRID_INTR	10	

/* Dev node major number */

#define CRID_MAJOR 237

/* Driver name */

#define D_NAME "crid"

/* Driver version */
#ifndef EFS_VER	
	#define EFS_VER "7.0.0"
#endif

/* status (behavioral) bits */
#define CRID_DEBUG_ALL 		0x80000000 	/* Turns on debug output */
#define CRID_IML_POLLING 	0x40000000	/* Turns on IML polling */
#define CRID_NO_SERVER_NAME	0x20000000	/* Turns off server name propagation */
#define CRID_NO_BTRY_STATUS	0x10000000	/* Turns off battery status check */

/* Flint card status */
#define    CARD_FIRST_OPENED	0x0001	/*card first opened */
#define    CARD_BUSY        	0x0010	/*Flint card is being opened */

/* Maximum value of sequence number */
#define MAX_SEQ_NUM 100

/* Mallocing kernel Memory */

#define MALLOC_ATOMIC		0x1

/*
** The following may be used by the "wrapper" code to assist with
** managing asynchronous threads of execution.  One example would
** be to store the OS Specific "timeout identifier" when a
** schedule call back function is used.  These values will be
** passed to the "cridw_timeout" functions to be used as needed.
*/
#define CRID_URGENT_BUF_ID		0
#define CRID_IML_TIMER_ID	     	1
#define CRID_FLASH_ID	  	      	2

/*
** The following waitqueue values are acceptable
** GET_PKT_WQ is the special value being passed in when trying to put
** a task onto the SNMP wait queue (get_pkt_wq).
** Any number between 0 and MAX_SEQ_NUM-1 (inclusive) are going to the
** slot_wq.
*/

#define GET_PKT_WQ			-1 

/*
** The following is used for logging errors to the screen.  We
** define these to provide a portable interface to all UNIX
** based OS's.
*/
#define CRID_KERN_PANIC                1    /* Print Message and Halt      */
#define CRID_KERN_CRITICAL             2    /* Critical Error Message      */ 
#define CRID_KERN_WARN                 3    /* Warning Message             */ 
#define CRID_KERN_INFO                 4    /* Information message         */
#define CRID_KERN_DEBUG                5    /* Debug Messages Only         */


//*************************************************************************
//  Defines and typedefs
//*************************************************************************

typedef struct _CRIDDATA {
    ULONG              	 ulInit;        /* used to keep track of init status, formerly init*/
    ULONG		 ulStatus;      /* used to keep track of card status, formerly smr_open*/

    ULONG                ulVendDeviceID; /* PCI Vend/ Device ID            */
    ULONG                ulSubVendDeviceID; /* PCI Vend/ Device ID            */
    LONG	    	 ulSubClass;
    ULONG		 ulSlot;
    ULONG                ulIRQ;

    ULONG		 ulCridType;

    ULONG                ulCpuCount;      /* Num of CPU's (Wrapper gives)   */

    PVOID                pOsData;         /* OS specific constructs         */
    PVOID		 pCridEntry;	  /* Pointer to private driver info  */
} CRIDDATA, *PCRIDDATA;


//*************************************************************************
//  Defines for ulCfgState
//*************************************************************************
#define CRID_REGISTER_CHARDEV		0x1	/* Device is registered */
#define CRID_REGISTER_INTERRUPT		0x2	/* Interrupt is registered */
#define CRID_REGISTER_MEMORY_MAP1	0x4	/* Memory mapped Phase 1 */
#define CRID_REGISTER_MEMORY_MAP2	0x8	/* Memory mapped Phase 2 */
#define CRID_REGISTER_PROC		0x10	/* Proc tables are registered */

//*************************************************************************
//  Function prototypes  (From Wrapper)
//*************************************************************************

//io memory mapping and unmapping
void *cridw_map32_bit_phys( ULONG ulPhysicalAddr, ULONG ulLength, PCRIDDATA pInstance );
VOID cridw_unmap32_bit_phys ( PVOID pVirtAddr,ULONG ulLength, PCRIDDATA pInstance );

//malloc'ing/free'ing kernel memory
PVOID cridw_malloc(ULONG ulSize, ULONG ulFlags);
VOID cridw_free(PVOID pVAddr, ULONG ulSize, ULONG ulFlags);

//Spinlocks 
#ifdef DEBUG
void cridw_lock_debug(ULONG ulIndex, PCRIDDATA pInstance, char *pFileName, ULONG ulLine);
#define cridw_lock(index, instance)\
cridw_lock_debug(index, instance, __FILE__, __LINE__)
#else
void cridw_lock(ULONG ulIndex, PCRIDDATA pInstance);
#endif

#ifdef DEBUG
void cridw_unlock_debug(ULONG ulIndex, PCRIDDATA pInstance, char *pFileName, ULONG ulLine);
#define cridw_unlock(index, instance)\
cridw_unlock_debug(index, instance, __FILE__, __LINE__)
#else
void cridw_unlock(ULONG ulIndex, PCRIDDATA pInstance);
#endif

//Wait queues
void cridw_wait_for_event(ULONG ulIndex, PCRIDDATA pInstance);
ULONG cridw_wait_for_event_timeout(ULONG ulIndex, ULONG ulTime, PCRIDDATA pInstance);
void cridw_event_notify(ULONG ulIndex, PCRIDDATA pInstance);
ULONG cridw_event_active(ULONG ulIndex, PCRIDDATA pInstance);

//Signal detection
ULONG cridw_signal_pending(PCRIDDATA pInstance);

//IO port read & write
UCHAR cridw_in_byte_mem(PULONG pulAddr, PCRIDDATA pInstance);
USHORT cridw_in_word_mem(PULONG pulAddr, PCRIDDATA pInstance);
ULONG cridw_in_dword_mem(PULONG pulAddr, PCRIDDATA pInstance);
void cridw_out_byte_mem( PULONG pAddr, UCHAR ucData, PCRIDDATA pInstance );
void cridw_out_word_mem( PULONG pAddr, USHORT usData, PCRIDDATA pInstance );
void cridw_out_dword_mem( PULONG pAddr, ULONG ulData, PCRIDDATA pInstance );

//IO memory read & write
UCHAR cridw_read_byte(  ULONG ulAddr, PCRIDDATA pInstance);
USHORT cridw_read_word( ULONG ulAddr, PCRIDDATA pInstance);
ULONG cridw_read_dword( ULONG ulAddr, PCRIDDATA pInstance);
void cridw_write_byte(  ULONG ulAddr, UCHAR ucData, PCRIDDATA pInstance );
void cridw_write_word(  ULONG ulAddr, USHORT usData, PCRIDDATA pInstance );
void cridw_write_dword( ULONG ulAddr, ULONG ulData, PCRIDDATA pInstance );

//stalling (non scheduling)
void cridw_microdelay( ULONG ulUsec, ULONG nosleep, PCRIDDATA pInstance );

//timer functionality
ULONG cridw_timeout( PVOID pFunction, PVOID pArg, ULONG ulUsec, ULONG ulTimeOutID, PCRIDDATA pInstance );
VOID cridw_cancel_timeout( ULONG ulTimeOutID, PCRIDDATA pInstance );
VOID cridw_halt(PCRIDDATA pInstance);

//Memory operations (C lib style)
void *cridw_memcpy(void *dest, void* source, int length);
void *cridw_memzero(void *s, int n);
void *cridw_memset(void *s, register int c, register int n);

//String operations (C lib style)
char *cridw_strcpy(char *s1, char *s2);
char *cridw_strcat(char *s1, char *s2);
ULONG cridw_strlen(char *s1);
int cridw_strncmp(register char *s1, register char *s2, register int length);

//console (debugging) output
//VOID cridw_printf( ULONG ulErrorLevel, PCHAR pString, 
//                   PULONG ppParms, PCRIDDATA pInstance );

//memory transfer to/from user space
int cridw_get_ubuff( void *pUserBuff, void *pKernelBuff, ULONG buffer_len, PCRIDDATA pInstance );
int cridw_put_ubuff( void *pUserBuff, void *pKernelBuff, ULONG buffer_len, PCRIDDATA pInstance );

//other abstractions
void cridw_get_server_name(char *s1, unsigned int n, PCRIDDATA pInstance);
void cridw_call_idistributed(ULONG irq_on, PCRIDDATA pInstance);
int print_lock(char* buffer, int bufsize, PCRIDDATA pInstance);
int print_wq(char* buffer, int bufsize, PCRIDDATA pInstance);
int crid_proc(char *buffer, int bufsize, PCRIDDATA pInstance);

//PCI config space operations
void* cridw_pci_find_dev(USHORT vendor, USHORT device, void* pCookie);

int   cridw_pci_read_irq(void* pCookie, ULONG* pResult);
int   cridw_pci_read_subsys(void* pCookie, USHORT* pSubVend, USHORT* pSubDevID);
int   cridw_pci_read_busdevfn(void* pCookie, UCHAR* pBus, UCHAR* pDev, UCHAR* pFn);
int   cridw_pci_read_bar(void* pCookie, int index, ULONG* pBar);
int   cridw_pci_read_slot(void* pCookie, ULONG* pSlot);

int   cridw_pci_read_byte(void* pCookie, int offset,  UCHAR* pResult); 
int   cridw_pci_read_word(void* pCookie, int offset,  USHORT* pResult); 
int   cridw_pci_read_dword(void* pCookie, int offset, ULONG* pResult); 
int   cridw_pci_write_byte(void* pCookie, int offset,  UCHAR pResult); 
int   cridw_pci_write_word(void* pCookie, int offset,  USHORT pResult); 
int   cridw_pci_write_dword(void* pCookie, int offset,  ULONG pResult); 

//*************************************************************************
//  Function prototypes  (For the  Wrapper)
//*************************************************************************

int cridc_common_open(PCRIDDATA pInstance);
int cridc_common_close(PCRIDDATA pInstance);
int cridc_common_ioctl(ULONG ulCmd, void *pUserData,
                        void* ulKernelData, PCRIDDATA pInstance );
int cridc_common_intr(PCRIDDATA pInstance);
int cridc_common_init(PCRIDDATA pInstance);
int cridc_common_fini(PCRIDDATA pInstance);

#endif 
