//-----------------------------------------------------------------------------------------
// Cookie and page configuration stuff
//-----------------------------------------------------------------------------------------

function Cookie( document, name, days, path, domain, secure )
{
    this.$document = document;
    this.$name = name;

    if(days)
    {
        this.$expiration = new Date((new Date()).getTime() + days*24*3600000);
    }
    else
    {
        this.$expiration = null;
    }

    this.$path = ( path ? path : null );
    this.$domain = ( domain ? domain : null );
    this.$secure = ( secure ? secure : null );
}


function _Cookie_store()
{
    var cookieval = "";
    var cookie;
    var prop;

    for( prop in this )
    {
        if (("$" == prop.charAt(0)) || ("function" == typeof(this[prop])))
        {
            continue;
        }

        if( "" != cookieval )
        {
            cookieval += "&";
        }

        cookieval += prop + ":" + escape( this[prop] );
    }

    cookie = this.$name + "=" + cookieval;

    if(this.$expiration)
    {
        cookie += "; expires=" + this.$expiration.toGMTString();
    }

    if(this.$path)
    {
        cookie += "; path=" + this.$path;
    }

    if(this.$domain)
    {
        cookie += "; domain=" + this.$domain;
    }

    if(this.$secure)
    {
        cookie += "; secure";
    }

    this.$document.cookie = cookie;
}


function _Cookie_load()
{
    var allcookies = this.$document.cookie;
    var end;
    var cookieval;
    var a;
    var i;

    if("" == allcookies)
    {
        return false;
    }

    start = allcookies.indexOf(this.$name + "=");
    if( -1 == start )
    {
        return false;
    }

    start += this.$name.length + 1;
    end = allcookies.indexOf(";", start);

    if( -1 == end )
    {
        end = allcookies.length;
    }

    cookieval = allcookies.substring(start, end);

    a = cookieval.split("&");
    for(i=0; i<a.length; i++)
    {
        a[i] = a[i].split(":");
        this[ a[i][0] ] = unescape( a[i][1] );
    }

    return true;
}


function _Cookie_remove()
{
    var cookie;

    cookie = this.$name + "=";

    if(this.$path)
    {
        cookie += "; path=" + this.$path;
    }

    if(this.$domain)
    {
        cookie += "; domain=" + this.$domain;
    }

    cookie += "; expires=Fri, 02-Jan-1970 00:00:00 GMT";

    this.$document.cookie = cookie;
}

new Cookie();

Cookie.prototype.store =    _Cookie_store;
Cookie.prototype.load =     _Cookie_load;
Cookie.prototype.remove =   _Cookie_remove;

//--- CHP config items ---
autorefreshEnabled = "autorefreshEnabled";
autorefreshInterval = "autorefreshInterval";

configDefaults = new Array;
configDefaults[autorefreshEnabled]     = "false";
configDefaults[autorefreshInterval]    = 5;

chpConfig = new Cookie(document, "COMPAQ-CHP", 30, "/");

chpConfig.load();

function defaultConfig()
{
    //-- use configDefaults to default values ---
    var member;

    for(member in configDefaults)
    {
       chpConfig[member] = configDefaults[member];
    }

    chpConfig.store();
}


function configSet( configItem, itemValue )
{
   chpConfig[configItem] = itemValue;
   chpConfig.store();
}


function configGet( configItem )
{
    var itemValue = null;

    if( "undefined" == typeof( chpConfig[ configItem ] ))
    {
        if( "undefined"!=typeof( configDefaults[ configItem ] ))
        {
            itemValue = configDefaults[ configItem ];
        }

        configSet( configItem, itemValue );
    }

    return chpConfig[ configItem ];
}


