




//-----------------------------------------------------------------------------
// Name: ValidateAMEA02()
// Desc: 
//
// Parameters:      disableNext -            [global or local?]
//                  requiresEven -           [global or local?]
//                  updateDataFormComplete - [global or local?]
//                  
// Return Value:    false always
// Pre-conditions:  none
// Post-conditions: none
//                                                                    mm25Aug03      
//-----------------------------------------------------------------------------

function ValidateAMEA02()
   {
   if ( !disableNext )
     {
     disableNext = true;
     if ( requiresEven )
        {
        SetTaskData("updateDataFormComplete", false);
        document.updateMigrationForm.submit();
        WaitForDataReadyAndValidate();
        }
     else
        {
        Validate();
        }
     }
   return false;
   }





//-----------------------------------------------------------------------------
// Name: WaitForDataReadyAndValidate()
// Desc: Polls until dataComplete has been set to true. [what does this mean?]
//
// Parameters:      dataComplete -           [global or local?]
//                  updateDataFormComplete - [global or local?] 
//                  
// Return Value:    none
// Pre-conditions:  none
// Post-conditions: none
//                                                                    mm25Aug03      
//-----------------------------------------------------------------------------


function WaitForDataReadyAndValidate()
  {
  dataComplete = GetTaskData("updateDataFormComplete");
  if ( !dataComplete )
    {
    setTimeout("WaitForDataReadyAndValidate();", 500);
    }
  else
    {
    Validate();
    }
  }

function Validate()
  {
  isOkToSubmit = true;
  shouldMigrate = false;
  numChecked = numElementsChecked();

  defaultMigrationOption = parent.AMEA02BFrame.migration.defaultOption;
  isMigrationNecessary = parent.AMEA02BFrame.migration.isNecessary;
  migrationNumChoices = parent.AMEA02BFrame.migration.numChoices;
  document.nextWithMigration.ARRAY_MIGRATION_OPTION.value = defaultMigrationOption;

  if ( numChecked == 0 )
    {
    message = LoadString("PX_TAG_EXPAND_ARRAY_EMPTY");
    alert(message);
    isOkToSubmit = false;
    }
  else if ( requiresEven && isMigrationNecessary )
    {
    if ( migrationNumChoices > 0 )
      {
      if ( defaultMigrationOption == "RAIDADG" )
        {
        message = LoadString("PX_TAG_EXPAND_ARRAY_MIGRATE_RAIDADG");
        }
      else
        {
        message = LoadString("PX_TAG_EXPAND_ARRAY_MIGRATE_RAID5");
        }

      shouldMigrate = confirm(message);
      isOkToSubmit = shouldMigrate;
      }
    else
      {
      message = LoadString("PX_TAG_EXPAND_ARRAY_EVEN_REQUIRED");
      alert(message);
      isOkToSubmit = false;
      }
    }

  if ( isOkToSubmit )
    {
    if ( shouldMigrate )
      {
      document.nextWithMigration.submit();
      }
    else
      {
      document.nextNoMigration.submit();
      }
    }
  disableNext = false;
  return false;
  }

function WritePhysicalDriveCommands()
   {
   for ( var i=0; i<numChoices; ++i )
      {
      physicalDriveCommand = offcommand;
      if (option[i].checked)
        {
        physicalDriveCommand = command;
        }
      WriteCommand( physicalDriveCommand, option[i].id );
      }
   }
   
   
function HandleSelectAll(isSelectAll)
   {
   NCFormReferenceArraySelectAll(isSelectAll);
   document.arrayPhysicalDrivesForm.submit();
   }
   
   
function HandlePhysicalDriveSelectionChange(index)
{
   NCFormReferenceArrayToggleItem(index);
   document.arrayPhysicalDrivesForm.submit();
}
 
function HandleArraySelectionChange(index)
{
   SetTaskData( "selectedArrayId", option[index].id );
}



