#! /bin/bash

#**************************************************************************
#    begin                : Wed Feb 28, 2001
#    copyright            : (C) 2003 by Adaptec
#
#    This is the installer script for Adaptec SCSI drivers
#**************************************************************************
#                                                                         *
#   This program is free software; you can redistribute it and/or modify  *
#   it under the terms of the GNU General Public License as published by  *
#   the Free Software Foundation; either version 2 of the License, or     *
#   (at your option) any later version.                                   *
#                                                                         *
#**************************************************************************

product="aic7xxx"
installer_path=/usr/adaptec/$product
initrdbackupdir=/usr/initrdbackup
PATH=$installer_path:$PATH 
export PATH 

VERSION="6.2.35"
verbose=0
root_dir=""
do_mkinitrd=1
do_lilo=1
force=0
module_count=0
use_grub=0
savail=0
sneeded=0
echo
echo Adaptec $product driver installer - V$VERSION
echo 

lilo_conf=$root_dir"/etc/lilo.conf"
grub_conf=$root_dir"/boot/grub/grub.conf"
elilo_conf=`find /boot -type f -name elilo.conf -print`
boot_dir=`echo $elilo_conf | sed -e 's,elilo.conf,,'`
if [ ! -n "$boot_dir" ] ; then
	boot_dir="/boot"
fi
if [ ! -e "$grub_conf" ] ; then
	grub_conf=$root_dir"/boot/grub/menu.lst"
fi
prebuilt_binaries=/usr/adaptec/$product/$product"_prebuilt.tgz"
tmp_magic=/tmp/magic$$

# output usage statement
usage () {
	echo "usage: `basename $0` [--version] || [--help] ||" >&2
	echo "            [--verbose] [--root=<root dir>] [--noinitrd] [--nolilo] [--force]" >&2
	echo
	echo "usage: `basename $0` [--list_modules] " >&2
	echo
	echo "For the proceedure to patch your kernel sources see /usr/adaptec/$product/readme.txt"
	echo
	exit 1
}

# write an updated magic file
write_magic () {
cat <<-blub >$tmp_magic
	0x202	string		HdrS		Linux/i386 Kernel
	>0x206	short		0x0105		setupV1 zImage
	>0x206	short		0x0200		setupV2
	>>0x211	byte		0		zImage
	>>0x211	byte		1		bzImage
	>(0x20e.s+0x205)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%5.5s"
	>(0x20e.s+0x206)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%6.6s"
	>(0x20e.s+0x207)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%7.7s"
	>(0x20e.s+0x208)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%8.8s"
	>(0x20e.s+0x209)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%9.9s"
	>(0x20e.s+0x20a)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%10.10s"
	>(0x20e.s+0x20b)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%11.11s"
	>(0x20e.s+0x20c)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%12.12s"
	>(0x20e.s+0x20d)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%13.13s"
	>(0x20e.s+0x20e)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%14.14s"
	>(0x20e.s+0x20f)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%15.15s"
	>(0x20e.s+0x210)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%16.16s"
	>(0x20e.s+0x211)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%17.17s"
	>(0x20e.s+0x212)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%18.18s"
	>(0x20e.s+0x213)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%19.19s"
	>(0x20e.s+0x214)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%20.20s"
	>(0x20e.s+0x215)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%21.21s"
	>(0x20e.s+0x216)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%22.22s"
	>(0x20e.s+0x217)	byte	32
	>>(0x20e.s+0x200)	string	>\0	"%23.23s"
blub
}

clean_magic () {
	rm -f $tmp_magic 2>/dev/null
}

list_prebuilt_modules () {

	echo Prebuilt modules:
	list=`tar ztf $prebuilt_binaries 2>/dev/null | sort` 
	display_list=`echo $list | sed "s/$product-//g"`
	for i in $display_list ; do
		echo "	** $i"
	done
	
	echo
}


install_module() {
	if [ ! -e "$1" ] ; then
		mkdir -p $1 
	fi
	saved_pwd=`pwd`
	cd $1

	versions="ia64 athlon i686 i586 i386 ia32"

	if [ $verbose -eq 1 ] ; then
		echo Installing Module...
	fi

	firstloop=1
	for m in $versions ; do
		if [ $firstloop -eq 1 ] ; then
			if [ $m = $3 ] ; then
				firstloop=0
			else
				continue
			fi
		fi
		if [ ! -n "$m" ] ; then
			m="ia32"
		fi
		if [ $verbose -eq 1 ] ; then
			echo "Checking for prebuilt $2-$m."
		fi
		module_file=$product-$2-$m
		tar zxf $prebuilt_binaries $module_file >/dev/null 2>/dev/null
		if [ -e "$module_file" ] ; then 
			if [ $verbose -eq 1 ] ; then
				echo "Found prebuilt for $2-$m."
			fi
			break;
		fi
	done
	if ! [ -e "$module_file" ] ; then
		echo
		echo "****** PROBLEM *******"
		echo "No prebuilt module for "$2 $3
		echo "**********************"
		cd $saved_pwd
		return 1
	fi	   
	find . -name $product.o -print |xargs rm -f 2>&1 > /dev/null
	mv -f $module_file $product.o
	if [ $verbose -eq 1 ] ; then
		echo "Module installed for "$1" kernel."
	fi
	cd $saved_pwd
	return 0
}


modify_sysconfig_kernel() {
	sysconfig_kernel=$root_dir"/etc/sysconfig/kernel"
	if [ $verbose -eq 1 ] ; then
		echo "Modifying "$sysconfig_kernel
	fi

	if ! [ -e "$sysconfig_kernel" ] ; then
		if [ $verbose -eq 1 ] ; then
			echo "No rc.config file"
		fi
		return 1
	fi

        # Backup current config
        cp -fp $sysconfig_kernel $root_dir/etc/sysconfig/kernel.$$
	if [ $verbose -eq 1 ] ; then
		grep "INITRD_MODULES" $sysconfig_kernel
	else
		grep "INITRD_MODULES" $sysconfig_kernel >/dev/null
	fi
        if [ $? -ne 0 ] ; then
		# Configuration not set up to use ramdisks add it
		echo "INITRD_MODULES= \"\"" >>$sysconfig_kernel 
        fi
	sed "s/INITRD_MODULES[ \t]*=[ \t]*/INITRD_MODULES=/" $sysconfig_kernel >/tmp/sysconfig_kernel.tmp && mv -f /tmp/sysconfig_kernel.tmp $sysconfig_kernel

        current_modules=`grep "INITRD_MODULES[ \t]*=" $sysconfig_kernel | head -1`
        echo $current_modules | grep $product >/dev/null
	if [ $? -ne 0 ] ; then
		# If we cannot find in the config file, add it.
		new_modules=`echo $current_modules | sed "s/\"[ \t]*$/ $product\"/"`
		sed "s/INITRD_MODULES.*/$new_modules/" $sysconfig_kernel >/tmp/sysconfig_kernel.tmp && mv -f /tmp/sysconfig_kernel.tmp $sysconfig_kernel
        fi
	if [ $verbose -eq 1 ] ; then
		grep "INITRD_MODULES" $sysconfig_kernel
	fi
	return 0
}


modify_rc_config() {
	rc_config=$root_dir"/etc/rc.config"
	if [ $verbose -eq 1 ] ; then
		echo "Modifying "$rc_config
	fi

	if ! [ -e "$rc_config" ] ; then
		if [ $verbose -eq 1 ] ; then
			echo "No rc.config file"
		fi
		return 1
	fi

        # Backup current config
        cp -fp $rc_config $root_dir/etc/rc.config.$$
	if [ $verbose -eq 1 ] ; then
		grep "INITRD_MODULES" $rc_config
	else
		grep "INITRD_MODULES" $rc_config >/dev/null
	fi
        if [ $? -ne 0 ] ; then
		# Configuration not set up to use ramdisks add it
		echo "INITRD_MODULES= \"\"" >>$rc_config 
        fi
	sed "s/INITRD_MODULES[ \t]*=[ \t]*/INITRD_MODULES=/" $rc_config >/tmp/rc.config.tmp && mv -f /tmp/rc.config.tmp $rc_config

        current_modules=`grep "INITRD_MODULES[ \t]*=" $rc_config | head -1`
        echo $current_modules | grep $product >/dev/null
	if [ $? -ne 0 ] ; then
		# If we cannot find in the config file, add it.
		new_modules=`echo $current_modules | sed "s/\"[ \t]*$/ $product\"/"`
		sed "s/INITRD_MODULES.*/$new_modules/" $rc_config >/tmp/rc.config.tmp && mv -f /tmp/rc.config.tmp $rc_config
        fi
	if [ $verbose -eq 1 ] ; then
		grep "INITRD_MODULES" $rc_config
	fi
	return 0
}


modify_modules_conf() {

	modules_conf=""
	if [ -e "$root_dir/etc/modules.conf" ] ; then
		modules_conf="$root_dir/etc/modules.conf"
	elif [ -e "$root_dir/etc/conf.modules" ] ; then
		modules_conf="$root_dir/etc/conf.modules"
	else
		if [ $verbose -eq 1 ] ; then
			echo "No modules.conf file"
		fi
		return 1
	fi
	if [ $verbose -eq 1 ] ; then
		echo "Modifying "$modules_conf
	fi

	# Remove references to old names for our drivers like aic7xxx_mod.o
	sed -e "s/${product}_mod/$product/g" $modules_conf \
	    > /tmp/modules.conf$$
	mv /tmp/modules.conf$$ $modules_conf
	grep 'alias scsi_hostadapter' $modules_conf \
	     | grep "${product}[[:space:]]*$" > /dev/null
	if [ $? -ne 0 ] ;  then
		# Put in entry if not already in config file
		echo "alias scsi_hostadapter $product" >> $modules_conf
		if [ $verbose -eq 1 ] ; then
			echo "No $product entry - adding it..."
		fi
	else
		grep 'alias scsi_hostadapter' $modules_conf \
		     | grep "^[^#]*$product" > /dev/null
		if [ $? -ne 0 ] ;  then
			# Module has been explicitly disabled from the
			# initrd.  Skip the mkinitrd step.
			if [ $verbose -eq 1 ] ; then
				echo "Module explicitly disabled in $modules_conf."
				echo "Skipping mkintird step."
			fi
			do_mkinitrd=0
		fi
	fi

	tmp_modules=/tmp/modules.conf.$$
	# Enumerate scsi_hostadapter entries
	awk ' \
	BEGIN \
	{ \
		c=1; \
	} \
	{ \
		if (($1 == "alias") && (substr($2, 0, length("scsi_hostadapter")) == "scsi_hostadapter")) \
		{ \
			$2="scsi_hostadapter"c; \
			print $0; \
			c=c+1; \
		} \
		else \
		{ \
			print $0; \
		} \
	}' $modules_conf >$tmp_modules && mv -f $tmp_modules  $modules_conf
	if [ $verbose -eq 1 ] ; then
		grep $product $modules_conf 
	fi

}

find_dups() {
	echo "Finding duplicate drivers..."

	mods=`find /lib/modules/$1 -type f -name "$product.o" -print`
	number=`echo $mods|wc -w`
	if [ $number -gt 1 ]; then
		echo "Duplicate $product drivers detected for kernel $1:"
		echo $mods
		echo "Please choose the correct one and then delete all others"
		echo "from /lib/modules/$1, then install this package again."
		echo "Installing the lastest $product RPM package, available"
		echo "from www.adaptec.com will also correct this problem."
		exit 1
	fi
}

# Making the initrd is one of the things that are very different 
# between the different distributions.  This script has been tested
# with RedHat, SuSE, Mandrake, and Caldera

run_mkinitrd() {

        echo "Creating initrd..."
# $1 = image
# $2 = kernel version
# $3 = initrd

	old_initrd=$3.$$
	mv -f $3 $old_initrd 2>/dev/null >/dev/null
	mkinitrd=`which mk_initrd 2>/dev/null`

	if [ -z "$mkinitrd" ] ; then	
		# if not the SuSE mk_initrd then try Red Hat/Mandrake style
		if [ "$root_dir" != "" ] ; then
			# if we specified root then use our modified one
			mkinitrd="/usr/adaptec/$product/adpt_mkinitrd --root="$root_dir
		else
			mkinitrd=`which mkinitrd 2>/dev/null`
		fi

		if [ -z "$mkinitrd" ] ; then
			# not Red Hat - check if Caldera
			tmp_initrd=`echo $3 | sed s/.gz$//`
			if [ "$tmp_initrd" != "$initrd" ] ; then
				if [ $verbose -eq 1 ] ; then
					echo "Making Caldera initrd..."
				fi
				if ! [ -e "/initrd" ] ; then
					mkdir -f /initrd
				fi

				mv -f $old_initrd $3

				rootfs="/etc/modules/rootfs"
				grep scsi_mod $rootfs >/dev/null 2>/dev/null
				if [ $? -ne 0 ] ; then
					echo scsi_mod >>$rootfs
				fi
				grep $product $rootfs >/dev/null 2>/dev/null
				if [ $? -ne 0 ] ; then
					echo $product >>$rootfs
				fi
				grep sd $rootfs >/dev/null 2>/dev/null
				if [ $? -ne 0 ] ; then
					echo sd >>$rootfs
				fi
				gunzip $3 >/dev/null 
				mount -o loop $tmp_initrd /initrd >/dev/null 2>/dev/null
				cp -f /lib/modules/$2/kernel/drivers/scsi/$product.o /initrd/lib/modules/
				cp -f $rootfs /initrd/etc/modules/rootfs
				sync
				umount $tmp_initrd >/dev/null 2>/dev/null
				sync
				gzip $tmp_initrd >/dev/null
				depmod -qa $2
				return 0
			else
				echo "Can not find mkinitrd. Exitting..."
				exit 1
			fi
		fi

		if [ $verbose -eq 1 ] ; then
			echo "$mkinitrd $3 $2"
		fi

		find_dups $2

		sh -c "$mkinitrd $3 $2"
	else
		grep root_device $mkinitrd >/dev/null 2>/dev/null
		if [ $? -ne 0 ] ; then
			mkinitrd="/usr/adaptec/$product/adpt_mk_initrd"
		fi

		if [ "$root_dir" != "" ] ; then
			mkinitrd=$mkinitrd" "$root_dir
		fi
		if [ $verbose -eq 1 ] ; then
			echo "$mkinitrd -k `basename $1` -i `basename $3`"
		fi

		sh -c "$mkinitrd  -k `basename $1` -i `basename $3`"
	fi

	if [ $? -ne 0 ] ; then
		echo Problem making initrd.  Quitting.
		if [ -e $old_initrd ] ; then
			mv -f $old_initrd $3
		fi
		return 1
	fi
	return 0

}

run_lilo() {

	echo
        echo "Running lilo..."
	if [ "$root_dir" != "" ] ; then
		lilo -r $root_dir -w
	else
		lilo
	fi
	if [ $? -ne 0 ] ; then
		echo Problem running lilo.  Quitting.
		exit 1
	fi
	echo
        echo "Reboot to load Ram Disk."
	echo
}

begin_install_module() {

	file=file
	[ -x /usr/bin/file ] && file=/usr/bin/file
	[ -x $root_dir/usr/bin/file ] && file=$root_dir/usr/bin/file

	awk -f $awk_script $awk_file | sort +2 | while read image initrd label; do

		if [ "X$boot_dir" != "X/boot" ] ; then
			cd $boot_dir
		fi
		if [ $image = "?" ] ; then
			global_initrd=$initrd
			continue
		fi
		echo
		file_magic=`$file -L -m $tmp_magic $image`" \""
		kernel=`echo $file_magic | cut -d \" -f 2 `

		if [ -z $kernel ] ; then
			# Try grepping.  Our magic file doesn't
			# understand IA64 kernels and making it
			# understand them looks difficult...
			kernel=`grep -a -e 'Linux version .* (' $image |
				tr -c -d [:print:] |
				sed -e 's,.*Linux version \([^ ]*\) (.*,\1,'`
		fi

		if [ -z $kernel ] ; then
			# Same thing, but try gunziping first.
			kernel=`zcat $image |
				grep -a -e 'Linux version .* (' |
				tr -c -d [:print:] |
				sed -e 's,.*Linux version \([^ ]*\) (.*,\1,'`
		fi

		if [ -z $kernel ] ; then
			# Same thing, but try bunziping first.
			kernel=`bzcat $image |
				grep -a -e 'Linux version .* (' |
				tr -c -d [:print:] |
				sed -e 's,.*Linux version \([^ ]*\) (.*,\1,'`
		fi

		echo "Configuration ["$label"]"
		if [ -z $kernel ] ; then
			echo
			echo ***NOTICE: $image " is not a kernel. Skipping."
			echo
			continue
		fi

		if [ $verbose -eq 1 ] ; then
			echo "label="${label}" image="${image}" version="\[$kernel\]" initrd="${initrd}
		fi

		if [ $do_mkinitrd -eq 1 ] ; then
			if [ $initrd = "?" ] ; then
				if [ -z $global_initrd ] ; then
					echo
					echo "****** PROBLEM *******"
					echo Kernel $image is not configured to use initrd.  Skipping.
					echo
					echo "TO FIX THIS PROBLEM:"
					echo "Modify $awk_file for this config to use an initrd"
					echo "(e.g. initrd=/boot/initrd-$kernel.img)"
					echo "**********************"
					continue
				fi
				if [ -z $last_initrd_kernel ] ; then
					initrd=$global_initrd
				elif [ $last_initrd_kernel = $kernel ] ; then
					initrd=$global_initrd
				else
					echo "****** PROBLEM *******"
					echo A globally declared initrd is used for two different 
					echo kernel versions.  Please fix this in $awk_file
					echo and rerun the install.
					echo "**********************"
					exit 1
				fi
				if [ $verbose -eq 1 ] ; then
					echo "Setting initrd to global initrd->"$initrd
				fi
				last_initrd_kernel=$kernel

			fi

			if [ x$initrd = x$last_initrd ] ; then
				if [ x$kernel = x$last_kernel ] ; then
					echo "Same as last initrd. Skipping."
					continue;
				elif [ $force -ne 1 ] ; then
					echo
					echo "****** PROBLEM *******"
					echo In $awk_file there are two different kernel versions 
					echo assigned to the same initrd - fix this and rerun installer.
					echo Or use the --force option
					echo "**********************"
					exit 1
				fi
			fi
		fi


		echo $image" -> "$kernel
		last_kernel=$kernel
		last_initrd=$initrd
		tmpVersion=`echo $kernel | sed -e "s/^2.2//"`
		if [ $tmpVersion != $kernel ] ; then
			installPath=$root_dir"/lib/modules/"$kernel"/scsi"
		else
			installPath=$root_dir"/lib/modules/"$kernel"/kernel/drivers/scsi"
		fi

		machine=`uname -m`
		if [ $machine = "i686" ] ; then
			# athlon check
			cat /proc/cpuinfo | grep "AMD Athlon"
			if [ $? -eq 0 ] ; then
				machine="athlon"
			fi
			cat /proc/cpuinfo | grep "AMD-K7"
			if [ $? -eq 0 ] ; then
				machine="athlon"
			fi
		fi

		install_module $installPath $kernel $machine
		if [ $? -ne 0 ] ; then
			continue;
		fi
		echo "Installing in "$installPath

		module_count=`expr $module_count + 1`
		echo $module_count >/tmp/$product.tmp

		if [ $do_mkinitrd -eq 1 ] ; then
			run_mkinitrd $image $kernel $initrd
			if [ $? -ne 0 ] ; then
				exit 1
			fi
		fi

	done
}


# parse the arguments
while [ $# -gt 0 ]; do
	case $1 in
		--version)
			echo `basename $0`": version $VERSION"
			exit 0
			;;

		--verbose)
			verbose=1
			;;

		--root*)
			if echo $1 | grep '=' >/dev/null ; then
				root_dir=`echo $1 | sed 's/^--root=//'`
			else
				root_dir=$2
				shift
			fi
			;;

		--list_modules)
			list_prebuilt_modules
			exit 0
			;;

		--noinitrd)
			do_mkinitrd=0
			do_lilo=0
			;;

		--nolilo)
			do_lilo=0
			;;

		--force)
			force=1
			;;

		--help)
			usage	
			;;
		*)
			usage
			;;
	esac

	shift
done

if [ $verbose -eq 1 ] ; then
	echo "Options: do_mkinitrd="$do_mkinitrd" do_lilo="$do_lilo" root dir="$root_dir
fi

df -k ${boot_dir} | awk -f df.awk | while read savail; do
echo  $savail > filesavail
done
tar ztvf $prebuilt_binaries |grep 'aic7.xx'|awk -f tar.awk|while read sneeded;do
	echo $sneeded > filesneeded
done
savail=`cat filesavail`
sneeded=`cat filesneeded`
echo "savail=" $savail
echo "sneeded=" $sneeded
if [ $savail -lt $sneeded ] ; then
	initrdlist=`ls /boot|grep 'initrd'`
	for i in $initrdlist; do
		if [ $i = "initrd" ] ; then
			echo $i " is not moving"
		else 
			if [ $i = "initrd.suse" ] ; then
				echo $i " is not moving"
			else
				if [ ! -e "$initrdbackupdir" ] ; then
					mkdir -p $initrdbackupdir
				fi
				if [ ! -e "$initrdbackupdir/$i" ] ; then
					mv /boot/$i $initrdbackupdir
					ln -s $initrdbackupdir/$i /boot/$i
					echo "No room in /boot, " $i "is now a link to " $initrdbackupdir$i
				else
					rm -rf /boot/$i
					ln -s $initrdbackupdir/$i /boot/$i
					echo "No room in /boot, " $i "is now a link to " $initrdbackupdir$i
				fi
			fi
		fi
	done
fi

# for now if no bootloader then we can not install anything. 
# TODO next version install anyway to the /lib/modules directories
if [ ! -e "$lilo_conf" -a ! -e "$grub_conf" -a ! -e "$elilo_conf" ] ; then
	echo "System is not configured to use a boot loader."
	echo "Checked lilo, elilo, and grub."
	echo "Stopping..."
	exit 1
fi

# Look for the existance of LILO and GRUB files independently
if [ -e "$grub_conf" ] ; then
	echo "Using GRUB configuration"
	echo "If this is not what you want, rename your $grub_conf file"
	use_grub=1
	do_lilo=0
	awk_script="grub.awk"
	awk_file=$grub_conf
fi

if [ -e "${root_dir}/etc/sysconfig/kernel" ]; then
	modify_sysconfig_kernel
fi
if [ -e "${root_dir}/etc/rc.config" ]; then
	modify_rc_config
fi
if [ -e "${root_dir}/etc/modules.conf" ]; then
	modify_modules_conf
fi
write_magic 

if [ -e "$grub_conf" ] ; then
	begin_install_module
fi

if [ -e "$lilo_conf" ] ; then
	echo "Using LILO configuration"
	use_grub=0
	do_lilo=1
	awk_script="lilo.awk"
	awk_file=$lilo_conf
	begin_install_module
fi

if [ -e "$elilo_conf" ] ; then
	use_grub=0
	do_lilo=0
	awk_script="lilo.awk"
	awk_file=$elilo_conf
	begin_install_module
fi

if [ $? -eq 1 ] ; then
	clean_magic
	exit 1
fi

clean_magic
module_count=`cat /tmp/$product.tmp 2>/dev/null || echo 0`
rm -f /tmp/$product.tmp >/dev/null 2>/dev/null
if [ $module_count -eq 0 ] ; then
	echo
	echo "***************************************"
	echo "******** NO MODULES INSTALLED *********"
	echo "***************************************"
	echo
	echo "Done."
	exit 1
fi


echo

if [ $do_lilo -eq 1 ] ; then
run_lilo	
fi

echo Done.
exit
