<html>
<!-- $RCSfile: MS-SCSI.TPL $ $Revision: 1.34 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>SCSI Device Information</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqScsiCntlrEntry>
<!cpqScsiTargetEntry>
<!cpqScsiPhyDrvEntry>
<!cpqTapePhyDrvEntry>
<!cpqTapeCountersEntry>
<!cpqTapeLibraryEntry>
<!cpqTapeLibraryDriveList.raw>
<!cpqSsDrvBoxEntry>
<!cpqCdLibraryEntry>
<!cpqScsiCdDrvEntry>
<!cpqCdLibraryDriveList.raw>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#TPENUMS.JS>
<!#SCSENUMS.JS>
<!#SSENUMS.JS>
<!#MS-SCSIC.JS>
<!#MS-DRVBX.JS>

postfix["cpqScsiPhyDrvSize"] = "MB";

function NegotiatedWidth(bits)
{
   if (bits == 8)
      return ("Narrow (8 bits)");
   else if (bits == 16)
      return ("Wide (16 bits)");
   else return ("N/A");
}

function hotPlugGraphic()
{
   return ("<img src='/WEBAGENT/CQMGSTOR/ENG/HOTPLUG.JPG' align='middle' width='11' height='15' hspace='3' border='0'> ");
}

function boxStatusGraphic(boxIndex)
{
   var boxStatus = new cpqCondition(cpqSsDrvBoxEntry[boxIndex].cpqSsBoxCondition);
   return boxStatus.image();
}

function writeScsiDevInfoTable(idx)
{
   writeTableHead();
   writeDoubleTableRow("Device Type:",      targetType(idx),
                       "Vendor:",           displayItem("cpqScsiTargetVendor", cpqScsiTargetEntry[idx].cpqScsiTargetVendor));
   writeDoubleTableRow("Firmware Version:", displayItem("cpqScsiTargetFWRev",  cpqScsiTargetEntry[idx].cpqScsiTargetFWRev),
                       "Model:",            displayItem("cpqScsiTargetModel",  cpqScsiTargetEntry[idx].cpqScsiTargetModel));
   writeTableTail();
}

function writeScsiBusTable(idx)
{
   if (cpqScsiTargetEntry[idx].cpqScsiTargetParityErrs     != "4294967295" ||
       cpqScsiTargetEntry[idx].cpqScsiTargetPhaseErrs      != "4294967295" ||
       cpqScsiTargetEntry[idx].cpqScsiTargetSelectTimeouts != "4294967295" ||
       cpqScsiTargetEntry[idx].cpqScsiTargetMsgRejects     != "4294967295")
   {
      document.write("<br>");
      writeTableLabel("SCSI Bus Information");
      writeTableHead();
      writeDoubleTableRow("Parity Errors:",   displayItem("cpqScsiTargetParityErrs",  cpqScsiTargetEntry[idx].cpqScsiTargetParityErrs),
                          "Physical Width:",  displayItem("cpqScsiTargetPhysWidth",   cpqScsiTargetEntry[idx].cpqScsiTargetPhysWidth));
      writeDoubleTableRow("Phase Errors:",    displayItem("cpqScsiTargetPhaseErrs",   cpqScsiTargetEntry[idx].cpqScsiTargetPhaseErrs),
                          "Current Width:",   NegotiatedWidth(cpqScsiTargetEntry[idx].cpqScsiTargetNegWidth));
      writeDoubleTableRow("Select Timeouts:", displayItem("cpqScsiTargetSelectTimeouts", cpqScsiTargetEntry[idx].cpqScsiTargetSelectTimeouts),
                          "Current Speed:",   displayItem("cpqScsiTargetCurrentSpeed", cpqScsiTargetEntry[idx].cpqScsiTargetCurrentSpeed));
      writeDoubleTableRow("Message Rejects:", displayItem("cpqScsiTargetMsgRejects",  cpqScsiTargetEntry[idx].cpqScsiTargetMsgRejects),
                          "","");
      writeTableTail();
   }
}

function actionFromStatus(status)
{
   rc = "No Action Required";

   if (status == null)
   {
      rc = "Unknown";
   }
   else if (status == 8 || status == 9)
   {
      rc = "Replace S.M.A.R.T. Drive";
   }
   else if (status == 3 || status == 6 || status == 7 || status == 11)
   {
      rc = "Replace drive";
   }
   return rc;
}

function writeScsiDriveTables(cntlr, bus, id, targIndex)
{
   var i;
   var modelName;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqScsiPhyDrvEntry.length; i++)
   {
      if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCntlrIndex == cntlr &&
          cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvBusIndex == bus &&
          cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvScsiID == id)
      {
         break;
      }
   }
   if (i < cpqScsiPhyDrvEntry.length)
   {
      if ((cpqScsiTargetEntry[targIndex].cpqScsiTargetVendor.length > 0) &&
          (cpqScsiTargetEntry[targIndex].cpqScsiTargetModel.length > 0))
      {
         modelName = cpqScsiTargetEntry[targIndex].cpqScsiTargetVendor + " " +
                     cpqScsiTargetEntry[targIndex].cpqScsiTargetModel;
      }
      else modelName = displayItem("cpqScsiTargetModel",  cpqScsiTargetEntry[targIndex].cpqScsiTargetModel);

      writeTableHead();
      writeDoubleTableRow(
         "Status:", displayItem("cpqScsiPhyDrvStatus", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvStatus),
         "Action:", actionFromStatus(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvStatus));
      writeDoubleTableRow(
         "Capacity:", driveCapacity("cpqScsiPhyDrvSize", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSize),
         "Model:",    modelName);
      writeDoubleTableRow(
         "Firmware Version:", displayItem("cpqScsiTargetFWRev",  cpqScsiTargetEntry[targIndex].cpqScsiTargetFWRev),
         "Serial Number:",    displayItem("cpqScsiPhyDrvSerialNum", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSerialNum));
      writeDoubleTableRow(
         "Service Hours:", displayItem("cpqScsiPhyDrvServiceHours", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvServiceHours),
         "S.M.A.R.T. Support:", displayItem("cpqScsiPhyDrvPreFailMonitoring", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPreFailMonitoring));

      if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHotPlug == 2)
      {
         writeDoubleTableRow(
            "Placement:",       displayItem("cpqScsiPhyDrvPlacement", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPlacement) + hotPlugGraphic(),
            "Rotational Speed:", displayItem("cpqScsiPhyDrvRotationalSpeed", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRotationalSpeed));
      }
      else writeDoubleTableRow(
              "Placement:",       displayItem("cpqScsiPhyDrvPlacement", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPlacement),
              "Rotational Speed:", displayItem("cpqScsiPhyDrvRotationalSpeed", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRotationalSpeed));
      writeTableTail();
      document.write("<br>");

      writeTableLabel("Drive Indicators");
      writeTableHead();
      writeDoubleTableRow("Used Realloc:",     displayItem("cpqScsiPhyDrvUsedReallocs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvUsedReallocs),
                          "Spinup Time:",      displayItem("cpqScsiPhyDrvSpinupTime", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSpinupTime));
      writeDoubleTableRow("Timeouts:",         displayItem("cpqScsiPhyDrvTimeouts", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvTimeouts),
                          "Self Test Errors:", displayItem("cpqScsiPhyDrvPostErrs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPostErrs));
      writeTableTail();
      document.write("<br>");

      writeTableLabel("Drive Statistics");
      writeTableHead();
      writeDoubleTableRow(
         "Sectors Read:", displayQuadNumber(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHighReadSectors,
                                            cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvLowReadSectors),
         "Sectors Written:", displayQuadNumber(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHighWriteSectors,
                                               cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvLowWriteSectors));
      writeDoubleTableRow(
         "Hard Read Errors:",  displayItem("cpqScsiPhyDrvHardReadErrs",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHardReadErrs),
         "Hard Write Errors:", displayItem("cpqScsiPhyDrvHardWriteErrs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHardWriteErrs));
      writeDoubleTableRow(
         "Recovered Read Errors:",  displayItem("cpqScsiPhyDrvRecvReadErrs",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRecvReadErrs),
         "Recovered Write Errors:", displayItem("cpqScsiPhyDrvRecvWriteErrs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRecvWriteErrs));
      writeDoubleTableRow(
         "ECC Corrected Reads:", displayItem("cpqScsiPhyDrvEccCorrReads", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvEccCorrReads),
         "Seek Errors:",         displayItem("cpqScsiPhyDrvSeekErrs",     cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSeekErrs));
      writeTableTail();
      log = cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvParent;
   }
}

function writeScsiTapeTables(cntlr, bus, id, targIndex)
{
   var i;
   var j;
   var fw;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqTapePhyDrvEntry.length; i++)
   {
      if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvCntlrIndex == cntlr &&
          cpqTapePhyDrvEntry[i].cpqTapePhyDrvBusIndex == bus &&
          cpqTapePhyDrvEntry[i].cpqTapePhyDrvScsiIdIndex == id)
      {
         break;
      }
   }
   if (i < cpqTapePhyDrvEntry.length)
   {
      if (typeof(cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwRev) == "undefined")
      {
         fw = displayItem("cpqTapePhyDrvFwSubtype", cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwSubtype);
      }
      else
      {
         fw = displayItem("cpqTapePhyDrvFwRev", cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwRev);
      }
      writeTableHead();
      writeDoubleTableRow(
         "Model:",  displayItem("cpqTapePhyDrvName",   cpqTapePhyDrvEntry[i].cpqTapePhyDrvName),
         "Status:", displayItem("cpqTapePhyDrvStatus", cpqTapePhyDrvEntry[i].cpqTapePhyDrvStatus));
      writeDoubleTableRow(
         "Firmware Version:", fw,
         "Serial Number:", displayItem("cpqTapePhyDrvSerialNumber", cpqTapePhyDrvEntry[i].cpqTapePhyDrvSerialNumber));

      if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvHotPlug == 2)
      {
         writeDoubleTableRow(
            "Library Drive:", displayItem("cpqTapePhyDrvLibraryDrive", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLibraryDrive),
            "Placement:",     displayItem("cpqTapePhyDrvPlacement", cpqTapePhyDrvEntry[i].cpqTapePhyDrvPlacement) + hotPlugGraphic());
      }
      else writeDoubleTableRow(
         "Library Drive:", displayItem("cpqTapePhyDrvLibraryDrive", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLibraryDrive),
         "Placement:",     displayItem("cpqTapePhyDrvPlacement", cpqTapePhyDrvEntry[i].cpqTapePhyDrvPlacement));
      writeTableTail();

      // Tape autoloader info
      if (cpqScsiTargetEntry[targIndex].cpqScsiTargetTypeExtended == 7)
      {
         document.write("<br>");
         writeTableLabel("Media Changer Information");
         writeTableHead();
         writeDoubleTableRow(
            "Model:",         displayItem("cpqTapePhyDrvLoaderName",   cpqTapePhyDrvEntry[i].cpqTapePhyDrvLoaderName),
            "Magazine Size:", displayItem("cpqTapePhyDrvMagSize",   cpqTapePhyDrvEntry[i].cpqTapePhyDrvMagSize));
         writeDoubleTableRow(
            "Firmware Version:", displayItem("cpqTapePhyDrvLoaderFwRev", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLoaderFwRev),
            "Serial Number:",    displayItem("cpqTapePhyDrvLoaderSerialNum", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLoaderSerialNum));
         writeTableTail();
      }
      // find the appropriate entry in the tape counters table
      for (j = 0; j < cpqTapeCountersEntry.length; j++)
      {
         if (cpqTapeCountersEntry[i].cpqTapeCountersCntlrIndex == cntlr &&
             cpqTapeCountersEntry[i].cpqTapeCountersBusIndex == bus &&
             cpqTapeCountersEntry[i].cpqTapeCountersScsiIdIndex == id)
         {
            document.write("<br>");
            writeTableLabel("Tape Drive Error Counts");
            writeTableHead();
            writeDoubleTableRow(
               "Tape Errors:", displayItem("cpqTapeCountersTotalErrors", cpqTapeCountersEntry[i].cpqTapeCountersTotalErrors),
               "Re-Reads:",    displayItem("cpqTapeCountersReReads", cpqTapeCountersEntry[i].cpqTapeCountersReReads));
            writeDoubleTableRow(
               "Uncorrectable:", displayItem("cpqTapeCountersTotalUncorrectable", cpqTapeCountersEntry[i].cpqTapeCountersTotalUncorrectable),
               "Re-Writes:",     displayItem("cpqTapeCountersReWrites", cpqTapeCountersEntry[i].cpqTapeCountersReWrites));
            writeTableTail();
            break;
         }
      }
      document.write("<br>");
      writeTableLabel("Tape Drive Maintenance");
      writeTableHead();
      writeSingleTableRow("Tape Drive Heads Need Cleaning:",
          displayItem("cpqTapePhyDrvCleanReq", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanReq));
      writeSingleTableRow("Cleaning Tape Needs Replacement:",
          displayItem("cpqTapePhyDrvCleanTapeRepl", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanTapeRepl));
      writeSingleTableRow("Number of Cleanings Performed:",
          displayItem("cpqTapePhyDrvCleanTapeCount", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanTapeCount));
      writeTableTail();
   }
}

function writeScsiTapeLibraryTables(cntlr, bus, id, targIndex)
{
   var i;
   var j;
   var n;
   var driveLink;
   var rawTable;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqTapeLibraryEntry.length; i++)
   {
      if (cpqTapeLibraryEntry[i].cpqTapeLibraryCntlrIndex == cntlr &&
          cpqTapeLibraryEntry[i].cpqTapeLibraryBusIndex == bus &&
          cpqTapeLibraryEntry[i].cpqTapeLibraryScsiIdIndex == id)
      {
         break;
      }
   }
   if (i < cpqTapeLibraryEntry.length)
   {
      writeTableHead();
      writeDoubleTableRow(
         "Model:",  displayItem("cpqTapeLibraryName",  cpqTapeLibraryEntry[i].cpqTapeLibraryName),
         "Status:", displayItem("cpqTapeLibraryState", cpqTapeLibraryEntry[i].cpqTapeLibraryState));
      writeDoubleTableRow(
         "Firmware Rev:",  displayItem("cpqTapeLibraryFwRev", cpqTapeLibraryEntry[i].cpqTapeLibraryFwRev),
         "Serial Number:", displayItem("cpqTapeLibrarySerialNumber", cpqTapeLibraryEntry[i].cpqTapeLibrarySerialNumber));
      writeDoubleTableRow(
         "Service Hours:", displayItem("cpqTapeLibraryStatHours", cpqTapeLibraryEntry[i].cpqTapeLibraryStatHours),
         "Total Moves:",   displayItem("cpqTapeLibraryStatMoves", cpqTapeLibraryEntry[i].cpqTapeLibraryStatMoves));
      writeDoubleTableRow(
         "Door Status:", displayItem("cpqTapeLibraryDoorStatus", cpqTapeLibraryEntry[i].cpqTapeLibraryDoorStatus),
         "Redundancy:", displayItem("cpqTapeLibraryRedundancy", cpqTapeLibraryEntry[i].cpqTapeLibraryRedundancy));
      writeDoubleTableRow(
         "Temperature:", displayItem("cpqTapeLibraryTemperature", cpqTapeLibraryEntry[i].cpqTapeLibraryTemperature),
         "Hot Swap:",   displayItem("cpqTapeLibraryHotSwap", cpqTapeLibraryEntry[i].cpqTapeLibraryHotSwap));
      writeDoubleTableRow(
         "Last Known Error:", displayItem("cpqTapeLibraryStatus", cpqTapeLibraryEntry[i].cpqTapeLibraryStatus),
         "", "");
      writeTableTail();

      document.write("<br>");
      writeTableLabel("Associated Tape Drives");
      writeTableHead();
      rawTable = cpqTapeLibraryDriveList[i];

      for (j = 0; j < (rawTable.length/4); j++)
      {
         var tapeName = "Tape Drive - ";
         var drvCntlr = rawTable[j*4];
         var drvBus = rawTable[j*4 + 1];
         var drvId  = rawTable[j*4 + 2];

         for (n = 0; n < cpqTapePhyDrvEntry.length; n++)
         {
            if (drvCntlr == cpqTapePhyDrvEntry[n].cpqTapePhyDrvCntlrIndex &&
                drvBus   == cpqTapePhyDrvEntry[n].cpqTapePhyDrvBusIndex   &&
                drvId    == cpqTapePhyDrvEntry[n].cpqTapePhyDrvScsiIdIndex)
            {
               tapeCondition = new cpqCondition(cpqTapePhyDrvEntry[n].cpqTapePhyDrvCondition);
               tapeName = tapeCondition.imageSmall() + cpqTapePhyDrvEntry[n].cpqTapePhyDrvName + " - ";
               break;
            }
         }
         for (n = 0; n < cpqScsiCntlrEntry.length; n++)
         {
            if (drvCntlr == cpqScsiCntlrEntry[n].cpqScsiCntlrIndex)
            {
               tapeName += "SCSI Controller Slot " +
                            cpqScsiCntlrEntry[n].cpqScsiCntlrSlot;
               break;
            }
         }
         tapeName += " Port " + drvBus + " ID " + drvId;
         driveLink = makeLink("CQMGSTOR/MS-SCSI.TPL?index=" + drvCntlr +
                              "&bus=" + drvBus + "&id=" + drvId, tapeName, "_self");
         writeOneItemTableRow(driveLink);
      }
      writeTableTail();
   }
}

function writeScsiCdLibraryTables(cntlr, bus, id, targIndex)
{
   var i;
   var j;
   var k;
   var rawTable;
   var drvCntlr;
   var drvBus;
   var drvId;
   var drvLun;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqCdLibraryEntry.length; i++)
   {
      if (cpqCdLibraryEntry[i].cpqCdLibraryCntlrIndex == cntlr &&
          cpqCdLibraryEntry[i].cpqCdLibraryBusIndex == bus &&
          cpqCdLibraryEntry[i].cpqCdLibraryScsiIdIndex == id)
      {
         break;
      }
   }
   if (i < cpqCdLibraryEntry.length)
   {
      writeTableHead();
      writeSingleTableRowInDoubleTable(
         "Status:", displayItem("cpqCdLibraryStatus", cpqCdLibraryEntry[i].cpqCdLibraryStatus));
      writeDoubleTableRow(
         "Serial Number:",  displayItem("cpqCdLibrarySerialNumber", cpqCdLibraryEntry[i].cpqCdLibrarySerialNumber),
         "Controller LUN:", displayItem("cpqCdLibraryLunIndex",     cpqCdLibraryEntry[i].cpqCdLibraryLunIndex));
      writeTableTail();

      document.write("<br>");
      writeTableLabel("Associated CD Drives");
      writeTableHead();
      writeColumnTableHeaderRow("Vendor:", "Model:", "Firmware Rev:", "LUN:");

      rawTable = cpqCdLibraryDriveList[i];
      for (j = 0; j < (rawTable.length/4); j++)
      {
         drvCntlr = rawTable[j*4];
         drvBus   = rawTable[j*4 + 1];
         drvId    = rawTable[j*4 + 2];
         drvLun   = rawTable[j*4 + 3];

         for (k = 0; k < cpqScsiCdDrvEntry.length; k++)
         {
            if (cpqScsiCdDrvEntry[k].cpqScsiCdDrvCntlrIndex ==  drvCntlr &&
                cpqScsiCdDrvEntry[k].cpqScsiCdDrvBusIndex ==    drvBus &&
                cpqScsiCdDrvEntry[k].cpqScsiCdDrvScsiIdIndex == drvId &&
                cpqScsiCdDrvEntry[k].cpqScsiCdDrvLunIndex ==    drvLun)
            {
               writeColumnTableDataRow(cpqScsiCdDrvEntry[k].cpqScsiCdDrvVendor,
                  cpqScsiCdDrvEntry[k].cpqScsiCdDrvModel,
                  cpqScsiCdDrvEntry[k].cpqScsiCdDrvFwRev, drvLun);
            }
         }
      }
      writeTableTail();
   }
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

cntlr = findArg("index");
bus = findArg("bus");

if (cntlr == -1 || bus == -1)
{
   parseArgs(tryPrevPage());
   cntlr = findArg("index");
   bus = findArg("bus");
}
for (cntlrIdx = 0; cntlrIdx < cpqScsiCntlrEntry.length; cntlrIdx++)
{
   if (cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrIndex == cntlr &&
       cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrBusIndex == bus)
      break;
}
if (cpqScsiCntlrEntry.length == cntlrIdx)
{
   reportMissingArgs();
}
else
{
   id = findArg("id");
   box = findArg("box");

   if (id != -1)  // SCSI target
   {
      for (i = 0; i < cpqScsiTargetEntry.length; i++)
      {
         if (cpqScsiTargetEntry[i].cpqScsiTargetCntlrIndex == cntlr &&
             cpqScsiTargetEntry[i].cpqScsiTargetBusIndex == bus &&
             cpqScsiTargetEntry[i].cpqScsiTargetScsiIdIndex == id)
            break;
      }
      targetidx = i;
      pageTitle = targetName(targetidx);
   }
   else if (box != -1) // storage box
   {
      count = 0;
      for (i = 0; i < cpqSsDrvBoxEntry.length; i++)
      {
         if (cpqSsDrvBoxEntry[i].cpqSsBoxCntlrIndex == cntlr &&
             cpqSsDrvBoxEntry[i].cpqSsBoxBusIndex == bus)
         {
            if (count == box) break;
            count++;
         }
      }
      boxidx = i;
      pageTitle = displayItem("cpqSsBoxPlacement", cpqSsDrvBoxEntry[boxidx].cpqSsBoxPlacement)
       + " on Port " + bus;
   }
   writePageHead(scsiCntlrName(cntlrIdx), "/WEBAGENT/IMAGES/MASSHDR.GIF", "SCSI Device Information");

   if (id != -1)  // display the devices
   {
      tableTitle = targetStatusGraphic(targetidx, "LARGE") + targetName(targetidx);
      writeTableLabel(tableTitle, "SCSI Device Information");

      // display any type-specific info here:
      thisType = cpqScsiTargetEntry[targetidx].cpqScsiTargetType;
      thisTypeExt = cpqScsiTargetEntry[targetidx].cpqScsiTargetTypeExtended;
      if (thisType ==  2) // drive
      {
         writeScsiDriveTables(cntlr, bus, id, targetidx);
      }
      else if (thisType == 3)   // tape
      {
         writeScsiTapeTables(cntlr, bus, id, targetidx);
      }
      else if (thisTypeExt == 4) // tape library
      {
         writeScsiTapeLibraryTables(cntlr, bus, id, targetidx);
      }
      else if (thisTypeExt == 5) // CD library
      {
         writeScsiDevInfoTable(targetidx);
         writeScsiCdLibraryTables(cntlr, bus, id, targetidx);
      }
      else
      {
         writeScsiDevInfoTable(targetidx);
      }
      document.write("<br>");
      writeScsiBusTable(targetidx);
   }
   else if (box != -1) // display storage boxes
   {
      tableTitle = boxStatusGraphic(boxidx) + displayItem("cpqSsBoxPlacement",
                   cpqSsDrvBoxEntry[boxidx].cpqSsBoxPlacement) + " on Port " + bus;
      writeTableLabel(tableTitle, "Storage System");
      writeDriveBoxTable(cpqSsDrvBoxEntry[boxidx]);
   }
   writeTableTail();
}
writeBodyTail();
</script>
</html>
