# Parse grub.conf output into kernel, initrd, and boot label
BEGIN {
	image=""
	initrd="?"
	label="?"
	title="?"
}

/^[[:space:]]*title/ {
	if ( label != "?" ) {
		dumpentry()
	}
	initrd="?"
	image="?"

	label=$2
	for (i = 3; i <= NF; i++) {
		label = label " " $i
	}
}

/^[[:space:]]*kernel/ {
	image=$2
	sub(/^\(.*\)/, "", image)
}

/^[[:space:]]*initrd/ {
	initrd=$2
	sub(/^\(.*\)/, "", initrd)
}

function dumpentry() {
	if (image != "?" && image !~ /^\/boot/) {
		if (image !~ /^\//) {
			image = "/" image
		}
		image = "/boot" image
	}
	if (initrd != "?" && initrd !~ /^\/boot/) {
		if (initrd !~ /^\//) {
			initrd = "/" initrd
		}
		initrd = "/boot" initrd
	}
	print image " " initrd " " label
	return
}

END {
	dumpentry()
	exit 0
}
