
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="expires" content="Tue, 01 Jan 1981 01:00:00 GMT">

<!-- chp style sheet imported using Elm file import tag to minimize network round trips/traffic -->
<!#chp.css>

<script>

<!#chp.js>
<!#helputil.js>

var AboutWindow = null;

function HMMONameMap( actualNameIn, displayNameIn )
{
   this.actualName = actualNameIn;  // should be all lower case!
   this.displayName = displayNameIn;
}

MarketingNameMap = new Array();

MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/am",                  "OpenVMS Availability Manager" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/axl300",              "AXL300 Accelerator PCI Card" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/cipram",              "Intelligent Power and Rack Manager" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/cpmagent",            "Power Management Agents" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/configreport",        "Tru64 UNIX Configuration Report" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/dclset",              "OpenVMS DCL Set Commands" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/dclshow",             "OpenVMS DCL Show Commands" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/dfw",                 "Remote Diagnostics" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/dmiagent",            "Subsystem Status Information" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/ebs",                 "StorageWorks Tape Controller Management" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/fibre",               "StorageWorks SAN Interconnect Management" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/gsview",              "GS Platform Discovery" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/rtr",                 "OpenVMS Reliable Transaction Router" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/appntucpqsecurepath", "Secure Path Manager" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/appcfgcpqnotify",     "Notification Utility" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/survey",              "Configuration History Reports (Compaq Survey Utility)" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/sid",                 "Server Instance Data" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/sysman_home_page",    "Tru64 UNIX SysMan" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/tsmc",                "Tape Storage Management Console" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/usb",                 "OpenVMS Universal System Bus" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/webagent",            "Subsystem Status Information" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/webdfwag",            "Diagnostics" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/webdmiag",            "Insight Manager LC" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/xfc",                 "OpenVMS Extended File Cache" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/avag",                "Availability Agents" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/cica",                "Intelligent Cluster Administrator" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/cmdscriptwin",        "SANworks Command Scripter" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/shc",                 "System Healthcheck" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "/swvr",                "SANworks Virtual Replicator" );

MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.wbemgroup.survey",   "Survey Utility" );

MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.am",       "OpenVMS Availability Manager" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.axl300",   "AXL300 Accelerator PCI Card" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.cipram",   "Intelligent Power and Rack Manager" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.cpmagent", "Power Management Agents" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.configreport", "Compaq Tru64 UNIX Configuration Report" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.dclset",   "OpenVMS DCL Set Commands" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.dclshow",  "OpenVMS DCL Show Commands" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.dfw",      "Remote Diagnostics" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.dmiagent", "Subsystem Status Information" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.ebs",      "StorageWorks Tape Controller Management" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.fibre",    "StorageWorks SAN Interconnect Management" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.gsview",   "GS Platform Discovery" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.rtr",      "OpenVMS Reliable Transaction Router" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.securepath", "SANworks Secure Path Management" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.survey",   "Survey Utility" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.sid",      "Server Instance Data" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.sysman_home_page", "Tru64 UNIX SysMan" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.tsmc",     "Tape Storage Management Console" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.usb",      "OpenVMS Universal System Bus" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.webagent", "Subsystem Status Information" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.webdfwag", "Diagnostics" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.webdmiag", "Insight Manager LC" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.xfc",      "OpenVMS Extended File Cache" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.avag",     "Availability Agents" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.cica",     "Intelligent Cluster Administrator" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.cmdscriptwin", "SANworks Command Scripter" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.shc",      "System Healthcheck" );
MarketingNameMap[ MarketingNameMap.length ] = new HMMONameMap( "compaq.hmmo.swvr",     "SANworks Virtual Replicator" );



function processedMarketingName( nameIn )
{
   var nameString = String( nameIn ).toLowerCase();
   var startsWithMarketingName = (0==nameString.indexOf("marketingname:"));
   var i;
   var noblankcount;
   var found;

   if( startsWithMarketingName )
   {
      // chop off the MarketingName:
      nameString = String(nameIn).substring(14);
   }
   else
   {
      // find the translation, if one exists
      found = false;
      for(i=0; i<MarketingNameMap.length; i++)
      {
         // check if the name starts with the string in the map
         if( 0 == nameString.indexOf( MarketingNameMap[i].actualName ))
         {
            nameString = MarketingNameMap[i].displayName;
            found = true;
            break;
         }
      }

      if(!found)
      {
         nameString = nameIn;    // we lc-ed it above
      }
   }

   //---- do breakdown of string
   for(i=0, nobreakcount=0; i<nameString.length; i++)
   {
      if( " "!= nameString.charAt(i) )
      {
         nobreakcount++;
      }
      else
      {
         nobreakcount = 0;
      }

      if(20==nobreakcount)
      {
         nameString = nameString.substring(0, i) + "<br>" + nameString.substring(i);
         i += 4;  //--- skip the inserted <br>
         nobreakcount = 0;
      }
   }

   return nameString;
}


function writeLegend()
{
   var statusOrder = new Array( 2, 3, 4, 1 );
   var thisStatus;
   var i;

   document.writeln(
      "<table border=1 bordercolor=#cccccc cellspacing=0 cellpadding=0 width=100%><tr><td>",
      "<table class=legendstyle cellpadding=2>",
      "<tr><td rowspan=5 valign=top class=lnavtitle>KEY:</td></tr>"
      );

   for(i=0;i<4;i++)
   {
      thisStatus = statusOrder[i];
      document.writeln("<tr><td><table cellspacing=0 cellpadding=0 class=legendstyle><tr><td>",
         imageFromStatus(thisStatus),
         "</td><td>&nbsp;<font color=#cccccc>",
         textFromStatus(thisStatus),
         "</font></td></tr></table></td></tr>"
         );
   }

   document.writeln(
      "</table>",
      "</td></tr></table>"
      );
}


function boxTitle( thisBox )
{
   var img = new String( largeImageFromStatus(thisBox.status) );
   var rc = (0==img.length ? "" : img + "&nbsp;");

   //--- turn it into a link that calls gotoPath

   rc = "<table border=0><rc><td>" + rc + "</td><td valign=center><a class=boxtitle href=\"\" onclick=\"gotoPath(\'" +
      (""==thisBox.path ? "" : thisBox.path + "::") + thisBox.name
      + "\');return false;\">" + thisBox.name + "</a></td></tr></table>";

   return  rc;
}

function boxItem()
{
   var img = new String( imageFromStatus(this.status) );
   var textlink;

   img = (0==img.length ? "" : img + "&nbsp;");

   textlink = "<a href=\"\" onclick=\"gotoPage(\'"
      + (""==this.path ? "" : this.path) + "\', \'" + this.name
      + "\');return false;\"  class=iteminbox>" + this.name + "</a>";

   return img+textlink;
}


function boxChild()
{
   var img = new String( imageFromStatus(this.status) );
   var textlink = "<a class=linkinbox href=\"\" onclick=\"gotoPath(\'" + this.path + "::" + this.name + "\');return false;\">" + this.name + "</a>";

   img = (0==img.length ? "" : img + "&nbsp;");

   return img+textlink;
}


function badItemDisplay()
{
   var img = new String( imageFromStatus(this.status) );
   var textlink = "<a class=iteminbox href=\"\" onclick=\"gotoPage(\'" + this.path + "\',\'" + this.name + "\');return false;\">" + this.prettypath+" -&gt; "+this.name + "</a>";

   img = (0==img.length ? "" : img + "&nbsp;");

   return img+textlink;
}


function FillInDataItems( thisBox )
{
   var   thisPath = ((""==thisBox.path ? "" : thisBox.path + "::") + thisBox.name);
   var   thisNode = null;
   var   i;

   if("undefined"!=typeof(parent.frames.CHPAppletFrame.getPathContext))
   {
      thisNode = parent.frames.CHPAppletFrame.getPathContext(thisPath);
   }

   if(null!=thisNode)
   {
      for(i=0; i<thisNode.dataList.length; i++)
      {
         thisBox.items[ thisBox.items.length ] = new ItemToShow( thisNode.dataList[i], thisPath );
      }
   }
}


function FillInChildren( thisBox )
{
   var   thisPath = ((""==thisBox.path ? "" : thisBox.path + "::") + thisBox.name);
   var   childList;
   var   i;
   var   thisNode = null;

   if("undefined"!=typeof(parent.frames.CHPAppletFrame.getPathContext))
   {
      thisNode = parent.frames.CHPAppletFrame.getPathContext(thisPath);
   }

   if(null!=thisNode)
   {
      for(i in thisNode.children)
      {
         thisBox.children[ thisBox.children.length ] = new BoxToShow( thisNode.children[i], thisPath );
      }
   }
}

function BoxToShow( nodeIn, pathIn )
{
   this.path = "";
   this.name = nodeIn.name;
   this.status = nodeIn.status;

   if( "" != pathIn )
   {
      this.path = pathIn;
   }

   this.items  = new Array();
   this.children = new Array();

   this.showInBox = boxChild;
}

function ItemToShow( nodeIn, pathIn )
{
   var   temparray;

   this.path = pathIn;
   this.name = nodeIn.displayName();

   this.status = nodeIn.status;
   this.url = nodeIn.url;

   this.prettypath = "";

   if("undefined"!=typeof(nodeIn.path))
   {
      this.path = nodeIn.path;

      temparray = this.path.split("::");
      this.prettypath = temparray.join(" -&gt; ");

      temparray.length = 0;
      temparray = null;
   }

   this.showInBox = boxItem;
   this.badItem = badItemDisplay;
}

function sortByName( a, b )
{
   var   aname = String(a.name).toLowerCase();
   var   bname = String(b.name).toLowerCase();
   var   rc = 0;

   if (aname < bname ) rc = -1;
   else if (aname > bname) rc = 1;

   return rc;
}


function sortItemsAndChildren( a, b )
{
   var   rc = -1;

   if(a.status == b.status)
   {
      rc = sortByName(a, b);
   }
   else if (a.status < b.status)
   {
      rc = 1;
   }

   return rc;
}


function sortBadItems( a, b )
{
   var   rc = -1;
   var   aname = String(a.prettypath+"->"+a.name).toLowerCase();
   var   bname = String(b.prettypath+"->"+b.name).toLowerCase();

   if(a.status == b.status)
   {
      if (aname == bname ) rc = 0;
      else if (aname > bname) rc = 1;
   }
   else if (a.status < b.status)
   {
      rc = 1;
   }

   return rc;
}


function GetBadItems()
{
   var bads = parent.frames.CHPAppletFrame.badItemList;
   var i;

   for(i=0; i<bads.length; i++)
   {
      badItems[ badItems.length ] = new ItemToShow( bads[i], "" );
   }
}


function doctorGinkgoAndWMI()
{
   var i,j;
   var majorver;

   for(i=0; i< IsapiExtensionCount; i++)
      {
         if( "/" == IsapiExtension[i].Name &&
             ("MarketingName: Compaq Subsystem Status Information"==IsapiExtension[i].MarketingName
              || "Compaq WMI WEB Agent"==IsapiExtension[i].MarketingName
              || "MarketingName: Insight Management Agents"==IsapiExtension[i].MarketingName
              || "HP WMI WEB Agent"==IsapiExtension[i].MarketingName
             )
            )
         {
            //--- determine if the Elm version is greater than 5.x
            majorver = IsapiExtension[i].IsapiVersion.charAt(19);

            if(5 <= majorver)
            {
               for(j=0; j<IsapiExtensionCount; j++)
               {
                  if( "/"!=IsapiExtension[j].Name &&
                      IsapiExtension[i].MarketingName == IsapiExtension[j].MarketingName
                     )
                     {
                        IsapiExtension[j].UsesCHP = "yes";  // Ginkgo or WMI w/5.x+ Elm is integrated
                     }
               }
            }
         }
      }
}

function HMMONameAndLink( isapiextension )
{
   var   rc="";
   var   showlink = true;

   if(""==isapiextension.BaseURL || "/"==isapiextension.BaseURL)
   {
      showlink = false;
   }

   rc = "<tr><td>&nbsp;&nbsp;</td><td class=navvector align=left>";

   if(showlink)
   {
      rc += "<a class=greylink target=otherhmmowindow href=\"";

      // remove and double quotes from the BaseURL string

      isapiextension.BaseURL = isapiextension.BaseURL.replace( /\"/g, "");

      if (0==isapiextension.BaseURL.indexOf("http") || 0==isapiextension.BaseURL.indexOf("HTTP"))
      {
         rc += isapiextension.BaseURL;
      }
      else
      {
         rc += ('/'==isapiextension.BaseURL.charAt(0) ? isapiextension.BaseURL : "/"+isapiextension.BaseURL);
      }

      rc +=  "\">";
   }
   else
   {
      rc += "<font color=#cccccc>";    //--- for NS 4.x
   }

   rc += processedMarketingName(isapiextension.MarketingName);

   if(showlink)
   {
      rc += "</a>";
   }
   else
   {
      rc += "</font>";    //--- for NS 4.x
   }

   rc += "</td></tr>";

   return rc;
}

function openAboutFile( target )
{
   if ((AboutWindow == null) || AboutWindow.closed)
   {
      AboutWindow = window.open( "/help/CHP00021.htm", target );
   }

   if ((AboutWindow != null) &&
       ("function" == typeof( AboutWindow.focus ) || "object" == typeof( AboutWindow.focus )))
   {
      AboutWindow.focus();
   }
}


BlankIfCHPNotReady();



lastSeparator = pathToShow.lastIndexOf("::");

if(-1==lastSeparator)
{
   pagePath = "";
   pageName = pathToShow;
}
else
{
   pagePath = pathToShow.substring(0, lastSeparator);
   pageName = pathToShow.substring(lastSeparator+2);

}

pageData = new BoxToShow( pageName, pagePath );
pageData.path = pagePath;
pageData.name = pageName;
pageData.status = -1;
pageData.items  = new Array();
pageData.children = new Array();
pageData.showInBox = boxChild;

badItems = new Array();

if(FramesAreThere)
{
   FillInChildren( pageData );
   FillInDataItems( pageData );
}


<!--- Elm internal tag for HMMOs loaded --->
<!.ObjectIsapiExtension>

</script>


<body TOPMARGIN=0 LEFTMARGIN=0>

<!--- Create the table for the left navigation frame/LOM/left organization frame if this is the Home page  -->
<script>
   if( "home" == pathToShow.toLowerCase() )
   {
      // this is the home page, do a table with a blue left navigation section
      document.writeln("<table border=0 cellspacing=0 cellpadding=10><tr><td class=navvector width=20% bgcolor=#006699 valign=top>");

      document.writeln("<a href='Javascript:openAboutFile(\"compaqwindow\")' class=aboutlink><font color=#ffffff>about this page</font></a><br><br>");

      document.writeln("<font class=lnavtitle>Integrated Agents</font><table border=0 width=100%>");

      doctorGinkgoAndWMI();

      agentsShown = 0;
      for(i=0; i< IsapiExtensionCount; i++)
      {
         if( "/"!=IsapiExtension[i].Name
            && "yes"==IsapiExtension[i].UsesCHP       // HMMO uses CHP
            && 0==(2 & IsapiExtension[i].Flags)       // hidden flag not set
           )
         {
            document.writeln( HMMONameAndLink( IsapiExtension[i] ));
            agentsShown++;
         }
      }
      if(0==agentsShown)
      {
            document.writeln("<tr><td>&nbsp;&nbsp;</td><td class=navvector align=left><font color=#cccccc>none</font></td></tr>");
      }

      document.writeln("</table><br>");

      document.writeln("<font class=lnavtitle>Other Agents</font><br><table border=0 width=100%>");

      agentsShown = 0;
      for(i=0; i< IsapiExtensionCount; i++)
      {
         if( "/"!=IsapiExtension[i].Name
            && "yes"!=IsapiExtension[i].UsesCHP
            && 0==(2 & IsapiExtension[i].Flags)       // hidden flag not set
           )
         {
            document.writeln( HMMONameAndLink( IsapiExtension[i] ));
            agentsShown++;
         }
      }
      if(0==agentsShown)
      {
            document.writeln("<tr class=navvector><td>&nbsp;&nbsp;</td><td align=left><font color=#cccccc>none</font></td></tr>");
      }

      document.writeln("</table><br>");

      document.writeln("<font class=lnavtitle>Management Processor</font><br><table border=0 width=100%>");

      if( "undefined" == typeof( parent.frames.CHPAppletFrame.chpMiscData.RIBName ))
      {
         // no rib in the system
            document.writeln("<tr><td>&nbsp;&nbsp;</td><td class=navvector align=left><font color=#cccccc>none</font></td></tr>");
      }
      else
      {
         ribname = parent.frames.CHPAppletFrame.chpMiscData.RIBName;
         riblink = parent.frames.CHPAppletFrame.chpMiscData.RIBLink;

         document.writeln(
            "<tr><td>&nbsp;&nbsp;</td><td class=navvector align=left>",
            (""!=riblink) ? "<a class=greylink target=ribwindow href=\""+riblink+"\">" :  "",
            ribname,
            (""!=riblink) ? "</a>" : "",
            "</td></tr>"
            );
      }

      document.writeln("</table><br>");

      document.writeln("<font class=lnavtitle>Other Software</font><br><table border=0 width=100%>");
      document.writeln(
         "<tr><td>&nbsp;&nbsp;</td>",
         "<td class=navvector align=left><a class=greylink href=/chpbrdg.htm target=CHPDataFrame>ProLiant Essentials</a></td>",
         "</tr></table><br>"
         );

      writeLegend();

      document.writeln("</td><td>");
   }
</script>


<!--- do the "page header" with the date/time loaded, load style and refresh link --->
<script>
writePageHeader();
</script>

<table width=100% border=0 cellpadding=10 cellspacing=0>
<script>

   document.writeln("<tr><td colspan=", pageColumns, " align=center width=100%>");

   <!--- put up either the failed/degraded items or the data items table for this page -->
   if( "home" == pathToShow.toLowerCase() )
   {
      GetBadItems();

      badItems.sort( sortBadItems );

      // this is the home page, do a failed&degraded items table
      document.writeln("<font class=boxtitle>Failed & Degraded Items</font><br>");
      document.writeln("<table width=100% border=0 bgcolor=",
         0==badItems.length ? "#006699" : colorFromStatus( badItems[0].status ),
         " cellspacing=2 cellpadding=2><tr><td><table border=0 width=100% cellpadding=5 bgcolor=#cccccc><tr><td>");

      if( 0==badItems.length)  document.writeln("none");
      else
      {
         for(i=0; i<badItems.length; i++)
         {
            if(0!=i) document.writeln("<br>");

            document.writeln( badItems[i].badItem() );
         }
      }
      document.writeln("</td></tr></table></td></tr></table>");
   }
   else
   {
      // this is not the home page, put up a box for the data items
      document.writeln("<font class=boxtitle>", pageData.name, "</font><br>");

      if( 0!=pageData.items.length )
      {
         pageData.items.sort( sortItemsAndChildren );

         document.writeln("<table width=100% border=0 bgcolor=",
            colorFromStatus( pageData.items[0].status ),
            " cellspacing=2 cellpadding=2><tr><td><table border=0 width=100% cellpadding=5 bgcolor=#cccccc><tr><td>");

         for(i=0; i<pageData.items.length; i++)
         {
            document.writeln( pageData.items[i].showInBox(), "<br>");
         }

         document.writeln("</td></tr></table></td></tr></table>");
       }
   }

   document.writeln("<br></td></tr><tr>");


columnWidth = 100 / pageColumns;

// sort the boxes
pageData.children.sort( sortItemsAndChildren );

for(box=0; box<pageData.children.length; box++)
{
   //--- fill in the content of the box
   FillInDataItems( pageData.children[box] );
   FillInChildren( pageData.children[box] );

   if( 0 == box % pageColumns && 0 != box )
   {
      document.writeln("</tr><tr>");
   }

   document.writeln("<td valign=top width=" + columnWidth + "%>");
   document.writeln( boxTitle( pageData.children[box] ) );

   document.writeln("<table border=0 width=100% bgcolor=", colorFromStatus( pageData.children[box].status ), " cellspacing=2 cellpadding=2><tr><td>");
   document.writeln("<table border=0 width=100% bgcolor=#cccccc cellpadding=5><tr><td>");

   // concatenate the children array onto the items array to make a single array for sorting
   for(i=0; i< pageData.children[box].children.length; i++)
   {
      pageData.children[box].items[ pageData.children[box].items.length ] = pageData.children[box].children[i];
   }

   // sort the combined array
   pageData.children[box].items.sort( sortItemsAndChildren );

   itemsToShow = pageData.children[box].items.length;

   if(itemsToShow > boxRows)
   {
      itemsToShow = boxRows-1;
   }

   for(i=0; i< pageData.children[box].items.length && i<itemsToShow; i++)
   {
      document.writeln( pageData.children[box].items[i].showInBox(), "<br>");
   }

   itemsNotShown = pageData.children[box].items.length - itemsToShow;


   if(itemsNotShown>0)
   {
      document.writeln(
         "<a href=\"\" onclick=\"gotoPath(\'",
         ""==pageData.children[box].path ? "" : (pageData.children[box].path + "::"),
         pageData.children[box].name,
         "\');return false;\" ",
         "class=linkinbox>. . . ",
         itemsNotShown,
         " item",
         itemsNotShown!=1 ? "s" : "",
         " not shown</a>"
         );
   }
   else
   {
      for(itemsToShow; itemsToShow < boxRows; itemsToShow++)  document.writeln("&nbsp;<br>");
   }

   document.writeln("</td></tr></table>");
   document.writeln("</td></tr></table>");
   document.writeln("</td>");
}

// fill in a blank space to fill out the table

columnsToFill = pageData.children.length % 3;

if(columnsToFill > 0)
{
   document.writeln("<td colspan=", columnsToFill, ">&nbsp;</td>");
}

</script>

</tr>
</table>

<script>
<!---- do the page footer ---->
writePageFooter();


<!--- close the left navigation bar table if this is the Home page --->
   if( "home" == pathToShow.toLowerCase() )
   {
      // this is the home page, do a table with a blue left navigation section
      document.writeln("</td></tr></table>");
   }
</script>


</body>
