//***************************************************************
//                   Event Notifier Control File
//***************************************************************
//    The following section is the main control section for this
//    product.
//***************************************************************
//
//    Name = The Marketing Name of the product
//
//    Description = What is displayed as the description of the
//              product. (Required Field)
//
//    Execute = This option is used to execute an application.
//              Some possible uses for this would be launching
//              another installation program, or a configuration
//              applet.
//
//    RequiredSpace = The total amount of disk space required
//              by this product for installation.
//
//    Dependency = This is a field that will specify a case
//              that must exist for the product to be installed.
//
//    Compaq_System = This field specifies if it needs to be a
//              Compaq System.
//                    1 = Needs to be a Compaq Machine
//                    0 = Can be any machine type
//
//    Services = This is a list of services that need to be
//              setup.  The list here, is a list of the service name
//              divided by a comma.  Each service name will then
//              be a section listed in the services section.
//
//    Registry = This is a list of registry keys that need to be
//              added.
//
//    DefaultLoad = This will specify if the product is loaded as a
//              default.
//                     1 = Product is loaded
//                     0 = Product is not loaded
//
//    Version = This is the current version of the agents
//
//    MinBuildNumber = This value will give a specific product the
//              ability to not install on a version of NT different from
//              the main product.
//
//    MaxBuildNumber = Similar to th MinBuildNumber, this one will
//              allow you to specifiy the maximum build number for this
//              product.
//
//    DllCalls = This is for specifiying additional Dll calls.
//
//***************************************************************
[Main]
Name=Compaq Event Notifier
Description=This component provides the ability for anyone with an email address to be notified of specific Compaq Server Management Agent events via electronic mail.
Execute=
RequiredSpace=1000000
Dependency=Compaq Foundation Agents
Compaq_System=1
Services=CIMNotify
Registry=RUN_ONCE
DefaultLoad=0
Version=6.%%SMA_VER_MIN%%.0.0
VersionFile=cimntfy.exe
InstalledVersionFile=WindowsSysDir\cimntfy\cimntfy.exe
RebootRequired=0
RebootUpgrade=0
//***************************************************************
//    This is where the start menu items are added.
//***************************************************************
//
//    Folder = The folder to be added
//
//    Entry# = The entries to be added
//
//***************************************************************
[Start Menu]
Folder=Compaq Products and Services
Entry1="Compaq Event Notifier Help" %SystemRoot%"\System32\cimntfy\lwconfig.hlp" "" 0
Entry2="Compaq Event Notifier Config" %SystemRoot%"\System32\cimntfy\lwconfig.exe" "" 0
Entries=HELP,CONFIG
HELP_SOURCE=help.lnk
HELP_DESTINATION=Compaq Event Notifier Help.lnk
CONFIG_SOURCE=config.lnk
CONFIG_DESTINATION=Compaq Event Notifier Config.lnk
//***************************************************************
//    Locations of all of the source directories
//***************************************************************
//
//    The entry names are the ones specified in the [Files] section
//    by the NAME_SOURCE directories.  This abstacts the actual
//    source directory, to this portion of the control file.
//
//***************************************************************
[SourcePath]
Notify=.
//***************************************************************
//    Locations of all of the destination directories
//***************************************************************
//
//    The entry names are the ones specifid in the [Files] section
//    by the NAME_DESTINATION directories.  This abstacts the actual
//    destination directory, to this portion of the control file.
//
//***************************************************************
[DestinationPath]
Notify=WindowsSysDir\cimntfy
Groups=%USERPROFILE%\Start Menu\Programs\Compaq Products and Services
//***************************************************************
//    Names of all of the files that are to be copied
//***************************************************************
//
//    FILE_LIST = This lists a code name for a file grouping.
//              Each group is a set of files that are similar in
//              behavior.  They all have the same source, destination
//              and flag conditions.  All file groups are separated
//              by a comma.
//
//    DEFAULT_NOTIFY = This is the default for the files in this section
//              it specifies if the dialog box will appear or not that
//              will ask if you want to over-write the file.  Any file
//              group that specifys a notify will be over-written.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_SOURCE = This shows the name of the source directory
//              for the group of files called NAME.
//
//    NAME_DESTINATION = This shows the name of the destination directory
//              for the group of files called NAME.
//
//    NAME_FILES = This is a list of the files that need to be copied.
//
//    NAME_NOTIFY = This will over-write the DEFAULT_NOTIFY option
//              listed above.  If it is not specified, it will NOT
//              chage the default.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_UNINSTALL = This will determine if the files listed will be
//               removed on an uninstall.  The default is uninstall all
//               files.
//                    1 = Will uninstall this group of files
//                    0 = Will leave these files during an uninstall
//
//    DELETE_FILES = List of files to be deleted
//
//***************************************************************
[Files]
FILE_LIST=CIMNtfy
DELETE_FILES=GROUPS
UNINSTALL_FILES=UNINSTALL_LIST
CIMNtfy_SOURCE=Notify
CIMNtfy_DESTINATION=Notify
CIMNtfy_FILES=cimntfy.exe,lwconfig.exe,lwconfig.hlp
CIMNtfy_UNINSTALL=1
GROUPS_SOURCE=Groups
GROUPS_FILES=Insight Agents Event Notifier Config.lnk,Insight Agents Event Notifier Help.lnk
UNINSTALL_LIST_DESTINATION=Notify
UNINSTALL_LIST_FILES=lwconfig.gid
//***************************************************************
//    Names of the services that are to be installed
//***************************************************************
//
//    Description = The Display name of the service
//
//    Path = The Image Path of the service
//
//    Dependencies = This is a field that will specify a case
//              that must exist for the service to be installed.
//
//    Start = The start parameter for the service
//
//    Type = The type value for the service
//
//    ObjectName = The Name of the object
//
//***************************************************************
[CIMNotify]
Name=CIMNotify
Description=Compaq Event Notifier
DependOnService=TcpIp
DependOnGroup=
Path=%SystemRoot%\system32\CIMNtfy\CIMNtfy.EXE
Start=4
Type=16
ErrorControl=1
ObjectName=LocalSystem
RegKeys=Parameters,Enum,Security,Linkage
EventMessageFile=%SystemRoot%\system32\Cimntfy\Cimntfy.exe
EventMessageEntry=CIMNotify
//***************************************************************
//    Names of the sub-services that are to be installed
//***************************************************************
//
//  Name = The Name of the sub-service as it appears in the
//         registry beneath the calling service
//
//  Description = The value that is called DisplayName in the
//         registry
//
//  Keys = A three part value that is seperated by a "#" that adds
//         additional keys to the sub-service.  It goes in the following
//         order:
//              KeyName,Type, Value
//              KeyName = The Key that will be written into the registry
//
//              Type = The type of entry that will be created include:
//                     DWORD
//                     EXPAND_SZ
//                     MULTI_SZ
//                     REG_SZ
//
//              Value = The initial starting value
//
//***************************************************************
[Parameters]
Name=Parameters
[Security]
Name=Security
[Enum]
Name=Enum
Keys=Count,DWORD,1 # NextInstance,DWORD,1 # 0,REG_SZ,Root\LEGACY_CIMNOTIFY\0000
[Linkage]
Name=Linkage
RegKeys=Disabled#
[Disabled]
Name=Disabled
//***************************************************************
//    Names of the Registry Values that are to be installed
//***************************************************************
//
//    NAME - The label of how it will be refered by the service
//           This value gives the key that the registry will be
//           Installed into
//
//    NAME_Dependency - This key must exist for the value to be
//           Installed
//
//    NAME_Name - This is the value to be created
//
//    NAME_Type - This is the type of registy entry that will be
//           created.
//
//    NAME_Data - This is the data that will be entered
//
//***************************************************************
[Registry]
RUN_ONCE=Software\Microsoft\Windows\CurrentVersion\RunOnce
RUN_ONCE_Dependency=!System\CurrentControlSet\Services\CIMNotify\Parameters\SmtpHost
RUN_ONCE_Name=CimNotify
RUN_ONCE_Type=REG_SZ
RUN_ONCE_Data=WindowsSysDir\CimNtfy\LwConfig.exe
