<!DOCTYPE xsl:stylesheet [
   <!ENTITY txtSnmpAgentSettingsClass "Cpq_SNMPAgentSettings">
   <!ENTITY txtAgent "SNMP Agent">
   <!ENTITY txtAgentProps "Agent Properties">
   <!ENTITY txtContact "Contact">
   <!ENTITY txtLocation "Location">
   <!ENTITY txtService "Service">
   <!ENTITY txtPhysical "Physical">
   <!ENTITY txtInternet "Internet">
   <!ENTITY txtDatalink "Datalink">
   <!ENTITY txtApplication "Application">
   <!ENTITY txtEndToEnd "End-to-End">
   <!ENTITY txtCompaqAgentSettingsClass "Cpq_CompaqAgentSettings">
   <!ENTITY txtcompaqAgent "Management Agents">
   <!ENTITY txtCpqProps "Management Agents Properties">
   <!ENTITY txtDataInterval "Data Collection Interval in seconds">
   <!ENTITY txtServerRole "Server Role">
   <!ENTITY txtRemoteReboot "Remote Reboot">
   <!ENTITY txtRemoteSets "SNMP Sets">
   <!ENTITY txtRestartServices "Restart Agents">
   <!ENTITY txtSnmpSecuritySettingsClass "Cpq_SNMPSecuritySettings">
   <!ENTITY txtSecurity "SNMP Security">
   <!ENTITY txtSnmpTrapSettingsClass "Cpq_SNMPTrapSettings">
   <!ENTITY txtTrapCommunities "SNMP Trap Community Names and Destination Hosts">
   <!ENTITY txtDestinationHosts "Destination Hosts">
   <!ENTITY txtAuthTrap "Authentication Trap">
   <!ENTITY txtSendTrap "Send Trap">
   <!ENTITY txtAcceptSpecficHosts "Accept Specific Hosts">
   <!ENTITY txtAcceptedHosts "Accepted Hosts">
   <!ENTITY txtHostNames "Host Names">
   <!ENTITY txtAcceptedCommunities "Accepted Community Names and Rights">
   <!ENTITY txtCommunities "Community Names">
   <!ENTITY txtThresholdClass "Cpq_WINOSThresholdSettings">
   <!ENTITY txtThreshold "Threshold Settings">
   <!ENTITY txtThresholdProps "Threshold properties">
   <!ENTITY txtThresholdWarn "Warning Value=">
   <!ENTITY txtThresholdCrit "Critical Value=">
   <!ENTITY txtCPUThreshold "CPU Percent Utilization Threshold">
   <!ENTITY txtCPUThreshold_Desc "Threshold warning and critical value settings, a value of 0 means it is not set">
   <!ENTITY txtMemThreshold "PageFile Percent  Used Threshold">
   <!ENTITY txtMemThreshold_Desc "Threshold warning and critical value settings, a value of 0 means it is not set">
   <!ENTITY txtCacheThreshold "Cache hits Threshold">
   <!ENTITY txtCacheThreshold_Desc "Threshold warning and critical value settings, a value of 0 means it is not set">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:strip-space elements="*"/>
   <xsl:param name="messageId" select="0"/>
   <!-- this stylesheet converts XML in the form of the snmpcfg.xml to CIMXML -->
   <xsl:output indent="yes" method="xml" version="1.0" encoding="UTF-8"/>
   <xsl:template match="snmp_config">
      <CIM CIMVERSION="2.0" DTDVERSION="2.0">
         <MESSAGE PROTOCOLVERSION="1.0">
            <xsl:attribute name="ID"><xsl:value-of select="$messageId"/></xsl:attribute>
            <SIMPLERSP>
               <IMETHODRESPONSE NAME="EnumerateInstances">
                  <IRETURNVALUE>
                     <xsl:call-template name="agent">
                        <xsl:with-param name="agent_settings" select="agent"/>
                     </xsl:call-template>
                     <xsl:call-template name="security">
                        <xsl:with-param name="security_settings" select="security"/>
                     </xsl:call-template>
                     <xsl:call-template name="traps">
                        <xsl:with-param name="traps_settings" select="traps"/>
                     </xsl:call-template>
                     <xsl:call-template name="compaq_agent">
                        <xsl:with-param name="compaq_agent_settings" select="agent"/>
                     </xsl:call-template>
                      <xsl:call-template name="thresholds">
                        <xsl:with-param name="thresholds_settings" select="thresholds"/>
                     </xsl:call-template>
                  </IRETURNVALUE>
               </IMETHODRESPONSE>
            </SIMPLERSP>
         </MESSAGE>
      </CIM>
   </xsl:template>
   <!-- outputs the snmp agent settings -->
   <xsl:template name="agent">
      <xsl:param name="agent_settings"/>
      <VALUE.NAMEDINSTANCE>
         <INSTANCENAME CLASSNAME="&txtSnmpAgentSettingsClass;">
            <KEYBINDING NAME="">
               <KEYVALUE>&txtAgentProps;</KEYVALUE>
            </KEYBINDING>
         </INSTANCENAME>
         <INSTANCE CLASSNAME="&txtSnmpAgentSettingsClass;">
            <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
               <VALUE>&txtAgent;</VALUE>
            </QUALIFIER>
            <PROPERTY NAME="contact" PROPAGATED="true" TYPE="string">
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtContact;</VALUE>
               </QUALIFIER>
               <VALUE><xsl:value-of select="$agent_settings/contact"/></VALUE>
            </PROPERTY>
            <PROPERTY NAME="location" PROPAGATED="true" TYPE="string">
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtLocation;</VALUE>
               </QUALIFIER>
               <VALUE><xsl:value-of select="$agent_settings/location"/></VALUE>
            </PROPERTY>
            <PROPERTY NAME="services" PROPAGATED="true" TYPE="string">
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtService;</VALUE>
               </QUALIFIER>
               <VALUE>
                                                <xsl:variable name="s1">
                                         <xsl:if test="$agent_settings/services/@physical='true'">&txtPhysical;</xsl:if>
                                        </xsl:variable>
                                                <xsl:variable name="s2">
                                         <xsl:value-of select="$s1"/><xsl:if test="$agent_settings/services/@datalink='true'"><xsl:if test="string-length($s1)">, </xsl:if>&txtDatalink;</xsl:if>
                                        </xsl:variable>
                                                <xsl:variable name="s3">
                                         <xsl:value-of select="$s2"/><xsl:if test="$agent_settings/services/@internet='true'"><xsl:if test="string-length($s2)">, </xsl:if>&txtInternet;</xsl:if>
                                        </xsl:variable>
                                                <xsl:variable name="s4">
                                         <xsl:value-of select="$s3"/><xsl:if test="$agent_settings/services/@application='true'"><xsl:if test="string-length($s3)">, </xsl:if>&txtApplication;</xsl:if>
                                        </xsl:variable>
                                                <xsl:variable name="s5">
                                         <xsl:value-of select="$s4"/><xsl:if test="$agent_settings/services/@end_to_end='true'"><xsl:if test="string-length($s4)">, </xsl:if>&txtEndToEnd;</xsl:if>
                                        </xsl:variable>
                                                <xsl:value-of select="$s5"/>
                                        </VALUE>
            </PROPERTY>
         </INSTANCE>
      </VALUE.NAMEDINSTANCE>
   </xsl:template>
    <!-- output the compaq agent settings -->
    <xsl:template name="compaq_agent">
      <xsl:param name="compaq_agent_settings"/>
      <VALUE.NAMEDINSTANCE>
         <INSTANCENAME CLASSNAME="&txtCompaqAgentSettingsClass;">
            <KEYBINDING NAME="">
               <KEYVALUE>&txtCpqProps;</KEYVALUE>
            </KEYBINDING>
         </INSTANCENAME>
         <INSTANCE CLASSNAME="&txtCompaqAgentSettingsClass;">
            <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
               <VALUE>&txtcompaqAgent;</VALUE>
            </QUALIFIER>
            <PROPERTY NAME="data_interval" PROPAGATED="true" TYPE="string">
                <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtDataInterval;</VALUE>
                </QUALIFIER>
                <VALUE><xsl:value-of select="$compaq_agent_settings/data_interval"/></VALUE>
            </PROPERTY>
            <PROPERTY NAME="server_role" PROPAGATED="true" TYPE="string">
                <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtServerRole;</VALUE>
                </QUALIFIER>
                <VALUE><xsl:value-of select="$compaq_agent_settings/server_role"/></VALUE>
            </PROPERTY>
            <PROPERTY NAME="remote_reboot" PROPAGATED="true" TYPE="boolean">
                <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtRemoteReboot;</VALUE>
                </QUALIFIER>
                <VALUE>
                                                <xsl:choose>
                     <xsl:when test="$compaq_agent_settings/sets_enabled/@remote_reboot='false'">Disabled</xsl:when>
                                                        <xsl:otherwise>Enabled</xsl:otherwise>
                  </xsl:choose>
              </VALUE>
            </PROPERTY>
            <PROPERTY NAME="remote_set" PROPAGATED="true" TYPE="boolean">
                <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtRemoteSets;</VALUE>
                </QUALIFIER>
                <VALUE>
                                                <xsl:choose>
                     <xsl:when test="$compaq_agent_settings/sets_enabled/@remote_set='false'">Disabled</xsl:when>
                                                        <xsl:otherwise>Enabled</xsl:otherwise>
                  </xsl:choose>
              </VALUE>
            </PROPERTY>
            <PROPERTY NAME="restart_services" PROPAGATED="true" TYPE="boolean">
                <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtRestartServices;</VALUE>
                </QUALIFIER>
                <VALUE>
                                                <xsl:choose>
                     <xsl:when test="$compaq_agent_settings/restart_services='0'">Disabled</xsl:when>
                                                        <xsl:otherwise>Enabled</xsl:otherwise>
                  </xsl:choose>
              </VALUE>
            </PROPERTY>
                        </INSTANCE>
        </VALUE.NAMEDINSTANCE>
     </xsl:template>
   <!-- outputs the trap community strings along with their destination host settings -->
   <xsl:template name="traps">
      <xsl:param name="traps_settings"/>
      <xsl:for-each select="$traps_settings/destination_community">
         <VALUE.NAMEDINSTANCE>
            <INSTANCENAME CLASSNAME="&txtSnmpTrapSettingsClass;">
               <KEYBINDING NAME="">
                  <KEYVALUE><xsl:value-of select="@name"/></KEYVALUE>
               </KEYBINDING>
            </INSTANCENAME>
            <INSTANCE CLASSNAME="&txtSnmpTrapSettingsClass;">
               <!-- the DISPLAYNAME actually binds all these instances together in XE's GC UI -->
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtTrapCommunities;</VALUE>
               </QUALIFIER>
               <PROPERTY TYPE="string">
                  <xsl:attribute name="NAME"><xsl:value-of select="@name"/></xsl:attribute>
                  <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                     <VALUE>&txtDestinationHosts;</VALUE>
                  </QUALIFIER>
                  <VALUE>
                     <xsl:for-each select="destination_host">
                        <xsl:value-of select="."/>
                        <xsl:if test="position()!=last()">
                           <xsl:text>, </xsl:text>
                        </xsl:if>
                     </xsl:for-each>
                  </VALUE>
               </PROPERTY>
            </INSTANCE>
         </VALUE.NAMEDINSTANCE>
      </xsl:for-each>
   </xsl:template>
   <!-- outputs the threshold settings -->
   <xsl:template name="thresholds">
      <xsl:param name="thresholds_settings"/>
         <VALUE.NAMEDINSTANCE>
            <INSTANCENAME CLASSNAME="&txtThresholdClass;">
               <KEYBINDING NAME="">
                  <KEYVALUE>&txtThresholdProps;</KEYVALUE>
               </KEYBINDING>
            </INSTANCENAME>
            <INSTANCE CLASSNAME="&txtThresholdClass;">
               <!-- the DISPLAYNAME actually binds all these instances together in XE's GC UI -->
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtThreshold;</VALUE>
               </QUALIFIER>
            <PROPERTY NAME="cpuThresh" PROPAGATED="true" TYPE="string">
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtCPUThreshold;</VALUE>
               </QUALIFIER>
               <QUALIFIER NAME="DESCRIPTION" TYPE="string">
                  <VALUE>&txtCPUThreshold_Desc;</VALUE>
               </QUALIFIER>
               <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
                  <VALUE>&txtThresholdWarn;<xsl:value-of select="$thresholds_settings/cpuThreshWarn"/> &txtThresholdCrit;<xsl:value-of select="$thresholds_settings/cpuThreshCrit"/></VALUE>
               </QUALIFIER>
               <VALUE><xsl:value-of select="$thresholds_settings/cpuThresh"/></VALUE>
            </PROPERTY>
            <PROPERTY NAME="memThresh" PROPAGATED="true" TYPE="string">
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtMemThreshold;</VALUE>
               </QUALIFIER>
               <QUALIFIER NAME="DESCRIPTION" TYPE="string">
                  <VALUE>&txtMemThreshold_Desc;</VALUE>
               </QUALIFIER>
               <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
                  <VALUE>&txtThresholdWarn;<xsl:value-of select="$thresholds_settings/memThreshWarn"/> &txtThresholdCrit;<xsl:value-of select="$thresholds_settings/memThreshCrit"/></VALUE>
               </QUALIFIER>
               <VALUE><xsl:value-of select="$thresholds_settings/memThresh"/></VALUE>
            </PROPERTY>
            <PROPERTY NAME="cacheThresh" PROPAGATED="true" TYPE="string">
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtCacheThreshold;</VALUE>
               </QUALIFIER>
               <QUALIFIER NAME="DESCRIPTION" TYPE="string">
                  <VALUE>&txtCacheThreshold_Desc;</VALUE>
               </QUALIFIER>
               <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
                  <VALUE>&txtThresholdWarn;<xsl:value-of select="$thresholds_settings/cacheThreshWarn"/> &txtThresholdCrit;<xsl:value-of select="$thresholds_settings/cacheThreshCrit"/></VALUE>
               </QUALIFIER>
               <VALUE><xsl:value-of select="$thresholds_settings/cacheThresh"/></VALUE>
            </PROPERTY>
            </INSTANCE>
         </VALUE.NAMEDINSTANCE>
   </xsl:template>
   <!-- outputs the security settings -->
   <xsl:template name="security">
      <xsl:param name="security_settings"/>
      <!-- output the send authentication trap setting -->
      <VALUE.NAMEDINSTANCE>
         <INSTANCENAME CLASSNAME="&txtSnmpSecuritySettingsClass;">
            <KEYBINDING NAME="">
               <KEYVALUE>&txtAuthTrap;</KEYVALUE>
            </KEYBINDING>
         </INSTANCENAME>
         <INSTANCE CLASSNAME="&txtSnmpSecuritySettingsClass;">
            <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
               <VALUE>&txtSecurity;</VALUE>
            </QUALIFIER>
            <PROPERTY NAME="send_auth_trap" PROPAGATED="true" TYPE="boolean">
               <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                  <VALUE>&txtSendTrap;</VALUE>
               </QUALIFIER>
               <VALUE>
                  <xsl:choose>
                     <xsl:when
test="$security_settings/send_auth_trap='0'">FALSE</xsl:when>
                     <xsl:otherwise>TRUE</xsl:otherwise>
                  </xsl:choose>
               </VALUE>
            </PROPERTY>
         </INSTANCE>
      </VALUE.NAMEDINSTANCE>
      <!-- output the accepted host names -->
      <xsl:choose>
         <xsl:when test="$security_settings/accept_specific_hosts[@value='true']">
            <VALUE.NAMEDINSTANCE>
               <INSTANCENAME CLASSNAME="&txtSnmpSecuritySettingsClass;">
                  <KEYBINDING NAME="">
                     <KEYVALUE>&txtAcceptedHosts;</KEYVALUE>
                  </KEYBINDING>
               </INSTANCENAME>
               <INSTANCE CLASSNAME="&txtSnmpSecuritySettingsClass;">
                  <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                      <VALUE>&txtSecurity;</VALUE>
                  </QUALIFIER>
                  <PROPERTY NAME="accepted_hosts" PROPAGATED="true" TYPE="boolean">
                     <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                        <VALUE>&txtHostNames;</VALUE>
                     </QUALIFIER>
                     <VALUE>
                                                 <xsl:for-each select="$security_settings/accept_specific_hosts/accepted_host">
                           <xsl:value-of select="."/>
                                     <xsl:if test="position()!=last()">
                                  <xsl:text>, </xsl:text>
                                    </xsl:if>
                      </xsl:for-each>
                   </VALUE>
                </PROPERTY>
                              </INSTANCE>
                           </VALUE.NAMEDINSTANCE>
         </xsl:when>
         <xsl:otherwise>
            <VALUE.NAMEDINSTANCE>
               <INSTANCENAME CLASSNAME="&txtSnmpSecuritySettingsClass;">
                  <KEYBINDING NAME="">
                     <KEYVALUE>&txtAcceptedHosts;</KEYVALUE>
                  </KEYBINDING>
               </INSTANCENAME>
               <INSTANCE CLASSNAME="&txtSnmpSecuritySettingsClass;">
                  <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                      <VALUE>&txtSecurity;</VALUE>
                  </QUALIFIER>
                  <PROPERTY NAME="accept_specific_hosts" PROPAGATED="true" TYPE="boolean">
                     <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                        <VALUE>&txtAcceptSpecficHosts;</VALUE>
                     </QUALIFIER>
                     <VALUE>FALSE</VALUE>
                  </PROPERTY>
               </INSTANCE>
            </VALUE.NAMEDINSTANCE>
         </xsl:otherwise>
      </xsl:choose>
      <!-- output the accepted communities and their rights -->
      <VALUE.NAMEDINSTANCE>
         <INSTANCENAME CLASSNAME="&txtSnmpSecuritySettingsClass;">
            <KEYBINDING NAME="">
               <KEYVALUE>&txtAcceptedCommunities;</KEYVALUE>
            </KEYBINDING>
         </INSTANCENAME>
         <INSTANCE CLASSNAME="&txtSnmpSecuritySettingsClass;">
            <!-- the DISPLAYNAME actually binds all these instances together in XE's GC UI -->
            <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
               <VALUE>&txtSecurity;</VALUE>
            </QUALIFIER>
            <xsl:for-each select="$security_settings/accepted_communities/accept_community">
               <PROPERTY TYPE="string">
                  <xsl:attribute name="NAME"><xsl:value-of select="@name"/></xsl:attribute>
                     <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                        <VALUE><xsl:value-of select="@name"/></VALUE>
                     </QUALIFIER>
                  <VALUE><xsl:value-of select="@type"/></VALUE>
               </PROPERTY>
            </xsl:for-each>
         </INSTANCE>
      </VALUE.NAMEDINSTANCE>
   </xsl:template>
</xsl:stylesheet>
