/***************************************************************************
*         Copyright 2002 Compaq Information Technologies Group, L.P.       *
****************************************************************************
*
*  @doc
*
*  @module  cpqevtw_linux.h
*  Version: 1.0
*
*  Function: Provide basic support for the hp ProLiant Advance Server
*            Management ASIC.
*
*  @doc
****************************************************************************
*
*  @doc
*
*  Change Log:
*
*       Date    Who   Description
*
*****************************************************************************/

#ifndef INCL_CPQEVTW_LINUX_H
#define INCL_CPQEVTW_LINUX_h



#ifndef __KERNEL__
#  define __KERNEL__
#endif

#ifndef MODULE
#  define MODULE
#endif

#ifndef EXPORT_SYMTAB
#  define EXPORT_SYMTAB
#endif


#ifdef INC_OS_HEADERS
#include <linux/config.h>


#ifdef CONFIG_SMP
#define __SMP__
#endif


#ifndef CONFIG_X86_LOCAL_APIC
#  define CONFIG_X86_LOCAL_APIC 1
#endif

#ifndef __MODULE_KERNEL_i686
#define __MODULE_KERNEL_i686
#endif

#ifndef OS_SYMBOL
#define OS_SYMBOL 1
#endif

#if OS_SYMBOL==1

#include <linux/autoconf.h>
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#	define MODVERSIONS
#endif

#ifdef MODVERSIONS
#	include <linux/modversions.h>
#endif

#endif

#include <linux/module.h>
#include <asm/io.h>
#include <linux/notifier.h>
#include <asm/uaccess.h>
#if 0
#include <linux/kernel.h> /* printk() */
#endif

#endif

#include "unixincl.h"
#include "convert.h"

//*************************************************************************
//  Constants
//*************************************************************************



//*************************************************************************
//  Defines and typedefs
//*************************************************************************


typedef struct _OSDATA {
    spinlock_t  imlq_lock;               /* controls access to imlq        */
    spinlock_t  msgq_lock;               /* controls access to msgq        */
    ULONG       imlq_pl;                 /* imlq_lock Priv. Level          */
    ULONG       msgq_pl;                 /* msgq_lock Priv. Level          */
    wait_queue_head_t task_wq;           /* User Tasks waits on this       */
} OSDATA, *POSDATA;



//*************************************************************************
//  Function prototypes
//*************************************************************************


#endif

