%define name bonding
%define version 1.0.4k
%define debug_package %{nil}

Summary: Linux Channel Bonding Driver
Name: %{name}
Version: %{version}
Release: 1
Vendor: HP
Copyright: GPL
Group: System Environment/Base
Source: bonding-%{version}.tgz
BuildRoot: /var/tmp/%{name}-buildroot

%description
This package contains Linux Channel Bonding Driver

%prep
# remove our buildroot in case it was left by a previous build failure
rm -rf /var/tmp/%{name}-buildroot
%setup -c -b 0

%build
make

%install
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
if [ -d /lib/modules/`uname -r`/kernel/drivers/net ]
then
   mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/drivers/net
fi
echo "/lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new" >> $RPM_BUILD_DIR/file.list.%{name}
if [ -d /sbin ]
then
   mkdir -p $RPM_BUILD_ROOT/sbin
fi
echo "/sbin/ifenslave.new" >> $RPM_BUILD_DIR/file.list.%{name}
make install PREFIX=$RPM_BUILD_ROOT
mv -f $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/drivers/net/bonding.o \
      $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new
mv -f $RPM_BUILD_ROOT/sbin/ifenslave $RPM_BUILD_ROOT/sbin/ifenslave.new

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%post
# update bonding.o driver at all locations if it exists
if [ -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o ]; then
   cp -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new \
         /lib/modules/`uname -r`/kernel/drivers/net/bonding.o
fi

if [ -f /lib/modules/`uname -r`/kernel/drivers/net/bonding/bonding.o ]; then
   cp -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new \
         /lib/modules/`uname -r`/kernel/drivers/net/bonding/bonding.o
fi

# if bonding.o driver does not exist, add it
if [ ! -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o -a \
     ! -f /lib/modules/`uname -r`/kernel/drivers/net/bonding/bonding.o ]; then
   cp -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new \
         /lib/modules/`uname -r`/kernel/drivers/net/bonding.o
fi

cp -f /sbin/ifenslave.new /sbin/ifenslave
depmod -a > /dev/null 2>&1
exit 0

%preun
# one big if around the postun..... $1 contains number versions after operation
if [ "$1" = 0 ]; then
   if [ -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new ]; then
      if [ -f /lib/modules/`uname -r`/kernel/drivers/net/bonding/bonding.o ]; then
         cmp -s /lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new \
                /lib/modules/`uname -r`/kernel/drivers/net/bonding/bonding.o
         if [ "$?" == 0 ]; then
            # files match
            rm -f /lib/modules/`uname -r`/kernel/drivers/net/bonding/bonding.o
         fi
      fi

      if [ -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o ]; then
         cmp -s /lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new \
                /lib/modules/`uname -r`/kernel/drivers/net/bonding.o
         if [ "$?" == 0 ]; then
            # files match
            rm -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o
         fi
      fi
   fi

   if [ -f /sbin/ifenslave.new ]; then
      cmp -s /sbin/ifenslave.new /sbin/ifenslave
      if [ "$?" == 0 ]; then
         # files match
         rm -f /sbin/ifenslave
      fi
   fi
fi
exit 0

%postun
# one big if around the postun..... $1 contains number versions after operation
if [ "$1" = 0 ]; then
   rm -f /lib/modules/`uname -r`/kernel/drivers/net/bonding.o.new
   rm -f /sbin/ifenslave.new
fi
depmod -a > /dev/null 2>&1
exit 0

%files -f ../file.list.%{name}
%doc bonding.txt
%doc LICENSE

%changelog
