<?php

echo "\n// ginkgosnmp included here\n";

$snmpqueue = array();
$jscriptqueue = array();
$snmpdata = array();

/*---- obsoleted - use generic PHP string substitution instead
function SubstituteOID( $oidin )
{
    $oidout = $oidin;

    $oidout = str_replace( "mib2",      ".1.3.6.1.2.1",     $oidout );

    $oidout = str_replace( "compaq",    ".1.3.6.1.4.1.232", $oidout );

    return $oidout;
}
*/

$oid_mib2 = ".1.3.6.1.2.1";

$oid_compaq = ".1.3.6.1.4.1.232";

function QueueSNMP( $jsvarname, $oid, $type, $mode, $columnnames = NULL )
{
    global $snmpqueue;
    global $jscriptqueue;

    # fixup the oid
    if( "." != $oid[0] )    $oid = ".$oid";

    if( 'leaf'==$type && ".0" != substr( $oid, -2 ) )   $oid = "$oid.0";

    #if(NULL!=$columnnames)
    #{
    #    echo "//---GSNMP--- $jsvarname columnnames: " . join(",", $columnnames) . "\n";
    #}

    $jscriptqueue[ $jsvarname ] = array( 'type' => $type,
                                         'mode' => $mode,
                                         'colnames' => $columnnames );

    $snmpqueue[ $oid ] =  array( 'name' => $jsvarname,
                                 'type' => $type,
                                 'mode' => $mode );
}

function ParseSNMPOutput( $text )
{
    global $snmpdata;

    foreach ($text as $line)
    {
        #echo "//---GSNMP--- input line: $line\n";

        if( $pos = strpos( $line, '::=' ) ) // intentional assignment in conditional
        {
            $name = substr( $line, 0, $pos );
            $value = substr( $line, $pos+3 );

            if( $pos = strpos( $name, '[' )) // intentional assignment in conditional
            {
                // table value
                $idx = substr( $name, $pos+1, strlen($name)-$pos-2 );
                $name = substr( $name, 0, $pos );

                // create the table if it doesn't exist
                if(! array_key_exists($name, $snmpdata))
                    $snmpdata[ $name ] = array();

                if( $pos = strpos( $idx, '.' )) // intentional assignment in conditional
                {
                    $column = substr( $idx, 0, $pos );
                    $rowidxs = substr( $idx, $pos+1 );

                    if(! array_key_exists( $rowidxs, $snmpdata[$name] ))
                        $snmpdata[ $name ][ $rowidxs ] = array();

                    $snmpdata[ $name ][ $rowidxs ][ $column ] = $value;
                    #echo "//---GSNMP---  snmpdata[$name][$rowidxs][$column] = $value\n";
                }
            }
            else
            {
                // leaf value
                $snmpdata[ $name ] = $value;

                #echo "//---GSNMP--- snmpdata[$name] = $value;\n";
            }
        }
    }
}


function EscapeJSString( $strin )
{
    $rc = ereg_replace( '[^[:print:]]', ' ', $strin );  # strip unprintable characters

    $rc = str_replace( '"', '\"', $rc );    # escape double quotes

    return $rc;
}


function GenerateJSLeaf( $varname, $mode )
{
    global $snmpdata;

    if('raw' == $mode )
    {
        echo "\n\n$varname = new Array;\n";

        $bytes = split(',', $snmpdata[ $varname ]);

        $count = count( $bytes );
        for($i=0; $i<$count; $i++)
        {
            echo $varname . "[" . $varname . ".length]=\"0x" . $bytes[ $i ] . "\";\n";
        }
    }
    else
        echo "\n\n$varname = \"" . EscapeJSString( $snmpdata[ $varname ] ) . "\";\n";
}


function GenerateJSTable( $varname, $mode, $namearray )
{
    global $snmpdata;

    // create the empty array for the value
    echo "\n\n$varname = new Array;\n";

    if(! array_key_exists( $varname, $snmpdata ))
    {
        // no data was generated/found for this OID
        return;
    }

    // count the number of columns in the first row of the table
    $colcount = 0;
    foreach ($snmpdata[$varname] as $key => $value)
    {
        foreach ($value as $key2 => $value2)
        {
            $colcount++;

            #echo "/---GSNMP--- column $colcount has key $key2\n";
        }

        break;  // only count the first row
    }

    // create a constructor for the JS array
    $namesexist = ( NULL != $namearray );
    $namecount = count($namearray);

    echo "function cs$varname(";
    for($i=1; $i <= $colcount; $i++)
    {
        if($i>1) echo ", ";

        echo "c$i";
    }
    echo ")\n";
    echo "{\n";
    for($i=1; $i <= $colcount; $i++)
    {
        $membername = "c$i";

        if( $namesexist && $i > 0 )
            if( ($i - 1) < $namecount )
                $membername = $namearray[ $i-1 ];

        echo "   this.$membername = c$i;\n";
    }
    echo "}\n\n";

    // iterate through the rows of data
    foreach ($snmpdata[$varname] as $key => $value)
    {
        echo $varname . "[ " . $varname . ".length ] = new cs" . $varname . "(";
        for($i=1; $i <= $colcount; $i++)
        {
            if($i>1) echo ", ";
            echo "\"" . EscapeJSString($value[ $i ]) . "\"";
        }
        echo ");\n";
    }

}


function GenerateJSTableLeaf( $varname, $mode )
{
    global $snmpdata;

    $rawmode = ('raw'==$mode);

    // create the empty array for the value
    echo "\n\n$varname = new Array;\n";

    if(! array_key_exists( $varname, $snmpdata ))
    {
        // no data was generated/found for this OID
        return;
    }

    // there should be only one index for the tables for
    // this leaf so pick one out
    $leafindex = "";
    foreach ($snmpdata[$varname] as $key => $value)
    {
        foreach( $value as $key2 => $value2)
        {
            $leafindex = $key2;
            break;
        }
        break;
    }

    // iterate through the rows of data
    foreach ($snmpdata[$varname] as $key => $value)
    {
        echo $varname . "[ " . $varname . ".length ] = ";

        if($rawmode)
        {
            $bytes = split(",", $value[$leafindex]);

            echo "new Array(\"" . join( "\",\"", $bytes) . "\");";
        }
        else
        {
            echo "\"" . EscapeJSString($value[$leafindex]) . "\"";
        }

        echo "\n";
    }

}


function JustGetSNMPQueue()
{
    global $snmpqueue;
    global $jscriptqueue;

    $sessiondir = $_SERVER['HTTP_HPSMH_SESSIONDIR'];
    $tempfilename = "$sessiondir/" . substr($_SERVER["SCRIPT_URL"], 1 + strrpos($_SERVER["SCRIPT_URL"], '/')) . uniqid(".", true) . time() . ".txt";

    #echo "//--- GSNMP --- $tempfilename\n";
    $fp = fopen( $tempfilename, "w" );

    foreach ($snmpqueue as $key => $value)
    {
        fwrite( $fp, $value['name'] . "  " . $key . "  get" . $value['type'] . "  " . $value['mode'] . "\n");

        #echo "//---GSNMP---- " . $value['name'] . "  " . $key . "  " . $value['type'] . $value['mode'] . "\n";
    }

    fclose( $fp );

    #--- get the SNMP data
    if("Linux" == PHP_OS)
       $cmd = "../../webapp-data/webagent/csginkgo \x3c$tempfilename";
    else
       $cmd = "..\\..\\smhutil\\csginkgo.exe\x3c$tempfilename";

    exec( $cmd, $out );

    #echo "//---GSNMP--- cmd is $cmd\n";
    #echo "//---GSNMP--- csginkgo.exe output:\n//---GSNMP--- " . join("\n//---GSNMP--- ", $out) . "\n";
    ParseSNMPOutput( $out );

    #--- delete the cmd file
    unlink( $tempfilename );

    # clear out the queues for additional calls
    $snmpqueue = array();
}

function GenerateJSfromSNMPQueue()
{
    global $snmpqueue;
    global $jscriptqueue;

    JustGetSNMPQueue();

    #--- generate the JS

    foreach( $jscriptqueue as $key => $value )
    {
        #echo "//---GSNMP--- JS for " . $key . "   " . "\n";

        if('leaf' == $value['type'])
        {
            GenerateJSLeaf( $key, $value['mode'] );
        }
        elseif( 'table'== $value['type'])
        {
            GenerateJSTable( $key, $value['mode'], $value['colnames'] );
        }
        elseif( 'tableleaf' == $value['type'] )
        {
            GenerateJSTableLeaf( $key, $value['mode'] );
        }
    }

    # clear out the queues for additional calls
    $jscriptqueue = array();
}

?>
