<html>
<!-- $RCSfile: ms-scsi.tpl,v $ $Revision: 1.1.2.1 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>SCSI Device Information</title>

<!#/COMMON/JPN/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqScsiCntlrEntry>
<!cpqScsiTargetEntry>
<!cpqScsiPhyDrvEntry>
<!cpqTapePhyDrvEntry>
<!cpqTapeCountersEntry>
<!cpqTapeLibraryEntry>
<!cpqTapeLibraryDriveList.raw>
<!cpqTapeLibraryTapeList.raw>
<!cpqSsDrvBoxEntry>
<!cpqCdLibraryEntry>
<!cpqScsiCdDrvEntry>
<!cpqCdLibraryDriveList.raw>

<!#/COMMON/JPN/COND.JS>
<!#/COMMON/JPN/STDITEMS.JS>
<!#/COMMON/JPN/TABLES.JS>
<!#/COMMON/JPN/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#TPENUMS.JS>
<!#SCSENUMS.JS>
<!#SSENUMS.JS>
<!#MS-SCSIC.JS>
<!#MS-DRVBX.JS>

postfix["cpqScsiPhyDrvSize"] = "MB";

function NegotiatedWidth(bits)
{
   if (bits == 8)
      return ("i[ (8 rbg)");
   else if (bits == 16)
      return ("Ch (16 rbg)");
   else return ("N/A");
}

function hotPlugGraphic()
{
   return ("<img src='/WEBAGENT/CQMGSTOR/ENG/HOTPLUG.JPG' align='middle' width='11' height='15' hspace='3' border='0'> ");
}

function boxStatusGraphic(boxIndex)
{
   var boxStatus = new cpqCondition(cpqSsDrvBoxEntry[boxIndex].cpqSsBoxCondition);
   return boxStatus.image();
}

function writeScsiDevInfoTable(idx)
{
   writeTableHead();
   writeDoubleTableRow("foCX ^Cv:",  targetType(idx),
                       "x_:",       displayItem("cpqScsiTargetVendor", cpqScsiTargetEntry[idx].cpqScsiTargetVendor));
   writeDoubleTableRow("F/W o[W:", displayItem("cpqScsiTargetFWRev", cpqScsiTargetEntry[idx].cpqScsiTargetFWRev),
                       "f:",        displayItem("cpqScsiTargetModel",  cpqScsiTargetEntry[idx].cpqScsiTargetModel));
   writeTableTail();
}

function writeScsiBusTable(idx)
{
   if (cpqScsiTargetEntry[idx].cpqScsiTargetParityErrs     != "4294967295" ||
       cpqScsiTargetEntry[idx].cpqScsiTargetPhaseErrs      != "4294967295" ||
       cpqScsiTargetEntry[idx].cpqScsiTargetSelectTimeouts != "4294967295" ||
       cpqScsiTargetEntry[idx].cpqScsiTargetMsgRejects     != "4294967295")
   {
      document.write("<br>");
      writeTableLabel("SCSI oX");
      writeTableHead();
      writeDoubleTableRow("peBG[:",        displayItem("cpqScsiTargetParityErrs",  cpqScsiTargetEntry[idx].cpqScsiTargetParityErrs),
                          "oX:",              displayItem("cpqScsiTargetPhysWidth",   cpqScsiTargetEntry[idx].cpqScsiTargetPhysWidth));
      writeDoubleTableRow("tF[YG[:",        displayItem("cpqScsiTargetPhaseErrs",   cpqScsiTargetEntry[idx].cpqScsiTargetPhaseErrs),
                          "݃oX:",            NegotiatedWidth(cpqScsiTargetEntry[idx].cpqScsiTargetNegWidth));
      writeDoubleTableRow("ZNg ^CAEg:", displayItem("cpqScsiTargetSelectTimeouts", cpqScsiTargetEntry[idx].cpqScsiTargetSelectTimeouts),
                          "ݑx:",              displayItem("cpqScsiTargetCurrentSpeed", cpqScsiTargetEntry[idx].cpqScsiTargetCurrentSpeed));
      writeDoubleTableRow("bZ[W WFNg:", displayItem("cpqScsiTargetMsgRejects",  cpqScsiTargetEntry[idx].cpqScsiTargetMsgRejects),
                          "","");
      writeTableTail();
   }
}

function actionFromStatus(status)
{
   rc = "ΏKvȂ";

   if (status == null)
   {
      rc = "s";
   }
   else if (status == 8 || status == 9)
   {
      rc = "S.M.A.R.T.hCu";
   }
   else if (status == 3 || status == 6 || status == 7 || status == 11)
   {
      rc = "hCu";
   }
   return rc;
}

function writeScsiDriveTables(cntlr, bus, id, targIndex)
{
   var i;
   var modelName;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqScsiPhyDrvEntry.length; i++)
   {
      if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCntlrIndex == cntlr &&
          cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvBusIndex == bus &&
          cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvScsiID == id)
      {
         break;
      }
   }
   if (i < cpqScsiPhyDrvEntry.length)
   {
      if ((cpqScsiTargetEntry[targIndex].cpqScsiTargetVendor.length > 0) &&
          (cpqScsiTargetEntry[targIndex].cpqScsiTargetModel.length > 0))
      {
         modelName = cpqScsiTargetEntry[targIndex].cpqScsiTargetVendor + " " +
                     cpqScsiTargetEntry[targIndex].cpqScsiTargetModel;
      }
      else modelName = displayItem("cpqScsiTargetModel",  cpqScsiTargetEntry[targIndex].cpqScsiTargetModel);

      writeTableHead();
      writeDoubleTableRow(
         "Xe[^X:", displayItem("cpqScsiPhyDrvStatus", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvStatus),
         "Ώ:",       actionFromStatus(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvStatus));
      writeDoubleTableRow(
         "e:",     driveCapacity("cpqScsiPhyDrvSize", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSize),
         "f:",   modelName);
      writeDoubleTableRow(
         "F/W o[W:", displayItem("cpqScsiTargetFWRev",  cpqScsiTargetEntry[targIndex].cpqScsiTargetFWRev),
         "VAԍ:",   displayItem("cpqScsiPhyDrvSerialNum", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSerialNum));
      writeDoubleTableRow(
         "ғ:",           displayItem("cpqScsiPhyDrvServiceHours", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvServiceHours),
         "S.M.A.R.T.T|[g:", displayItem("cpqScsiPhyDrvPreFailMonitoring", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPreFailMonitoring));

      if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHotPlug == 2)
      {
         writeDoubleTableRow(
            "zu:",   displayItem("cpqScsiPhyDrvPlacement", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPlacement) + hotPlugGraphic(),
            "]:", displayItem("cpqScsiPhyDrvRotationalSpeed", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRotationalSpeed));
      }
      else writeDoubleTableRow(
              "zu:",         displayItem("cpqScsiPhyDrvPlacement", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPlacement),
              "]:", displayItem("cpqScsiPhyDrvRotationalSpeed", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRotationalSpeed));
      writeTableTail();
      document.write("<br>");

      writeTableLabel("hCu CWP[^");
      writeTableHead();
      writeDoubleTableRow("pςݍĊ蓖:",    displayItem("cpqScsiPhyDrvUsedReallocs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvUsedReallocs),
                          "XsAbv:",      displayItem("cpqScsiPhyDrvSpinupTime",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSpinupTime));
      writeDoubleTableRow("^CAEg:",        displayItem("cpqScsiPhyDrvTimeouts",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvTimeouts),
                          "ZteXg G[:", displayItem("cpqScsiPhyDrvPostErrs",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPostErrs));
      writeTableTail();
      document.write("<br>");

      writeTableLabel("hCu v");
      writeTableHead();
      writeDoubleTableRow(
         "[hZN^:", displayQuadNumber(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHighReadSectors,
                                            cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvLowReadSectors),
         "CgZN^:", displayQuadNumber(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHighWriteSectors,
                                               cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvLowWriteSectors));
      writeDoubleTableRow(
         "n[h [h G[:", displayItem("cpqScsiPhyDrvHardReadErrs",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHardReadErrs),
         "n[h Cg G[:", displayItem("cpqScsiPhyDrvHardWriteErrs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHardWriteErrs));
      writeDoubleTableRow(
         "[h G[:", displayItem("cpqScsiPhyDrvRecvReadErrs",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRecvReadErrs),
         "Cg G[:", displayItem("cpqScsiPhyDrvRecvWriteErrs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRecvWriteErrs));
      writeDoubleTableRow(
         "ECC ς݃[h:", displayItem("cpqScsiPhyDrvEccCorrReads", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvEccCorrReads),
         "V[N G[:",      displayItem("cpqScsiPhyDrvSeekErrs",     cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSeekErrs));
      writeTableTail();
   }
}

function writeScsiTapeTables(cntlr, bus, id, targIndex)
{
   var i;
   var j;
   var fw;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqTapePhyDrvEntry.length; i++)
   {
      if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvCntlrIndex == cntlr &&
          cpqTapePhyDrvEntry[i].cpqTapePhyDrvBusIndex == bus &&
          cpqTapePhyDrvEntry[i].cpqTapePhyDrvScsiIdIndex == id)
      {
         break;
      }
   }
   if (i < cpqTapePhyDrvEntry.length)
   {
      if (typeof(cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwRev) == "undefined")
      {
         fw = displayItem("cpqTapePhyDrvFwSubtype", cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwSubtype);
      }
      else
      {
         fw = displayItem("cpqTapePhyDrvFwRev", cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwRev);
      }
      writeTableHead();
      writeDoubleTableRow(
         "f:",     displayItem("cpqTapePhyDrvName", cpqTapePhyDrvEntry[i].cpqTapePhyDrvName),
         "Xe[^X:", displayItem("cpqTapePhyDrvStatus", cpqTapePhyDrvEntry[i].cpqTapePhyDrvStatus));
      writeDoubleTableRow(
         "F/W o[W:", fw,
         "VAԍ:", displayItem("cpqTapePhyDrvSerialNumber", cpqTapePhyDrvEntry[i].cpqTapePhyDrvSerialNumber));

      if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvHotPlug == 2)
      {
         writeDoubleTableRow(
            "CuhCu:", displayItem("cpqTapePhyDrvLibraryDrive", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLibraryDrive),
            "zu:",               displayItem("cpqTapePhyDrvPlacement", cpqTapePhyDrvEntry[i].cpqTapePhyDrvPlacement) + hotPlugGraphic());
      }
      else writeDoubleTableRow(
         "CuhCu:", displayItem("cpqTapePhyDrvLibraryDrive", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLibraryDrive),
         "zu:",               displayItem("cpqTapePhyDrvPlacement", cpqTapePhyDrvEntry[i].cpqTapePhyDrvPlacement));
      writeTableTail();

      // Tape autoloader info
      if (cpqScsiTargetEntry[targIndex].cpqScsiTargetTypeExtended == 7)
      {
         document.write("<br>");
         writeTableLabel("fBA");
         writeTableHead();
         writeDoubleTableRow(
            "f:",          displayItem("cpqTapePhyDrvLoaderName", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLoaderName),
            "}KW TCY:", displayItem("cpqTapePhyDrvMagSize", cpqTapePhyDrvEntry[i].cpqTapePhyDrvMagSize));
         writeDoubleTableRow(
            "F/W o[W:", displayItem("cpqTapePhyDrvLoaderFwRev", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLoaderFwRev),
            "VAԍ:",   displayItem("cpqTapePhyDrvLoaderSerialNum", cpqTapePhyDrvEntry[i].cpqTapePhyDrvLoaderSerialNum));
         writeTableTail();
      }
      // find the appropriate entry in the tape counters table
      for (j = 0; j < cpqTapeCountersEntry.length; j++)
      {
         if (cpqTapeCountersEntry[i].cpqTapeCountersCntlrIndex == cntlr &&
             cpqTapeCountersEntry[i].cpqTapeCountersBusIndex == bus &&
             cpqTapeCountersEntry[i].cpqTapeCountersScsiIdIndex == id)
         {
            document.write("<br>");
            writeTableLabel("e[vhCu G[");
            writeTableHead();
            writeDoubleTableRow(
               "e[v G[:", displayItem("cpqTapeCountersTotalErrors",  cpqTapeCountersEntry[i].cpqTapeCountersTotalErrors),
               "ă[h:",      displayItem("cpqTapeCountersReReads", cpqTapeCountersEntry[i].cpqTapeCountersReReads));
            writeDoubleTableRow(
               "s\:",   displayItem("cpqTapeCountersTotalUncorrectable", cpqTapeCountersEntry[i].cpqTapeCountersTotalUncorrectable),
               "ăCg:", displayItem("cpqTapeCountersReWrites", cpqTapeCountersEntry[i].cpqTapeCountersReWrites));
            writeTableTail();
            break;
         }
      }
      document.write("<br>");
      writeTableLabel("e[vhCu eiX");
      writeTableHead();
      writeSingleTableRow("e[vhCuwbh̓N[jOKv:",
          displayItem("cpqTapePhyDrvCleanReq", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanReq));
      writeSingleTableRow("N[jOe[v͌Kv:",
          displayItem("cpqTapePhyDrvCleanTapeRepl", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanTapeRepl));
      writeSingleTableRow("N[jOs:",
          displayItem("cpqTapePhyDrvCleanTapeCount", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanTapeCount));
      writeTableTail();
   }
}

function writeScsiTapeLibraryTables(cntlr, bus, id, targIndex)
{
   var i;
   var j;
   var n;
   var driveLink;
   var rawTable;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqTapeLibraryEntry.length; i++)
   {
      if (cpqTapeLibraryEntry[i].cpqTapeLibraryCntlrIndex == cntlr &&
          cpqTapeLibraryEntry[i].cpqTapeLibraryBusIndex == bus &&
          cpqTapeLibraryEntry[i].cpqTapeLibraryScsiIdIndex == id)
      {
         break;
      }
   }
   if (i < cpqTapeLibraryEntry.length)
   {
      writeTableHead();
      writeDoubleTableRow(
         "f:",     displayItem("cpqTapeLibraryName", cpqTapeLibraryEntry[i].cpqTapeLibraryName),
         "Xe[^X:", displayItem("cpqTapeLibraryState", cpqTapeLibraryEntry[i].cpqTapeLibraryState));
      writeDoubleTableRow(
         "F/W rW:", displayItem("cpqTapeLibraryFwRev", cpqTapeLibraryEntry[i].cpqTapeLibraryFwRev),
         "VAԍ:",   displayItem("cpqTapeLibrarySerialNumber", cpqTapeLibraryEntry[i].cpqTapeLibrarySerialNumber));
      writeDoubleTableRow(
         "ғ:", displayItem("cpqTapeLibraryStatHours", cpqTapeLibraryEntry[i].cpqTapeLibraryStatHours),
         "ړv:", displayItem("cpqTapeLibraryStatMoves", cpqTapeLibraryEntry[i].cpqTapeLibraryStatMoves));
      writeDoubleTableRow(
         "hA Xe[^X:", displayItem("cpqTapeLibraryDoorStatus", cpqTapeLibraryEntry[i].cpqTapeLibraryDoorStatus),
         "__V:",    displayItem("cpqTapeLibraryRedundancy", cpqTapeLibraryEntry[i].cpqTapeLibraryRedundancy));
      writeDoubleTableRow(
         "x:",           displayItem("cpqTapeLibraryTemperature", cpqTapeLibraryEntry[i].cpqTapeLibraryTemperature),
         "zbgXbv:", displayItem("cpqTapeLibraryHotSwap", cpqTapeLibraryEntry[i].cpqTapeLibraryHotSwap));
      writeDoubleTableRow(
         "ŏIG[:", displayItem("cpqTapeLibraryStatus", cpqTapeLibraryEntry[i].cpqTapeLibraryStatus),
         "", "");
      writeTableTail();

      document.write("<br>");
      writeTableLabel("gݍ܂ꂽe[vhCu");
      writeTableHead();

      if (cpqTapeLibraryDriveList[i].length > 0)
      {
      rawTable = cpqTapeLibraryDriveList[i];
         idSize = 4;
      }
      else // Use new list
      {
         rawTable = cpqTapeLibraryTapeList[i];
         idSize = 7;
      }

      for (j = 0; j < rawTable.length; j += idSize)
      {
         var tapeName = "e[vhCu - ";
         var drvCntlr = (rawTable[j+3] << 24) + (rawTable[j+2] << 16) +
                        (rawTable[j+1] <<  8) +  rawTable[j];
         var drvBus = rawTable[j+4];
         var drvId  = rawTable[j+5];

         for (n = 0; n < cpqTapePhyDrvEntry.length; n++)
         {
            if (drvCntlr == cpqTapePhyDrvEntry[n].cpqTapePhyDrvCntlrIndex &&
                drvBus   == cpqTapePhyDrvEntry[n].cpqTapePhyDrvBusIndex   &&
                drvId    == cpqTapePhyDrvEntry[n].cpqTapePhyDrvScsiIdIndex)
            {
               tapeCondition = new cpqCondition(cpqTapePhyDrvEntry[n].cpqTapePhyDrvCondition);
               tapeName = tapeCondition.imageSmall() + cpqTapePhyDrvEntry[n].cpqTapePhyDrvName + " - ";
               break;
            }
         }
         for (n = 0; n < cpqScsiCntlrEntry.length; n++)
         {
            if (drvCntlr == cpqScsiCntlrEntry[n].cpqScsiCntlrIndex)
            {
               tapeName += "SCSI Rg[ Xbg" +
                            cpqScsiCntlrEntry[n].cpqScsiCntlrSlot;
               break;
            }
         }
         tapeName += " |[g" + drvBus + " ID " + drvId;
         driveLink = makeLink("CQMGSTOR/MS-SCSI.TPL?index=" + drvCntlr +
                              "&bus=" + drvBus + "&id=" + drvId, tapeName, "_self");
         writeOneItemTableRow(driveLink);
      }
      writeTableTail();
   }
}

function writeScsiCdLibraryTables(cntlr, bus, id, targIndex)
{
   var i;
   var j;
   var k;
   var rawTable;
   var drvCntlr;
   var drvBus;
   var drvId;
   var drvLun;

   // find the physical drive that corresponds to this target
   for (i = 0; i < cpqCdLibraryEntry.length; i++)
   {
      if (cpqCdLibraryEntry[i].cpqCdLibraryCntlrIndex == cntlr &&
          cpqCdLibraryEntry[i].cpqCdLibraryBusIndex == bus &&
          cpqCdLibraryEntry[i].cpqCdLibraryScsiIdIndex == id)
      {
         break;
      }
   }
   if (i < cpqCdLibraryEntry.length)
   {
      writeTableHead();
      writeSingleTableRowInDoubleTable(
         "Xe[^X:", displayItem("cpqCdLibraryStatus", cpqCdLibraryEntry[i].cpqCdLibraryStatus));
      writeDoubleTableRow(
         "VAԍ:",     displayItem("cpqCdLibrarySerialNumber", cpqCdLibraryEntry[i].cpqCdLibrarySerialNumber),
         "Rg[ LUN:", displayItem("cpqCdLibraryLunIndex",     cpqCdLibraryEntry[i].cpqCdLibraryLunIndex));
      writeTableTail();

      document.write("<br>");
      writeTableLabel("gݍ܂ꂽ CDhCu");
      writeTableHead();
      writeColumnTableHeaderRow("x_:", "f:", "F/W rW:", "LUN:");

      rawTable = cpqCdLibraryDriveList[i];
      for (j = 0; j < (rawTable.length/4); j++)
      {
         drvCntlr = rawTable[j*4];
         drvBus   = rawTable[j*4 + 1];
         drvId    = rawTable[j*4 + 2];
         drvLun   = rawTable[j*4 + 3];

         for (k = 0; k < cpqScsiCdDrvEntry.length; k++)
         {
            if (cpqScsiCdDrvEntry[k].cpqScsiCdDrvCntlrIndex ==  drvCntlr &&
                cpqScsiCdDrvEntry[k].cpqScsiCdDrvBusIndex ==    drvBus &&
                cpqScsiCdDrvEntry[k].cpqScsiCdDrvScsiIdIndex == drvId &&
                cpqScsiCdDrvEntry[k].cpqScsiCdDrvLunIndex ==    drvLun)
            {
               writeColumnTableDataRow(cpqScsiCdDrvEntry[k].cpqScsiCdDrvVendor,
                  cpqScsiCdDrvEntry[k].cpqScsiCdDrvModel,
                  cpqScsiCdDrvEntry[k].cpqScsiCdDrvFwRev, drvLun);
            }
         }
      }
      writeTableTail();
   }
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

cntlr = findArg("index");
bus = findArg("bus");

if (cntlr == -1 || bus == -1)
{
   parseArgs(tryPrevPage());
   cntlr = findArg("index");
   bus = findArg("bus");
}
for (cntlrIdx = 0; cntlrIdx < cpqScsiCntlrEntry.length; cntlrIdx++)
{
   if (cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrIndex == cntlr &&
       cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrBusIndex == bus)
      break;
}
if (cpqScsiCntlrEntry.length == cntlrIdx)
{
   reportMissingArgs();
}
else
{
   id = findArg("id");
   box = findArg("box");

   if (id != -1)  // SCSI target
   {
      for (i = 0; i < cpqScsiTargetEntry.length; i++)
      {
         if (cpqScsiTargetEntry[i].cpqScsiTargetCntlrIndex == cntlr &&
             cpqScsiTargetEntry[i].cpqScsiTargetBusIndex == bus &&
             cpqScsiTargetEntry[i].cpqScsiTargetScsiIdIndex == id)
            break;
      }
      targetidx = i;
      pageTitle = targetName(targetidx);
   }
   else if (box != -1) // storage box
   {
      count = 0;
      for (i = 0; i < cpqSsDrvBoxEntry.length; i++)
      {
         if (cpqSsDrvBoxEntry[i].cpqSsBoxCntlrIndex == cntlr &&
             cpqSsDrvBoxEntry[i].cpqSsBoxBusIndex == bus)
         {
            if (count == box) break;
            count++;
         }
      }
      boxidx = i;
      pageTitle = displayItem("cpqSsBoxPlacement", cpqSsDrvBoxEntry[boxidx].cpqSsBoxPlacement)
       + " |[g" + bus;
   }
   writePageHead(scsiCntlrName(cntlrIdx), "/WEBAGENT/IMAGES/MASSHDR.GIF", "SCSI foCX");

   if (id != -1)  // display the devices
   {
      tableTitle = targetStatusGraphic(targetidx, "LARGE") + targetName(targetidx);
      writeTableLabel(tableTitle, "SCSI foCX");

      // display any type-specific info here:
      thisType = cpqScsiTargetEntry[targetidx].cpqScsiTargetType;
      thisTypeExt = cpqScsiTargetEntry[targetidx].cpqScsiTargetTypeExtended;
      if (thisType ==  2) // drive
      {
         writeScsiDriveTables(cntlr, bus, id, targetidx);
      }
      else if (thisType == 3)   // tape
      {
         writeScsiTapeTables(cntlr, bus, id, targetidx);
      }
      else if (thisTypeExt == 4) // tape library
      {
         writeScsiTapeLibraryTables(cntlr, bus, id, targetidx);
      }
      else if (thisTypeExt == 5) // CD library
      {
         writeScsiDevInfoTable(targetidx);
         writeScsiCdLibraryTables(cntlr, bus, id, targetidx);
      }
      else
      {
         writeScsiDevInfoTable(targetidx);
      }
      document.write("<br>");
      writeScsiBusTable(targetidx);
   }
   else if (box != -1) // display storage boxes
   {
      tableTitle = boxStatusGraphic(boxidx) + displayItem("cpqSsBoxPlacement",
                   cpqSsDrvBoxEntry[boxidx].cpqSsBoxPlacement) + " |[g" + bus;
      writeTableLabel(tableTitle, "Xg[W VXe");
      writeDriveBoxTable(cpqSsDrvBoxEntry[boxidx]);
   }
   writeTableTail();
}
writeBodyTail();
</script>
</html>
