<html>
<!-- $RCSfile: ms-idlog.tpl,v $ $Revision: 1.1.2.1 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>IDE Logical Drive Information</title>

<!#/COMMON/JPN/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqIdeControllerEntry>
<!cpqIdeLogicalDriveEntry>
<!cpqIdeLogicalDriveDiskIds.raw>
<!cpqIdeLogicalDriveSpareIds.raw>
<!cpqIdeAtaDiskEntry>

<!#/COMMON/JPN/COND.JS>
<!#/COMMON/JPN/STDITEMS.JS>
<!#/COMMON/JPN/TABLES.JS>
<!#/COMMON/JPN/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#IDENUMS.JS>
<!#MS-IDCMN.JS>

postfix["cpqIdeLogicalDriveCapacity"] = "MB";
postfix["cpqIdeLogicalDriveStripeSize"] = "KB";
</script>
</head>
<script language="JavaScript">

writeBodyHead();

cntrlIdx = findArg("index");
driveIdx = findArg("drive");

if (cntrlIdx == -1 || driveIdx == -1)
{
   parseArgs(tryPrevPage());
   cntrlIdx  = findArg("index");
   driveIdx = findArg("drive");
}
for (cntrl = 0; cntrl < cpqIdeControllerEntry.length; cntrl++)
{
   if (cpqIdeControllerEntry[cntrl].cpqIdeControllerIndex == cntrlIdx)
      break;
}
if (cntrl >= cpqIdeControllerEntry.length || driveIdx == -1)
{
   reportMissingArgs();
}
else
{
   writePageHead(ideControllerName(cntrl), "/WEBAGENT/IMAGES/MASSHDR.GIF", "IDE ATA _hCu");

   for (drive = 0; drive < cpqIdeLogicalDriveEntry.length; drive++)
   {
      if (cpqIdeLogicalDriveEntry[drive].cpqIdeLogicalDriveIndex == driveIdx)
         break;
   }
   thisDrv = cpqIdeLogicalDriveEntry[drive];
   driveCondition = new cpqCondition(thisDrv.cpqIdeLogicalDriveCondition);
   writeTableLabel(driveCondition.image() + logicalDriveName(drive));
   writeTableHead();
   writeDoubleTableRow("Xe[^X:",          displayItem("cpqIdeLogicalDriveStatus", thisDrv.cpqIdeLogicalDriveStatus),
                       "tH[ggX:", displayItem("cpqIdeLogicalDriveRaidLevel", thisDrv.cpqIdeLogicalDriveRaidLevel));
   writeDoubleTableRow("e:",        displayItem("cpqIdeLogicalDriveCapacity", thisDrv.cpqIdeLogicalDriveCapacity),
                       "XgCvTCY:",     displayItem("cpqIdeLogicalDriveStripeSize", thisDrv.cpqIdeLogicalDriveStripeSize));
   diskName = "N/A";
   for (i = 0; i < cpqIdeAtaDiskEntry.length; i++)
   {
      if (thisDrv.cpqIdeLogicalDriveRebuildingDisk ==
          cpqIdeAtaDiskEntry[i].cpqIdeAtaDiskIndex)
      {
         diskName = physicalDriveName(i);
         break;
      }
   }
   writeDoubleTableRow("fBXNč\:", diskName, "","");
   writeTableTail();
   document.write("<br>");

   writeTableLabel("hCu");
   writeTableHead();
   rawData = cpqIdeLogicalDriveDiskIds[drive];
   count = 0;

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqIdeAtaDiskEntry.length; j++)
      {
         if (cpqIdeAtaDiskEntry[j].cpqIdeAtaDiskIndex == rawData[i])
         {
            driveCondition.set(cpqIdeAtaDiskEntry[j].cpqIdeAtaDiskCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-IDPHY.TPL?index="+cntrlIdx+"&disk=1&drive="+rawData[i];
            writeStatusNameTable(makeLink(phyLink, driveCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, physicalDriveName(j), "_self"));
            document.write("</td></tr>");
            count++;
            break;
         }
      }
   }
   if (count == 0)  writeOneItemTableRow("Ȃ");
   writeTableTail();
   document.write("<br>");

   writeTableLabel("XyAhCu");
   writeTableHead();
   rawData = cpqIdeLogicalDriveSpareIds[drive];
   count = 0;

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqIdeAtaDiskEntry.length; j++)
      {
         if (cpqIdeAtaDiskEntry[j].cpqIdeAtaDiskIsSpare == 2 &&
             cpqIdeAtaDiskEntry[j].cpqIdeAtaDiskIndex == rawData[i])
         {
            driveCondition.set(cpqIdeAtaDiskEntry[j].cpqIdeAtaDiskCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-IDPHY.TPL?index="+cntrlIdx+"&disk=1&drive="+rawData[i];
            writeStatusNameTable(makeLink(phyLink, driveCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, physicalDriveName(j), "_self"));
            document.write("</td></tr>");
            count++;
            break;
         }
      }
   }
   if (count == 0)  writeOneItemTableRow("Ȃ");
   writeTableTail();
}
writeBodyTail();
</script>
</html>
