// RCSfile: MS-IDCMN.JS Revision: 1.6 $

function ideControllerName(idx)
{
   var index = parseInt(idx, 10) + 1;
   var name = cpqIdeControllerEntry[idx].cpqIdeControllerModel;

   if (cpqIdeControllerEntry[idx].cpqIdeControllerSlot > 0)
      name += " in Slot " + cpqIdeControllerEntry[idx].cpqIdeControllerSlot;
   else if (cpqIdeControllerEntry[idx].cpqIdeControllerSlot == 0)
      name += " on System Board";
   else // No slot number
      name += " (" + index + ")";
   return name;
}
function atapiDeviceName(idx)
{
   var device = cpqIdeAtapiDeviceEntry[idx];
   var name = displayItem("cpqIdeAtapiDeviceType", device.cpqIdeAtapiDeviceType);
   
   if (device.cpqIdeAtapiDeviceTypeExtended > 1)
      name = displayItem("cpqIdeAtapiDeviceTypeExtended", device.cpqIdeAtapiDeviceTypeExtended); 
   
   name += " - " + displayItem("cpqIdeAtapiDeviceChannel", device.cpqIdeAtapiDeviceChannel) +
           ", "  + displayItem("cpqIdeAtapiDeviceNumber",  device.cpqIdeAtapiDeviceNumber);
   return name;
}
function physicalDriveName(idx)
{
   var drive = cpqIdeAtaDiskEntry[idx];
   var name = displayItem("cpqIdeAtaDiskChannel", drive.cpqIdeAtaDiskChannel) +
          ", " + displayItem("cpqIdeAtaDiskNumber",  drive.cpqIdeAtaDiskNumber);
   
   if (drive.cpqIdeAtaDiskIsSpare == 2)  name += " - Spare";
   return name;
}
function logicalDriveName(idx)
{
   var drive = cpqIdeLogicalDriveEntry[idx];
   var name = "Logical Drive " + drive.cpqIdeLogicalDriveIndex;

   if (drive.cpqIdeLogicalDriveRaidLevel > 1)
      name += " - " + displayItem("cpqIdeLogicalDriveRaidLevel", drive.cpqIdeLogicalDriveRaidLevel);
   return name;
}


