<html>
<!-- RCSfile: MS-FCMNU.TPL Revision: 1.31  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Menu</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
<!cpqSsChassisEntry>
<!cpqSsBackplaneEntry>
<!cpqFcaCntlrEntry>
<!cpqFcaPhyDrvEntry>
<!cpqFcaLogDrvEntry>
<!cpqFcaSpareEntry>
<!cpqFcSwitchEntry>
<!cpqFcTapeDriveEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/NAVTABLE.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SSENUMS.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index"); // Chassis index
if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqSsChassisEntry.length)
{
   reportMissingArgs();
}
else
{
   thisChassis = cpqSsChassisEntry[idx];
   thisChassisIdx = thisChassis.cpqSsChassisIndex;
   thisChassisCondition = new cpqCondition(thisChassis.cpqSsChassisOverallCondition);

   if (window.name == 'submenu') target = 'subdata';
   else  target= "_self";

   writeSmallTableLabel(thisChassisCondition.image()+ fcChassisName(idx),
      "Storage System Information");
   writeTableHead();
   thisCondition = storageSysCondition(idx);
   writeNavTableRow("Storage System Information", "CQMGSTOR/MS-FCSS.TPL?index=" + idx,
                    thisCondition.imageSmall(), target);
   writeTableText("Controllers:");
   for (i = 0; i < cpqFcaCntlrEntry.length; i++)
   {
      if (cpqFcaCntlrEntry[i].cpqFcaCntlrBoxIndex == thisChassisIdx)
      {
         thisCondition.set(cpqFcaCntlrEntry[i].cpqFcaCntlrCondition);
         writeNavTableRow(fcCntlrName(i),"CQMGSTOR/MS-FCCTL.TPL?index="+ i,
             thisCondition.imageSmall(), target);
         cntlrIndex = i;
      }
   }
   writeTableText("Physical Drives:");
   count = 0;
   for (i = 0; i < cpqFcaPhyDrvEntry.length; i++)
   {
      if (cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvBoxIndex == thisChassisIdx)
      {
         count++;
         thisCondition.set(cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvCondition);
         writeNavTableRow(fcPhyDrvName(i), "CQMGSTOR/MS-FCPHY.TPL?index=" + i,
            thisCondition.imageSmall(), target);
      }
   }
   if (count == 0) writeNavTableRow("None", null, "", target);

   writeTableText("Logical Drives:");
   count = 0;
   for (i = 0; i < cpqFcaLogDrvEntry.length; i++)
   {
      if (cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex == thisChassisIdx &&
          (cpqFcaLogDrvEntry[i].cpqFcaLogDrvSnapshotSourceDrvIndex == "" ||
           cpqFcaLogDrvEntry[i].cpqFcaLogDrvSnapshotSourceDrvIndex == -1))
      {
         count++;
         thisCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
         writeNavTableRow(fcLogDrvName(i), "CQMGSTOR/MS-FCLOG.TPL?index=" + i,
            thisCondition.imageSmall(), target);
      }
   }
   if (count == 0)  writeNavTableRow("None", null, "", target);

   count = 0;
   for (i = 0; i < cpqFcaLogDrvEntry.length; i++)
   {
      if (cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex == thisChassisIdx &&
          cpqFcaLogDrvEntry[i].cpqFcaLogDrvSnapshotSourceDrvIndex != "" &&
          cpqFcaLogDrvEntry[i].cpqFcaLogDrvSnapshotSourceDrvIndex != -1)
      {
         if (count == 0)
            writeTableText("Snapshot Resource Volumes:");
         thisCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
         writeNavTableRow(fcLogDrvName(i), "CQMGSTOR/MS-FCLOG.TPL?index=" + i,
            thisCondition.imageSmall(), target);
         count++;
      }
   }
   count = 0;
   for (i = 0; i < cpqFcTapeDriveEntry.length; i++)
   {
      ssName = fcTapeStorageSystem(i);
      if (thisChassis.cpqSsChassisName == ssName)
      {
         if (count == 0)
            writeTableText("Tape Drives:");
         thisCondition.set(cpqFcTapeDriveEntry[i].cpqFcTapeDriveCondition);
         writeNavTableRow(fcTapeName(i), "CQMGSTOR/MS-FTAPE.TPL?index=" + i +
            "&loc=" + idx, thisCondition.imageSmall(), target);
         count++;
      }
   }
   if (thisChassis.cpqSsChassisConnectionType == 2 && thisChassis.cpqSsChassisModel > 2)
   {
      writeTableText("External Storage Boxes:");
      count = 0;
      for (i = 0; i < cpqSsBackplaneEntry.length; i++)
      {
         if (cpqSsBackplaneEntry[i].cpqSsBackplaneChassisIndex == thisChassisIdx &&
             cpqSsBackplaneEntry[i].cpqSsBackplanePlacement == 3)
         {
            count++;
            thisCondition.set(cpqSsBackplaneEntry[i].cpqSsBackplaneCondition);
            writeNavTableRow(fcBackplaneName(i), "CQMGSTOR/MS-FCES.TPL?index=" + i +
               "&chassis=" + idx, thisCondition.imageSmall(), target);
         }
      }
      if (count == 0)  writeNavTableRow("None", null, "", target);
   }
   if (thisChassis.cpqSsChassisConnectionType == 2 && thisChassis.cpqSsChassisModel > 2)
   {
      thisCondition.set(1);
      count = 0;
      for (i = 0; i < cpqFcSwitchEntry.length; i++)
      {
         if (cpqFcSwitchEntry[i].cpqFcSwitchChassisIndex == thisChassisIdx)
         {
            count++;
            if (count == 1)  writeTableText("Fibre Channel Switches:");
            writeNavTableRow(fcSwitchName(i), "CQMGSTOR/MS-FCSW.TPL?index=" + i,
               thisCondition.imageSmall(), target);
         }
      }
   }
   writeTableTail();
}
writeBodyTail();
</script>
</html>
