
<!cpqSeCpuStatus>
<!cpqSeFloppyDiskEntry>
<!cpqHeFltTolPowerSupplyEntry>
<!cpqHePowerConverterEntry>
<!cpqSiRackEnclosureMgrType>
<!cpqSiRackEnclosureMgrCondition>
<!cpqSm2NicIpAddress.raw>
//--- use the existence of cpqSeCpuStatus to indicate that Ginkgo is running
if("undefined"!=typeof( cpqSeCpuStatus ))
{
   AddDataEntry("SNMP Webagent", "Home::System::Summary", -1, "/WEBAGENT/SUMMARY.TPF", "0");
   AddDataEntry("SNMP Webagent", "Home::System::Software Version", -1, "/WEBAGENT/CQMGHOST/CF-SWVER.TPL", "0");
   AddDataEntry("SNMP Webagent", "Home::System::System Info", -1, "/WEBAGENT/CQMGSERV/CF-SINFO.TPF", "0");
   AddDataEntry("SNMP Webagent", "Home::System::File System Use", -1, "/WEBAGENT/CQMGHOST/MS-SPACE.TPL", "0");
   sysboardstatus = 1;
   for (x=0; x<=cpqSeCpuStatus.length-1; x++)
   {
      sysboardstatus = sysboardstatus > cpqSeCpuStatus[x] ? sysboardstatus : cpqSeCpuStatus[x];
   }
   AddDataEntry("SNMP Webagent", "Home::System::System Board",     sysboardstatus,          "/WEBAGENT/CQMGSERV/SB-INFO.TPL",  "0");
   AddDataEntry("SNMP Webagent", "Home::System::Exp Buses",        "<!cpqSiHotPlugSlotCondition>", "/WEBAGENT/CQMGSERV/EX-INFO.TPL",  "0");
   AddDataEntry("SNMP Webagent", "Home::System::System Resources",  -1,                           "/WEBAGENT/CQMGSERV/EX-RES.TPL",   "0");
   AddDataEntry("SNMP Webagent", "Home::System::Security",          -1,                           "/WEBAGENT/CQMGSERV/CF-SECUR.TPL", "0");
EnclosureStatus = 1;
EnclosureManaged = false;
EnclosureType = 0;
for (x=0; x<=cpqSiRackEnclosureMgrType.length-1; x++)
{
   if (cpqSiRackEnclosureMgrType[x] == 2)
   {
      EnclosureManaged = true;
      EnclosureType = 2;
   }
   if (cpqSiRackEnclosureMgrType[x] == 3)
   {
      EnclosureManaged = true;
      EnclosureType = 3;
   }
}
if (EnclosureManaged != false && EnclosureType == 3)
{
   for (x=0; x<=cpqSiRackEnclosureMgrCondition.length-1; x++)
   {
      EnclosureStatus = (cpqSiRackEnclosureMgrCondition[x] > EnclosureStatus ? cpqSiRackEnclosureMgrCondition[x] : EnclosureStatus);
   }
   AddDataEntry("SNMP Webagent", "Home::System::Enclosure Information", EnclosureStatus, "/WEBAGENT/CQMGSERV/EM-INFO.TPL", "0");
}
if (EnclosureManaged != false && EnclosureType == 2)
{
   rackMibCondition = "<!cpqRackMibCondition>";
   EnclosureStatus = (rackMibCondition > EnclosureStatus ? rackMibCondition : EnclosureStatus);
   rackinfopage = "/WEBAGENT/SUBFRAME.TPL?currentSubmenu=/WEBAGENT/CQMGSERV/EM-INFO1.TPL";
   AddDataEntry("SNMP Webagent", "Home::System::Enclosure Information", EnclosureStatus, rackinfopage, "0");
}
   if( 0 < cpqSeFloppyDiskEntry.length )
   {
      AddDataEntry("SNMP Webagent", "Home::Storage::Floppy Drives", -1, "/WEBAGENT/CQMGSERV/MS-FLOP.TPL", "0");
   }
   AddDataEntry("SNMP Webagent", "Home::Utilization::Processor Utilization", -1, "/WEBAGENT/CQMGSERV/UT-INFO.TPL", "0");
   logSupport = "<!cpqHeEventLogSupported>";
   criticalSupport = "<!cpqHeCritLogSupported>";
   postMsgSupport =  "<!cpqHePostMsgCondition>";
   correctMemSupport = "<!cpqHeCorrMemLogStatus>";
   AddDataEntry("SNMP Webagent", "Tasks::Recovery::Reboot Server", -1, "/WEBAGENT/CQMGSERV/RC-RBOOT.TPL", "0");
   asrStatus = "<!cpqHeAsrStatus>";
   // '2' means asr is not supported.
   if ((asrStatus != 2) && (asrStatus !="NULL"))
   {
      autoRecoveryStatus = "<!cpqHeAsrCondition>";
      AddDataEntry("SNMP Webagent", "Home::Recovery::Autorecovery", autoRecoveryStatus, "/WEBAGENT/CQMGSERV/RC-RECOV.TPL", "0");
      AddDataEntry("SNMP Webagent", "Tasks::Recovery::Autorecovery", -1, "/WEBAGENT/CQMGSERV/RC-RECOV.TPL", "0");
   }
   // '3' is supported, '2' is not_supported
   if (logSupport == '3')
   {
      eventLogStatus = "<!cpqHeEventLogCondition>";
      AddDataEntry("SNMP Webagent", "Logs::Integrated Management Log", eventLogStatus, "/WEBAGENT/CQMGSERV/RC-IML.TPL", "0");
   }
   else
   {
      if(criticalSupport == '3')     //3 means Supported
      {
         criErrorStatus = "<!cpqHeCritLogCondition>";
         AddDataEntry("SNMP Webagent", "Logs::Critical Error Log", criErrorStatus, "/WEBAGENT/CQMGSERV/RC-CRIT.TPL", "0");
      }
      if(postMsgSupport != "NULL" && postMsgSupport != '1')
      {
         postMsgStatus = "<!cpqHePostMsgCondition>";
         AddDataEntry("SNMP Webagent", "Logs::Power On Messages Log", postMsgStatus, "/WEBAGENT/CQMGSERV/RC-BTLOG.TPL", "0");
      }
      if(correctMemSupport == '4')
      {
         correctableMsgStatus = "<!cpqHeCorrMemLogCondition>";
         AddDataEntry("SNMP Webagent", "Logs::Correctable Memory Log", correctableMsgStatus, "/WEBAGENT/CQMGSERV/RC-CRMEM.TPL", "0");
      }
   }
   EnvStatus = "<!cpqHeThermalTempStatus>";
   FanStatus = "<!cpqHeThermalSystemFanStatus>";
   CpuFanStatus = "<!cpqHeThermalCpuFanStatus>";
   if( FanStatus > EnvStatus) EnvStatus = FanStatus;
   if( CpuFanStatus > EnvStatus) EnvStatus = CpuFanStatus;
   PowerStatus = 0;
   if (cpqHeFltTolPowerSupplyEntry.length != 0 )
   {
      for (nIndex=0; nIndex <= cpqHeFltTolPowerSupplyEntry.length-1; nIndex++)
      {
         if( cpqHeFltTolPowerSupplyEntry[nIndex].cpqHeFltTolPowerSupplyCondition > PowerStatus)
         {
            PowerStatus = cpqHeFltTolPowerSupplyEntry[nIndex].cpqHeFltTolPowerSupplyCondition;
         }
      }
   }
   else
   {
      PowerStatus = "<!cpqHeFltTolPwrSupplyCondition>";
   }
   PowerConvStatus = 0;
   if (cpqHePowerConverterEntry.length != 0 )
   {
      for(nIndex = 0; nIndex <= cpqHePowerConverterEntry.length-1; nIndex++)
      {
         if( cpqHePowerConverterEntry[nIndex].cpqHePwrConvCondition > PowerConvStatus)
         {
            PowerConvStatus = cpqHePowerConverterEntry[nIndex].cpqHePwrConvCondition;
         }
      }
   }
   else
   {
      PowerConvStatus = "<!cpqHePowerConverterCondition>";
   }
   AddDataEntry("SNMP Webagent", "Home::Recovery::Environment",      EnvStatus,       "/WEBAGENT/CQMGSERV/RC-ENV.TPL", "0");
   AddDataEntry("SNMP Webagent", "Tasks::Recovery::Environment - Thermal Degraded Action", -1,       "/WEBAGENT/CQMGSERV/RC-ENV.TPL", "0");
   AddDataEntry("SNMP Webagent", "Home::Recovery::Power Supply",     PowerStatus,     "/WEBAGENT/CQMGSERV/RC-POWER.TPL", "0");
   AddDataEntry("SNMP Webagent", "Home::Recovery::Power Converter",  PowerConvStatus, "/WEBAGENT/CQMGSERV/RC-PCONV.TPL", "0");
   AddDataEntry("SNMP Webagent", "Home::Recovery::Remote Communications", -1, "/WEBAGENT/CQMGSERV/RC-RCOMM.TPL", "0");
   //Remote Insight
   <!cpqSm2NicConfigEntry>
   RemoteInsightCond = "<!cpqSm2MibCondition>";
   if (RemoteInsightCond != null && RemoteInsightCond != "" && RemoteInsightCond != "NULL")
   {
      cntlrModel = "<!cpqSm2CntlrModel>";
      if (""==cntlrModel)
      {
        cntlrModel = 1;
      }
      Flint        = 2;
      Orwell       = 3;
      Thunderchild = 4;
      Gromit       = 5;
      Aspen        = 6;
      RibModel     = cntlrModel;
      if (RibModel == Gromit)
        Name = "Integrated Lights-Out";
      else
        Name = "Remote Insight";
      AddDataEntry("SNMP Webagent", "Home::Management Processor::" + Name, RemoteInsightCond, "/WEBAGENT/CQMGSERV/RC-RIBRD.TPL", "0");
      AddDataEntry("SNMP Webagent", "Tasks::Remote Management::Remote Insight Options", -1, "/WEBAGENT/CQMGSERV/RC-RIBRD.TPL", "0");
      //AddDataEntry("SNMP Webagent", "Tasks::" + "Set " + Name, -1, "/WEBAGENT/CQMGSERV/RC-RIBRD.TPL", "0");
      AddDataEntry("SNMP Webagent", "Logs::" + Name + " Log", -1, "/WEBAGENT/CQMGSERV/RC-RBLOG.TPL", "0");
      for(i=0; i<cpqSm2NicConfigEntry.length; i++)
      {
        nicCond     = cpqSm2NicConfigEntry[i].cpqSm2NicCondition;
        nicName     = cpqSm2NicConfigEntry[i].cpqSm2NicModel;
        nicLocation = cpqSm2NicConfigEntry[i].cpqSm2NicLocation;
        AddDataEntry("SNMP Webagent", "Home::Management Processor::" + nicName, nicCond, "/WEBAGENT/CQMGSERV/RC-RBNIC.TPL?index="+nicLocation, "0");
        AddDataEntry("SNMP Webagent", "Tasks::Remote Management::Remote Communication Options for " + nicName, nicCond, "/WEBAGENT/CQMGSERV/RC-RBNIC.TPL?index="+nicLocation, "0");
      }
      //---- add RIB info to the CHP ---
      if( "undefined" != typeof( CHPSetRIBInfo ))
      {
         ribWebLink = "http://";
         badAddress = false;
         if(0<cpqSm2NicIpAddress.length)
         {
            for(j=0; j<8; j+=2)
            {
               if(j>0) ribWebLink+=".";
               if(cpqSm2NicIpAddress[0].length) ribWebLink+=cpqSm2NicIpAddress[0][j];
               else
               {
                  badAddress = true;
                  break;
               }
            }
         }
         CHPSetRIBInfo( Name, badAddress ? "" : ribWebLink );
      }
   }
}
