<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<!DOCVERSION "1.6">
<html>
<head>
<!-- chp style sheet imported using Elm file import tag to minimize network round trips/traffic -->
<!#chp.css>
        <title>
      <!.StringSystemName> - <!=PageTitle>HP WBEM Device Options<!/PageTitle>
        </TITLE>
   <meta http-equiv="pragma" content="no-cache">
   <meta http-equiv="expires" content="Tue, 01 Jan 1981 01:00:00 GMT">
   <meta http-equiv="content-type"
         content="text/html; charset=<!=CharSet>iso-8859-1<!/CharSet>">
<!--- chp common javascript --->
<script>
<!#chp.js>
onlyInCHP();   // only allow this page to be displayed in the CHP
<!#chpif.js>
PageDisableAutorefresh();  // don't autorefresh this page
</script>
</head>
<body bgcolor=#FFFFFF>
<script language=JavaScript>
   writePageHeader();
</script>
   <base target=_self>
   <form name=Options
         onSubmit="return Verify(this.form)">
<SCRIPT LANGUAGE=JavaScript>
<!-- hide the script
var optsParameters = "/cpqopts.htm?";
var append = false;
var AddXECert = false;
if ("<!^more>" == "yes")
   optsParameters = "/cpqopts.htm?more=yes&";
else
   optsParameters = "/cpqopts.htm?";
function UseDefault()
{
   if(append == true)
   {
      optsParameters += "&";
   }
   optsParameters += "ResetToDefault";
   append = true;
   return(true);
}
function AddXECertHandler()
{
   AddXECert = true;
   return(1);
}
function isAllBlank(s)
{
   var i = 0;
   var len = s.length;
   var allSpace = true;
   while ((i < len) && (allSpace == true))
   {
      if (s.charCodeAt(i) != 32)
         allSpace = false;
      else
         i++;
   }
   if (allSpace == false)  //if the last thing is CR
   {
      if (s.lastIndexOf( "\r\n" ) == i)
         allSpace = true;
   }
   return(allSpace);
}
function VerifyIPRange( ipString )
{
   var   i = 0;
   var   len = ipString.length;
   // blank, no need to validate further
   if (isAllBlank( ipString ) == true)
   {
      return(true);
   }
   // see if the string is too long
   if (len > 256)
   {
<!=AlertLongLine>
      alert( "Line is too long." );
<!/AlertLongLine>
      return(false);
   }
   // regular expression used to find invalid characters
   var   regExpBadChars = new RegExp( "[^0123456789.;-]", "g" );
   var   regExpSpaces = new RegExp( "[ ]", "g" );
   // check to make sure the string contains only valid characters
   badCharIdx = ipString.search( regExpBadChars );
   // Did we find any?
   if (badCharIdx != -1)
   {
      // Yes, we did.  Put up a message...
<!=AlertInvalidCharInAddress>
      badCharMsg = "An invalid character was entered in the IP address list.\r\n\r\n";
<!/AlertInvalidCharInAddress>
      // ...that shows the user what the invalid character is
<!=AlertInvalidChar>
      badCharMsg += "Invalid char = \"";
      badCharMsg += ipString.charAt( badCharIdx );
      badCharMsg += "\"";
<!/AlertInvalidChar>
      // display the message
      alert( badCharMsg );
      // return false to indicate we found a problem
      return(false);
   }
   // split the string into ranges delimited by semi-colons
   var   ipArray = ipString.split( ";" );
   var   arrayCnt = ipArray.length;         // how many ranges
   // loop through the array of ranges
   for (i = 0; i < arrayCnt; i++)
   {
      // not blank, have to validate
      if (isAllBlank( ipArray[ i ] ) == false)
      {
         // split the first one
         limitArray = ipArray[ i ].split( "-" );
         limitCnt = limitArray.length;
         // can only have 1 or no -
         if (limitCnt > 2)
         {
<!=AlertTooManyIPs>
            alert( "There are too many IP addresses in one of the ranges." );
<!/AlertTooManyIPs>
            return(false);
         }
         else
         {
            // validate each limit
            for (j = 0; j < limitCnt; j++)
            {
               // not blank, have to validate
               if (isAllBlank( limitArray[ j ]) == false)
               {
                  // split the IP address into octets
                  nodeArray = limitArray[ j ].split( "." );
                  nodeCnt = nodeArray.length;
                  // we must have exactly four octets
                  if (nodeCnt != 4)
                  {
<!=AlertTooFewNodes>
                     alert( "One of the IP addresses has too few nodes." );
<!/AlertTooFewNodes>
                     return(false);
                  }
                  else
                  {
                     // validate each node
                     for (k = 0; k < nodeCnt; k++)
                     {
                        // not blank, have to validate
                        if (isAllBlank( nodeArray[ k ] ) == false)
                        {
                           nodeAddrLen = nodeArray[ k ].length;
                           // ignore the trailing spaces of the last node address
                           if (k == (nodeCnt - 1))
                           {
                              whiteSpace = 1;
                              while ((nodeAddrLen > 0) && (whiteSpace == 1))
                              {
                                 code = nodeArray[ k ].charCodeAt( nodeAddrLen - 1 );
                                 if (code==32 || code==9 || code==10 || code==13)
                                 {
                                    nodeAddrLen--;
                                 }
                                 else
                                 {
                                    whiteSpace = 0;
                                 }
                              }
                           }
                           // make sure the node address consists of only numbers
                           for (l = 0; l < nodeAddrLen; l++)
                           {
                              code = nodeArray[ k ].charCodeAt( l );
                              // not 0 - 9
                              if ((code < 48) || (code > 57))
                              {
<!=AlertNonNumeric>
                                 alert( "One of the IP addresses contains a non-numeric value." );
<!/AlertNonNumeric>
                                 return(false);
                              }
                           }
                           nodeValue = nodeArray[ k ] - 0;
                           if (nodeValue > 255)
                           {
<!=AlertGreaterThan255>
                              alert( "One of the IP addresses contains a value greater than 255." );
<!/AlertGreaterThan255>
                              return(false);
                           }
                        }
                        else            // blank node
                        {
<!=AlertMissingValue>
                           alert( "One of the IP addresses is missing a value." );
<!/AlertMissingValue>
                           return(false);
                        }
                     }  // end of for k
                  }
               }
               else
               {
<!=AlertMissingAddress>
                  alert( "One of the ranges is missing an IP address." );
<!/AlertMissingAddress>
                  return(false);
               }
            }    // end of for j
         }
      }
      else              // blank range
      {
         // we don't care if the last one is empty
         if (i < (arrayCnt - 1))
         {
<!=AlertMissingAddress>
            alert( "One of the ranges is missing an IP address." );
<!/AlertMissingAddress>
            return(false);
         }
      }
    }  // end of for i
    return(true);
}
function CheckForInvalidChar( ipString )
{
   var   i = 0;
   var   len = ipString.length;
   // blank, no need to validate further
   if (isAllBlank( ipString ) == true)
   {
      return(true);
   }
   // see if the string is too long
   if (len > 256)
   {
<!=AlertLongLine>
      alert( "Line is too long." );
<!/AlertLongLine>
      return(false);
   }
   // regular expression used to find invalid characters
   var   regExpBadChars = new RegExp( "[~`!@#$%^&*()+=\":'<>?]", "g" );
   var   regExpSpaces = new RegExp( "[ ]", "g" );
   // check to make sure the string contains only valid characters
   badCharIdx = ipString.search( regExpBadChars );
   //Do we have an invalid char?
   if (badCharIdx != -1)
   {
      // Yes, we did.  Put up a message...
<!=AlertInvalidCharInText>
      badCharMsg = "An invalid character was entered in the text area.\r\n\r\n";
<!/AlertInvalidCharInText>
      // ...that shows the user what the invalid character is
<!=AlertInvalidChar>
      badCharMsg += "Invalid char = \"";
      badCharMsg += ipString.charAt( badCharIdx );
      badCharMsg += "\"";
<!/AlertInvalidChar>
      // display the message
      alert( badCharMsg );
      // return false to indicate we found a problem
      return(false);
   }
   return(true);
}
function CheckForIpAddress ( ipString )
{
   var   i = 0;
   var   len = ipString.length;
   // blank, no need to validate further
   if (isAllBlank( ipString ) == true)
   {
      return(false);
   }
   // regular expression used to find invalid characters
   var   regExpBadChars = new RegExp( "[!.]", "g" );
   var   regExpSpaces = new RegExp( "[ ]", "g" );
   ipString = ipString.replace( regExpSpaces, "" );
   badCharIdx = ipString.search( regExpBadChars );
   //Do we have an period in the string?
   if (badCharIdx != -1)
   {
      // Yes, so assume it's an ip address
      return(true);
   }
   return(false);
}
function Verify()
{
   var   rangeOk = true;
   var   resetStr = "ResetToDefault";
   if("<!.StringUserAccountGroup>" != "administrator")
   {
<!=AlertReadOnly>
           alert("READ ONLY ACCESS." +
                 "  Please login with Administrator privilege.\n");
<!/AlertReadOnly>
           rangeOk = false;
   }
   else if ((optsParameters.length < resetStr.length) ||
            (optsParameters.indexOf( resetStr ) == -1))
   {
      // loop through the elements validating data until we get through
      // them all or until one of them contains an error.
      for(i = 0; ((i < document.Options.elements.length) && rangeOk); i++)
      {
         var   oldStr = document.Options.elements[i].value;
         rangeOk = true;
         if(document.Options.elements[i].type == "radio")
         {
            if((document.Options.elements[i].checked !=
               document.Options.elements[i].defaultChecked)&&
                              (document.Options.elements[i].checked==true))
            {
               if(append == true)
               {
                  optsParameters += "&";
               }
               optsParameters += document.Options.elements[i].name;
               optsParameters += "=";
               optsParameters += document.Options.elements[i].value;
               append = true;
            }
         }
         else if(document.Options.elements[i].type == "checkbox")
         {
            if(document.Options.elements[i].checked !=
               document.Options.elements[i].defaultChecked)
            {
               if(append == true)
               {
                  optsParameters += "&";
               }
               optsParameters += document.Options.elements[i].name;
               optsParameters += "=";
               optsParameters += document.Options.elements[i].checked;
               append = true;
            }
         }
         else if(document.Options.elements[i].type == "text")
         {
            if(document.Options.elements[i].value !=
               document.Options.elements[i].defaultValue)
            {
               if(document.Options.elements[i].name == "ReleaseFreeMemoryMinutes")
               {
                  var releaseFreeMemoryMinutes = parseInt(document.Options.elements[i].value,10);
                  if((releaseFreeMemoryMinutes != document.Options.elements[i].value) ||
                     (releaseFreeMemoryMinutes > 1440) ||
                     (releaseFreeMemoryMinutes < 0))
                  {
<!=ALERTInvalidTextforRelease>
                     alert("Invalid text entry for Release Free Memory Pools.\n" +
                           "Must be in the range 0 to 1440.\n");
<!/ALERTInvalidTextforRelease>
                     document.Options.elements[i].value =
                     document.Options.elements[i].defaultValue;
                     rangeOk = false;
                  }
               }
               else if((document.Options.elements[i].name == "AdministratorIPExclude") ||
                       (document.Options.elements[i].name == "OperatorIPExclude") ||
                       (document.Options.elements[i].name == "UserIPExclude") ||
                       (document.Options.elements[i].name == "AdministratorIPInclude") ||
                       (document.Options.elements[i].name == "OperatorIPInclude") ||
                       (document.Options.elements[i].name == "UserIPInclude"))
               {
                  // if the IP ranges aren't valid...
                  if (VerifyIPRange( document.Options.elements[i].value ) == false)
                  {
                     // ...set the focus back to the edit field and don't accept the input.
                     document.Options.elements[i].focus();
                     document.Options.elements[i].select();
                     rangeOk = false;
                  }
                  // otherwise...
                  else if (!isAllBlank( document.Options.elements[i].value ))
                  {
                     var   myRegExp = new RegExp( ";", "g" );
                     var   regExpSpaces = new RegExp( "[ ]", "g" );
                     // ...the string contains a valid set of IP ranges so we
                     // need to swap the semi-colons for commas before sending the
                     // string back to the server.
                     myNewStr = document.Options.elements[i].value.replace( myRegExp, "," );
                     myNewStr = myNewStr.replace( regExpSpaces, "" );
                     document.Options.elements[i].value = myNewStr;
                  }
               }
               else if(document.Options.elements[i].name == "XENameList")
               {
                  if (CheckForInvalidChar(document.Options.elements[i].value ) == false)
                  {
                     // ...set the focus back to the edit field and don't accept the input.
                     document.Options.elements[i].focus();
                     document.Options.elements[i].select();
                     rangeOk = false;
                  }
                  // otherwise...
                  else if (!isAllBlank( document.Options.elements[i].value ))
                  {
                     var   myRegExp = new RegExp( ";", "g" );
                     var   regExpSpaces = new RegExp( "[ ]", "g" );
                     // need to swap the semi-colons for commas before sending the
                     // string back to the server.
                     myNewStr = document.Options.elements[i].value.replace( myRegExp, "," );
                     document.Options.elements[i].value = myNewStr;
                  }
               }
               else if(document.Options.elements[i].name == "KeyExpirationMins")
               {
                  var expirationDays = parseInt(document.Options.elements[i].value,10);
                  if((expirationDays != document.Options.elements[i].value) ||
                     (expirationDays > 1440) ||
                     (expirationDays < 1))
                  {
<!=ALERTInvalidTextforKey>
                     alert("Invalid text entry for Key Expiration.\n" +
                           "Must be in the range 1 to 1440.\n");
<!/ALERTInvalidTextforKey>
                     document.Options.elements[i].value =
                     document.Options.elements[i].defaultValue;
                                         rangeOk = false;
                  }
               }
               if(rangeOk)
               {
                                 if(append == true)
                       {
                          optsParameters += "&";
                       }
                       optsParameters += document.Options.elements[i].name;
                       optsParameters += "=";
                       optsParameters += document.Options.elements[i].value;
                       append = true;
                  // Was this one of the IP exclusion/inclusion strings?
                  if((document.Options.elements[i].name == "AdministratorIPExclude") ||
                     (document.Options.elements[i].name == "OperatorIPExclude") ||
                     (document.Options.elements[i].name == "UserIPExclude") ||
                     (document.Options.elements[i].name == "AdministratorIPInclude") ||
                     (document.Options.elements[i].name == "OperatorIPInclude") ||
                     (document.Options.elements[i].name == "UserIPInclude"))
                  {
                     // Then swap back to the string with the semi-colons.
                     document.Options.elements[i].value = oldStr;
                  }
               }
            }
         }
      }
   }
   if(rangeOk)
   {
      self.location = optsParameters;
   }
   return(false);
}
function OpenLogFile()
{
   gotoPage( "logs", "HTTP Server Log" );
}
// stop hiding script -->
</SCRIPT>
<center><h1>Options</h1></center>
<hr>
<table border=0 width=100% cellpadding=5>
<tr><td align=center colspan=2><font size=3 face=Arial><b><!=Section>Page Sections:<!/Section><b></font></td></tr>
<tr><td valign=top><a href=#configopts><font size=2 face=Arial><!=ConfigurationOptions>Configuration&#160Options<!/ConfigurationOptions></font></a></td>
    <td><font size=2 face=Arial><!=OptionsBrief>The list of general options such as anonymous access, local access type, and more<!/OptionsBrief></font></td></tr>
<tr><td valign=top><a href=#trustedcerts><font size=2 face=Arial><!=TrustedCert>Trusted&#160Certificates<!/TrustedCert></font></a></td>
    <td><font size=2 face=Arial><!=TrustedCertBrief>A way to specify the certificates for management applications on trusted servers.<!/TrustedCertBrief></font></td></tr>
<tr><td valign=top><a href=#custgencerts><font size=2 face=Arial><!=CustomerCert>Customer&#160Generated&#160Certificates<!/CustomerCert></font></a></td>
    <td><font size=2 face=Arial><!=CustomerCertBrief>A way to extract a PKCS #10 certificate request and import a PKCS #7 generated certificate.<!/CustomerCertBrief></font></td></tr>
</table>
<br><hr><br>
   <table border=0 width=100%>
      <tr bgcolor=#006699>
         <td align=center colspan=2>
            <font size=3 face=Arial color=#FFFFFF>
            <b><a name=configopts><!=ConfigurationOptions>Configuration Options<!/ConfigurationOptions></a></b>
            </font>
         </td>
      </tr>
<SCRIPT LANGUAGE=JavaScript>
<!-- hide the script
if("<!.StringUserAccountGroup>" == "administrator")
{
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td align=center colspan=2>");
   document.writeln("<font size=4 face=Arial>");
   document.writeln("<input type=submit");
<!=SaveConfiguration>
   document.writeln(" value='Save Configuration'");
   document.writeln(" name=Configuration>");
   document.writeln("&nbsp;");
   document.writeln("<input type=submit ");
   document.writeln(" value='Default Configuration'");
<!/SaveConfiguration>
   document.writeln(" name=Default");
   document.writeln(" onClick='return UseDefault()'>");
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
}
else
{
   document.writeln("<tr bgcolor=#F0F0F0>");
   document.writeln("<td align=center colspan=2>");
   document.writeln("<font size=4 face=Arial>");
<!=ReadOnlyAccess>
   document.writeln("<b>Read Only Access</b>");
<!/ReadOnlyAccess>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
}
// stop hiding script -->
</SCRIPT>
      <tr bgcolor=#FFFFFF>
         <td>
            <font size=2 face=Arial>
            <input type=checkbox
               name=AnonymousAccess <!.StringChecked=AnonymousAccess>>
               <b><!=AnonymousAccess>Anonymous Access<!/AnonymousAccess></b>
            </font>
         </td>
         <td width=70%>
            <font size=2 face=Arial>
<!=AllowAnonymous>
            Allow Anonymous users access to unsecured
            pages.  Please note that this includes Local Anonymous Access.
<!/AllowAnonymous>
            </font>
         </td>
      </tr>
      <tr bgcolor=#FFFFFF>
         <td>
            <font size=2 face=Arial>
            <input type=checkbox
               name=LocalAccessEnabled <!.StringChecked=LocalAccessEnabled>>
               <b><!=LocalAccess>Local Access<!/LocalAccess></b>
            </font>
         </td>
         <td width=70%>
            <font size=2 face=Arial>
<!=SetupWBEMHTTP>
            Setup the HTTP Server to automatically
            configure local IP addresses as part of the selected group.  This
            means that any user with access to the local console will be
            granted full access if Administrator is selected, or access limited
            to unsecured pages if Anonymous is selected, without being challenged
            for a username and password.
<!/SetupWBEMHTTP>
            <br>
            <table>
            <tr>
               <td valign=top width=14%>
               </td>
               <td>
                  <font size=2 face=Arial>
                  <input type=radio
                     name=LocalAccessType value=Anonymous <!.StringChecked=LocalAnonymous>>
                     <!=Anonymous>Anonymous<!/Anonymous>
                  </font>
                </td>
            </tr>
            <tr>
               <td valign=top width=14%>
               </td>
               <td>
                  <font size=2 face=Arial>
                  <input type=radio
                     name=LocalAccessType value=Administrator <!.StringChecked=LocalAdministrator>>
                     <!=Administrator>Administrator<!/Administrator>
                  </font>
               </td>
            </tr>
            </table>
            </font>
         </td>
      </tr>
      <tr bgcolor=#FFFFFF>
         <td>
                <font size=2 face=Arial>
            <input type=checkbox
               name=Logging <!.StringChecked=Logging>>
               <b><!=Logging>Logging<!/Logging></b>
            </font>
         </td>
         <td width=70%>
            <font size=2 face=Arial>
<!=LoggingDesc>
            Log entries are recorded to the
            <a href='JavaScript:OpenLogFile()'>
               HTTP Server Log File
            </a>
            .  Select from below the types of logs to record:
            <br>
            <table>
            <tr>
               <td valign=top width=14%>
               </td>
               <td>
                  <font size=2 face=Arial>
                  <input type=checkbox
                     name=SecurityError <!.StringChecked=SecurityError>>
                     Security Error &nbsp
                   </font>
               </td>
            </tr>
            <tr>
               <td valign=top width=14%>
               </td>
               <td>
                  <font size=2 face=Arial>
                  <input type=checkbox
                     name=SecurityInformation <!.StringChecked=SecurityInformation>>
                     Security Information
                  </font>
               </td>
            </tr>
            </table>
<!/LoggingDesc>
            </font>
         </td>
      </tr>
<!-- ********************************************  -->
<!-- ****** Present the IP Restriction UI *******  -->
<!-- ********************************************  -->
    <tr bgcolor=#FFFFFF>
        <td>
            <font size=2 face=Arial>
            <input type=checkbox
               name=IPRestriction <!.StringChecked=IPRestriction>>
                   <b><!=IPRestriction>IP Restricted Logins<!/IPRestriction></b>
                </font>
        </td>
<!-- ****** Put up the Text used to describe the IP restriction ****** -->
        <td width=70%>
            <font size=2 face=Arial>
<!=IPRestrictionText>
                The HTTP Server can restrict login access based on the IP
                address of the machine from which the login is attempted.
                These restrictions apply only to direct login attempts and not
                to logins attempted as part of a trusted Insight Manager 7 server's Single
                Login or Secure Task Execution features.<br><br>
                IP addresses can be explicitly excluded or explicitly included
                for each type of user.  If an IP address is explicitly excluded
                it will be excluded even if it is also explicitly included.
                If there are <b>any</b> IP addresses in the inclusion list,
                then only those IP addresses will be allowed login access.  If
                there are no IP addresses in the inclusion list, then login
                access will be allowed to any IP addresses not in the exclusion
                list.<br><br>
                IP address ranges should be listed with the lower end of the
                range followed by a hyphen followed by the upper end of the
                range.  All ranges are inclusive in that the upper and lower
                bounds are considered part of the range.  IP address ranges
                and single addresses are separated by semi-colons.<br><br>
                IP address ranges should be entered in the following format: <br><br>
                &nbsp;&nbsp;&nbsp;&nbsp;122.23.44.1-122.23.44.255;172.84.100.35;127.0.0.0-127.0.0.255<br><br>
<!/IPRestrictionText>
            </font>
<!-- ****** Put up the IP address edit fields ****** -->
            <table width=98%>
                <td align=center>
                    <tr><td align=left colspan=2><font face=arial><u><i><!=IPAddrEx>IP Addresses to Exclude<!/IPAddrEx></u></i></font></td></tr>
                    <tr><td width=30%><font face=arial><i>&nbsp;&nbsp;&nbsp;&nbsp;<!=Administrator>Administrator<!/Administrator>:&nbsp;&nbsp;&nbsp;&nbsp;</i></font>
                    <td align=right><input type=text name=AdministratorIPExclude size=64 value=<!.StringAdminExclude>></td></td></tr>
                    <tr><td width=30%><font face=arial><i>&nbsp;&nbsp;&nbsp;&nbsp;<!=Operator>Operator<!/Operator>:&nbsp;&nbsp;&nbsp;&nbsp;</i></font>
                    <td align=right><input type=text name=OperatorIPExclude size=64 value=<!.StringOperatorExclude>></td></tr>
                    <tr><td width=30%><font face=arial><i>&nbsp;&nbsp;&nbsp;&nbsp;<!=User>User<!/User>:&nbsp;&nbsp;&nbsp;&nbsp;</i></font>
                    <td align=right><input type=text name=UserIPExclude size=64 value=<!.StringUserExclude>></td></td></tr><br>
                    <tr><td align=left colspan=2><font face=arial>&nbsp;</font></td></tr>
                    <tr><td align=left colspan=2><font face=arial><u><i><!=IPAddrIn>IP Addresses to Include<!/IPAddrIn></u></i></font></td></tr>
                    <tr><td width=30%><font face=arial><i>&nbsp;&nbsp;&nbsp;&nbsp;<!=Administrator>Administrator<!/Administrator>:&nbsp;&nbsp;&nbsp;&nbsp;</i></font>
                    <td align=right><input type=text name=AdministratorIPInclude size=64 value=<!.StringAdminInclude>></td></td></tr>
                    <tr><td width=30%><font face=arial><i>&nbsp;&nbsp;&nbsp;&nbsp;<!=Operator>Operator<!/Operator>:&nbsp;&nbsp;&nbsp;&nbsp;</i></font>
                    <td align=right><input type=text name=OperatorIPInclude size=64 value=<!.StringOperatorInclude>></td></td></tr>
                    <tr><td width=30%><font face=arial><i>&nbsp;&nbsp;&nbsp;&nbsp;<!=User>User<!/User>:&nbsp;&nbsp;&nbsp;&nbsp;</i></font>
                    <td align=right><input type=text name=UserIPInclude size=64 value=<!.StringUserInclude>></td></td></tr>
                </td>
            </table><br>
        </td>
      </tr>
      <tr bgcolor=#FFFFFF>
         <td>
            <font size=2 face=Arial>
                <b><!=TrustMode>Trust Mode<!/TrustMode></b>
                </font>
         </td>
         <td width=70%>
                      <table>
            <tr><td><font size=2 face=Arial><b><i><u><!=SecureTrustModes>Secure Trust Modes<!/SecureTrustModes>:</u></i></b></font></td></tr>
            <tr>
                         <td valign=top>
                  <font size=2 face=Arial>
                  <p><input type=RADIO name=TrustMode value=TrustByCert <!.StringChecked=TrustByCert>><i><!=TrustByCert>Trust By Certificate<!/TrustByCert>: </i>
                  <br>
                  </font>
                  <table>
                          <td valign=top width=6%>
                     </td>
                     <td>
                        <font size=2 face=Arial>
<!=SetupTrustedCert>
                        Setup the HTTP Server to only accept Secure Task Execution requests
                        and Single Login requests that have been signed by an Insight Manager 7
                        server with a <a href=#trustedcerts><font size=2 face=Arial>Trusted&#160Certificate</font></a>.
<!/SetupTrustedCert>
                        </font>
                     </td>
                  </table>
               </td>
            </tr>
            <tr><td><font size=2 face=Arial><br><i><u><b><!=OtherTrustModes>Other Trust Modes<!/OtherTrustModes>:</b></u>
                        <br>
<!=OtherTrustModesNote>
                        Note:  These trust modes are considered less secure than certificate based trust modes.
                        HP strongly recommends using Trust by Certificate.
<!/OtherTrustModesNote>
                        </i></font></td></tr>
            <tr>
               <td>
                  <font size=2 face=Arial>
                  <input type=RADIO name=TrustMode value=TrustByAll <!.StringChecked=TrustByAll>><i><!=TrustAll>Trust All<!/TrustAll>: </i>
                  <br>
                  </font>
                  <table>
                     <td valign=top width=6%>
                     </td>
                     <td>
                        <font size=2 face=Arial>
<!=TrustAllText>
                        Setup the HTTP Server to accept Secure Task Execution requests and
                        Single Login requests from any server.
<!/TrustAllText>
                       </font>
                     </td>
                  </table>
               </td>
            </tr>
            <tr>
               <td valign=top>
                  <font size=2 face=Arial>
                  <p><input type=RADIO name=TrustMode value=TrustByName <!.StringChecked=TrustByName>><i><!=TrustByName>Trust By Name<!/TrustByName>: </i>
                            <br>
                  </font>
                  <table>
                     <td valign=top width=6%>
                     </td>
                     <td>
                        <font size=2 face=Arial>
<!=TrustByNameText>
                        Setup the HTTP Server to only accept Secure Task Execution requests and Single Login requests
                        from servers with the following Insight Manager 7 server names (separate server names with
                        commas or semi-colons).
<!/TrustByNameText>
                        <input type=text name=XENameList size=64 value=<!.StringXENameList>>
                        </font>
                     </td>
                  </table>
               </td>
            </tr>
            </table>
         </td>
      </tr>
<SCRIPT LANGUAGE=JavaScript>
<!-- hide the script
if("<!^more>" == "yes")
{
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("<input type=checkbox");
   document.writeln("name=KeyExpiration <!.StringChecked=KeyExpiration>>");
<!=KeyExpiration>
   document.writeln("<b>Key Expiration</b>");
<!/KeyExpiration>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("<td width=70%>");
   document.writeln("<font size=2 face=Arial>");
<!=ConfigureKey0>
   document.writeln("Enforce STE and Single Login Key expiration.  ");
   document.writeln("If enabled, the key will expire after");
<!/ConfigureKey0>
   document.writeln("<input type=text");
   document.writeln("name=KeyExpirationMins");
   document.writeln("size=5");
   document.writeln("value=<!.StringKeyExpirationMins>>");
<!=ConfigureKey1>
   document.writeln("minutes.");
<!/ConfigureKey1>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("<input type=checkbox");
   document.writeln(" name=ClientProxySet");
   document.writeln(" <!.StringChecked=ClientProxySet>>");
<!=ClientProxy>
   document.writeln("<b>Client Proxy</b>");
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("<td width=70%>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("Use ");
   document.writeln("<input type=text");
   document.writeln(" name=ClientProxy");
   document.writeln(" size=40");
   document.writeln(" value=<!.StringWorkingSet=Proxy>> ");
   document.writeln("as a proxy for client HTTP requests from this HMMD.");
<!/ClientProxy>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("<input type=checkbox");
   document.writeln(" name=IpSecurity");
   document.writeln(" <!.StringChecked=IpSecurity>>");
<!=IPSecurityToken>
   document.writeln("<b>IP Security Token</b>");
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("<td width=70%>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("Use the IP address of the client when creating the ");
   document.writeln("security token.  This provides an additional safeguard ");
   document.writeln("against attempts to impersonate a user on the network.");
<!/IPSecurityToken>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("<input type=checkbox");
   document.writeln(" name=UrlSynchronization");
   document.writeln(" <!.StringChecked=UrlSynchronization>>");
<!=URLSynchronization>
   document.writeln("<b>URL Synchronization</b>");
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("<td width=70%>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("Synchronize access to identical URLs from multiple ");
   document.writeln("clients so that the resulting file processing is ");
   document.writeln("single threaded.  This should not normally be selected. ");
   document.writeln("If during periods of heavy use by multiple clients the ");
   document.writeln("HTTP Server appears to hang, then selecting this ");
   document.writeln("option may correct the problem.");
<!/URLSynchronization>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
//   document.writeln("<tr bgcolor=#FFFFFF>");
//   document.writeln("<td>");
//   document.writeln("<font size=2 face=Arial>");
//   document.writeln("<input type=checkbox");
//   document.writeln(" name=PingDevices");
//   document.writeln(" <!.StringChecked=PingDevices>>");
//   document.writeln("<b>Ping Addresses on Device Page</b>");
//   document.writeln("</font>");
//   document.writeln("</td>");
//
//   document.writeln("<td width=70%>");
//   document.writeln("<font size=2 face=Arial>");
//   document.writeln("Verify the address links on the Devices page by ");
//   document.writeln("using 'ping' requests to ensure the addresses are ");
//   document.writeln("reachable from the managed device.  This does not ");
//   document.writeln("guarantee the addresses are reachable from the browser.");
//   document.writeln("</font>");
//   document.writeln("</td>");
//   document.writeln("</tr>");
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("<input type=checkbox");
   document.writeln(" name=SleepModeCheck");
   document.writeln(" <!.StringChecked=SleepModeCheck>>");
<!=SleepModeCheck>
   document.writeln("<b>Sleep Mode Check</b>");
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("<td width=70%>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("Allow the HTTP Server to check for the system ");
   document.writeln("resuming from a sleep state.  This option must be ");
   document.writeln("selected unless the system does not implement a ");
   document.writeln("sleep state.");
<!/SleepModeCheck>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td>");
   document.writeln("<font size=2 face=Arial>");
<!=DefaultLanguage>
   document.writeln("<b>Default Language Directory</b>");
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("<td width=70%>");
   document.writeln("<font size=2 face=Arial>");
   document.writeln("Use ");
   document.writeln("<input type=text");
   document.writeln(" name=DefaultLanguage");
   document.writeln(" size=40");
   document.writeln(" value=<!.StringWorkingSet=DefaultLanguage>> ");
   document.writeln("as the default language directory for HTTP requests ");
   document.writeln("that do not have the Accept-Language HTTP header.");
<!/DefaultLanguage>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
   if(VersionCheck.substring(0,4) >= "1.4.")
   {
      document.writeln("<tr bgcolor=#FFFFFF>");
      document.writeln("<td>");
      document.writeln("<font size=2 face=Arial>");
<!=Release Free Memory Pools>
      document.writeln("<b>Release Free Memory Pools</b>");
      document.writeln("</font>");
      document.writeln("</td>");
      document.writeln("<td width=70%>");
      document.writeln("<font size=2 face=Arial>");
      document.writeln("Memory for the HTTP server is allocated in pools that ");
      document.writeln("are consummed as each request is processed.  If a large ");
      document.writeln("number of requests are received simultaneously then the ");
      document.writeln("number of memory pools will increase.  The memory is ");
      document.writeln("returned to the operating system on a gradual basis to ");
      document.writeln("improve performance.  The memory pools are returned based ");
      document.writeln("on an age.  Any free memory pool that has not been accessed ");
      document.writeln("for ");
      document.writeln("<input type=text");
      document.writeln(" name=ReleaseFreeMemoryMinutes");
      document.writeln(" size=10");
      document.writeln(" value=<!.StringReleaseFreeMemoryMinutes>> ");
      document.writeln("minutes will be returned to the operating system.  By ");
      document.writeln("adjusting this value long term memory usage and performance ");
      document.writeln("will be affected.");
<!/Release Free Memory Pools>
      document.writeln("</font>");
      document.writeln("</td>");
      document.writeln("</tr>");
   }
}
if("<!.StringUserAccountGroup>" == "administrator")
{
   document.writeln("<tr bgcolor=#FFFFFF>");
   document.writeln("<td align=center colspan=2>");
   document.writeln("<font size=4 face=Arial>");
   document.writeln("<input type=submit");
<!=SaveConfiguration>
   document.writeln(" value='Save Configuration'");
   document.writeln(" name=Configuration>");
   document.writeln("&nbsp;");
   document.writeln("<input type=submit ");
   document.writeln(" value='Default Configuration'");
<!/SaveConfiguration>
   document.writeln(" name=Default");
   document.writeln(" onClick='return UseDefault()'>");
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
}
else
{
   document.writeln("<tr bgcolor=#F0F0F0>");
   document.writeln("<td align=center colspan=2>");
   document.writeln("<font size=4 face=Arial>");
<!=ReadOnlyAccess>
   document.writeln("<b>Read Only Access</b>");
<!/ReadOnlyAccess>
   document.writeln("</font>");
   document.writeln("</td>");
   document.writeln("</tr>");
}
// stop hiding script -->
</SCRIPT>
   </table>
   </center>
</form>
<!-- ************************************* -->
<!-- ******* The XE Certificate Form ***** -->
<!-- ************************************* -->
<form name=TrustedCert
    onSubmit="return VerifyTrustedCert(this.form)">
<SCRIPT LANGUAGE=JavaScript>
<!-- hide the script
function VerifyTrustedCert()
{
   var rangeOk = true;
   parameters = "/proxy/XECert.htm?";
   retVal = false;
   append = false;
   if("<!.StringUserAccountGroup>" != "administrator")
   {
<!=AlertReadOnly>
      alert("READ ONLY ACCESS." +
            "  Please login with Administrator privilege.\n");
<!/AlertReadOnly>
      rangeOk = false;
   }
   else
   {
      if (AddXECert)
      {
         document.TrustedCert.method="post";
         document.TrustedCert.action = "/proxy/AddXECert";
         retVal = true;
      }
      else
      {
         document.TrustedCert.method="get";
         // loop through the elements validating data until we get through
         // them all or until one of them contains an error.
         for(i = 0; ((i < document.TrustedCert.elements.length) && rangeOk); i++)
         {
            if(document.TrustedCert.elements[i].type == "text")
            {
             if(document.TrustedCert.elements[i].name == "GetXECert")
               {
                  if(document.TrustedCert.elements[i].value.length > 40)
                  {
                     // ...set the focus back to the edit field and don't accept the input.
                     document.TrustedCert.elements[i].focus();
                     document.TrustedCert.elements[i].select();
                     rangeOk = false;
<!=AlertLongLine>
                     alert( "Line is too long." );
<!/AlertLongLine>
                  }
                  else if(CheckForInvalidChar(document.TrustedCert.elements[i].value) == false)
                  {
                     // ...set the focus back to the edit field and don't accept the input.
                     document.TrustedCert.elements[i].focus();
                     document.TrustedCert.elements[i].select();
                     rangeOk = false;
                  }
                  //if this is an ip address, then verify ip range.
                  else if((CheckForIpAddress(document.TrustedCert.elements[i].value) == true)
                       &&(VerifyIPRange(document.TrustedCert.elements[i].value) == false))
                  {
                     // ...set the focus back to the edit field and don't accept the input.
                     document.TrustedCert.elements[i].focus();
                     document.TrustedCert.elements[i].select();
                     rangeOk = false;
                  }
                  // otherwise...
                  else if (!isAllBlank( document.TrustedCert.elements[i].value ))
                  {
                     if(append == true)
                     {
                       parameters += "&";
                     }
                     parameters += document.TrustedCert.elements[i].name;
                     parameters += "=";
                     parameters += escape(document.TrustedCert.elements[i].value);
                     append = true;
                  }
               }
            }
         }
         if(rangeOk)
         {
            //check for blank entries
            if(parameters == "/proxy/XECert.htm?")
            {
               rangeOk = false;
<!=AlertInvalidEntry>
               alert( "Invalid entry." );
<!/AlertInvalidEntry>
            }
            else
            {
               self.location = parameters;
               retval = false;
            }
         }
      }
   }
   return(retVal);
}
// stop hiding script -->
</SCRIPT>
<!-- ************************************* -->
<!-- **** Present the XE Certificate UI ** -->
<!-- ************************************* -->
   <br>
   <table border=0 width=100%>
      <tr bgcolor=#006699>
         <td align=center colspan=2>
            <font size=3 face=Arial color=#FFFFFF>
            <a name=trustedcerts><b><!=TrustedCert>Trusted Certificates<!/TrustedCert></b></a>
            </font>
         </td>
      </tr>
      <tr bgcolor=#FFFFFF>
         <td width=70%>
            <table>
               <tr>
                  <td>
                     <font size=2 face=Arial>
                     <b>
                     <!.StringXETrustList>
                     </b>
                     <p>
                     <font size=2 face=Arial>
                  </td>
               </tr>
               <tr>
                  <td>
                     <font size=2 face=Arial>
                     <p>
<!=TrustedCertText>
                     Certificates are used to establish the trust relationship
                     between Insight Manager 7 and the HTTP Server.  To add
                     a certificate to the Trusted Certificates List, cut and paste the
                     base64 encoded certificate into the text box and press
                     the 'Submit Cert' button.
<!/TrustedCertText>
                     </font>
                  </td>
               </tr>
               <tr>
                  <td align=center>
                     <font size=2 face=Arial>
                     <b><!=CIM7CertData>Insight Manager 7 Certificate Data:<!/CIM7CertData></b><br>
                     <textarea name="AddXECert" ROWS=6 COLS=78></textarea>
                     <br>
                     <input type=submit value='<!=SubmitCert>Submit Cert<!/SubmitCert>' onClick="return AddXECertHandler();">
                     <p>
                     </font>
                  </td>
               </tr>
               <tr>
                  <td>
                     <font size=2 face=Arial>
                     <p>
<!=TrustedCertText2>
                     Insight Manager 7 certificates can also be retrieved through HTTP requests.
                     To retrieve the public certificate, enter the server name in the text box below 
                     and press the 'Get Cert' button.
<!/TrustedCertText2>
                     </font>
                  </td>
               </tr>
               <tr>
                  <td align=center>
                     <font size=2 face=Arial>
                     <b><!=CIM7ServerName>Insight Manager 7 Server Name:<!/CIM7ServerName></b>
                     <input type=text name=GetXECert size=20>
                     <input type=submit value='<!=GetCert>Get Cert<!/GetCert>' name=GetButton>
                     </center>
                     </font>
                  <td>
               </tr>
            </table>
         </td>
      </tr>
   </table>
</form>
<!-- ************************************* -->
<!-- ****** End of XE certificate Form *** -->
<!-- ************************************* -->
<!-- *************************************************** -->
<!-- ********** The Certificate Handling Form ********** -->
<!-- *************************************************** -->
<form name=CustomerCert>
<SCRIPT LANGUAGE=JavaScript>
<!-- hide the script
function VerifyCert(importCert)
{
   var rangeOk = true;
   if("<!.StringUserAccountGroup>" != "administrator")
   {
<!=AlertReadOnly>
      alert("READ ONLY ACCESS." +
            "  Please login with Administrator privilege.\n");
<!/AlertReadOnly>
      rangeOk = false;
   }
   else
   {
      if (importCert) {
         document.CustomerCert.method="post";
         document.CustomerCert.action = "/proxy/cpqimp_c.htm";
      }
      else
      {
         document.CustomerCert.method="get";
         document.CustomerCert.action = "/proxy/cpqgen_c.htm";
      }
   }
   return(rangeOk);
}
// stop hiding script -->
</SCRIPT>
<!-- *********************************************************** -->
<!-- ****** Present the Customer Generated Certificate UI ****** -->
<!-- *********************************************************** -->
   <br>
   <table border=0 width=100%>
      <tr bgcolor=#006699>
         <td align=center colspan=2>
            <font size=3 face=Arial color=#FFFFFF>
            <a name=custgencerts><b><!=CustomerCert>Customer Generated Certificates<!/CustomerCert></b></a>
            </font>
         </td>
      </tr>
      <tr bgcolor=#FFFFFF>
<!-- ****** Put up the Text used to describe the PKCS #10 button ****** -->
          <td width=70%>
            <table>
               <tr>
                  <td>
                     <font size=2 face=Arial>
<!=CustomerCertText>
                     The HTTP Server can create Certificate Request (PKCS #10) data which can be
                     sent to a Certificate Authority (CA) at a later time.  This data is base64
                     encoded.  The CA will process this request and return a response file
                     (PKCS #7) which can be imported into the HTTP Server.  Use the button
                     below to create the PKCS #10 Certificate Request data.
<!/CustomerCertText>
                     </font>
                  </td>
               </tr>
<!-- ****** Put up the PKCS #10 button (pressed to generate a Certificate Request) ****** -->
               <tr>
                  <td align=center>
                     <p>
                     <input type=submit value='<!=CreatePKCS10Data>Create PKCS #10 Data<!/CreatePKCS10Data>' onClick="return VerifyCert(0);">
                     <p>
                  </td>
               </tr>
<!-- ****** Put up the Text used to describe the PKCS #7 button ****** -->
               <tr>
                  <td>
                     <font size=2 face=Arial>
<!=CustomerCertText2>
                     The HTTP Server imports base64 encoded PKCS #7 data which a Certificate Authority returned based
                     upon an earlier Certificate Request (PKCS #10).  Cut and paste the PKCS #7 information
                     into the text box below and press the button below to import it into the HTTP Server.
<!/CustomerCertText2>
                     </font>
                  </td>
               </tr>
<!-- ****** Put up the PKCS #7 button (pressed to unravel a CA's PKCS #7 package and to extract the Certificate) ****** -->
               <tr>
                  <td align=center>
                     <p>
                     <font size=2 face=Arial>
                     <b><!=PCKS7Data>PKCS #7 Data:<!/PCKS7Data></b><br>
                     <textarea name="pkcs7_data" ROWS=6 COLS=78></textarea>
                     </font>
                     <br>
                     <input type=submit value='<!=ImportPKCS7Data>Import PKCS #7 Data<!/ImportPKCS7Data>' onClick="return VerifyCert(1)">
                     <p>
                  </td>
               </tr>
            </table>
         </td>
      </tr>
   </table>
</form>
<!-- *************************************************** -->
<!-- ****** End of the Certificate Handling Form ******* -->
<!-- *************************************************** -->
<SCRIPT LANGUAGE=JavaScript>
<!-- hide the script
writePageFooter();
// stop hiding script -->
</SCRIPT>
</body>
<head>
 <meta http-equiv="pragma" content="no-cache">
</head>
</html>