// $Id: cond.js,v 1.1.2.1 2004/07/16 21:57:53 cschmitz Exp $
// (C) 1998-2002 Compaq Information Technologies Group, L.P.
function setCondition( conditionIn )
{
    if( null==conditionIn )
    {
        conditionIn = 1;
    }
    this.state = conditionIn;
}
function updateCondition( newCondition )
{
    if( null==newCondition || ""==newCondition )    // error/problem data
    {
        newCondition = 1;
    }
    if(4 == this.state) // failed
    {
        // do nothing, we are already at the worst case
    }
    else if ( 3 == this.state) // degraded
    {
        if(4==newCondition)
            this.state = 4;
    }
    else if ( 2 == this.state) // OK
    {
        if(2<newCondition)
            this.state = newCondition;
    }
    else    // unknown
    {
        this.state = newCondition;
    }
}
function colorFromCondition()
{
    if(4 == this.state) // failed
    {
        return "#FF0000";
    }
    else if ( 3 == this.state) // degraded
    {
        return "#FFFF00";
    }
    else if ( 2 == this.state) // OK
    {
        return "#008800";
    }
    else    // unknown
    {
        return "#0000FF";
    }
}
function statusGraphic(alignment)
{
    var rc;
    if(null==alignment)
    {
        alignment = "TOP";
    }
    if(4 == this.state) // failed
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/failed.gif' ALIGN=" + alignment + " WIDTH=20 HEIGHT=20 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    else if ( 3 == this.state) // degraded
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/degraded.gif' ALIGN=" + alignment + " WIDTH=20 HEIGHT=20 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    else if ( 2 == this.state) // OK
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/ok.gif' ALIGN=" + alignment + " WIDTH=20 HEIGHT=20 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    else    // unknown
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/unknown.gif' ALIGN=" + alignment + " WIDTH=20 HEIGHT=20 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    return rc;
}
function statusGraphicSmall(alignment)
{
    var rc;
    if(null==alignment)
    {
        alignment = "TOP";
    }
    if(4 == this.state) // failed
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/failed.gif' ALIGN="+ alignment + " WIDTH=14 HEIGHT=14 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    else if ( 3 == this.state) // degraded
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/degraded.gif' ALIGN="+ alignment + " WIDTH=14 HEIGHT=14 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    else if ( 2 == this.state) // OK
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/ok.gif' ALIGN="+ alignment + " WIDTH=14 HEIGHT=14 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    else    // unknown
    {
        rc = "<IMG SRC='/WEBAGENT/IMAGES/unknown.gif' ALIGN="+ alignment + " WIDTH=14 HEIGHT=14 HSPACE=3 VSPACE=1 BORDER=0> ";
    }
    return rc;
}
function statusText()
{
    var rc;
    if(4 == this.state) // failed
    {
        rc = "Q";
    }
    else if ( 3 == this.state) // degraded
    {
        rc = "";
    }
    else if ( 2 == this.state) // OK
    {
        rc = "OK";
    }
    else    // unknown
    {
        rc = "s";
    }
    return rc;
}
function cpqCondition( startingCondition )
{
    if( null == startingCondition )
    {
        startingCondition = 1;  // unknown
    }
    this.state = startingCondition;
    this.update = updateCondition;
    this.color = colorFromCondition;
    this.image = statusGraphic;
    this.imageSmall = statusGraphicSmall;
    this.set = setCondition;
    this.text = statusText;
}