%define name vlan
%define version 1.8.0

Summary: Linux 802.1Q Module
Name: %{name}
Version: %{version}
Release: 14
Vendor: HP
Copyright: GPL
Group: System Environment/Base
Source: vlan-%{version}.tgz
BuildRoot: /var/tmp/%{name}-buildroot

%description
This package contains the Linux Module for 802.1Q VLAN Support and
the vconfig utility to configure VLAN's

%prep
%setup -c -b 0

%build
make 


%install
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
if [ -d /etc ]
then
mkdir -p $RPM_BUILD_ROOT/etc
echo "/etc/vlan.conf" >> $RPM_BUILD_DIR/file.list.%{name}
fi

if [ -d /etc/init.d ]
then
mkdir -p $RPM_BUILD_ROOT/etc/init.d
echo "/etc/init.d/vlan" >> $RPM_BUILD_DIR/file.list.%{name}
fi

if [ -d /lib/modules/`uname -r`/kernel/net/8021q ]
then
mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/net/8021q
echo "/lib/modules/`uname -r`/kernel/net/8021q/8021q.o.new" >> $RPM_BUILD_DIR/file.list.%{name}
fi
if [ -d /sbin ]
then
mkdir -p $RPM_BUILD_ROOT/sbin
fi
echo "/sbin/vconfig.new" >> $RPM_BUILD_DIR/file.list.%{name}
if [ -d /usr/share/man/man8 ]
then
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man8
fi
echo "/usr/share/man/man8/vconfig.8.new.gz" >> $RPM_BUILD_DIR/file.list.%{name}
make install PREFIX=$RPM_BUILD_ROOT
mv -f $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/net/8021q/8021q.o \
   $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/net/8021q/8021q.o.new
mv -f $RPM_BUILD_ROOT/sbin/vconfig $RPM_BUILD_ROOT/sbin/vconfig.new
mv -f $RPM_BUILD_ROOT/usr/share/man/man8/vconfig.8.gz $RPM_BUILD_ROOT/usr/share/man/man8/vconfig.8.new.gz

%preun
/etc/init.d/vlan stop
chkconfig --del vlan > /dev/null 2> /dev/null
if [ -s /etc/rc.config ]; then
    pushd .
    cd /etc/init.d/rc2.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    cd /etc/init.d/rc3.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    cd /etc/init.d/rc4.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    cd /etc/init.d/rc5.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    popd
fi
if [ -f /lib/modules/`uname -r`/kernel/net/8021q/8021q.o.new ]; then
      cmp -s /lib/modules/`uname -r`/kernel/net/8021q/8021q.o.new \
             /lib/modules/`uname -r`/kernel/net/8021q/8021q.o
   if [ "$?" == 0 ]; then
         # files match
         rm -f /lib/modules/`uname -r`/kernel/net/8021q/8021q.o
   fi
fi

if [ -f /sbin/vconfig.new ]; then
      cmp -s /sbin/vconfig.new /sbin/vconfig
   if [ "$?" == 0 ]; then
         # files match
         rm -f /sbin/vconfig
   fi
fi

if [ -f /usr/share/man/man8/vconfig.8.new.gz ]; then
      cmp -s /usr/share/man/man8/vconfig.8.new.gz /usr/share/man/man8/vconfig.8.gz
   if [ "$?" == 0 ]; then
         # files match
         rm -f /usr/share/man/man8/vconfig.8.gz
   fi
fi
exit 0

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files -f ../file.list.%{name}
%doc vlan.txt

%post
cp -f /lib/modules/`uname -r`/kernel/net/8021q/8021q.o.new \
      /lib/modules/`uname -r`/kernel/net/8021q/8021q.o
cp -f /sbin/vconfig.new /sbin/vconfig
cp -f /usr/share/man/man8/vconfig.8.new.gz /usr/share/man/man8/vconfig.8.gz

chkconfig --del vlan > /dev/null 2> /dev/null
chkconfig --add vlan > /dev/null 2> /dev/null
if [ -s /etc/rc.config ]; then
    pushd .
    cd /etc/init.d/rc2.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    ln -s ../vlan S11vlan
    ln -s ../vlan K89vlan
    cd /etc/init.d/rc3.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    ln -s ../vlan S11vlan
    ln -s ../vlan K89vlan
    cd /etc/init.d/rc4.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    ln -s ../vlan S11vlan
    ln -s ../vlan K89vlan
    cd /etc/init.d/rc5.d
    rm -f S11vlan >/dev/null 2>/dev/null
    rm -f K89vlan >/dev/null 2>/dev/null
    ln -s ../vlan S11vlan
    ln -s ../vlan K89vlan
    popd
fi
depmod -a > /dev/null 2> /dev/null
exit 0

%postun
# one big if around the preun..... $1 contains number versions after operation
if [ "$1" = 0 ]; then
   rm -f /lib/modules/`uname -r`/kernel/net/8021q.o
   rm -f /sbin/vconfig
   rm -f /usr/share/man/man8/vconfig.8.gz
fi
depmod -a > /dev/null 2> /dev/null
exit 0

%changelog
