<html>
<!--  MS-SCLOG.TPL 1.3  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>SCSI Logical Drive Information</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqScsiCntlrEntry>
<!cpqScsiTargetEntry>
<!cpqScsiPhyDrvEntry>
<!cpqScsiLogDrvEntry>
<!cpqScsiLogDrvPhyDrvIDs.raw>
<!cpqScsiLogDrvAvailSpares.raw>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/NAVTABLE.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SCSENUMS.JS>
<!#MS-SCSIC.JS>

postfix["cpqScsiLogDrvSize"] = "MB";
postfix["cpqScsiLogDrvStripeSize"] = "KB";

</script>
</head>
<script language="JavaScript">

writeBodyHead();

cntlr = findArg("index");
bus   = findArg("bus");
drive = findArg("target");

if (cntlr == -1 || bus == -1 || drive == -1)
{
   parseArgs(tryPrevPage());
   cntlr = findArg("index");
   bus   = findArg("bus");
   drive = findArg("target");
}
for (ctlIndex = 0; ctlIndex < cpqScsiCntlrEntry.length; ctlIndex++)
{
   if (cpqScsiCntlrEntry[ctlIndex].cpqScsiCntlrIndex == cntlr)
      break;
}
for (drvIndex = 0; drvIndex < cpqScsiLogDrvEntry.length; drvIndex++)
{
   if (cpqScsiLogDrvEntry[drvIndex].cpqScsiLogDrvCntlrIndex == cntlr &&
       cpqScsiLogDrvEntry[drvIndex].cpqScsiLogDrvBusIndex == bus &&
       cpqScsiLogDrvEntry[drvIndex].cpqScsiLogDrvIndex == drive)
      break;
}
if (cpqScsiLogDrvEntry.length == drvIndex || cpqScsiCntlrEntry.length == ctlIndex)
{
   reportMissingArgs();
}
else
{
   thisDrv = cpqScsiLogDrvEntry[drvIndex];
   driveCondition = new cpqCondition(thisDrv.cpqScsiLogDrvCondition);

   writePageHead(scsiCntlrName(ctlIndex), "/WEBAGENT/IMAGES/MASSHDR.GIF", "SCSI Logical Drive Information");
   writeTableLabel(driveCondition.image() + logDrvName(drvIndex));
   writeTableHead();
   writeDoubleTableRow("Status:", displayItem("cpqScsiLogDrvStatus", thisDrv.cpqScsiLogDrvStatus),
                       "Fault Tolerance:", displayItem("cpqScsiLogDrvFaultTol", thisDrv.cpqScsiLogDrvFaultTol));
   writeDoubleTableRow("Capacity:", driveCapacity("cpqScsiLogDrvSize", thisDrv.cpqScsiLogDrvSize),
                       "Stripe Size:", displayItem("cpqScsiLogDrvStripeSize", thisDrv.cpqScsiLogDrvStripeSize));
   writeSingleTableRowInDoubleTable("Percent Rebuild Complete:",
                                     percentGraph(thisDrv.cpqScsiLogDrvPercentRebuild));
   writeTableTail();
   document.write("<br>");

   writeTableLabel("Physical Drives");
   writeTableHead();
   phyDrvData = cpqScsiLogDrvPhyDrvIDs[0];
   phyDrvCondition = new cpqCondition(1);
   phyDrvCount = 0;

   for (i = 0; i < phyDrvData.length; i++)
   {
      for (j = 0; j < cpqScsiPhyDrvEntry.length; j++)
      {
         if (cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvCntlrIndex == cpqScsiLogDrvEntry[drvIndex].cpqScsiLogDrvCntlrIndex &&
             cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvBusIndex == cpqScsiLogDrvEntry[drvIndex].cpqScsiLogDrvBusIndex &&
             cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvIndex == phyDrvData[i])
         {
            phyDrvCondition.set(cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvCondition);
            writeNavTableRow(phyDriveName(j), "CQMGSTOR/MS-SCSI.TPL?index=" + cntlr +
               "&bus=" + bus + "&id=" + phyDrvData[i], phyDrvCondition.imageSmall(), "_self");
            phyDrvCount++;
            break;
         }
      }
   }
   if (phyDrvCount == 0) writeOneItemTableRow("None");
   writeTableTail();
   document.write("<br>");

   writeTableLabel("Spare Drives");
   writeTableHead();
   logDrvData = cpqScsiLogDrvAvailSpares[0];
   phyDrvCondition = new cpqCondition(1);
   phyDrvCount = 0;

   for (i = 0; i < logDrvData.length; i++)
   {
      for (j = 0; j < cpqScsiPhyDrvEntry.length; j++)
      {
         if (cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvCntlrIndex == cpqScsiLogDrvEntry[drvIndex].cpqScsiLogDrvCntlrIndex &&
             cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvBusIndex == cpqScsiLogDrvEntry[drvIndex].cpqScsiLogDrvBusIndex &&
             cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvIndex == logDrvData[i])
         {
            phyDrvCondition.set(cpqScsiPhyDrvEntry[j].cpqScsiPhyDrvCondition);
            writeNavTableRow(phyDriveName(j), "CQMGSTOR/MS-SCSI.TPL?index=" + cntlr +
               "&bus=" + bus + "&id=" + logDrvData[i], phyDrvCondition.imageSmall(), "_self");
            phyDrvCount++;
            break;
         }
      }
   }
   if (phyDrvCount == 0) writeOneItemTableRow("None");
   writeTableTail();
}
writeBodyTail();
</script>
</html>


