<html>
<!--  MS-FTLIB.TPL 1.15  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Tape Library Information</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqFcTapeCntlrEntry>
<!cpqFcTapeLibraryEntry>
<!cpqFcTapeLibraryDriveList.raw>
<!cpqFcTapeDriveEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#/COMMON/NUMCNVRT.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>
</script>
</head>
<script language="JavaScript">

writeBodyHead();

libIndex = findArg("index");

if (libIndex == -1)
{
   parseArgs(tryPrevPage());
   libIndex = findArg("index");
}
if (libIndex >= cpqFcTapeLibraryEntry.length)
{
   reportMissingArgs();
}
else
{
   cntlrName = "";
   cntlrIndex = -1;
   for (i = 0; i < cpqFcTapeCntlrEntry.length; i++)
   {
      if (cpqFcTapeCntlrEntry[i].cpqFcTapeCntlrIndex ==
          cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryCntlrIndex)
      {
         cntlrIndex = i;
         cntlrName = fcTapeCntlrName(i);
         break;
      }
   }
   writePageHead(cntlrName, "/WEBAGENT/IMAGES/MASSHDR.GIF", "Tape Storage System Information");
   cond = new cpqCondition(cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryCondition);
   writeTableLabel(cond.image() + fcTapeLibraryName(libIndex));
   writeTableHead();
   writeDoubleTableRow(
      "Status:", displayItem("cpqFcTapeLibraryStatus", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryStatus),
      "Model:",  displayItem("cpqFcTapeLibraryName",   cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryModel));
   writeDoubleTableRow(
      "Firmware Rev:",  displayItem("cpqFcTapeLibraryFWRev",        cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryFWRev),
      "Serial Number:", displayItem("cpqFcTapeLibrarySerialNumber", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibrarySerialNumber));
   writeDoubleTableRow(
      "Service Hours:", displayItem("cpqFcTapeLibraryStatHours", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryStatHours),
      "Total Moves:",   displayItem("cpqFcTapeLibraryStatMoves", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryStatMoves));
   writeDoubleTableRow(
      "Door Status:", displayItem("cpqFcTapeLibraryDoorStatus", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryDoorStatus),
      "Redundancy:",  displayItem("cpqFcTapeLibraryRedundancy", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryRedundancy));
   writeDoubleTableRow(
      "Temperature:", displayItem("cpqFcTapeLibraryTemperature", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryTemperature),
      "Hot Swap:",    displayItem("cpqFcTapeLibraryHotSwap",     cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryHotSwap));
   writeDoubleTableRow(
      "Last Known Error:", displayItem("cpqFcTapeLibraryLastError", hexfromdec(cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryLastError) +"h"),
      "", "");
   writeTableTail();

   document.write("<br>");
   writeTableLabel("Associated Tape Drives");
   writeTableHead();
   driveCount = 0;
   driveCond = new cpqCondition(1);
   driveList = cpqFcTapeLibraryDriveList[libIndex];

   for (j = 0; j < driveList.length; j+=5)
   {
      cntlrIdx = (driveList[j+1] << 8) + driveList[j];  // 2 byte value
      scsiBus  = driveList[j+2];
      scsiId   = driveList[j+3];
      scsiLun  = driveList[j+4];

      drive = fcTapeDriveIndex(cntlrIdx, scsiBus, scsiId, scsiLun);
      if (drive < cpqFcTapeDriveEntry.length)
      {
         driveCond.set(cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCondition);
         driveLink = makeLink("CQMGSTOR/MS-FTAPE.TPL?index=" + drive + "&loc=" +
                              cntlrIndex, fcTapeDriveName(drive), "_self");
         writeOneItemTableRow(driveCond.imageSmall() + driveLink);
         driveCount++;
      }
   }
   if (driveCount == 0)  writeOneItemTableRow("None");

   writeTableTail();
}
writeBodyTail();
</script>
</html>
