<html>
<!--  MS-FCSW.TPL  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Switch Informaiton</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqSsChassisEntry>
<!cpqFcSwitchEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SSENUMS.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>
</script>
</head>
<script language="JavaScript">

writeBodyHead();

function newWindow(url)
{
   window.open(url,"","width=640,height=480,resizable=1,scrollbars=1,status=1,menubar=1");
}
idx = findArg("index");

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqFcSwitchEntry.length)
{
   reportMissingArgs();
}
else
{
   heading = "Fibre Channel Switch Information";
   for (i = 0; i < cpqSsChassisEntry.length; i++)
   {
      if (cpqSsChassisEntry[i].cpqSsChassisIndex ==
          cpqFcSwitchEntry[idx].cpqFcSwitchChassisIndex)
      {
         heading = fcChassisName(i);
         break;
      }
   }
   writePageHead(heading, "/WEBAGENT/IMAGES/MASSHDR.GIF", "Fibre Channel Switch Information");
   swCond = new cpqCondition(1);
   writeTableLabel(swCond.image() + fcSwitchName(idx),"Fibre Channel Switch Information");
   writeTableHead();
   writeDoubleTableRow(
      "Firmware Revision:", displayItem("cpqFcSwitchFWRev", cpqFcSwitchEntry[idx].cpqFcSwitchFWRev),
      "Location:", displayItem("cpqFcSwitchLocation", cpqFcSwitchEntry[idx].cpqFcSwitchLocation));
   writeDoubleTableRow(
      "Network Link Status:", displayItem("cpqFcSwitchNetworkLinkStatus", cpqFcSwitchEntry[idx].cpqFcSwitchNetworkLinkStatus),
      "Connection Status:", displayItem("cpqFcSwitchFibreConnectStatus", cpqFcSwitchEntry[idx].cpqFcSwitchFibreConnectStatus));

   if (cpqFcSwitchEntry[idx].cpqFcSwitchChassisSlot < 255)
   {
      writeDoubleTableRow(
         "IP Address:", displayItem("cpqFcSwitchIpAddress", cpqFcSwitchEntry[idx].cpqFcSwitchIpAddress),
         "Storage System Slot:",  displayItem("cpqFcSwitchChassisSlot", cpqFcSwitchEntry[idx].cpqFcSwitchChassisSlot));
   } else {
      writeDoubleTableRow(
         "IP Address:", displayItem("cpqFcSwitchIpAddress", cpqFcSwitchEntry[idx].cpqFcSwitchIpAddress),
         "Storage System Slot:",  "N/A");
   }
   writeDoubleTableRow(
      "Subnet Mask:", displayItem("cpqFcSwitchIpSubnet", cpqFcSwitchEntry[idx].cpqFcSwitchIpSubnet),
      "World Wide Node Name:", displayItem("cpqFcSwitchWorldWideNodeName", cpqFcSwitchEntry[idx].cpqFcSwitchWorldWideNodeName));
   writeDoubleTableRow(
      "Gateway Address:", displayItem("cpqFcSwitchIpGateway", cpqFcSwitchEntry[idx].cpqFcSwitchIpGateway),
      "World Wide Port Name:", displayItem("cpqFcSwitchWorldWidePortName", cpqFcSwitchEntry[idx].cpqFcSwitchWorldWidePortName));
   writeTableTail();

   if (cpqFcSwitchEntry[idx].cpqFcSwitchIpAddress != "")
   {
      if (cpqFcSwitchEntry[idx].cpqFcSwitchNetworkLinkStatus == 2)
      {
         switchUrl = "http://" + cpqFcSwitchEntry[idx].cpqFcSwitchIpAddress;
         document.write("<form><input type='button' value='Manage Switch' onClick='newWindow(switchUrl)'></form>");
      }
      else // Link inactive
      {
         msgManage = "Switch Management is not available because the link status is inactive.\n\nCheck the network connection to the switch.";
         document.write("<form><input type='button' value='Manage Switch' onClick='window.alert(msgManage)'></form>");
      }
   }
   else // Not configured
   {
      msgIpAddress = "Switch Management is not available because the IP address, subnet mask, and\ngateway address have not been configured.\n\nUse the Array Configuration Utility XE 1.30 or later to configure it.";
      document.write("<form><input type='button' value='Manage Switch' onClick='window.alert(msgIpAddress)'></form>");
   }
   document.write("<br>");
}
writeBodyTail();
</script>
</html>

