// MS-FCCMN.JS 1.28

function fcChassisName(idx)
{
   var i = parseInt(idx) + 1;
   var rc = "Storage System ";
   if (idx >= 0 && idx < cpqSsChassisEntry.length)
      rc += cpqSsChassisEntry[idx].cpqSsChassisName + " (" + i + ")";
   return rc;
}
function fcSwitchName(idx)
{
   var rc = "Switch ";
   if (idx >= 0 && idx < cpqFcSwitchEntry.length)
   {
      if (cpqFcSwitchEntry[idx].cpqFcSwitchName == "")
      {
         if (cpqFcSwitchEntry[idx].cpqFcSwitchChassisSlot < 255)
         {
            rc += cpqFcSwitchEntry[idx].cpqFcSwitchChassisSlot;
         } else {
            rc += cpqFcSwitchEntry[idx].cpqFcSwitchIndex;
         }
      } else {
         rc = cpqFcSwitchEntry[idx].cpqFcSwitchName;
      }
   }
   return rc;
}
function boxIoSlot(idx, hbaIdx)
{
   var i;
   var slot = "N/A";
   if (idx >= 0 && idx < cpqSsChassisEntry.length)
   {
      for (i = 0; i < cpqSsFibreAttachmentEntry.length; i++)
      {
         if (cpqSsFibreAttachmentEntry[i].cpqSsFibreAttachmentDeviceType == 2 &&
             cpqSsFibreAttachmentEntry[i].cpqSsFibreAttachmentHostControllerIndex == hbaIdx &&
             cpqSsFibreAttachmentEntry[i].cpqSsFibreAttachmentDeviceIndex ==
             cpqSsChassisEntry[idx].cpqSsChassisIndex)
         {
            slot = cpqSsFibreAttachmentEntry[i].cpqSsFibreAttachmentDevicePort;
            break;
         }
      }
   }
   return slot;
}
function fcBackplaneName(idx)
{
   var rc = "";
   if (idx >= 0 && idx < cpqSsBackplaneEntry.length)
   {
      rc = displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[idx].cpqSsBackplanePlacement);
      rc += " Storage System (" + cpqSsBackplaneEntry[idx].cpqSsBackplaneIndex + ")";
   }
   return rc;
}
function fcCntlrName(idx)
{
   var rc = "";
   if (idx >= 0 && idx < cpqFcaCntlrEntry.length)
   {
      rc = displayItem("cpqFcaCntlrModel", cpqFcaCntlrEntry[idx].cpqFcaCntlrModel);
      if (cpqFcaCntlrEntry[idx].cpqFcaCntlrBoxIoSlot != 0)
         rc += " in Slot " + cpqFcaCntlrEntry[idx].cpqFcaCntlrBoxIoSlot;
   }
   return rc;
}
function fcPhyDrvName(idx)
{
   var i;
   var drive, size;
   var rc = "";
   if (idx >= 0 && idx < cpqFcaPhyDrvEntry.length)
   {
      drive = cpqFcaPhyDrvEntry[idx];
      size = parseInt(drive.cpqFcaPhyDrvSize, 10);
      rc = "Port " + drive.cpqFcaPhyDrvBusNumber + " Drive " + drive.cpqFcaPhyDrvBay;
      if (!isNaN(size) && size > 0)
      {
         rc += "  " + drive.cpqFcaPhyDrvSize + " MB";
      }
      for (i = 0; i < cpqFcaSpareEntry.length; i++)
      {
         if (cpqFcaSpareEntry[i].cpqFcaSpareBoxIndex == drive.cpqFcaPhyDrvBoxIndex &&
             cpqFcaSpareEntry[i].cpqFcaSparePhyDrvIndex == drive.cpqFcaPhyDrvIndex)
         {
            rc += " - Spare";
         }
      }
   }
   return rc;
}
function fcLogDrvName(idx)
{
   var drive;
   var name = "Logical Drive ";
   if (idx >= 0 && idx < cpqFcaLogDrvEntry.length)
   {
      drive = cpqFcaLogDrvEntry[idx];
      name += drive.cpqFcaLogDrvIndex;

      if (drive.cpqFcaLogDrvFaultTol == 2)
      {
         name += " - No Fault Tolerance";
      }
      else if (drive.cpqFcaLogDrvFaultTol > 2)
      {
         name += " - ";
         name += displayItem("cpqFcaLogDrvFaultTol", drive.cpqFcaLogDrvFaultTol);
      }
   }
   return name;
}
function storageSysCondition(idx)
{
   var i;
   var ssCondition = new cpqCondition(1);
   ssCondition.update(cpqSsChassisEntry[idx].cpqSsChassisPowerSupplyCondition);
   ssCondition.update(cpqSsChassisEntry[idx].cpqSsChassisFanCondition);
   ssCondition.update(cpqSsChassisEntry[idx].cpqSsChassisTemperatureCondition);
   for (i = 0; i < cpqSsBackplaneEntry.length; i++)
   {
      if (cpqSsBackplaneEntry[i].cpqSsBackplaneChassisIndex ==
          cpqSsChassisEntry[idx].cpqSsChassisIndex &&
          cpqSsBackplaneEntry[i].cpqSsBackplanePlacement != 3)
         ssCondition.update(cpqSsBackplaneEntry[i].cpqSsBackplaneCondition);
   }
   if (cpqSsChassisEntry[idx].cpqSsChassisRsoCondition == 4)  // failed
      ssCondition.update(3);  // degraded
   else ssCondition.update(cpqSsChassisEntry[idx].cpqSsChassisRsoCondition);

   return ssCondition;
}
function compileFcCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqSsChassisEntry[this.index].cpqSsChassisOverallCondition);
}
// RA-8000
function compileSsRaidCondition()
{
   this.state = 1;
   this.update(cpqSsRaidSystemEntry[this.index].cpqSsRaidSystemCondition);
}
function compileFcTapeCondition()
{
   this.state = 1;
   this.update(cpqFcTapeCntlrEntry[this.index].cpqFcTapeCntlrOverallCondition);
}
function fcTapeCntlrName(idx)
{
   var rc = "";
   if (idx >= 0 && idx < cpqFcTapeCntlrEntry.length)
   {
      if (cpqFcTapeCntlrEntry[idx].cpqFcTapeCntlrModel == "")
         rc = displayItem("cpqFcTapeCntlrType", cpqFcTapeCntlrEntry[idx].cpqFcTapeCntlrType);
      else
         rc = cpqFcTapeCntlrEntry[idx].cpqFcTapeCntlrModel;
      rc += " (" + cpqFcTapeCntlrEntry[idx].cpqFcTapeCntlrWWN + ")";
   }
   return rc;
}
function fcTapeLibraryName(idx)
{
   var rc = "";
   if (idx >= 0 && idx < cpqFcTapeLibraryEntry.length)
   {
      rc = cpqFcTapeLibraryEntry[idx].cpqFcTapeLibraryModel +
           " - Port " + cpqFcTapeLibraryEntry[idx].cpqFcTapeLibraryScsiBus +
           " Device " + cpqFcTapeLibraryEntry[idx].cpqFcTapeLibraryScsiTarget +
           " LUN "    + cpqFcTapeLibraryEntry[idx].cpqFcTapeLibraryScsiLun;
   }
   return rc;
}
function fcTapeDriveIndex(cntlr, bus, id, lun)
{
   for (idx = 0; idx < cpqFcTapeDriveEntry.length; idx++)
   {
      if (cpqFcTapeDriveEntry[idx].cpqFcTapeDriveCntlrIndex == cntlr &&
          cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiBus == bus &&
          cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiTarget == id &&
          cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiLun == lun)
         break;
   }
   return idx;
}
function fcTapeDriveName(idx)
{
   var n;
   var rc = fcTapeName(idx);
   if (rc != "")
   {
      for (n = 0; n < cpqFcTapeCntlrEntry.length; n++)
      {
         if (cpqFcTapeCntlrEntry[n].cpqFcTapeCntlrIndex ==
             cpqFcTapeDriveEntry[idx].cpqFcTapeDriveCntlrIndex)
         {
            rc += " (" + cpqFcTapeCntlrEntry[n].cpqFcTapeCntlrWWN + ")";
            break;
         }
      }
   }
   return rc;
}
function fcTapeName(idx)
{
   var rc = "";
   if (idx >= 0 && idx < cpqFcTapeDriveEntry.length)
   {
      rc = cpqFcTapeDriveEntry[idx].cpqFcTapeDriveModel +
           " - Port " + cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiBus +
           " Device " + cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiTarget +
           " LUN "    + cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiLun;
   }
   return rc;
}
function fcTapeStorageSystem(idx)
{
   var location;
   var start, end;
   var ssName = "";
   if (idx >= 0 && idx < cpqFcTapeDriveEntry.length)
   {
      location = cpqFcTapeDriveEntry[idx].cpqFcTapeDriveLocation;
      if ((location.length > 0) && (location.indexOf("Storage system") != -1))
      {
         start = location.indexOf("&#034");
         start += 5;
         end = location.indexOf("&#034", start);
         if (start > 4 && end != -1)
            ssName = location.substring(start, end);
      }
   }
   return ssName;
}
function fcDriveCapacity(item, size)
{
   var rc = parseInt(size, 10);

   if (isNaN(rc) || rc <= 0)
   {
      rc = "N/A";
   } else {
      rc = displayItem(item, size);
   }
   return rc;
}
function writeTableText(text)
{
   document.write("<tr><td align='left' colspan='4'>",
      navTableText(text), "</td></tr>");
}
