SRCS=CpqCiKlx.c CpqCiSem.c CpqCiUSl.c CpqCiPlx.c
OBJS=CpqCiKlx.o CpqCiSem.o CpqCiUSl.o CpqCiPlx.o

CC=gcc
LD=ld
AR=ar rcs

OS_MODEL=LINUX
OS_DIST=$(shell cat distro.txt)
OS_SYMBOL=1
OS_VERSION=$(shell uname -r)

BUILD_DAY_RAW=$(shell date +%-d)
BUILD_DAY=$(shell expr $(BUILD_DAY_RAW))
BUILD_MONTH_RAW=$(shell date +%-m)
BUILD_MONTH=$(shell expr $(BUILD_MONTH_RAW))
BUILD_YEAR_RAW=$(shell date +%Y)
BUILD_YEAR=$(shell expr $(BUILD_YEAR_RAW) - 1990 )


DFLAGS= -D__KERNEL__ $(OS_MUNMAP4) $(OS_MREMAP5) -D$(OS_MODEL) -D$(OS_DIST) -DOS_VERSION=$(OS_VERSION) -DOS_SYMBOL=$(OS_SYMBOL) -DIOCTL_GET_INFO -DBUILD_DAY=$(BUILD_DAY) -DBUILD_MONTH=$(BUILD_MONTH) -DBUILD_YEAR=$(BUILD_YEAR) -DPROC_ENTRY=2 

DEBUGFLAGS=-O 
IFLAGS=-I/lib/modules/$(OS_VERSION)/build/include -Ilinux -I.

EFS_VER=\"7.1.0\"

TARGET=cpqci.o
TARGETDIR=.

CFLAGS = $(DEBUGFLAGS) -O $(DFLAGS) $(IFLAGS) $(LINUX_HEADERS)
    
LDFLAGS=-x -r

all: install

install: build
	mkdir -p $(TARGETDIR)
	cp -avf $(TARGET) $(TARGETDIR)/. || /bin/true
	echo $(OS_VERSION) > $(TARGETDIR)/kernel.txt

build:	$(TARGET) 

copy:	manifest.$(OS_MODEL)
	mkdir -p $(TARGETDIR)/linux
	cat manifest.$(OS_MODEL) | xargs -l1 -ix cp -av x $(TARGETDIR)/x 
	echo $(OS_DIST) > $(TARGETDIR)/distro.txt

cpqci.o: $(OBJS) cpqcip.o 
	$(LD) $(LDFLAGS) -o cpqci.o $(OBJS) cpqcip.o

CpqCiUSl.o:	linux/CpqCiUSl.c
	$(CC) $(CFLAGS) -c linux/CpqCiUSl.c	

CpqCiPlx.o:	linux/CpqCiPlx.c
	$(CC) $(CFLAGS) -c linux/CpqCiPlx.c	

CpqCiSem.o:	linux/CpqCiSem.c
	$(CC) $(CFLAGS) -c linux/CpqCiSem.c	

CpqCiKlx.o:	CpqCiKlx.c
	$(CC) $(CFLAGS) -c CpqCiKlx.c	

cpqcip.o:
	make -C private -f linuxk.mk -e OS_DIST=$(OS_DIST) OS_MODEL=$(OS_MODEL) TARGETDIR=.. clean all

libcpqci.so:
	make -C private -f linuxu.mk clean all

clean:
	rm -f CpqCi*.o  *~ $(TARGET)

mrproper: clean
	rm -f cpqcip.o lib*.a lib*.so*
