<html>
<!-- $RCSfile: MS-FTLIB.TPL $ $Revision: 1.2 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Tape Library Information</title>

<!#/COMMON/JPN/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqFcTapeCntlrEntry>
<!cpqFcTapeLibraryEntry>
<!cpqFcTapeLibraryDriveList.raw>
<!cpqFcTapeDriveEntry>

<!#/COMMON/JPN/COND.JS>
<!#/COMMON/JPN/STDITEMS.JS>
<!#/COMMON/JPN/TABLES.JS>
<!#/COMMON/JPN/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#/COMMON/NUMCNVRT.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>
</script>
</head>
<script language="JavaScript">

writeBodyHead();

libIndex = findArg("index");

if (libIndex == -1)
{
   parseArgs(tryPrevPage());
   libIndex = findArg("index");
}
if (libIndex >= cpqFcTapeLibraryEntry.length)
{
   reportMissingArgs();
}
else
{
   cntlrName = "";
   cntlrIndex = -1;
   for (i = 0; i < cpqFcTapeCntlrEntry.length; i++)
   {
      if (cpqFcTapeCntlrEntry[i].cpqFcTapeCntlrIndex ==
          cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryCntlrIndex)
      {
         cntlrIndex = i;
         cntlrName = fcTapeCntlrName(i);
         break;
      }
   }
   writePageHead(cntlrName, "/WEBAGENT/IMAGES/MASSHDR.GIF", "e[vXg[W VXe");
   cond = new cpqCondition(cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryCondition);
   writeTableLabel(cond.image() + fcTapeLibraryName(libIndex));
   writeTableHead();
   writeDoubleTableRow(
      "Xe[^X:", displayItem("cpqFcTapeLibraryStatus", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryStatus),
      "f:",  displayItem("cpqFcTapeLibraryName",   cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryModel));
   writeDoubleTableRow(
      "F/W rW:",  displayItem("cpqFcTapeLibraryFWRev",        cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryFWRev),
      "VAԍ:", displayItem("cpqFcTapeLibrarySerialNumber", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibrarySerialNumber));
   writeDoubleTableRow(
      "ғ:", displayItem("cpqFcTapeLibraryStatHours", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryStatHours),
      "ړv:",   displayItem("cpqFcTapeLibraryStatMoves", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryStatMoves));
   writeDoubleTableRow(
      "hA Xe[^X:", displayItem("cpqFcTapeLibraryDoorStatus", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryDoorStatus),
      "__V:",  displayItem("cpqFcTapeLibraryRedundancy", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryRedundancy));
   writeDoubleTableRow(
      "x:", displayItem("cpqFcTapeLibraryTemperature", cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryTemperature),
      "zbgXbv:",    displayItem("cpqFcTapeLibraryHotSwap",     cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryHotSwap));
   writeDoubleTableRow(
      "ŏIG[:", displayItem("cpqFcTapeLibraryLastError", hexfromdec(cpqFcTapeLibraryEntry[libIndex].cpqFcTapeLibraryLastError) +"h"),
      "", "");
   writeTableTail();

   document.write("<br>");
   writeTableLabel("ꂽe[vhCu");
   writeTableHead();
   driveCount = 0;
   driveCond = new cpqCondition(1);
   driveList = cpqFcTapeLibraryDriveList[libIndex];

   for (j = 0; j < driveList.length; j+=5)
   {
      cntlrIdx = (driveList[j+1] << 8) + driveList[j];  // 2 byte value
      scsiBus  = driveList[j+2];
      scsiId   = driveList[j+3];
      scsiLun  = driveList[j+4];

      drive = fcTapeDriveIndex(cntlrIdx, scsiBus, scsiId, scsiLun);
      if (drive < cpqFcTapeDriveEntry.length)
      {
         driveCond.set(cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCondition);
         driveLink = makeLink("CQMGSTOR/MS-FTAPE.TPL?index=" + drive + "&loc=" +
                              cntlrIndex, fcTapeDriveName(drive), "_self");
         writeOneItemTableRow(driveCond.imageSmall() + driveLink);
         driveCount++;
      }
   }
   if (driveCount == 0)  writeOneItemTableRow("Ȃ");

   writeTableTail();
}
writeBodyTail();
</script>
</html>
