//***************************************************************
//                   Insight Web - Agent Control File
//***************************************************************
//    The following section is the main control section for this
//    product.
//***************************************************************
//
//    Name = The Marketing Name of the product
//
//    Description = What is displayed as the description of the
//              product. (Required Field)
//
//    Execute = This option is used to execute an application.
//              Some possible uses for this would be launching
//              another installation program, or a configuration
//              applet.
//
//    RequiredSpace = The total amount of disk space required
//              by this product for installation.
//
//    Dependency = This is a field that will specify a case
//              that must exist for the product to be installed.
//
//    Compaq_System = This field specifies if it needs to be a
//              Compaq System.
//                    1 = Needs to be a Compaq Machine
//                    0 = Can be any machine type
//
//    Services = This is a list of services that need to be
//              setup.  The list here, is a list of the service name
//              divided by a comma.  Each service name will then
//              be a section listed in the services section.
//
//    Registry = This is a list of registry keys that need to be
//              added.
//
//    DefaultLoad = This will specify if the product is loaded as a
//              default.
//                     1 = Product is loaded
//                     0 = Product is not loaded
//
//    Version = This is the current version of the agents
//
//    MinBuildNumber = This value will give a specific product the
//              ability to not install on a version of NT different from
//              the main product.
//
//    MaxBuildNumber = Similar to th MinBuildNumber, this one will
//              allow you to specifiy the maximum build number for this
//              product.
//
//    DllCalls = This is for specifiying additional Dll calls.
//
//***************************************************************
[Main]
Name=Compaq Web Agent
Description=This component runs as a software service under Windows. The service converts information into HTML so that it can be viewed from a web browser.
Execute=
RequiredSpace=5000000
Dependency=Compaq Foundation Agents
Compaq_System=1
Services=CPQWEBMGMT,CPQWEBMGMTNoSNMP
Registry=
DefaultLoad=1
Version=7.1.0.0
VersionFile=cpqwmgmt.exe
InstalledVersionFile=WindowsSysDir\cpqmgmt\cpqwmgmt.exe
RebootRequired=0
RebootUpgrade=0
Include=
Warning=The initial install of the Compaq Management Agents has default passwords to enable web browser access. If you have not changed the passwords already, please refer to the Compaq Management Agents for Servers user guide.
//***************************************************************
//    Locations of all of the source directories
//***************************************************************
//
//    The entry names are the ones specifid in the [Files] section
//    by the NAME_SOURCE directories.  This abstacts the actual
//    source directory, to this portion of the control file.
//
//***************************************************************
[SourcePath]
WebAgent=.
Common=common
Eng=eng
Help=help\eng
HelpRoot=help
Images=images
HostRoot=cqmghost
HostEng=cqmghost\eng
HostHelp=cqmghost\help
HostHelpEng=cqmghost\help\eng
Dll_Symbols=support\symbols\dll
Exe_Symbols=support\symbols\exe
BirchRoot=cpq
BirchCommon=cpq\common
BirchEng=cpq\eng
BirchHelp=cpq\help\eng
//***************************************************************
//    Locations of all of the destination directories
//***************************************************************
//
//    The entry names are the ones specifid in the [Files] section
//    by the NAME_DESTINATION directories.  This abstacts the actual
//    destination directory, to this portion of the control file.
//
//***************************************************************
[DestinationPath]
System=WindowsSysDir
CPQMgmt=WindowsSysDir\CPQMgmt
WebAgent=WindowsSysDir\cpqmgmt\webagent
Eng=WindowsSysDir\cpqmgmt\webagent\eng
Common=WindowsSysDir\cpqmgmt\webagent\common
HelpRoot=WindowsSysDir\cpqmgmt\webagent\help
Help=WindowsSysDir\cpqmgmt\webagent\help\eng
Images=WindowsSysDir\cpqmgmt\webagent\images
HostRoot=WindowsSysDir\cpqmgmt\webagent\cqmghost
HostEng=WindowsSysDir\cpqmgmt\webagent\cqmghost\eng
HostHelp=WindowsSysDir\cpqmgmt\webagent\cqmghost\help
HostHelpEng=WindowsSysDir\cpqmgmt\webagent\cqmghost\help\eng
Dll_Symbols=WindowsDir\symbols\dll
Exe_Symbols=WindowsDir\symbols\exe
BirchRoot=WindowsSysDir\cpqmgmt\webagent\cpq
BirchCommon=WindowsSysDir\cpqmgmt\webagent\cpq\common
BirchEng=WindowsSysDir\cpqmgmt\webagent\cpq\eng
BirchHelp=WindowsSysDir\cpqmgmt\webagent\cpq\help\eng
//***************************************************************
//    Names of all of the files that are to be copied
//***************************************************************
//
//    FILE_LIST = This lists a code name for a file grouping.
//              Each group is a set of files that are similar in
//              behavior.  They all have the same source, destination
//              and flag conditions.  All file groups are separated
//              by a comma.
//
//    DEFAULT_NOTIFY = This is the default for the files in this section
//              it specifies if the dialog box will appear or not that
//              will ask if you want to over-write the file.  Any file
//              group that specifys a notify will be over-written.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_SOURCE = This shows the name of the source directory
//              for the group of files called NAME.
//
//    NAME_DESTINATION = This shows the name of the destination directory
//              for the group of files called NAME.
//
//    NAME_FILES = This is a list of the files that need to be copied.
//
//    NAME_NOTIFY = This will over-write the DEFAULT_NOTIFY option
//              listed above.  If it is not specified, it will NOT
//              chage the default.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_UNINSTALL = This will determine if the files listed will be
//               removed on an uninstall.  The default is uninstall all
//               files.
//                    1 = Will uninstall this group of files
//                    0 = Will leave these files during an uninstall
//
//    DELETE_FILES = List of files to be deleted
//
//***************************************************************
[Files]
FILE_LIST=CPQMGMT,WEBMGMT,TEMPLATE1,TEMPLATE2,TEMPLATE3,COMMON,HELP,ROOT_HELP,IMAGES,HOST,HOSTENG,HOSTHELP,HOSTHELPENG,EXE_SYMBOLS,DLL_SYMBOLS,BIRCHINI, BIRCHROOT,BIRCHCOMMON,BIRCHENG1,BIRCHENG2,BIRCHENG3,BIRCHHELP1,BIRCHHELP2,BIRCHHELP3
DELETE_FILES=423ENG,423ENG2,423ENG3,423HELP,423HELP2,423HELP3,423WEB,OBSOLETE_FILES,OLDPFC,OLDPFCHELP,OLDPFCHELPENG
OSBSOLETE_FILES_SOURCE=CPQMgmt
OSBSOLETE_FILES_FILES=msvcp50.dll,msvcrt.dll
OLDPFC_SOURCE=WebAgent
OLDPFC_FILES=CQMGWNNT.INI
OLDPFCHELP_SOURCE=HelpRoot
OLDPFCHELP_FILES=NTOSMAP.JS
OLDPFCHELPENG_SOURCE=Help
OLDPFCHELPENG_FILES=NTOSIDX.TPL,NTOSCONT.TPL,bmclogo.gif,IMA00031.HTM
WEBMGMT_SOURCE=WebAgent
WEBMGMT_DESTINATION=CPQMgmt
WEBMGMT_FILES=cpqwmgmt.exe,cpqwebag.dll,cpqhmmo.dll
WEBMGMT_UNINSTALL=1
CPQMGMT_SOURCE=WebAgent
CPQMGMT_DESTINATION=WebAgent
CPQMGMT_FILES=ABOUT.HTM,BE4CALL.HTM,cimlogo.gif,COMPAQ.HTM,connec.gif,CPQDEV.FRM,CPQHMMD.INI,CPQLOGIN.FRM,CPQLOGIN.JAR,cpqlogo.gif,CPQOPTS.FRM,CPQSNS.HTM,CQMGHOST.INI,csns0.gif,csu.gif,CUSTOM.HTM,DEFAULT.FRM,HELP.HTM,info3.gif,infomsgr.gif,inslogo.gif,lock.gif,phone.gif,question.gif,srhome19.gif,sstart.gif,survey1.gif,SURVEYLD.HTM,TROUBLE.FRM,WEBAGENT.INI,webbum.gif,webhead.gif,WORLDHDR.GIF
CPQMGMT_UNINSTALL=1
TEMPLATE1_SOURCE=Eng
TEMPLATE1_DESTINATION=Eng
TEMPLATE1_FILES=BLANK.TPL,CACHE.TPL,FINDEX.TPL,HDRFRAME.TPL,INDEX.TPL
TEMPLATE1_UNINSTALL=1
TEMPLATE2_SOURCE=Eng
TEMPLATE2_DESTINATION=Eng
TEMPLATE2_FILES=NAVDATA.TPL,NAVFRAME.TPF
TEMPLATE2_UNINSTALL=1
TEMPLATE3_SOURCE=Eng
TEMPLATE3_DESTINATION=Eng
TEMPLATE3_FILES=NOCSERR.TPL,POSTERR.TPL,RMTERR.TPL,SETERR.TPL,SETUP.TPL,SNMPERR.TPL,SUBFRAME.TPL,SUMMARY.TPF
TEMPLATE3_UNINSTALL=1
COMMON_SOURCE=Common
COMMON_DESTINATION=Common
COMMON_FILES=COMPAQ.JS,COND.JS,DISPBASE.JS,NAVTABLE.JS,NUMCNVRT.JS,OBJPAGE.TPL,OBJTABLE.TPL,PAGETAGS.TPL,PARSEARG.JS,SETS.JS,STDITEMS.JS,SWTABLE.JS,TABLES.JS,UIDENUMS.JS
COMMON_UNINSTALL=1
HELP_SOURCE=Help
HELP_DESTINATION=Help
HELP_FILES=BANNER.HTM,bmclogo.gif,bottom.gif,BOTTOM.HTM,BOTTOM_I.HTM,contents.jpg,DEFAULT.CSS,FINDHELP.TPL,HELPIDX.HTM,IMA00000.HTM,IMA00007.HTM,IMA00030.HTM,index.jpg,L_LEFT.HTM,left.gif,LEFT.HTM,LEFT_I.HTM,logo.gif,major.gif,MIDDLE.HTM,MIDDLE_I.HTM,minor.gif,normal.gif,right.gif,RIGHT.HTM,START.HTM,START_I.HTM,TOP.HTM,top_big.gif,toparrow.gif,unknown.gif,WBAGCONT.HTM,WBAGIDX.HTM,WELCOME.HTM,WHIEIND.HTM,WHNONIE4.CSS
HELP_UNINSTALL=1
ROOT_HELP_SOURCE=HelpRoot
ROOT_HELP_DESTINATION=HelpRoot
ROOT_HELP_FILES=Wbagmap.js,WebHelp.cab,WebHelp.zip
ROOT_HELP_UNINSTALL=1
IMAGES_SOURCE=Images
IMAGES_DESTINATION=Images
IMAGES_FILES=agntlogo.gif,backgrnd.gif,bttyhdr.gif,cfghdr.gif,cfgnav.gif,critical.jpg,disabled.jpg,degraded.gif,dot-blck.gif,dot-blue.gif,dot-grn.gif,dot-red.gif,dot-wht.gif,dot-yllw.gif,exhdr.gif,expbrd2.gif,failed.gif,helpptr.gif,ima.gif,line1.gif,mass5.gif,masshdr.gif,mntrhdr.gif,nic.gif,nichdr.gif,notslctd.gif,ok.gif,recov.gif,recvrhdr.gif,sbhdr.gif,slctlft.gif,slctrt.gif,sysbrd2.gif,unknown.gif,utilhdr.gif,utnav.gif,WARNING.JPG
IMAGES_UNINSTALL=1
HOST_SOURCE=HostRoot
HOST_DESTINATION=HostRoot
HOST_FILES=backgrnd.jpg,CPQTHRSH.JAR,CQMGHOST.BIN
HOST_UNINSTALL=1
HOSTENG_SOURCE=HostEng
HOSTENG_DESTINATION=HostEng
HOSTENG_FILES=CF-CLSTR.TPL,CF-SWVER.TPL,CQMGHOST.TPL,MS-SPACE.TPL,CLSENUMS.JS
HOSTENG_UNINSTALL=1
HOSTHELP_SOURCE=HostHelp
HOSTHELP_DESTINATION=HostHelp
HOSTHELP_FILES=HOSTMAP.JS
HOSTHELP_UNINSTALL=1
HOSTHELPENG_SOURCE=HostHelpEng
HOSTHELPENG_DESTINATION=HostHelpEng
HOSTHELPENG_FILES=HOSTCONT.HTM,HOSTIDX.HTM,IMA00040.HTM,IMA00090.HTM,IMA00091.HTM,toparrow.gif,DEFAULT.CSS,WHNONIE4.CSS
HOSTHELPENG_UNINSTALL=1
EXE_SYMBOLS_SOURCE=Exe_Symbols
EXE_SYMBOLS_DESTINATION=Exe_Symbols
EXE_SYMBOLS_FILES=Cpqwmgmt.pdb
EXE_SYMBOLS_UNINSTALL=1
DLL_SYMBOLS_SOURCE=Dll_Symbols
DLL_SYMBOLS_DESTINATION=Dll_Symbols
DLL_SYMBOLS_FILES=cpqwebag.pdb,cpqhmmo.pdb
DLL_SYMBOLS_UNINSTALL=1
BIRCHINI_SOURCE=BirchRoot
BIRCHINI_DESTINATION=WebAgent
BIRCHINI_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHINI_FILES=CQTC1K.INI
BIRCHINI_UNINSTALL=1
BIRCHROOT_SOURCE=BirchRoot
BIRCHROOT_DESTINATION=BirchRoot
BIRCHROOT_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHROOT_FILES=CPQTHRSH.JAR,CQTC1K.BIN
BIRCHROOT_UNINSTALL=1
BIRCHCOMMON_SOURCE=BirchCommon
BIRCHCOMMON_DESTINATION=BirchCommon
BIRCHCOMMON_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHCOMMON_FILES=COMPAQ.JS,COND.JS,DISPBASE.JS,NAVTABLE.JS,NUMCNVRT.JS,PAGETAGS.TPL,PARSEARG.JS,SETS.JS,STDITEMS.JS,SWTABLE.JS,TABLES.JS
BIRCHCOMMON_UNINSTALL=1
BIRCHENG1_SOURCE=BirchEng
BIRCHENG1_DESTINATION=BirchEng
BIRCHENG1_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHENG1_FILES=BLANK.TPL,BT-BTTY.TPL,CACHE.TPL,CF-CLSTR.TPL,CF-SECUR.TPL,CF-SINFO.TPF,CF-SWVER.TPL,CLSENUMS.JS,DAENUMS.JS,DT5ENUMS.JS,EX-COMMN.TPL,EX-INFO.TPL,EX-RES.TPL,FCAENUMS.JS,FINDEX.TPL,HDRFRAME.TPL,HEENUMS.JS,HEMENUMS.JS,HOENUMS.JS,IDEENUMS.JS,IFENUMS.JS,INDEX.TPL,MEENUMS.JS,MS-COND.JS,MS-DAACL.TPL,MS-DABOX.TPL,MS-DACMN.JS,MS-DACTL.TPL,MS-DALOG.TPL,MS-DAMNU.TPL,MS-DAPHY.TPL,MS-DRVBX.JS,MS-FCCMN.JS,MS-FCCON.TPL,MS-FCCTL.TPL,MS-FCLOG.TPL,MS-FCMNU.TPL,MS-FCPHY.TPL,MS-FCSS.TPL,MS-FLOP.TPL
BIRCHENG1_UNINSTALL=1
BIRCHENG2_SOURCE=BirchEng
BIRCHENG2_DESTINATION=BirchEng
BIRCHENG2_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHENG2_FILES=MS-FTAPE.TPL,MS-FTCON.TPL,MS-FTCTL.TPL,MS-FTLIB.TPL,MS-FTMNU.TPL,MS-IDE.TPL,MS-SCMNU.TPL,MS-SCSI.TPL,MS-SCSIC.JS,MS-SCSID.TPL,MS-SPACE.TPL,MT-MON.TPL,NAVDATA.TPL,NAVFRAME.TPF,NC-CMMN.JS,NC-IF.TPL,NC-IFACE.TPL,NC-LOG.TPL,NC-NAV.TPL,NC-PHY.TPL,NC-SNGL.TPL,NC-TMMNU.TPL,NICENUMS.JS,NICHEAD.JS,NUMCNVRT.JS,POSTERR.HTM,RC-BTLOG.TPL,RC-CRIT.TPL,RC-CRMEM.TPL,RC-DEVSW.TPL,RC-ENV.TPL,RC-IML.TPL,RC-POWER.TPL,RC-RAWLG.JS,RC-RBOOT.TPL,RC-RBTWT.TPL,RC-RCOMM.TPL,RC-RECOV.TPL,RC-RIBRD.TPL,RMTERR.HTM,SB-INFO.TPL
BIRCHENG2_UNINSTALL=1
BIRCHENG3_SOURCE=BirchEng
BIRCHENG3_DESTINATION=BirchEng
BIRCHENG3_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHENG3_FILES=SBENUMS.JS,SCSENUMS.JS,SEENUMS.JS,SETERR.HTM,SETUP.TPL,SIENUMS.JS,SM2ENUMS.JS,SNMPERR.HTM,SSENUMS.JS,SUBFRAME.TPL,SUMMARY.TPF,TAPENUMS.JS,TPENUMS.JS,UPSENUMS.JS,UT-INFO.TPL,CQTC1K.TPL
BIRCHENG3_UNINSTALL=1
BIRCHHELP1_SOURCE=BirchHelp
BIRCHHELP1_DESTINATION=BirchHelp
BIRCHHELP1_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHHELP1_FILES=ASYNCH95.GIF,ASYNCHNT.GIF,BMC.JPG,CNT0.GIF,CNT1.GIF,CONTENTS.HTM,contents.jpg,CUSTOM.GIF,DESKTOP.GIF,FINDHELP.TPL,HEADER.JPG,HELPHEAD.JPG,HELPIDX.JS,IMA00000.HTM,IMA00001.HTM,IMA00002.HTM,IMA00003.HTM,IMA00004.HTM,IMA00005.HTM,IMA00006.HTM,IMA00007.HTM,IMA00008.HTM,IMA00009.HTM,IMA00010.HTM,IMA00011.HTM,IMA00012.HTM,IMA00013.HTM,IMA00014.HTM,IMA00015.HTM,IMA00016.HTM,IMA00017.HTM,IMA00018.HTM,IMA00019.HTM,IMA00020.HTM,IMA00021.HTM,IMA00022.HTM,IMA00023.HTM,IMA00024.HTM
BIRCHHELP1_UNINSTALL=1
BIRCHHELP2_SOURCE=BirchHelp
BIRCHHELP2_DESTINATION=BirchHelp
BIRCHHELP2_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHHELP2_FILES=IMA00025.HTM,IMA00026.HTM,IMA00030.HTM,IMA00031.HTM,IMA00040.HTM,IMA00041.HTM,IMA00042.HTM,IMA00043.HTM,IMA00044.HTM,IMA00045.HTM,IMA00046.HTM,INDEX.HTM,index.jpg,INDEXA.GIF,INDEXB.GIF,INDEXC.GIF,INDEXD.GIF,INDEXE.GIF,INDEXF.GIF,INDEXG.GIF,INDEXH.GIF,INDEXI.GIF,INDEXJ.GIF,INDEXK.GIF,INDEXL.GIF,INDEXM.GIF,INDEXN.GIF,INDEXO.GIF,INDEXP.GIF,INDEXQ.GIF,INDEXR.GIF,INDEXS.GIF,INDEXT.GIF,INDEXU.GIF,INDEXV.GIF,INDEXW.GIF,INDEXX.GIF,INDEXY.GIF,INDEXZ.GIF,major.gif,MINOR.GIF
BIRCHHELP2_UNINSTALL=1
BIRCHHELP3_SOURCE=BirchHelp
BIRCHHELP3_DESTINATION=BirchHelp
BIRCHHELP3_DEPENDENCY=Software\Compaq\Insight Manager XE
BIRCHHELP3_FILES=NEXTTOP.GIF,normal.gif,PREVTOP.GIF,PROCMON.GIF,REMOTE.GIF,SERVICES.GIF,SNMP.GIF,toparrow.gif,UNKNOWN.GIF
BIRCHHELP3_UNINSTALL=1
423ENG_SOURCE=Eng
423ENG_FILES=bt-btty.tpl,cf-clstr.tpl,cf-secur.tpl,cf-sinfo.tpf,cf-swver.tpl,clsenums.js,daenums.js,dt5enums.js,enums.js,ex-commn.tpl,ex-info.tpl,ex-res.tpl,fcaenums.js,heenums.js,hemenums.js,hoenums.js,ideenums.js,ifenums.js,meenums.js,ms-cond.js,ms-daacl.tpl,ms-dabox.tpl,ms-dacmn.js,ms-dactl.tpl,ms-dalog.tpl,ms-damnu.tpl,ms-daphy.tpl,ms-drvbx.js,ms-fccmn.js,ms-fccon.tpl,ms-fcctl.tpl,ms-fclog.tpl,ms-fcmnu.tpl,ms-fcphy.tpl,ms-fcss.tpl,ms-flop.tpl
423ENG2_SOURCE=Eng
423ENG2_FILES=ms-ftape.tpl,ms-ftcon.tpl,ms-ftctl.tpl,ms-ftlib.tpl,ms-ftmnu.tpl,ms-ide.tpl,ms-scmnu.tpl,ms-scsi.tpl,ms-scsic.js,ms-scsid.tpl,ms-space.tpl,mt-mon.tpl,navframe.tpf,nc-cmmn.js,nc-if.tpl,nc-iface.tpl,nc-log.tpl,nc-nav.tpl,nc-phy.tpl,nc-snet.tpl,nc-sngl.tpl,nc-tmmnu.tpl,nicenums.js,nichead.js,posterr.tpl,rc-btlog.tpl,rc-crit.tpl,rc-crmem.tpl,rc-devsw.tpl,rc-env.tpl,rc-iml.tpl,rc-power.tpl,rc-rawlg.js,rc-rboot.tpl,rc-rbtwt.tpl,rc-rcomm.tpl,rc-recov.tpl,rc-ribrd.tpl
423ENG3_SOURCE=Eng
423ENG3_FILES=sbenums.js,sb-info.tpl,scsenums.js,seenums.js,sienums.js,sm2enums.js,sntenums.js,ssenums.js,summary.tpf,tapenums.js,tpenums.js,upsenums.js,ut-info.tpl
423HELP_SOURCE=Help
423HELP_FILES=asynch95.gif,asynchnt.gif,bmc.jpg,cnt0.gif,cnt1.gif,contents.htm,custom.gif,desktop.gif,header.jpg,helphead.jpg,helpidx.js,ima00001.htm,ima00002.htm,ima00003.htm,ima00004.htm,ima00005.htm,ima00006.htm,ima00007.htm,ima00008.htm,ima00009.htm,ima00010.htm,ima00011.htm,ima00012.htm,ima00013.htm,ima00014.htm,ima00015.htm,ima00016.htm,ima00017.htm,ima00018.htm,ima00019.htm,ima00020.htm,ima00021.htm,ima00022.htm,ima00023.htm,ima00024.htm
423HELP2_SOURCE=Help
423HELP2_FILES=ima00025.htm,ima00026.htm,ima00027.htm,ima00028.htm,ima00029.htm,ima00031.htm,ima00040.htm,ima00041.htm,ima00042.htm,ima00043.htm,ima00044.htm,ima00045.htm,ima00046.htm,index.htm,indexa.gif,indexb.gif,indexc.gif,indexd.gif,indexe.gif,indexf.gif,indexg.gif,indexh.gif,indexi.gif,indexj.gif,indexk.gif,indexl.gif,indexm.gif,indexn.gif,indexo.gif,indexp.gif,indexq.gif,indexr.gif,indexs.gif,indext.gif,indexu.gif,indexv.gif,indexw.gif,indexx.gif,indexy.gif,indexz.gif
423HELP3_SOURCE=Help
423HELP3_FILES=nexttop.gif,prevtop.gif,procmon.gif,remote.gif,services.gif,snmp.gif
423WEB_SOURCE=WebAgent
423WEB_FILES=cpqthrsh.jar,cpqwmib.bin
//***************************************************************
//    Names of the services that are to be installed
//***************************************************************
//
//    Description = The Display name of the service
//
//    Path = The Image Path of the service
//
//    Dependencies = This is a field that will specify a case
//              that must exist for the service to be installed.
//
//    Start = The start parameter for the service
//
//    Type = The type value for the service
//
//    ObjectName = The Name of the object
//
//***************************************************************
[CPQWEBMGMT]
Name=CpqWebMgmt
Description=Compaq Web Agent
DependOnService=CqMgHost
Dependency=SYSTEM\CurrentControlSet\Services\SNMP
Path=%SystemRoot%\System32\CPQMGMT\CPQWMGMT.EXE
Start=2
Type=16
DependOnGroup=
ErrorControl=1
ObjectName=LocalSystem
RegKeys=Parameters
EventMessageEntry=Compaq Web Agent
[CPQWEBMGMTNoSNMP]
Name=CpqWebMgmt
Description=Compaq Web Agent
DependOnService=CqMgHost
Dependency=!SYSTEM\CurrentControlSet\Services\SNMP
Path=%SystemRoot%\System32\CPQMGMT\CPQWMGMT.EXE
Start=4
Type=16
DependOnGroup=
ErrorControl=1
ObjectName=LocalSystem
RegKeys=Parameters
EventMessageEntry=Compaq Web Agent
//***************************************************************
//    Names of the sub-services that are to be installed
//***************************************************************
//
//  Name = The Name of the sub-service as it appears in the
//         registry beneath the calling service
//
//  Description = The value that is called DisplayName in the
//         registry
//
//  Keys = A three part value that is seperated by a "#" that adds
//         additional keys to the sub-service.  It goes in the following
//         order:
//              KeyName,Type, Value
//              KeyName = The Key that will be written into the registry
//
//              Type = The type of entry that will be created include:
//                     DWORD
//                     EXPAND_SZ
//                     MULTI_SZ
//                     REG_SZ
//
//              Value = The initial starting value
//
//***************************************************************
[Parameters]
Name=Parameters
Keys=HTTPPort,DWORD,0
[Security]
Name=Security
[Enum]
Name=Enum
Keys=Count,DWORD,1 # NextInstance,DWORD,1 # 0,REG_SZ,Root\LEGACY_CPQWEBMGMT\0000
[Linkage]
Name=Linkage
RegKeys=Disabled#
[Disabled]
Name=Disabled
