/***************************************************************************
* copyright 2002 Compaq Information Technologies Group, L.P.
* Hewlett-Packard Company Confidential
****************************************************************************
*
*  @doc
*
*  @module  cpqevtc.h
*  Version: 1.0
*
*  Function: 
*  This provides legacy support for IML Logging.
*           
*
*  @doc
****************************************************************************
* 
*  @doc
* 
*  Change Log:
* 
*       Date    Who   Description
* 
*****************************************************************************/

#ifndef INCL_CPQEVTC_H
#define INCL_CPQEVTC_H


/**************************************************************************
**  Includes needed for all files
***************************************************************************/
#include "oswrap.h"


/**************************************************************************
**  Constants
***************************************************************************/

#ifndef SUCCESS
#define SUCCESS      0
#endif

#ifndef FAILURE
#define FAILURE      1
#endif

#define MAX_RES_Q_ELEMENTS     10     /* Max. memory resident entries   */
#define MAX_Q_FULL_ATTEMPTS    10     /* Determines when to shut        */
                                      /* off the CSM interrupts         */

/*
** The following are used by the registration routines to either
** add or remove a device driver handler.
*/
#define CEVT_ADD_HANDLER       0x01
#define CEVT_REMOVE_HANDLER    0x02

/*
** The following is used for logging errors to the screen.  We
** define these to provide a portable interface to all UNIX
** based OS's.
*/
#define CEVT_KERN_INFO                 1    /* Information message         */
#define CEVT_KERN_WARN                 2    /* Warning Message             */
#define CEVT_KERN_CRITICAL             3    /* Critical Error Message      */
#define CEVT_KERN_PANIC                4    /* Print Message and Halt      */
#define CEVT_KERN_DEBUG                5    /* Debug Messages Only         */


#define EVT_IOCTL_BUFFER_TOO_BIG       0x02


typedef ULONG(* PIML_LOGGER)( LONG lAction, LONG lMatchCode, 
                              LONG lEvtNum, VOID *pEvt );
typedef ULONG(* PRIB_LOGGER)(VOID *pCridData);


typedef struct _CEVTDATA {
    ULONG                ulCfgState;    /* Current Configuration State    */
    ULONG                ulFlags;       /* To print debug messages        */
    ULONG                ulWaitCondition;/* for cevtd to handle a signal  */
    ULONG                ulImlQCount;   /* Count of IML Q entries         */
    ULONG                ulMsgQCount;   /* Count of MSG Q entries         */
    ULONG                ulOpenCnt;     /* Count of who is registered     */
    PQELEMENT            pImlQHead;     /* Pointer to Head of the IML Q   */
    PQELEMENT            pImlQTail;     /* Pointer to Tail of the IML Q   */
    PQELEMENT            pMsgQHead;     /* Pointer to Head of the MSG Q   */
    PQELEMENT            pMsgQTail;     /* Pointer to Tail of the MSG Q   */
    PIML_LOGGER          pImlLogger;    /* Pointer to IML Logging routine */
    PRIB_LOGGER          pRIBLogger;    /* Pointer to RIB Logging routine */
    PVOID                pOsData;	    /* OS specific constructs         */
} CEVTDATA, *PCEVTDATA;


/**************************************************************************
**  Defines for ulCfgState above
***************************************************************************/
#define    CEVT_LOADED             0x01    /* Module has completed init      */
#define    CEVT_RIB_INIT_FIRST     0x02    /* RILOE Driver loaded first      */
#define    CEVT_HEALTH_RELOAD      0x04    /* Health Driver reloading        */
#define    CEVT_INITIALIZED        0x08    /* Common Code Ready  */
#define    CEVT_SHUTDOWN           0x10    /* Stop processing                */


//*************************************************************************
//  Defines for lower 2 bytes of ulFlags above
//  See cevtioctl.h for definitions of upper two bytes.
//*************************************************************************
#define CEVT_DEBUG_ALL                     0x01



/**************************************************************************
**  Function prototypes
****************************************************************************/

PVOID cevtw_malloc(ULONG ulSize);
VOID cevtw_free(PVOID pVAddr, ULONG ulSize);
void cevtw_lock_iml_queue(PCEVTDATA pInstance);
void cevtw_unlock_iml_queue(PCEVTDATA pInstance);
void cevtw_lock_msg_queue(PCEVTDATA pInstance);
void cevtw_unlock_msg_queue(PCEVTDATA pInstance);
ULONG cevtw_memcpy(char *dest, char *source, int length);
void *cevtw_memzero(void *s, int n);
void * cevtw_memset(  void *s, register int c, register int n);
VOID cevtw_printf( ULONG ulErrorLevel, PCHAR pString, 
                   PULONG ppParms, PCEVTDATA pInstance );
ULONG cevtw_microdelay( ULONG ulUsec, PCEVTDATA pInstance );


int cevtc_log_iml_event( LONG lAction, LONG lMatchCode,
                         LONG lEvtNum, VOID *pEvt );
VOID cevtc_console_log(PVOID pCridData);

#endif 
