 /***************************************************************************
 *        Copyright 2002 Compaq Information Technologies Group, L.P.       *
 ****************************************************************************
 *
 *  @doc
 *
 *  @module   UNIXINCL.H
 *
 *  Title:   UNIX General Data Type  Include
 *
 *  Version: 1.0
 *
 *  Author : Patrick M. Schoeller
 *
 *  Function: To provide a common include for all the OSs to resolve their
 *           includes within.  Conditional compilation will cause the correct
 *           includes to be picked up by the compiler.
 *
 * @doc
 *
 ***************************************************************************/

//****************************************************************************

#ifndef UNIX_INCL
#define UNIX_INCL 1

//*************************************************************************
// OS Specific Defines
//*************************************************************************

//*************************************************************************
//  COMMON DEFINES
//*************************************************************************

/*
** We have to provide a define for "sprinf" to make the common code
** work.
*/
#define sprintf  OSC_sprintf

//****************************************************************************

#ifndef BYTE
  typedef unsigned char       BYTE, *PBYTE;
#endif 

#ifndef WORD
  typedef unsigned short      WORD, *PWORD;
#endif

#ifndef DWORD
  typedef unsigned long       DWORD, *PDWORD;
#endif

#ifndef LONG
  typedef unsigned long       LONG, *PLONG;
#endif

#ifndef CHAR
  typedef char                CHAR, *PCHAR;
#endif

#ifndef UCHAR
  typedef unsigned char       UCHAR, *PUCHAR;
#endif

#ifndef BOOLEAN
  typedef unsigned char       BOOLEAN, *PBOOLEAN;
#endif

#ifndef USHORT
  typedef unsigned short      USHORT, *PUSHORT;
#endif

#ifndef ULONG
  typedef unsigned long       ULONG, *PULONG;
#endif

/*
** The real 64 bit data type is valid under 
** UW7 and Linux. The OpenServer OS does not 
** have such a data type and probably never
** will.
*/
#ifdef SCO500
    typedef unsigned long  ULONGLONG, *PULONGLONG;
#else
    typedef unsigned long long  ULONGLONG, *PULONGLONG;
#endif

#ifndef VOID
  typedef void                VOID, *PVOID;
#endif

#ifndef UINT
  typedef unsigned int        UINT;
#endif

#ifndef NULL
  #define NULL ((void*)0)
#endif


#ifdef NOT_NEEDED
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((UINT)(w) >> 8) & 0xFF))
#define LOWORD(l)           ((WORD)(DWORD)(l))
#define HIWORD(l)           ((WORD)((((DWORD)(l)) >> 16) & 0xFFFF))
#define MAKELONG(low, high) ((LONG)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))
#define MAKELP(sel, off)    ((void FAR*)MAKELONG((off), (sel)))
#define FALSE               0
#define TRUE                1

#endif

#endif
