#include <linux/config.h>

#if defined(CONFIG_SMP) && !defined(__SMP__)
#define __SMP__
#endif  // defined(CONFIG_SMP) && !defined(__SMP__)

#include <linux/version.h>

// only one C file can include module headers with __NO_VERSION__
#if defined(MODULE)
#define __NO_VERSION__
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif  // defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#if defined(MODVERSIONS) && (LINUX_VERSION_CODE < 0x020500)
#include <linux/modversions.h>
#endif  // defined(CONFIG_MODVERSIONS)
#include <linux/module.h>
#endif  // defined(MODULE)

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/fcntl.h>
#include <linux/interrupt.h>        // ???
#include <linux/ptrace.h>           // ???
#include <linux/ioport.h>           // ???
#include <linux/in.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/slab.h>
#else
#include <linux/malloc.h>
#endif
#include <linux/string.h>
#include <linux/init.h>
#include <asm/system.h>
#include <asm/bitops.h>
#include <asm/io.h>                 // ???
#include <asm/dma.h>                // ???
#include <asm/uaccess.h>            // copy_[from|to]_user
#include <asm/atomic.h>
#include <linux/errno.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/inetdevice.h>
#include <linux/skbuff.h>
#include <linux/notifier.h>
#include <linux/string.h>
#include <linux/rtnetlink.h>
#include <linux/proc_fs.h>
#include <linux/smp_lock.h>

// version dependent includes
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/spinlock.h>
#else
#include <asm/spinlock.h>
#endif

#include "nicext.h"
#include "pal.h"

void
blf_core_fini(
    void
    )
{
}

int
blf_core_init(
    int mgmt_major
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
int
blf_core_mgmt_ioctl(
    unsigned int cmd,
    void* arg
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
void
blf_set_multicast_list(
    PAL_DEVICE dev 
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
void
blf_recv(
    PAL_PACKET pkt,
    void* ctx
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
int
blf_close(
    PAL_DEVICE dev 
    )
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
int
blf_change_mtu(
    PAL_DEVICE dev,
    int new_mtu
    )
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
int
blf_send(
    PAL_PACKET pkt,
    PAL_DEVICE dev
    )
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
PAL_DEVICE_STAT
blf_get_stats(
    PAL_DEVICE dev
    )
{
    PAL_DEVICE_STAT dummy;

    return dummy = 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
int
blf_ioctl(
    PAL_DEVICE dev ,
    void* ifr,
    int cmd
    )
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
int 
blf_probe( 
	PAL_DEVICE dev 
    )
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
__attribute__((regparm (0)))
#endif
int
blf_open(
    PAL_DEVICE dev 
    )
{
    return 0;
}
