/****************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name:        blf.c
 *
 * Description: Broadcom Advanced Server Program For Linux modules.
 *              This file implements the module load and unload, as well
 *              as the driver initialization.
 *
 * Author:      Frankie Fan
 *
 * Created:     September 1, 2000
 *
 ****************************************************************************/
#include <linux/config.h>

#if defined(CONFIG_SMP) && !defined(__SMP__)
#define __SMP__
#endif  // defined(CONFIG_SMP) && !defined(__SMP__)

#include <linux/version.h>

// this is necessary because we want this file to be the module
#if defined(MODULE)
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif  // defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#if defined(MODVERSIONS) && (LINUX_VERSION_CODE < 0x020500)
#include <linux/modversions.h>
#endif  // defined(CONFIG_MODVERSIONS)
#include <linux/module.h>
#endif  // defined(MODULE)

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/fcntl.h>
#include <linux/interrupt.h>        // ???
#include <linux/ptrace.h>           // ???
#include <linux/ioport.h>           // ???
#include <linux/in.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/slab.h>
#else
#include <linux/malloc.h>
#endif
#include <linux/string.h>
#include <linux/init.h>
#include <asm/system.h>
#include <asm/bitops.h>
#include <asm/io.h>                 // ???
#include <asm/dma.h>                // ???
#include <asm/uaccess.h>            // copy_[from|to]_user
#include <asm/atomic.h>
#include <linux/errno.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>

// version dependent include
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/spinlock.h>
#else
#include <asm/spinlock.h>
#endif

//
// driver public interface
//
#include "blfopt.h"
#include "bcmtype.h"
#include "blfver.h"
#include "blfcore.h"
#include "pal.h"

//
// local constants
//
#if defined(MODVERSIONS)
#define BLF_COMPILE_VERSION_SUPPORT "symbols versioning, "
#else   // defined(MODVERSIONS)
#define BLF_COMPILE_VERSION_SUPPORT ""
#endif  // defined(MODVERSIONS)

#if defined(__SMP__)
#define BLF_COMPILE_SMP_SUPPORT "SMP "
#else   // defined(__SMP__)
#define BLF_COMPILE_SMP_SUPPORT "non-SMP "
#endif  // defined(__SMP__)

//
// local function prototypes
//
int  blf_install( void );
void blf_cleanup( void );
int  blf_mgmt_ioctl( struct inode*, struct file*, unsigned int, unsigned long );

//
// management device file operations
//
static struct file_operations blf_mgmt_fops =
{
    ioctl:     blf_mgmt_ioctl,
};

//
// management device major
//
static int mgmt_major;

//
// Functions that are required for both compiled-in and modules
//
/****************************************************************************
 * blf_install:
 *
 * driver installation
 *
 * Input;
 *      none
 *
 * Output:
 *      0 - success
 *
 ****************************************************************************/
int
blf_install(
    void
    )
{
    int rc;

    printk( KERN_INFO BLF_PRODUCT_NAME " v" BLF_VERSION_STRING "\n" );
    printk( KERN_INFO "Copyright (c) 2000-2003 " BLF_PRODUCT_COMPANY "\n" );
    printk( KERN_INFO "basp: module is built for " BLF_COMPILE_VERSION_SUPPORT
            BLF_COMPILE_SMP_SUPPORT "kernel " UTS_RELEASE "\n" );

    // register the management device
    rc = register_chrdev( BLF_DEVICE_MAJOR, "basp", &blf_mgmt_fops );
    if( rc < 0 )
    {
        printk( "basp: failed to register management device, "
                "error=%d\n", rc );
        printk( "basp: is character mode device %d used by other modules?\n",
                BLF_DEVICE_MAJOR );
        return rc;
    }

    else if( rc == 0 )
    {
        mgmt_major = BLF_DEVICE_MAJOR;
    }

    else
    {
        mgmt_major = rc;
    }

    printk( KERN_INFO "basp: installed successfully\n" );
    printk( KERN_INFO "basp: management major device number is %d\n", mgmt_major );

    // init the core
    blf_core_init( mgmt_major );

    return 0;
}

/****************************************************************************
 * blf_cleanup:
 *
 * driver cleanup
 *
 * Input;
 *      none
 *
 * Output:
 *      none
 *
 ****************************************************************************/
void
blf_cleanup(
    void
    )
{
    unregister_chrdev( mgmt_major, "basp" );

    // core cleanup
    blf_core_fini();

    printk( KERN_INFO BLF_PRODUCT_NAME " is unloaded\n" );
}

/****************************************************************************
 * blf_mgmt_ioctl
 *
 * management interface
 *
 * Input;
 *      none
 *
 * Output:
 *      none
 *
 ****************************************************************************/
int
blf_mgmt_ioctl(
    struct inode *inode,
    struct file* file,
    unsigned int cmd,
    unsigned long arg
    )
{
    if( !capable(CAP_NET_ADMIN) )
    {
        return -EPERM;
    }

    return blf_core_mgmt_ioctl( cmd, (void*)arg );
}

//
//
// Required functions for Linux modules
//
#ifdef MODULE

/****************************************************************************
 * init_module:
 *
 * Linux module initialization
 *
 * Input;
 *      none
 *
 * Output:
 *      none
 *
 ****************************************************************************/
int 
init_module(
    void
    )
{
    return blf_install();
}

/****************************************************************************
 * cleanup_module:
 *
 * Linux module removal clean-up
 *
 * Input;
 *      none
 *
 * Output:
 *      none
 *
 ****************************************************************************/
void 
cleanup_module(
    void
    )
{
#if (LINUX_VERSION_CODE < 0x020500)
    if( MOD_IN_USE )
    {
        printk( "basp: unable to unload because it is still in use.\n" );
    }

    else
#endif
    {
        blf_cleanup();
    }
}

void
pal_inc_usage(
    void
    )
{
#if (LINUX_VERSION_CODE < 0x020500)
    MOD_INC_USE_COUNT;
#endif
}

void
pal_dec_usage(
    void
    )
{
#if (LINUX_VERSION_CODE < 0x020500)
    MOD_DEC_USE_COUNT;
#endif
}

#else   // ! MODULE
void
pal_inc_usage(
    void
    )
{
}

void
pal_dec_usage(
    void
    )
{
}
#endif  // MODULE

MODULE_AUTHOR("Frankie Fan <ffan@broadcom.com>, " BLF_PRODUCT_COMPANY );
MODULE_DESCRIPTION(BLF_PRODUCT_NAME);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,10)
MODULE_LICENSE("Proprietary");
#endif // LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,10)

/****************************************************************************
 *  End of file
 ****************************************************************************/
