<html>
<!-- $RCSfile: MS-DACTL.TPL $ $Revision: 1.23 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Drive Array Controller Information</title>

<script language="JavaScript">
   writeAccess = (2 & <!cpqDaCntlrBlinkTime.access>) != 0;
   if (writeAccess) noAutoRefresh = 1;
</script>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqDaCntlrEntry>
<!cpqDaAccelEntry>
<!cpqDaCntlrPerfEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#DAENUMS.JS>
<!#MS-DACMN.JS>

function getIndex(form, CtlIndex)
{
   form.INDEX.value = parseInt(CtlIndex);
   return true;
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = 0;
cntlrIdx = findArg("index");

if (cntlrIdx == -1)
{
   parseArgs(tryPrevPage());
   cntlrIdx = findArg("index");
}
for (idx = 0; idx < cpqDaCntlrEntry.length; idx++)
{
   if (cpqDaCntlrEntry[idx].cpqDaCntlrIndex == cntlrIdx)
      break;
}
if (idx >= cpqDaCntlrEntry.length)
{
   reportMissingArgs();
}
else
{
   perfData = null;

   for (i = 0; i < cpqDaCntlrPerfEntry.length; i++)
   {
      if (cpqDaCntlrPerfEntry[i].cpqDaCntlrPerfCntlrIndex == cntlrIdx)
      {
         perfData = cpqDaCntlrPerfEntry[i];
         break;
      }
   }
   postfix["cpqDaCntlrPerfCpuPercentBusy"] = "%";
   postfix["cpqDaCntlrPerfCommandCount"]   = "/sec";
   postfix["cpqDaCntlrPerfAvgLatency"]     = "/10000 sec";

   writePageHead("Array Controller Information", "/WEBAGENT/IMAGES/MASSHDR.GIF", "Array Controller Information");
   thisCntlr = cpqDaCntlrEntry[idx];
   duplexed = false;

   if (typeof(cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != "undefined") &&
       cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != null &&
       cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != "")
   {
      duplexed = true;
   }
   cntlrCondition = new cpqCondition(cpqDaCntlrEntry[idx].cpqDaCntlrBoardCondition);
   writeTableLabel(cntlrCondition.image() + daCntlrBoardName(idx));
   writeTableHead();

   if (thisCntlr.cpqDaCntlrModel < 5)
   {
      // IDA controller, limited info in this table
      writeSingleTableRow("Model:",
         displayItem("cpqDaCntlrModel", thisCntlr.cpqDaCntlrModel));
      writeSingleTableRow("Firmware Version:",
         displayItem("cpqDaCntlrFWRev", thisCntlr.cpqDaCntlrFWRev));
   }
   else    // SMART controller
   {
      if (perfData == null)  // no perf data found for this controller
      {
         cpuUsage   = "N/A";
         cmdCount   = "N/A";
         cmdLatency = "N/A";
      }
      else
      {
         cpuUsage   = displayItem("cpqDaCntlrPerfCpuPercentBusy",
            perfData.cpqDaCntlrPerfCpuPercentBusy);
         cmdCount   = displayItem("cpqDaCntlrPerfCommandCount",
            perfData.cpqDaCntlrPerfCommandCount);
         cmdLatency = displayItem("cpqDaCntlrPerfAvgLatency",
            perfData.cpqDaCntlrPerfAvgLatency);
      }
      writeSingleTableRowInDoubleTable(
         "Model:", displayItem("cpqDaCntlrModel", thisCntlr.cpqDaCntlrModel));

      if (duplexed)
      {
         writeDoubleTableRow(
            "Controller Status:", displayItem("cpqDaCntlrBoardStatus", thisCntlr.cpqDaCntlrBoardStatus),
            "Redundancy Mode:",   displayItem("cpqDaCntlrRedundancyType", thisCntlr.cpqDaCntlrRedundancyType));
         writeDoubleTableRow(
            "Current Role:",     displayItem("cpqDaCntlrCurrentRole", thisCntlr.cpqDaCntlrCurrentRole),
            "Redundancy Error:", displayItem("cpqDaCntlrRedundancyError", thisCntlr.cpqDaCntlrRedundancyError));
      }
      writeDoubleTableRow(
         "Firmware Version:", thisCntlr.cpqDaCntlrFWRev,
         "CPU Usage:",        cpuUsage);
      writeDoubleTableRow(
         "Product Revision:", thisCntlr.cpqDaCntlrProductRev,
         "Command Count:",    cmdCount);
      writeDoubleTableRow(
         "Serial Number:",   displayItem("cpqDaCntlrSerialNumber", thisCntlr.cpqDaCntlrSerialNumber),
         "Command Latency:", cmdLatency);
      writeDoubleTableRow(
         "ADG Enabler Status:",  displayItem("cpqDaCntlrAccessModuleStatus", thisCntlr.cpqDaCntlrAccessModuleStatus),
         "Daughter Board Type:", displayItem("cpqDaCntlrDaughterBoardType", thisCntlr.cpqDaCntlrDaughterBoardType));
      writeDoubleTableRow(
         "Number of Ports:",  displayItem("cpqDaCntlrNumberOfBuses", thisCntlr.cpqDaCntlrNumberOfBuses),
         "", "");
   }
   writeTableTail();

   // Display accelerator information
   accelIdx = -1;
   for (i = 0; i < cpqDaAccelEntry.length; i++)
   {
      if (cpqDaAccelEntry[i].cpqDaAccelCntlrIndex == cntlrIdx &&
          cpqDaAccelEntry[i].cpqDaAccelStatus != 2)
      {
         accelIdx = i;
         break;
      }
   }
   if (accelIdx >= 0 && accelIdx < cpqDaAccelEntry.length)
   {
      thisAccel = cpqDaAccelEntry[accelIdx];
      thisAccelCondition = new cpqCondition(thisAccel.cpqDaAccelCondition);

      postfix["cpqDaAccelMemory"] = "KB";
      postfix["cpqDaAccelReadMemory"] = "KB";
      postfix["cpqDaAccelTotalMemory"] = "KB";

      if ((typeof(thisAccel.cpqDaAccelReadCachePercent) != "undefined") &&
          (thisAccel.cpqDaAccelReadCachePercent != MAXCOUNT))
      {
         readCache  = thisAccel.cpqDaAccelReadCachePercent  + "%";
         writeCache = thisAccel.cpqDaAccelWriteCachePercent + "%";
      } else {
         readCache  = displayItem("cpqDaAccelReadMemory", thisAccel.cpqDaAccelReadMemory);
         writeCache = displayItem("cpqDaAccelMemory", thisAccel.cpqDaAccelMemory);
      }
      document.write("<br>");
      writeTableLabel(thisAccelCondition.imageSmall()+"Accelerator", "Accelerator");
      writeTableHead();
      writeDoubleTableRow(
         "Status:",         displayItem("cpqDaAccelStatus", thisAccel.cpqDaAccelStatus),
         "Battery Status:", displayItem("cpqDaAccelBattery", thisAccel.cpqDaAccelBattery));
      writeDoubleTableRow(
         "Serial Number:", displayItem("cpqDaAccelSerialNumber", thisAccel.cpqDaAccelSerialNumber),
         "Read Errors:",   displayItem("cpqDaAccelReadErrs", thisAccel.cpqDaAccelReadErrs));
      writeDoubleTableRow(
         "Total Memory:",  displayItem("cpqDaAccelTotalMemory", thisAccel.cpqDaAccelTotalMemory),
         "Write Errors:",  displayItem("cpqDaAccelWriteErrs", thisAccel.cpqDaAccelWriteErrs));
      writeDoubleTableRow(
         "Read Cache:",  readCache,
         "Error Code:",  displayItem("cpqDaAccelErrCode", thisAccel.cpqDaAccelErrCode));
      writeDoubleTableRow(
         "Write Cache:", writeCache,
         "Bad Data:",    displayItem("cpqDaAccelBadData", thisAccel.cpqDaAccelBadData));
      writeTableTail();
   }

   if (thisCntlr.cpqDaCntlrBlinkTime != "" && thisCntlr.cpqDaCntlrBlinkTime < 4294967295)
   {
      document.write("<br>");
      writeTableLabel("Identify Drives");
      writeTableHead();
      if (thisCntlr.cpqDaCntlrBlinkTime > 1)
          imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'>";
       else
          imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRIVE.GIF' width='72' height='42' border='0'>";

      if (thisCntlr.cpqDaCntlrCurrentRole == 4)  // Backup
      {
         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small><font face='Arial'>Select the active controller to identify the drives ",
            "attached to this backup controller. Select <I>Help</I> for further information.",
            "</font></small></td></tr>");
      }
      else if (writeAccess)
      {
         actionStr = "MS-DACTL.TPL?index=" + cntlrIdx;
         if (thisCntlr.cpqDaCntlrBlinkTime > 1)
            document.write("<tr><form action='", actionStr, "' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisCntlr.cpqDaCntlrIndex);'>",
              "<input type='hidden' name='TABLESET' value='1'><input type='hidden' name='INDEX' value=''>",
              "<input type='hidden' name='cpqDaCntlrBlinkTime' value='1'><td align='center' width='50%'>",
              "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'></td>",
              "<td align='center'><input type='submit' value='Stop'></td></form></tr>");
         else  // Not blinking
            document.write("<tr><form action='", actionStr, "' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisCntlr.cpqDaCntlrIndex);'>",
              "<td align='center' width='50%'><input type='hidden' name='TABLESET' value='1'>",
              "<input type='hidden' name='INDEX' value=''><small><font face='Arial'>Blink Drive Lights </font></small>",
              "<select name='cpqDaCntlrBlinkTime'>",
              "<option value='600'>1 minute<option value='1200'>2 minutes<option value='1800'>3 minutes",
              "<option value='2400'>4 minutes<option value='3000' selected>5 minutes<option value='6000'>10 minutes",
              "<option value='12000'>20 minutes<option value='18000'>30 minutes<option value='24000'>40 minutes",
              "<option value='30000'>50 minutes<option value='36000'>1 hour</select></td>",
              "<td align='center'><input type='submit' value='Start'></td>",
              "</form></tr>");
      }
      else  // Read only
      {
         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small><font face='Arial'>Only an administrator or an operator can blink the drive lights ",
            "to identify the drives attached to the controller. Select <I>Help</I> for further information.",
            "</font></small></td></tr>");
      }
      writeTableTail();
   }
}
writeBodyTail();
</script>
</html>

