##################################################################
# Copyright 1997-2002, Compaq Information Technologies Group, L.P.
##################################################################
#
# Title   : $RCSfile: linux_rebuild.mk,v $
#
# Version : $Revision: 1.7.6.1 $
#
# Date    : $Date: 2003/03/03 21:45:24 $
#
##################################################################
CC = gcc 

OS_VERSION=$(shell uname -r)
OS_SYMBOL=1
OS_SMP=0

PROC_ENTRY=0

CRID_DAY_RAW=$(shell date +%-d)
CRID_DAY=$(shell expr $(CRID_DAY_RAW))
CRID_MONTH_RAW=$(shell date +%-m)
CRID_MONTH=$(shell expr $(CRID_MONTH_RAW))
CRID_YEAR_RAW=$(shell date +%-Y)
CRID_YEAR=$(shell expr $(CRID_YEAR_RAW) - 1990 )

EFS_VER=\"6.30.0\"

DEBUGFLAGS= -Wall
#-DDEBUG 

DFLAGS = -O -DOS_VERSION=$(OS_VERSION) -DEFS_VER=$(EFS_VER) -DDRV_DAY=$(CRID_DAY) -DDRV_MON=$(CRID_MONTH) -DDRV_YEAR=$(CRID_YEAR) -DOS_SYMBOL=$(OS_SYMBOL) -DLINUX -DPROC_ENTRY=$(PROC_ENTRY) 
IFLAGS=-I. 
CFLAGS = $(DFLAGS) $(IFLAGS) $(LINUX_HEADERS) $(DEBUGFLAGS) 

TARGET=cpqrid
TARGETDIR=.

OFILES = cpqridp.o cridw_linux.o cridw_proc.o

INCDIR = /lib/modules/$(OS_VERSION)/build/include
INCLUDE = -I$(INCDIR)

all:	install

build:	$(TARGET).o

install: build
	mkdir -p $(TARGETDIR)
	cp -af $(TARGET).o $(TARGETDIR) || /bin/true

cpqrid.o: $(OFILES)
	ld -r -o cpqrid.o $(OFILES)

cridw_proc.o: linux/cridw_proc.c 
	$(CC) $(CFLAGS) $(INCLUDE) -c  linux/cridw_proc.c

.c.o:
	$(CC) $(CFLAGS) $(INCLUDE) -c $<

clean:
	rm -f cridw_linux.o cridw_proc.o *~ core $(TARGET).o

touch:
	touch *.c

