#include "CpqCiHlx.h"

//#ifdef loops_per_jiffy
//#undef loops_per_jiffy
//#endif

#if LINUX_VERSION_CODE < 0x020300
void CpqCiUSleep(unsigned long usecs)
{
	udelay(usecs);
}
#else
/* Borrowed from arch/i386/lib/delay.c */
void CpqCiUSleep(unsigned long usecs)
{
        int xloops = usecs * 0x000010c6; /* 2**32 / 1000000 */
        unsigned long bclock, now;
        int d0;
        __asm__("mull %0"
                :"=d" (xloops), "=&a" (d0)
                :"1" (xloops),"0" (current_cpu_data.loops_per_jiffy));

        xloops *= HZ;
        rdtscl(bclock);
        do {
                schedule();
                rdtscl(now);
        } while((now-bclock) < xloops);
}
#endif
