############################################################################
#  Copyright (c) 2003, Hewlett Packerd Technologies Group, L. P.           #
############################################################################
#   PROGRAM: install.sh                                                    #
#   PURPOSE: Shell script for initiating the HP Linux Deployment Utility.  #
############################################################################

#DEBUG DEBUG DEBUG
# set -x

#################
##    LOCALE   ##
#################

LANG=ENG

#################
##   GLOBALS   ##
#################
# Change the pass number on this variable for each pass.
TARBALL=hppldu-1.0.0-4.tar.gz
LCKDIR=/var/lock/hppldu
PSE="ps -e"
INTR=0
DISTROS="2.1AS 7.3 8.0 9.0 SLES-7 1.0"

# Base kernel versions for each supported Linux Distro.
RHAS21="2.4.9-e.3"
RH73="2.4.18-3"
RH80="2.4.18-14"
RH90="2.4.20-2.21"
SuSE7="2.4.7"
UL10="2.4.19"

#################
##  FUNCTIONS  ##
#################

#Determine which OS this is, and setup the required directories accordingly.
SetupForOS()
{
    if [ -f /etc/redhat-release ]
	then
		RELFILE="/etc/redhat-release"
		export RPMDIR=/usr/src/redhat
        KERNELSRC=`uname -r | sed -e 's/enterprise//' -e 's/debug//' -e 's/[sS][mM][pP]//' -e 's/workstation//' -e 's/bigmem//' -e 's/summit//'`
  		export KERNELSRC=/usr/src/linux-`echo $KERNELSRC | tr -d '[A-Da-d][f-wF-WyYzZ]'`
		Version=`grep "[89]\.[0-9]" </etc/redhat-release`
		if [ ${#Version} -gt 0 ]
		then
	    	PSE="ps -em"
		fi
                rmdir $KERNELSRC 1>/dev/null 2>&1
		GetDistrVer
    fi
	if [ -f /etc/SuSE-release ]
	then
	    RELFILE="/etc/SuSE-release"
		export RPMDIR=/usr/src/packages
		export KERNELSRC=/usr/src/linux-`uname -r | sed -e 's/-[-0-9A-Za-z]*$//' -e 's/$/\.SuSE/'`
                rmdir $KERNELSRC 1>/dev/null 2>&1
		GetDistrVer
	fi
	if [ -f /etc/UnitedLinux-release ]
	then
		RELFILE="/etc/UnitedLinux-release"
		export RPMDIR=/usr/src/packages
		export KERNELSRC=/usr/src/linux-`uname -r | sed -e 's/-[-0-9A-Za-z]*$//' -e 's/$/\.SuSE/'`
                rmdir $KERNELSRC 1>/dev/null 2>&1
		GetDistrVer
	fi
}

# Function for ID'ing the Base Kernel Version.
GetDistrVer()
{
	BASEKRNL=""
	DST=0                 # Positional counter
	for i in $DISTROS     # List of Linux distributions
	do
		DST=`expr $DST + 1` 
                # Lets see which distribution we are running on.
		FOUND=`awk -v ver=${i} 'BEGIN {x=0} {if($0 ~ ver) ++x} END {print x}' ${RELFILE}`
		if [ $FOUND -gt 0 ]
		then
			case $DST in
			1) BASEKRNL=$RHAS21 ;;
			2) BASEKRNL=$RH73 ;;
			3) BASEKRNL=$RH80 ;;
			4) BASEKRNL=$RH90 ;;
			5) BASEKRNL=$SuSE7 ;;
			6) BASEKRNL=$UL10 ;;
			*) ;;
			esac
		fi
	done
	export BASEKRNL        # Move it to the environment.
	return
}

# Function for cleaning up the work area.
cleanup()
{
# Capture the return code from the application.
  RC=`echo $?`
# Remove the lock.
  if [ -d $LCKDIR -a ${INTR} -eq 1 ]
  then
     rmdir $LCKDIR >/dev/null 2>&1
  fi
# See if we need to cleanup any Remote Access mounts/directories.
  MTD=`mount | grep $KERNELSRC 2>/dev/null`
  if [ -n "$MTD" ]
  then
	umount $KERNELSRC 1>/dev/null 2>&1
  	if [ -d $KERNELSRC ]
  	then
		rmdir $KERNELSRC 1>/dev/null 2>&1
  	fi
  fi
# Did we have to copy the files to a /tmp directory?
# If so, we need to clean it up, or just cleanup here.
  if [ -d /tmp/hppldu ]
  then
     cd /tmp
     rm -rf hppldu >/dev/null 2>&1
  else
     rm -f hppldu >/dev/null 2>&1
     rm -f hpplduparserss >/dev/null 2>&1
     rm -f hppldupctss >/dev/null 2>&1
     rm -f hppldusecurityss >/dev/null 2>&1
     rm -f hpplduioss >/dev/null 2>&1
     rm -f hppldudepchkss >/dev/null 2>&1
     rm -f hpplduinstallerss >/dev/null 2>&1
     rm -f hppldurpminstallerss >/dev/null 2>&1
     rm -f hpplduverchkdbss >/dev/null 2>&1
     rm -f hppldu.conf >/dev/null 2>&1
     rm -f libcpqlsp* >/dev/null 2>&1
     rm -f /usr/lib/libcpqlsptransport.* >/dev/null 2>&1
  fi
# Clear the environment.
  unset HPLSPINSTALL KERNELSRC RPMDIR BASEKRNL
# Move to the original working directory.
  cd $ODIR
# Double check to ensure the lock is removed.
  if [ -d ${LCKDIR} -a ${INTR} -eq 1 ]
  then
	rm -rf ${LCKDIR}
  fi
# Echo message, if any, to user.
  if [ -n "$1" ]
  then
	echo -e "$1"
  fi
# Clear the traps.
  trap '' 2 3 15
# Then return.
  return
}

# Function for killing all hppldu processes.
killer()
{
    # Identify all our appl processes.
    PIDs=`${PSE}|grep hppldu|awk '{print $1}'|sort -r`
    # Now kill them one at a time. (use SIGKILL to make sure)
    for k in $PIDs
    do
        kill -9 $k >/dev/null 2>&1
    done
    return
}

# Function for catching a user interrupt, then
# terminate our application.
interrupt()
{
    # Call killer to terminate all hppldu processes.
    killer
    # Set the interrupt flag.
    INTR=1
    # Call the cleanup crew.
    cleanup "$1"
    # Make sure we have killed all the processes.
    killer
    # Restore the user's terminal.
    stty echo >/dev/null 2>&1
    tput cnorm >/dev/null 2>&1
    # and, get out!
    exit $RC
}


###################################
##                               ##
##          M A I N              ##
##                               ##
###################################
# Lets make verify that 'superuser' is running this appl.
if [ `id -u` -eq 0 ]
then
  # Set some traps.
  trap 'interrupt "\nTerminated!\n"' 2
  trap 'cleanup ""' 1 3 15
  # Which Distr. of Linux are we on.
  SetupForOS
  # We need to store the current working directory.
  ODIR=$PWD
  # Determine the path to our executables, and move there.
  RDIR=`dirname $0`
  cd $RDIR
  # Are we in a Read-Only directory?  If so, we must
  # move our files to one with write permission.
  RO=`df $RDIR | grep -v Available | awk '{print $4}'`
  if [ $RO -eq 0 ]
  then
      RO=`df /tmp | grep -v Available | awk '{print $4}'`
      if [ $RO -gt 50000 ]
      then
          echo -e "\n\nBecause of Read-Only media, we are copying files to a work location..."
          mkdir -p /tmp/hppldu >/dev/null 2>&1
          if [ $? -ne 0 ]
          then
              echo -e "\n\nUnable to create a working directory in /tmp."
              echo -e "Verify, or set, the /tmp permissions, and re-run."
	      exit
	  fi
          /bin/cp -f ./* /tmp/hppldu/
          cd /tmp/hppldu
      else
          echo -e "\n\nThere is inadequate disk space available in /tmp to execute this application."
          exit
      fi
  fi
  # Now setup a lock, so that we only allow one instance of
  # then application to run at a time.
  if [ ! -d ${LCKDIR} ]
  then
	mkdir -p $LCKDIR
  else
        INTR=0
        cleanup "\nOnly one instance of the HP Proliant Deployment Utility for Linux\nmay run at a time.\n"
        exit 22   # Exit Code = LSP_APPLICATION_ALREADY_RUNNING
  fi
  # Well we finally got thru all the preliminaries, so now
  # we can get down to business.
  # Setup the execution environment. 
  tar zxf ${TARBALL} >/dev/null
  ln -sf libcpqlsptransport.so.0.0 libcpqlsptransport.so.0 >/dev/null 2>&1
  ln -sf libcpqlsptransport.so.0 libcpqlsptransport.so >/dev/null 2>&1
  cp libcpqlsptransport.so.0.0 /usr/lib/ >/dev/null 2>&1
  /sbin/ldconfig >/dev/null 2>&1
  HPLSPINSTALL=TRUE
  export HPLSPINSTALL
  # And kick off the Application.
  ./hppldu "$@" 
  
  # We are finished, so call the cleanup crew.
  INTR=1
  cleanup ""
else
  INTR=1
  cleanup "\n'root' access is required to run the HP Deployment Utility for Linux.\n"
fi
exit $RC
