#!/bin/bash
# ##################################################################
# ### copyright 2002 Compaq Information Technologies Group, L.P. ###
# ##################################################################

OS_SMP=`uname -a | grep SMP`
OS_ENT=`uname -r | grep enterprise`

echo "Starting Custom Installation Process  . . ." 
if [ ${#OS_SMP} -eq 0 ]; then
	echo "Installation detected single processor Linux kernel."
	CPQEVT=/lib/modules/Compaq/drivers/up/cpqevt.o
else
	if [ ${#OS_ENT} -eq 0 ]; then
		echo "Installation detected SMP Linux kernel."
		CPQEVT=/lib/modules/Compaq/drivers/smp/cpqevt.o
	else
		echo "Installation detected Enterprise Linux kernel."
		CPQEVT=/lib/modules/Compaq/drivers/ent/cpqevt.o
	fi
fi

echo "Installing ${CPQEVT}  . . ." 
cp /opt/compaq/cpqhealth/cpqevt/cpqevt.o ${CPQEVT}


if [ ${#OS_SMP} -eq 0 ]; then
	CPQASM=/lib/modules/Compaq/drivers/up/cpqasm.o
else
	if [ ${#OS_ENT} -eq 0 ]; then
		CPQASM=/lib/modules/Compaq/drivers/smp/cpqasm.o
	else
		CPQASM=/lib/modules/Compaq/drivers/ent/cpqasm.o
	fi
fi

echo "Installing ${CPQASM}  . . ." 
cp /opt/compaq/cpqhealth/cpqasm/cpqasm.o ${CPQASM}

echo "Custom Installation Process Complete . . ." 

