#!/bin/bash
# ##################################################################
# ### copyright 2002 Compaq Information Technologies Group, L.P. ###
# ##################################################################

# ********************************************************
# ** log_msg                                            **
# ********************************************************
# ** This routine will log a message to the screen and  **
# ** to our error log.                                  **
# ********************************************************
function log_msg() {
   echo "$*" >> /opt/compaq/cpqhealth/cpqhealth_boot.log 
   echo "$*"
}


# ********************************************************
# ** MAIN                                               **
# ********************************************************
# ** This is the main routine of the shell script       **
# ********************************************************

MY_DATE=`date`
THIS_KERNEL=`uname -r`
CPQEVT=/opt/compaq/cpqhealth/cpqevt/${THIS_KERNEL}/cpqevt.o

if [ ! -d /opt/compaq/cpqhealth/cpqevt/${THIS_KERNEL} ]
then
   log_msg "Creating directory \"/opt/compaq/cpqhealth/cpqevt/${THIS_KERNEL}\" "
   mkdir -p /opt/compaq/cpqhealth/cpqevt/${THIS_KERNEL} 
fi

log_msg "Replacing ${CPQEVT} at ${MY_DATE} . . ."
cp cpqevt.o ${CPQEVT}

log_msg "Custom cpqevt Driver installed  . . ."

log_msg "Reloading the hp ProLiant Advanced Server Management Event module . . ."
if eval "insmod -p ${CPQEVT}" >>/opt/compaq/cpqhealth/cpqhealth_boot.log 2>&1

then 
	/sbin/insmod ${CPQEVT} >>/opt/compaq/cpqhealth/cpqhealth_boot.log 2>&1
	log_msg " "
	log_msg "The hp ProLiant Advanced Server Management Event module (cpqevt.o) has rebuilt"
	log_msg "and has loaded successfully."
	log_msg " "
	exit 0 
else
	echo -e "\n"
	log_msg "WARNING!  The hpasm RPM is not compatible with this kernel."
	log_msg "          See /opt/compaq/cpqhealth/cpqhealth_boot.log for details."
	log_msg "          Hint:  Look for Compiler or Linker issues."
	exit 1 
fi

