 
#!/bin/sh
# ##################################################################
# ### copyright 2002 Compaq Information Technologies Group, L.P. ###
# ##################################################################
# ## cpqasm_mknod.sh                                              ##
# ##################################################################
# ## This module will create the /dev node files for the cpqasm   ##
# ## driver.  This MUST be called AFTER the cpqasm driver has     ##
# ## been "insmod" into the kernel.                               ##
# ##################################################################

MODULE="cpqasm"

# remove stale nodes
rm -f /dev/cpqhealth/casm
rm -f /dev/casm
rm -f /dev/cpqhealth/casr
rm -f /dev/casr
rm -f /dev/cpqhealth/cecc
rm -f /dev/cecc
rm -f /dev/cpqhealth/ccsm
rm -f /dev/ccsm
rm -f /dev/cpqhealth/cmca
rm -f /dev/cmca
rm -f /dev/cpqhealth/cside
rm -f /dev/cside
rm -f /dev/cpqhealth/cevt
rm -f /dev/cevt
rm -f /dev/cpqhealth/cpci
rm -f /dev/cpci
rm -f /dev/cpqhealth/cdt
rm -f /dev/cdt
rm -f /dev/cpqhealth/cpqw
rm -f /dev/cpqw
rm -f /dev/cpqhealth/crom
rm -f /dev/crom
rm -f /dev/cpqhealth/cwell
rm -f /dev/cwell
rm -f /dev/cpqhealth/cpqevt
rm -f /dev/cpqevt
rm -f /dev/cpqhealth/cmhp
rm -f /dev/cmhp

major=`awk "\\$2==\"$MODULE\" {print \\$1}" /proc/devices`

#
# Make new nodes with updated major number
#
mkdir -p /dev/cpqhealth
mknod /dev/casm c $major 0
mknod /dev/cpqhealth/casm c $major 0
mknod /dev/casr c $major 1
mknod /dev/cpqhealth/casr c $major 1
mknod /dev/cecc c $major 2
mknod /dev/cpqhealth/cecc c $major 2
mknod /dev/ccsm c $major 3
mknod /dev/cpqhealth/ccsm c $major 3
mknod /dev/cmca c $major 4
mknod /dev/cpqhealth/cmca c $major 4
mknod /dev/cside c $major 5
mknod /dev/cpqhealth/cside c $major 5
mknod /dev/cevt c $major 6
mknod /dev/cpqhealth/cevt c $major 6
mknod /dev/cpci c $major 7
mknod /dev/cpqhealth/cpci c $major 7
mknod /dev/cdt c $major 8
mknod /dev/cpqhealth/cdt c $major 8
mknod /dev/cpqw c $major 9
mknod /dev/cpqhealth/cpqw c $major 9
mknod /dev/crom c $major 10
mknod /dev/cpqhealth/crom c $major 10
mknod /dev/cwell c $major 11
mknod /dev/cpqhealth/cwell c $major 11

major=`awk "\\$2==\"cevt\" {print \\$1}" /proc/devices`
mknod /dev/cpqevt c $major 0
mknod /dev/cpqhealth/cpqevt c $major 0

major=`awk "\\$2==\"cmhp\" {print \\$1}" /proc/devices`
if [ ! -z "${major}" ]; then
   mknod /dev/cmhp c $major 0
   mknod /dev/cpqhealth/cmhp c $major 0
fi
