PreLoadImage("onImage", "./Images/connected.gif");
PreLoadImage("offImage", "./Images/notconnected.gif");

function SSPAccessReferenceArrayInit(form)
  {
  sspAccessReferenceArray = new Array();
  for (var i=0; i<numChoices; ++i)
    {
    sspAccessReferenceArray[i] = form.elements[i];
    }
  }

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// TOGGLE SSP ACCESS COMMAND <f>    
//
function ToggleSSPAccessCommand( i )
   {
   accessCommand = offcommand;
   haIndex = i*2;
   if ( document.sspTable.elements[haIndex].checked )
      {
      accessCommand = command;
      }
   sspAccessReferenceArray[i].name = accessCommand;
   }
   
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// VALIDATE ALL SSP CONNECTION NAMES <f>    
//
function ValidateAllSSPConnectionNames()
   {
   isOK = true;
   
   for ( i = 0; (i < numChoices) && isOK; ++i )
      {
      cnIndex = (i*2) + 1;
      isOK = ValidateSSPConnectionName(document.sspTable.elements[cnIndex]);
      }

   return isOK;   
   }
   
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// VALIDATE SSP CONNECTION NAME <f>    
//
function ValidateSSPConnectionName( item )   
   {
   isOK = false;

   var pattern = new RegExp("[^a-zA-Z0-9 !@#\*_\(\)\+\\:\.\/,\-]+");

   if ( !pattern.test(item.value) )
      {
      isOK = true;
      var pattern2 = new RegExp("[a-zA-Z0-9 !@#\*_\(\)\+\\:\.\/,\-]+");
      if ( !pattern2.test(item.value) )
         {
         item.value = "";
         }
      }
   
   if ( !isOK )
      {
      alert(invalidConnectionNameString);
      }

   return isOK;   
   }
   

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// VALIDATE SSP HOST ACCESS <f>
//   
function ValidateSSPHostAccess()
   {
   isOK = true;
   numChecked = 0;
   
   for( i = 0; i < numChoices; ++i )
      {
      // Does the connection have access?
      if ( document.sspTable.elements[i*2].checked )
         {
         ++numChecked;
         }                  
      }      

     if ( numChecked == 0 )
        {
        isOK = confirm( noCheckedConnectionsString );
        }
                     
     return isOK; 
     }
            

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// SSP CONNECTION NAME TEXT FROM <f>    
//
function sspConnectionNameTextFrom( str )
   {
   str = RemoveTrailingSpacesFrom( str );
   if ( str == "" )
      {
      str = unknownString;
      }
   return str;
   }
   
function SSPConnNameReferenceArrayInit(form)
  {
  sspConnNameReferenceArray = new Array();
  for (var i=0; i < numChoices; ++i)
    {
    hbaFocusIndex = i*2 + numChoices;
    connectionNameIndex = hbaFocusIndex + 1;
    sspConnNameReferenceArray[i] = new Object();
    sspConnNameReferenceArray[i].hbaFocus = document.next.elements[hbaFocusIndex];
    sspConnNameReferenceArray[i].connName = document.next.elements[connectionNameIndex];
    }
  }

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// TOGGLE SSP CONNECTION NAME COMMAND <f>    
//      
function ToggleSSPConnectionNameCommand( i )
   {      
   cnIndex = (i*2) + 1;
   var cnItem = document.sspTable.elements[cnIndex];
   connectionNameCommand = editcommand;
   connectionNameValue = cnItem.value;

   cnItem.value = sspConnectionNameTextFrom( cnItem.value );

   if ( cnItem.value == unknownString )
      {
      connectionNameCommand = deletecommand;
      connectionNameValue = "DEFAULT";
      }
   else
      {
      connectionNameValue = "*" + connectionNameValue;
      }
   sspConnNameReferenceArray[i].hbaFocus.name = sspConnNameReferenceArray[i].hbaFocus.name;
   sspConnNameReferenceArray[i].hbaFocus.value = sspConnNameReferenceArray[i].hbaFocus.value;
   sspConnNameReferenceArray[i].connName.name = connectionNameCommand;
   sspConnNameReferenceArray[i].connName.value = connectionNameValue;
   }

// ~~~~~~~~~~~~~~~~~
// SSP IMAGE FOR <f>    
//   
function SSPImageFor( item )
   {
   image = offImage.src;
   if ( item.checked )
      {
      image = onImage.src;
      }
   return image;
   }   
   
// ~~~~~~~~~~~~~~~~~~~~
// TOGGLE SSP IMAGE <f>    
//   
function ToggleSSPImage( i )
   {   
   haIndex = i*2;
   if ( document.sspTable.elements[haIndex].checked )
      {
      document.images[i].src = onImage.src;
      }
   else
      {
      document.images[i].src = offImage.src;
      }
   }

// ~~~~~~~~~~~~~~~~~~~~~
// DISPLAY SSP TABLE <f>    
//
function DisplaySSPTable() 
   {
   document.write("<table width=100% border=1 cellpadding=2 ");
   document.write("cellspacing=0 id=sspTable>");
   
   document.write("<tr align=center id=sspTableHeader>");   
       document.write("<td width=10% id=sspTableHeader>");
       document.write(accessString);
       document.write("</td>");

       document.write("<td width=25% id=sspTableHeader>");
       document.write(connectionNameString);
       document.write("</td>");

       document.write("<td width=25% id=sspTableHeader>");
       document.write(adapterIDString);
       document.write("</td>");

       document.write("<td width=20% id=sspTableHeader>");
       document.write(locationString);
       document.write("</td>");

       document.write("<td width=20% id=sspTableHeader>");
       document.write(statusString);
       document.write("</td>");
   document.write("</tr>");
        
   for (var i = 0; i < numChoices; ++i)
      {        
      document.write("<tr valign=center align=center id=sspTableEntry>");
      document.write("<td width='10%' nowrap>");
                                                        
      document.write("<input type='checkbox' value=''");
        
      if (option[i].checked)
         {
         document.write(" checked ");
         }
      document.write("id='" + i + "'");
      document.write(" onclick=\"ToggleSSPImage(" + i + "); ToggleSSPAccessCommand(" + i + ")\";>");
      document.write("<IMG name='sspImage'" + i + " SRC=" + SSPImageFor(option[i]) + " align=absmiddle>" );
      document.write("</td>");

      document.write("<td width='25%'>");
      document.write("<input type='text' name='");
      document.write(editcommand);
      document.write("' value='");
      document.write(sspConnectionNameTextFrom( option[i].editText) );
      document.write("' id='" + i + "' ");
      document.write("SIZE='" + option[i].maxConnectionNameLength + "' ");
      document.write("MAXLENGTH='" + option[i].maxConnectionNameLength + "' ");
      document.write("onFocus='EnableKeysForInput();' ");
      document.write("onBlur='ToggleSSPConnectionNameCommand(" + i + "); DisableKeysForInput();' ");
      document.write(">");
      document.write("</td>");

      document.write("<td width='25%'>");
      document.write("<font face='Courier New'>");
      document.write(InsertParmsInString(option[i].wwn));
      document.write("</td>");                

      document.write("<td width='20%'>");
      document.write(InsertParmsInString(option[i].location));
      document.write("</td>");                

      document.write("<td width='20%'>");
      document.write(InsertParmsInString(option[i].status));
      document.write("</td>");                

      document.write("</tr>");
      }
   document.write("</table>");
   }

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// DISPLAY SSP V2 NEW GUI TABLE <f>    
//
function DisplayAVSPV2NewGUI() 
   {
    document.write("<TABLE width=100%  border=0 cellpadding=0 cellspacing=0 align=center >");
    document.write("<TR width=100% id=configtableHead>");
    document.write("<TD id=configtableHead align=left valign=top><IMG src='./Images/top_left_trans.gif'></TD>");
    document.write("<TD id=configtableHead align=center nowrap>");
    WriteString("PX_TAG_UB_SPV2_02_TEXT");
    document.write("</TD>");
	 document.write("<TD id=configtableHead align=right valign=top><IMG src='./Images/top_right_trans.gif'></TD>");
    document.write("</TR>");
    //document.write("</TABLE>");
   }


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// DISPLAY STANDARD SSP V2 TABLE <f>    
//
function DisplayStandardSSPv2Table() 
   {
   document.write("<TR id=configtable>");
   document.write("<TD id=configtable colspan=3>&nbsp;</TD>");
   document.write("</TR>");
   //document.write("</TABLE>");
   document.write("<TR id=configtable>");
   document.write("<TD id=configtable >&nbsp;</TD>");
   document.write("<TD id=configtable >");
   document.write("<table border=1 cellpadding=4 ");
   document.write("cellspacing=0 id=sspTable align=center>");

   document.write("<tr id=sspTableHeader align=center>");
   if ( controllerHasHostMode )
   {  
    numColumns = numLogicalDrives + 4; //changed to 4 to allow Host Modes combo box
   }
   else
   {
    numColumns = numLogicalDrives + 3; //no Host Modes
   
   }
   document.write("<td id=sspTableHeader colspan=" + numColumns + ">");
   WriteString("PX_TAG_SSP_SETTINGS2");
   document.write("</td>");
   document.write("</tr>");

   document.write("<tr align=center>");
   if ( controllerHasHostMode )
   {
    document.write("<td id=sspTableHeaderSmall align=center colspan=4>"); //changed colspan to 4 to allow for Host Modes combo box
   }
   else
   {
    document.write("<td id=sspTableHeaderSmall align=center colspan=3>"); //colspan when no Host Modes
   }
   WriteString("PX_TAG_SSP_HBA");
   document.write("</td>");
   document.write("<td id=sspTableHeaderSmall align=center colspan=" + numLogicalDrives + ">");
   WriteString("PX_TAG_LOGICAL_DRIVE");
   document.write("</td>");
   document.write("</tr>");

   document.write("<tr id=sspTableHeaderSmall align=center>");
   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_SSP_ADAPTER_ID");
   document.write("</td>");

   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_SSP_DETAILS");
   document.write("</td>");

   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_SSP_CONNECTION_NAME");
   document.write("</td>");

   if ( controllerHasHostMode )                   //make new column if Host Modes supported
   {
   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_HOST_MODE");
   document.write("</td>");
   }

   for ( var i=0; i < numLogicalDrives; ++i )
      {
      document.write("<td id=sspTableHeaderSmall align=center>" + hbaOptions[logicalDrive[i]].ldriveId + "</td>");
      }

   document.write("</tr>");

   for ( var i=0; i < numChoices; ++i )
     {
     document.write("<tr id=sspTableEntry align=center>");

     document.write("<td id=sspTableEntry align=center>");
     document.write(option[i].wwn);
     document.write("</td>");

     document.write("<td id=sspTableEntry align=center nowrap>");
     document.write("<DIV align=left id=sspTableEntrySmall nowrap>");
     document.write("<B>");
     WriteString("PX_TAG_SSP_LOCATION_LABEL");
     document.write("</B>");
     document.write(option[i].location);
     document.write("</DIV>");
     document.write("<DIV align=left id=sspTableEntrySmall nowrap>");
     document.write("<B>");
     WriteString("PX_TAG_SSP_STATUS_LABEL");
     document.write("</B>");
     document.write(option[i].status);
     document.write("</td>");

     document.write("<td id=sspTableEntry align=center>");
     document.write("<input type='text' name='");
     document.write(editcommand);
     document.write("' value='");
     document.write(sspConnectionNameTextFrom( option[i].editText) );
     document.write("' id='" + i + "' ");
     document.write("SIZE='" + option[i].maxConnectionNameLength + "' ");
     document.write("MAXLENGTH='" + option[i].maxConnectionNameLength + "' ");
     document.write("onFocus='EnableKeysForInput();' ");
     document.write("onBlur='ToggleSSPv2ConnectionNameCommand(" + i + ", this); DisableKeysForInput();' ");
     document.write(">");
     document.write("</td>");


     if ( controllerHasHostMode ) // Add Host Mode select box information here
     {
      document.write("<td id=sspTableEntry align=center>");

     //dynamcially name each select for each HBA    
     document.write("<select name='HostMode" + i + "' onChange='ToggleSSPv2HostMode(" + i + ", this)' >");
     
     //write out option list for total number of available host modes for HBA
     for ( var h=0; h < option[i].numHostModeChoices; ++h)
     { 
     
      if( option[i].hostModes[h] == option[i].currentHostMode)
       {
        document.write("<option   value='" + option[i].hostModes[h] + "' SELECTED >" + option[i].hostModes[h]);
        document.write("</option>"); 
       }
      else
       {       
       document.write("<option   value='" + option[i].hostModes[h] + "' >" + option[i].hostModes[h]);
       document.write("</option>"); 
       }             
     }
     
     document.write("</select>");
      
     if (option[i].currentHostMode == "") 
       {
       option[i].currentHostMode = "Default";
       }   
    SelectOptionWithValue( (eval("document.sspTable.HostMode" + i + "")), option[i].currentHostMode);

     document.write("</td>");
     }


     for ( var j=0; j < numLogicalDrives; ++j )
        {
        document.write("<td id=sspTableEntry align=center>");
        document.write("<input type=checkbox value='' ");
        if (hbaOptions[logicalDrive[j]][i].checked)
           {
           document.write(" checked ");
           }
        checkboxId = (i * numLogicalDrives) + j;
        document.write("id='" + checkboxId + "'");
        document.write(" onclick=\"ToggleSSPv2AccessCommand(" + i + ", " + j + ", this.checked )\";>");
        document.write("</td>");
        }

     document.write("</tr>"); 
     }
   
   document.write("</table>");
   document.write("</TD>");
   document.write("<TD id=configtable >&nbsp;</TD>");
   document.write("</TR>");
   //document.write("</TABLE>");
   
   
   }

// ~~~~~~~~~~~~~~~~~~~~~~~~
// DISPLAY SSP V2 TABLE <f>    
//
function DisplaySSPv2Table() 
   {
   
   document.write("<table border=1 cellpadding=4 ");
   document.write("cellspacing=0 id=sspTable align=center>");

   document.write("<tr id=sspTableHeader align=center>");
   if ( controllerHasHostMode )
   {  
    numColumns = numLogicalDrives + 4; //changed to 4 to allow Host Modes combo box
   }
   else
   {
    numColumns = numLogicalDrives + 3; //no Host Modes
   
   }
   document.write("<td id=sspTableHeader colspan=" + numColumns + ">");
   WriteString("PX_TAG_SSP_SETTINGS2");
   document.write("</td>");
   document.write("</tr>");

   document.write("<tr align=center>");
   if ( controllerHasHostMode )
   {
    document.write("<td id=sspTableHeaderSmall align=center colspan=4>"); //changed colspan to 4 to allow for Host Modes combo box
   }
   else
   {
    document.write("<td id=sspTableHeaderSmall align=center colspan=3>"); //colspan when no Host Modes
   }
   WriteString("PX_TAG_SSP_HBA");
   document.write("</td>");
   document.write("<td id=sspTableHeaderSmall align=center colspan=" + numLogicalDrives + ">");
   WriteString("PX_TAG_LOGICAL_DRIVE");
   document.write("</td>");
   document.write("</tr>");

   document.write("<tr id=sspTableHeaderSmall align=center>");
   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_SSP_ADAPTER_ID");
   document.write("</td>");

   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_SSP_DETAILS");
   document.write("</td>");

   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_SSP_CONNECTION_NAME");
   document.write("</td>");

   if ( controllerHasHostMode )                   //make new column if Host Modes supported
   {
   document.write("<td id=sspTableHeaderSmall>");
   WriteString("PX_TAG_HOST_MODE");
   document.write("</td>");
   }

   for ( var i=0; i < numLogicalDrives; ++i )
      {
      document.write("<td id=sspTableHeaderSmall align=center>" + hbaOptions[logicalDrive[i]].ldriveId + "</td>");
      }

   document.write("</tr>");

   for ( var i=0; i < numChoices; ++i )
     {
     document.write("<tr id=sspTableEntry align=center>");

     document.write("<td id=sspTableEntry align=center>");
     document.write(option[i].wwn);
     document.write("</td>");

     document.write("<td id=sspTableEntry align=center nowrap>");
     document.write("<DIV align=left id=sspTableEntrySmall nowrap>");
     document.write("<B>");
     WriteString("PX_TAG_SSP_LOCATION_LABEL");
     document.write("</B>");
     document.write(option[i].location);
     document.write("</DIV>");
     document.write("<DIV align=left id=sspTableEntrySmall nowrap>");
     document.write("<B>");
     WriteString("PX_TAG_SSP_STATUS_LABEL");
     document.write("</B>");
     document.write(option[i].status);
     document.write("</td>");

     document.write("<td id=sspTableEntry align=center>");
     document.write("<input type='text' name='");
     document.write(editcommand);
     document.write("' value='");
     document.write(sspConnectionNameTextFrom( option[i].editText) );
     document.write("' id='" + i + "' ");
     document.write("SIZE='" + option[i].maxConnectionNameLength + "' ");
     document.write("MAXLENGTH='" + option[i].maxConnectionNameLength + "' ");
     document.write("onFocus='EnableKeysForInput();' ");
     document.write("onBlur='ToggleSSPv2ConnectionNameCommand(" + i + ", this); DisableKeysForInput();' ");
     document.write(">");
     document.write("</td>");


     if ( controllerHasHostMode ) // Add Host Mode select box information here
     {
      document.write("<td id=sspTableEntry align=center>");

     //dynamcially name each select for each HBA    
     document.write("<select name='HostMode" + i + "' onChange='ToggleSSPv2HostMode(" + i + ", this)' >");
     
     //write out option list for total number of available host modes for HBA
     for ( var h=0; h < option[i].numHostModeChoices; ++h)
     {        
      document.write("<option   value='" + option[i].hostModes[h] + "' >" + option[i].hostModes[h]);
       document.write("</option>");              
      }
     
     document.write("</select>");
      
     if (option[i].currentHostMode == "") 
       {
       option[i].currentHostMode = "Default";
       }   
    SelectOptionWithValue( (eval("document.sspTable.HostMode" + i + "")), option[i].currentHostMode);

     document.write("</td>");
     }


     for ( var j=0; j < numLogicalDrives; ++j )
        {
        document.write("<td id=sspTableEntry align=center>");
        document.write("<input type=checkbox value='' ");
        if (hbaOptions[logicalDrive[j]][i].checked)
           {
           document.write(" checked ");
           }
        checkboxId = (i * numLogicalDrives) + j;
        document.write("id='" + checkboxId + "'");
        document.write(" onclick=\"ToggleSSPv2AccessCommand(" + i + ", " + j + ", this.checked )\";>");
        document.write("</td>");
        }

     document.write("</tr>"); 
     }
   
   document.write("</table>");
      
   
   }


function SSPv2ConnNameReferenceArrayInit(form)
  {
  sspConnNameReferenceArray = new Array();
  for (var i=0; i < numChoices; ++i)
    {
     if ( controllerHasHostMode )
     {
      
      hbaFocusIndex = (i*3) + 1; // new offset with HostMode
      connectionNameIndex = hbaFocusIndex + 1;
      hostModeNameIndex = connectionNameIndex + 1; // added Host mode
      sspConnNameReferenceArray[i] = new Object();
      sspConnNameReferenceArray[i].hbaFocus = document.next.elements[hbaFocusIndex];
      sspConnNameReferenceArray[i].connName = document.next.elements[connectionNameIndex];
      sspConnNameReferenceArray[i].hostMode = document.next.elements[hostModeNameIndex]; // added Host Mode
     }
     else
     {
      hbaFocusIndex = (i*2) + 1;
      connectionNameIndex = hbaFocusIndex + 1;
      sspConnNameReferenceArray[i] = new Object();
      sspConnNameReferenceArray[i].hbaFocus = document.next.elements[hbaFocusIndex];
      sspConnNameReferenceArray[i].connName = document.next.elements[connectionNameIndex];
    
     }
    }
  }

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// TOGGLE SSP V2 CONNECTION NAME COMMAND <f>
//      
function ToggleSSPv2ConnectionNameCommand( i, item )
   { 
   connectionNameCommand = editcommand;
   item.value = sspConnectionNameTextFrom( item.value );

   if ( item.value == unknownString )
      {
      connectionNameCommand = deletecommand;
      connectionNameValue = "DEFAULT";
      }
   else
      {
      connectionNameValue = "*" + item.value;
      }
         
   sspConnNameReferenceArray[i].hbaFocus.name = sspConnNameReferenceArray[i].hbaFocus.name;
   sspConnNameReferenceArray[i].hbaFocus.value = sspConnNameReferenceArray[i].hbaFocus.value;
   sspConnNameReferenceArray[i].connName.name = connectionNameCommand;
   sspConnNameReferenceArray[i].connName.value = connectionNameValue;

   if (controllerHasHostMode)
      {
       sspConnNameReferenceArray[i].hostMode.name = sspConnNameReferenceArray[i].hostMode.name;
      if ( sspConnNameReferenceArray[i].hostMode.value != LoadString("PX_TAG_HOST_UNKNOWN") )
       {
        sspConnNameReferenceArray[i].hostMode.value = sspConnNameReferenceArray[i].hostMode.value;
       }
       else
       {
       sspConnNameReferenceArray[i].hostMode.value = "*" + "";    //make sure sending empty string when Host Unknown
       }
      }
   
   }

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// VALIDATE ALL SSP V2 CONNECTION NAMES <f>
//
function ValidateAllSSPv2ConnectionNames()
   {
   isOK = true;
   
   for ( i = 0; (i < numChoices) && isOK; ++i )
      {
      isOK = ValidateSSPConnectionName(sspConnNameReferenceArray[i].connName);
      }
   if ( isOK )   //Connection is Valid
   {
     if ( controllerHasHostMode ) //only do if HostMode is supported
     {
      for ( i = 0; (i < numChoices) && isOK; ++i )
      {
       isOK = ValidateSSPConnectionNameHostModeCombo(sspConnNameReferenceArray[i].connName, sspConnNameReferenceArray[i].hostMode );
      }
     }
   }

   return isOK;   
   }

   // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// VALIDATE SSP CONNECTION NAME AND HOST MODE COMBOS <f>    
//
function ValidateSSPConnectionNameHostModeCombo( item , item2)   
   {
   isOK = false;
   
   if ( ( item.value == "" ) || ( item.value == "DEFAULT" ) )
   {
    compareString = "*Default";
    if ( item2.value == compareString )
    {
     isOK = true;
    }
   }
   else     // if HBA has a valid Connection name, regardless of HostMode, user can submit
   {
    isOK = true;
   }
   
   if ( !isOK )
      {
      alert(invalidConnectionNameHostModeCombo);
      }
   return isOK;   
   }

function SSPv2AccessReferenceArrayInit(form)
  {
  if ( controllerHasHostMode )
  {
   hostAccessOffset = (numChoices*3) + 1; //offset to skip past connection Names and Host Mode in the form
  }
  else
  {
   hostAccessOffset = (numChoices*2) + 1; //offset to skip past connection Names in the form
  }
  
  sspAccessReferenceArray = new Array();
  for (var i=0; i<numLogicalDrives; ++i)
    {
    sspAccessReferenceArray[i] = new Object();
    logicalDriveIndex = hostAccessOffset + (i* (numHbas+1));
    sspAccessReferenceArray[i].ldrive = form.elements[logicalDriveIndex];
    sspAccessReferenceArray[i].numHbas = hbaOptions[logicalDrive[i]].numChoices;
    sspAccessReferenceArray[i].hbaAccess = new Array();
    for (var j=0; j<hbaOptions[logicalDrive[i]].numChoices; ++j)
      {
      hbaIndex = logicalDriveIndex + j + 1;
      sspAccessReferenceArray[i].hbaAccess[j] = form.elements[hbaIndex];
      }
    }
  }

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// TOGGLE SSP V2 ACCESS COMMAND <f>
//
function ToggleSSPv2AccessCommand( hbaIndex, logicalDriveIndex, isChecked )
   {
   accessCommand = offcommand;
   if ( isChecked )
     {
     accessCommand = command;
     }

   sspAccessReferenceArray[logicalDriveIndex].ldrive.name = sspAccessReferenceArray[logicalDriveIndex].ldrive.name;
   sspAccessReferenceArray[logicalDriveIndex].ldrive.value = sspAccessReferenceArray[logicalDriveIndex].ldrive.value;
   for (var k=0; k<sspAccessReferenceArray[logicalDriveIndex].numHbas; ++k)
     {
     sspAccessReferenceArray[logicalDriveIndex].hbaAccess[k].name = sspAccessReferenceArray[logicalDriveIndex].hbaAccess[k].name;
     sspAccessReferenceArray[logicalDriveIndex].hbaAccess[k].value = sspAccessReferenceArray[logicalDriveIndex].hbaAccess[k].value;
     }
   sspAccessReferenceArray[logicalDriveIndex].hbaAccess[hbaIndex].name = accessCommand;
   sspAccessReferenceArray[logicalDriveIndex].hbaAccess[hbaIndex].value = sspAccessReferenceArray[logicalDriveIndex].hbaAccess[hbaIndex].value;
   
   }

// ~~~~~~~~~~~~~~~~~~~~~~~~
// NUM HBAS WITH ACCESS <f>
//
function numHbasWithAccess()
   {
   numWithAccess = 0;
   for (var logicalDriveIndex=0; logicalDriveIndex < numLogicalDrives; ++logicalDriveIndex)
      {
      for (var hbaIndex=0; hbaIndex < numHbas; ++hbaIndex)
         {
         if ( sspAccessReferenceArray[logicalDriveIndex].hbaAccess[hbaIndex].name == command )
            {
            ++numWithAccess;
            }
         }
      }
   return numWithAccess;
   }

function ToggleSSPv2HostMode(hbaIndex, item)
   {
   newValue = selectedOption(item);
   //newValue2 = selectedOption(eval("document.sspTable.HostMode" + hbaIndex));

   sspConnNameReferenceArray[hbaIndex].hbaFocus.name = sspConnNameReferenceArray[hbaIndex].hbaFocus.name;
   sspConnNameReferenceArray[hbaIndex].hbaFocus.value = sspConnNameReferenceArray[hbaIndex].hbaFocus.value;
   sspConnNameReferenceArray[hbaIndex].connName.name = sspConnNameReferenceArray[hbaIndex].connName.name
   sspConnNameReferenceArray[hbaIndex].connName.value = sspConnNameReferenceArray[hbaIndex].connName.value
   sspConnNameReferenceArray[hbaIndex].hostMode.name = "HOST_MODE";
   if ( item.value != LoadString("PX_TAG_HOST_UNKNOWN") )
   {
   sspConnNameReferenceArray[hbaIndex].hostMode.value = "*" + newValue;
   }
   else
   {
   sspConnNameReferenceArray[hbaIndex].hostMode.value = "*" + "";  //make sure sending empty string when Host Unknown
   }
   
   }