function CheckControllerStatusAndSubmit(formName, actionName, targetName, controllerFocus)
   {
   hasEmptyArrays = false;
   isSavePossible = false;
   configFrame = GetConfigFrame();
   TransferDataFromTo( "hasEmptyArrays", configFrame, this );
   TransferDataFromTo( "isSavePossible", configFrame, this );

   changeController = true;
       
   if ( GetTaskData("controllerSelected") )
      {
      if ( isSavePossible || hasEmptyArrays )
         {
         changeController = confirm(discardMessage);
         }
      }

   if ( changeController )
      {
      //Delete the controller focus tag that is used for critical errors since
      //we are providing a new focus.
      DeleteData("CONTROLLER_FOCUS_TAG");
      SetTaskData("selectedController", controllerFocus);
      if (isInAdvancedMode())
         {
         SetData("advancedReturnComplete", false);
         mainFrame = GetMainFrame();
         mainFrame.location = "ACU-Main-Return.htm";
         WaitForAndExecute("GetData('advancedReturnComplete') == true;", 
                           "SubmitControllerForm('" + formName + "', '" + actionName + "', '" + targetName + "')", 
                           250);
         }
       else
         {
         SubmitControllerForm(formName, actionName, targetName);
         }
      }
   else
      {
      SetTaskData("controllerSelectionComplete", true);
      }
   return false;
   } 

function SubmitControllerForm(formName, actionName, targetName)
   {
   SetData("CONTROLLER_SELECTION_COMPLETE", false);
   SubmitFullForm(formName, actionName, targetName); 
   WaitForAndExecute("GetData('CONTROLLER_SELECTION_COMPLETE') == true",
                     "document.updateCCForm.submit();",
                     250);
   SetTaskData("controllerSelected", true);
   }

function SelectInitialControllerIfPossible()
   {
   var isFound = false;
   var controllerIndex = -1;

   if ( DataExists("FIRST_TIME_CONTROLLER_DETECTION") && numChoices == 1 ) 
      {
      isFound = true;
      controllerIndex = 0;
      }
   else if ( DataExists("INIT_CONTROLLER_SLOT") )
      {
      var initSlot = GetData("INIT_CONTROLLER_SLOT");
      DeleteData("INIT_CONTROLLER_SLOT");
      for (var i=0; (i < numChoices) && !isFound; ++i)
         {
         if (option[i].slot != null)
            {
            if (option[i].slot == initSlot)
               {
               isFound = true;
               controllerIndex = i;
               }
            }
         }
      }
   else if ( DataExists("INIT_CONTROLLER_WWN") )
      {
      var initWWN = GetData("INIT_CONTROLLER_WWN");
      DeleteData("INIT_CONTROLLER_WWN");
      for (var i=0; (i < numChoices) && !isFound; ++i)
         {
         if (option[i].wwn != null)
            {
            if (option[i].wwn == initWWN)
               {
               isFound = true;
               controllerIndex = i;
               }
            }
         }
      }
   else if ( DataExists("INIT_CONTROLLER_SERIALNUMBER") )
      {
      var initSERIALNUMBER = GetData("INIT_CONTROLLER_SERIALNUMBER");
      DeleteData("INIT_CONTROLLER_SERIALNUMBER");
      for (var i=0; (i < numChoices) && !isFound; ++i)
         {
         if (option[i].serialnumber != null)
            {
            if (option[i].serialnumber == initSERIALNUMBER)
               {
               isFound = true;
               controllerIndex = i;
               }
            }
         }
      }

   DeleteData("FIRST_TIME_CONTROLLER_DETECTION");
   if (isFound)
      {
      controllerForm = "option" + controllerIndex;
      controllerFocus = option[controllerIndex].focusTag;
      DeleteData("CONTROLLER_FOCUS_TAG");
      SetTaskData("selectedController", controllerFocus);
      }

   return isFound;
   }

function DisplayControllerChoices() 
   {
   selectedController = GetTaskData("selectedController");
   document.write("<table width=100% cellspacing=0 id=selectionTable cellpadding=0 border=0 bordercolor=#FFFFFF>")   
   for (var i = 0; i < numChoices; ++i)
      {
      document.write("<tr ");     
      if (option[i].focusTag == selectedController)
         {
         document.write("id=selectedController");
         }       
      document.write(">");
     if (option[i].focusTag == selectedController)
     {
     document.write("<td align=left valign=top><IMG src='Images/top_left_trans2.gif'></td>");
      }
     else
     {
      document.write("<td>&nbsp;</td>");
     }
     document.write("<td height=20 rowspan=2>");
      document.write("<a href='' id=controllerChoiceLink target='' ");
      document.write("onclick= \"return HandleControllerSelectionChange(" + i + ");\">");
      document.write("<img border=0 src='");
      WriteCtrlImageName(option[i]);
      
      document.write("' width=30 ");
      document.write("height=20 align=left>");
      document.write(" </a>");
      document.write("</td>");
      document.write("<td height=40 id=controllerChoiceLink rowspan=2>");
      document.write("<a href='' id=controllerChoiceLink target='' ");
      document.write("onclick=");
      document.write("\"return HandleControllerSelectionChange(" + i + ");\">");
      document.write(InsertParmsInString(option[i].name));
      document.write("</a>");
      document.write("</td>");
     if (option[i].focusTag == selectedController)
     {
     document.write("<td height=20 align=right valign=top><IMG src='Images/top_right_trans2.gif'></td>");
      }
     else
     {
      document.write("<td>&nbsp;</td>");
     }
     document.write("</tr>");
     document.write("<tr ");     
      if (option[i].focusTag == selectedController)
      {
       document.write("id=selectedController");
      document.write("><td height=20 align=left valign=bottom><IMG src='Images/btm_left_trans2.gif'></td><td height=20 align=right valign=bottom><IMG src='Images/btm_right_trans2.gif'></td></tr>");
      }       
     else
     {
       document.write("><td height=20>&nbsp;</td><td height=20 >&nbsp;</td></tr>");
      }
     }        
   if (numChoices == 0)
      {
      document.write("<tr><I>" + LoadString("PX_TAG_NONE") + "</I></tr>");
      }
   if (numErrors == 0)
      {
      // If there are no errors
      if (numChoices == 0)
         {
         // If there are no controllers, blank the screens and display message
         choiceFrame = GetChoiceFrame();
         choiceFrame.location = "NC-01-No.htm";
         }
      else
         {
         // Otherwise, if a controller is not selected,
         // show the arrow to select a controller.
         if (!TaskDataExists("selectedController"))
            {
            choiceFrame = GetChoiceFrame();
            choiceFrame.location = "NC-01.htm";
            }
         }
      }
   else
      {
      // There are errors, so we need to load the error page and blank the screen
      choiceFrame = GetChoiceFrame();
      choiceFrame.location = "NC-01-Er.htm";
      }
   document.write("</table><br>");
   }

function HandleControllerSelectionChange(index)
   {
   if (!isSaveInProgress())
     {
     if ( GetTaskData("controllerSelectionComplete") )
        {
        SetTaskData("controllerSelectionComplete", false);

        choiceFrame = GetChoiceFrame();
        if (choiceFrame.userTag != null)
           {
           statement = "document.option" + index + ".TAG.value = " + "choiceFrame.userTag;"
           eval(statement);
           }

        controllerFocus = option[index].focusTag;
        CheckControllerStatusAndSubmit("option" + index, 
                                       "NU-01.htm", "choice", controllerFocus);
        }
     }
   return false;
   }

function DisplayDiscoveryErrors()
  {
  for( var i =0; i < numErrors; ++i )
    {
    alert( error[i].name.text );
    }
  }

function DisplayControllerRescan()
   {
   document.write("<table width=100% cellspacing=0 id=selectionTable cellpadding=1 border=0>");
   document.write("<tr align=center valign=middle><td>");
   document.write("<a href='' id=controllerChoiceLink target='disc' onClick='return ControllerRescan();'>");
   WriteString("PX_TAG_CONTROLLER_RESCAN");
   document.write("</a></td></tr></table>");
   }

function ControllerRescan()
   {
   if( !isSaveInProgress() )
   {
   var isOKtoRescan = true;
   if ( GetTaskData("controllerSelected") == true )
      {
      configFrame = GetConfigFrame();

      if ( configFrame.isSavePossible ||
           configFrame.hasEmptyArrays )
         {
         if ( !confirm(discardMessage) )
            {
            isOKtoRescan = false;
            }
         }
      }

   if ( isOKtoRescan )
      {
      DeleteAllTaskData();
      SetData("FIRST_TIME_CONTROLLER_DETECTION", true);
      mainFrame = GetMainFrame();
      
      var unlockController = false;
      choiceFrame = GetChoiceFrame();
      unlockController = ( choiceFrame.focusTag != null );

      //Unlock the current controller image if necessary before doing the rescan.
      if ( unlockController )
         {
         document.rescanWithUnlockForm.TAG.value = choiceFrame.userTag;
         document.rescanWithUnlockForm.FOCUS.value = choiceFrame.focusTag;
         mainFrame.location="ACU-Main.htm";
         document.rescanWithUnlockForm.submit();
         }
      else
         {
         mainFrame.location="ACU-Main.htm";
         parent.disc.location = "CC-Init.htm?RESCAN=TRUE";
         }
      }
   }
   return false;
   }