@echo off
cls

set LANG=C

@call ov.envvars.bat

echo OpenView BIN Directory is %OV_BIN%
echo OpenView BITMAPS Directory is %OV_BITMAPS%
echo OpenView SYMBOLS Directory is %OV_SYMBOLS%
echo OpenView CONF Directory is %OV_CONF%
echo OpenView REGISTRATION Directory is %OV_REGISTRATION%
echo OpenView LRF Directory is %OV_LRF%
echo OpenView HELP Directory is %OV_HELP%
echo OpenView FIELDS Directory is %OV_FIELDS%
echo OpenView Main Directory is %OV_MAIN_PATH%

Echo .
Echo You are about to uninstall the Insight Integration for OpenView 
Echo Network Node Manager (NNM).
Echo .
Echo NOTE: Be sure you remove the Insight Manager objects from the NNM
Echo map before uninstalling the integration.  From the Root map, select 
Echo Map - Properties - Applications - Insight Integration for HP 
Echo OpenView and click Configure for this Map.  Set delete CIM
Echo Objects and Symbols to True, click verify, then click Ok.
Echo .
Echo Press any key to remove the application or press CTRL-C to exit.
Echo .
Pause

echo Removing the Insight Integration Processes...
echo Removing the Insight Integration Processes... 1>>"%OV_BIN%\cimuninstall.log"
"%OV_BIN%\ovdelobj" "%OV_LRF%\cpq\cpqtrapd.lrf" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
"%OV_BIN%\ovdelobj" "%OV_LRF%\cpq\cpqdis.lrf" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_LRF%\cpq\*.*" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_LRF%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Stopping the OpenView services... 
echo Stopping the OpenView services... 1>>"%OV_BIN%\cimuninstall.log"
"%OV_BIN%\ovstop" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the Insight Integration Binary Files... 
echo Removing the Insight Integration Binary Files... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_BIN%\cpq\*.*" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_BIN%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the Insight Integration Icon Files...
echo Removing the Insight Integration Icon Files... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_BITMAPS%\%LANG%\cpq\*.*" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_BITMAPS%\%LANG%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the Insight Integration Icon GIF Files...
echo Removing the Insight Integration Icon GIF Files... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_WWW%\htdocs\bitmaps\%LANG%\cpq\*.*" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_WWW%\htdocs\%LANG%\images\launcher\str_hpweb.16.gif" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_WWW%\htdocs\bitmaps\%LANG%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_WWW_REG%\jovw\%LANG%\insight" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_WWW_REG%\launcher\%LANG%\insighthome" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"


call del /q "%OV_WWW_REG%\dynamicViews\%LANG%\insight.xml" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"


echo Removing the Insight Integration Symbol Registration File...
echo Removing the Insight Integration Symbol Registration File... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_SYMBOLS%\%LANG%\cpq\cpqSym.reg" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_SYMBOLS%\%LANG%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

call del /q "%OV_CONF%\oid_to_sym_reg\001_HP\018_HP_Insight" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"


echo Removing the Insight Integration Fields file... 
echo Removing the Insight Integration Fields file... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_FIELDS%\%LANG%\cpq\cpqField.reg" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_FIELDS%\%LANG%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the Insight Integration Registration files...
echo Removing the Insight Integration Registration files... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_REGISTRATION%\%LANG%\cpq\*.*" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_REGISTRATION%\%LANG%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the Insight Integration tools...
echo Removing the Insight Integration tools... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_MAIN_PATH%\install\tools\cpq\*.*" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_MAIN_PATH%\install\tools\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Starting the OpenView database...
echo Starting the OpenView database... 1>>"%OV_BIN%\cimuninstall.log"
"%OV_BIN%\ovstart" ovwdb 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
echo Loading registrations and fields... 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
"%OV_BIN%\ovw" -fields 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Stopping the OpenView services...
echo Stopping the OpenView services... 1>>"%OV_BIN%\cimuninstall.log" 
"%OV_BIN%\ovstop" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the previous Insight Integration trap definitions...
echo Removing the previous Insight Integration trap definitions... 1>>"%OV_BIN%\cimuninstall.log"
call "%OV_CONF%\%LANG%\cpq\hpqdeletetraps.bat" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_CONF%\%LANG%\cpq\hpqdeletetraps.bat" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_CONF%\%LANG%\cpq\cpqdeletetraps.bat" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the Insight Integration configuration files...
echo Removing the Insight Integration configuration files... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_CONF%\%LANG%\cpq\cpqconfig.dat" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removing the Insight Integration trap files...
echo Removing the Insight Integration trap files... 1>>"%OV_BIN%\cimuninstall.log"
call del /q "%OV_CONF%\%LANG%\cpq\cpqtrapd.conf" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_CONF%\%LANG%\cpq\newtraps.cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call del /q "%OV_CONF%\%LANG%\cpq\cpqval2str.trap" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
REM call del /q "%OV_CONF%\%LANG%\cpq\cpqtrapdtest.conf" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"
call rmdir "%OV_CONF%\%LANG%\cpq" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Starting the OpenView services...
echo Starting the OpenView services... 1>>"%OV_BIN%\cimuninstall.log"
"%OV_BIN%\ovstart" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Unloading the ProLiant MIBs from Network Node Manager...
echo Unloading the ProLiant MIBs from Network Node Manager... 1>>"%OV_BIN%\cimuninstall.log"

@call cpqunloadmibs.cmd

echo Deleting the integration fields from the database...
echo Deleting the integration fields from the database... 1>>"%OV_BIN%\cimuninstall.log"

".\tools\delfields y" 1>>"%OV_BIN%\cimuninstall.log" 2>>"%OV_BIN%\cimerror.log"

echo Removal of the Insight Integration version 3.1 complete.
echo Removal of the Insight Integration version 3.1 complete. 1>>"%OV_BIN%\cimuninstall.log" 


