#!/bin/sh
# $Id: $
#
# Component:	TivoliPlus Generic Installation Script, for use with winstruct_plus
#
# $Source: $
# $Revision: $
#
# Description:  
#		
#
# Author:	Annelle Harrison
#		Tivoli Systems, Inc.
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1997-2000
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

##############################################################################
# This script is normally located under the export area specified 
# on the winstruct_plus command line:
#      <plus_export_dir>/generic_unix/TME/PLUS/LINK
# or as specified using the -D option on the winstruct_plus command line.
# An alternative script may be specified using the -D option on the
# winstruct_plus command line.  The following files may contain
# information from previous uses of the -D option; these values may override
# the default locations:
#        $DBDIR/AMS/<module-name>/Default/plus_script
#        $DBDIR/AMS/<module-name>/Default/plus_export_dir
#
# This script will do the following:
# 1. Source the info_file_path script that is passed in as an argument
# 2. Use information in the script to determine the module's Tivoli target 
#    installation directory
# 3. Copy the info script to the export_path area
# 4. Check for ability to copy LINK and binaries from the
#    export area to the Tivoli install tree: $INST_DIR
#    - make backups of stuff in the install dir that we might not want to step on (?)
#    - copy, move, or merge contents of export area into the
#      appropriate Tivoli install directory on this node
#    - exit if can't do it
#    - note that a copy of the info_file_path script is now present in the install 
#      directory
# 5. Check for existence of some minimal set of .gdf variables to make sure we
#    can continue
# 6. Process information in the info file, creating link objects, etc.
#
##################################################################################

######################################################################
#
#  wbindmsg utilities
#

outmsg() {

  ## turn off tracing for this routine
  ###if [ "$DEBUG" = true ]; then set +x; fi
  set +xv

  arg1=`echo "$1"`
  arg2=`echo "$2"`
  arg3=`echo "$3"`

  if [ ! "$arg3" ]; then
    eval echo "$arg1" "$arg2"
    ## turn tracing back on if applicable ...
    if [ "$DEBUG" = true ]; then set -x; fi
    return
  fi

  # got 3 or more args, we must be trying to wbindmsg ...
  file="$arg1"
  num="$arg2"
  string="`echo \"$arg3\" | sed -e 's/*/./g'`"
  shift;shift;shift
  afterstring="$*"

  ## handle up to 4 substitution args
  subarg1=`echo "$1"`; if [ "$subarg1" ]; then shift; fi
  subarg2=`echo "$1"`; if [ "$subarg2" ]; then shift; fi
  subarg3=`echo "$1"`; if [ "$subarg3" ]; then shift; fi
  subarg4=`echo "$1"`; if [ "$subarg4" ]; then shift; fi
  rest="$*"   ## not real graceful, but at least we're not throwing it away ...

  # use USER_LANG if it's set; so our wbindmsg will find the user's locale
  save_lang=$LANG
  if [ "$USER_LANG" ]; then
    LANG=$USER_LANG
  elif [ ! "$LANG" ]; then
    LANG=C
  fi

  if wbindmsg $file $num "$string" "$subarg1" "$subarg2" "$subarg3" "$subarg4" "$rest" 1> /dev/null 2>&1; then
    wbindmsg $file $num "$string" "$subarg1" "$subarg2" "$subarg3" "$subarg4" "$rest"
    echo   ## add a line ending to wbindmsg result
  else
    # couldn't use wbindmsg, but try and spit out something useful
    substitute_strings "$string" "$subarg1" "$subarg2" "$subarg3" "$subarg4" "$rest"
    if [ $? -ne 0 ]; then
      eval echo $string $afterstring
    fi
  fi

  # restore LANG
  LANG=$save_lang

  ## turn tracing back on if applicable ...
  if [ "$DEBUG" = true ]; then set -x; fi

}

errmsg() {

  ## turn off tracing for this routine ...
  ###if [ "$DEBUG" = true ]; then set +x; fi
  set +xv

  # preserve arg format for call to outmsg()
  arg1=`echo "$1"`
  arg2=`echo "$2"`
  arg3=`echo "$3"`
  if [ "$arg3" ]; then 
    shift;shift;shift
    subarg1=`echo "$1"`; if [ "$subarg1" ]; then shift; fi
    subarg2=`echo "$1"`; if [ "$subarg2" ]; then shift; fi
    subarg3=`echo "$1"`; if [ "$subarg3" ]; then shift; fi
    subarg4=`echo "$1"`; if [ "$subarg4" ]; then shift; fi
    rest="$*"
  fi

  outmsg "$arg1" "$arg2" "$arg3" "$subarg1" "$subarg2" "$subarg3" "$subarg4" $rest >& 2

  ## turn tracing back on if applicable ...
  if [ "$DEBUG" = true ]; then set -x; fi

}

substitute_strings() {

  ## turn off tracing for this routine
  ###if [ "$DEBUG" = true ]; then set +x; fi
  set +xv

  base="`echo \"$1\" | sed -e 's/*/./g'`"; if [ "$base" ]; then shift; fi
  sub1=`echo "$1"`; if [ "$sub1" ]; then shift; fi
  sub2=`echo "$1"`; if [ "$sub2" ]; then shift; fi
  sub3=`echo "$1"`; if [ "$sub3" ]; then shift; fi
  sub4=`echo "$1"`; if [ "$sub4" ]; then shift; fi
  xtra=`echo "$*"`


  base="`echo \"$base\" | sed -e 's/%1$s/$sub1/g'`"
  base="`echo \"$base\" | sed -e 's/%2$s/$sub2/g'`"
  base="`echo \"$base\" | sed -e 's/%3$s/$sub3/g'`"
  base="`echo \"$base\" | sed -e 's/%4$s/$sub4/g'`"
  eval echo "$base" "$xtra"

  ## turn tracing back on if applicable ...
  if [ "$DEBUG" = true ]; then set -x; fi

}

#
#       xlate_var -- please pass in a var name, not its value!
#                    we construct variables appending var name 
#                    with _MSGFILE and _MSGID, and use those values
#
xlate_var() {
  varname="$1"
  eval default_val='"$'${varname}'"'
  if [ ! "$default_val" ]; then
    default_val="$1"
  fi
  eval msgid='"$'${varname}'_MSGID"'
  eval msgfile='"$'${varname}'_MSGFILE"'
  outmsg $msgfile $msgid "$default_val"
}

#
############### end of wbindmsg utilities

usage() {
  THIS_CMD=`echo $0 | tr "\\\\\\\\" "/"`; THIS_CMD=`basename $THIS_CMD`
  errmsg LinkInstallCat 28 "  Usage: %1\$s [ -a | -jfs ] [ -u ] [ -d ] [ -c ] <info_file_path> <export_path>" "$THIS_CMD"
  errmsg LinkInstallCat 29 "             -a   = do all (default)"
  errmsg LinkInstallCat 30 "             -u   = undo"
  errmsg LinkInstallCat 31 "             -t   = do tasks/jobs"
  errmsg LinkInstallCat 32 "             -f   = do file packs"
  errmsg LinkInstallCat 33 "             -s   = do sentries"
  errmsg LinkInstallCat 34 "             -d   = debug on"
  errmsg LinkInstallCat 35 "             -c   = copy files only"
  exit 1
}

do_instruct() {
  
  [ "$DEBUG" = true ] && set -x

  common_init || return 1

  log_start_instruct || return 1

  #
  # Create the top level plus collection and the collection for this module
  #
  create_plus_collection || return 1
  
  init_module_globals || return 1

  if $ALL ; then
	  #
	  #	set install options
	  #
	  set_install_options || return 1

	  #
	  # Create application launch icons
	  #
	  create_app_launch || return 1
  fi

  if IsValidPolicyRegion "$APP_PR_NAME"; then

	  if $ALL ; then
	  	#
	  	# Create subscription list profile managers.
	  	#
	  	create_subscription_lists || return 1

	  	#
	  	# Determine to which subscription list, if any, this host should be added
	  	#
	  	add_host_to_subscription_lists || return 1
	  fi

	  if $DO_JOBS || $ALL ; then
	  	#
	  	# Create application management jobs, mapping them to tasks created by winstruct
	  	#
	  	create_administrative_jobs || return 1

	  	#
	 	# Create /Plus configuration jobs
	  	#
	  	create_plus_config_jobs || return 1

		#
		# Create filepack configuration jobs, but only if courier is installed
		#
		if $COURIER_INSTALLED ; then
			create_filepack_config_jobs || return 1
		fi

		#
		# Create logfile adapter configuration job, regardless of whether
		# TEC or logfile is installed
		#
		create_log_config_jobs || return 1

		#
		# Create the custom adapter configuration job, regardless ...
		#
		create_adapter_config_jobs || return 1
	  fi

	  #
	  # If Sentry is installed, then create the link objects and indicator
	  #	collections
	  #
	  if $SENTRY_INSTALLED ; then
		if $DO_SENTRIES || $ALL ; then
			create_sentry_profile_links || return 1
		fi
	  else
		errmsg LinkInstallCat 26 "Tivoli Distributed Monitoring NOT installed!"
	  fi

	  #
	  # If Courier is installed, then create the file packages
	  #
	  if $COURIER_INSTALLED ; then
		if $DO_FILEPACKS || $ALL ; then
			create_file_package_links || return 1
		fi
	  else
		errmsg LinkInstallCat 25 "Tivoli Software Distribution NOT installed!"
	  fi

	  #
	  # If TEC is installed, then create the events and load rule bases
	  #
	  if $TEC_INSTALLED ; then
		#
		# Create hidden tasks (create_tec_hidden_tasks)
		#
	        ### actually, this is done by winstruct_task, regardless of $TEC_INSTALLED 

		#
		# Install TEC config job
		#
		if $DO_JOBS || $ALL ; then
			create_tec_config_jobs || return 1
		fi
	  else
		errmsg LinkInstallCat 27 "Tivoli Enterprise Console NOT installed!"
	  fi

  fi

  refresh_plus_collection

  touch $DBDIR/${SHORT_prodname}plus-installed

  log_end_instruct

}

undo_instruct() {

  [ "$DEBUG" = true ] && set -x

  set_path_and_dir || return 1

  set_region_vars

  init_module_globals || return 1

  log_start_instruct

  #
  # undo everything in the reverse order of installation ...
  #

  if $DO_JOBS || $ALL ; then

	delete_log_config_jobs || return 1

	delete_adapter_config_jobs || return 1

  	delete_tec_config_jobs || return 1

	delete_filepack_config_jobs || return 1

  	delete_plus_config_jobs || return 1

  	delete_administrative_jobs || return 1

  fi

  if $DO_FILEPACKS || $ALL ; then

  	delete_file_packages || return 1

  fi

  if $DO_SENTRIES || $ALL ; then
	
	delete_mar_profiles || return 1
	delete_sentry_profiles || return 1

  fi

  if $DO_JOBS || $ALL ; then

  	delete_app_launch || return 1

 	remove_install_options || return 1

  fi

  if $ALL ; then
	delete_inventory_profile || return 1
  fi

  if $ALL ; then

	### remove_host_from_subscription_lists || return 1

  	delete_subscription_lists || return 1

  	remove_plus_collection || return 1

 	rm -f $DBDIR/${SHORT_prodname}plus-installed
  fi

  log_end_instruct

} # end of undo_instruct ...

undo_infra() {

  [ "$DEBUG" = true ] && set -x

  log_start_instruct

  if $DO_SENTRIES || $ALL ; then
    delete_infra_mars || return 1
    delete_infra_sentries || return 1
    delete_infra_tasks $SENTRYTASKS || return 1
  fi
  
  if $DO_FILEPACKS || $ALL ; then
    delete_infra_filepacks || return 1
    delete_infra_tasks $FILEPACKTASKS || return 1
  fi

  if $DO_JOBS || $ALL ; then
    ALL_OTHER_TASKS="$TASKS $HIDDENTASKS $TECTASKS $LOGTASKS $ADAPTERTASKS $ABOUTTASKS $CONFIGTASKS"
    delete_infra_tasks $ALL_OTHER_TASKS || return 1
    delete_default_tasklib || return 1
    delete_infra_tasklibs || return 1
  fi

  if $ALL ; then
    delete_infra_inventory || return 1
  fi

  if $ALL ; then
    delete_infra_app_pr || return 1
  fi

  refresh_desktop

  log_end_instruct

}

undo_prodinfo() {
  if [ "$PATCH_ID" ]; then
    PATCH_ID=`echo $PATCH_ID | tr "/" "_"`
    if wlookup -r ProductInfo "$PATCH_ID" > /dev/null 2>&1; then
      pi_obj=`wlookup -r ProductInfo "$PATCH_ID"`
      objcall $pi_obj _delete
    fi
    rm -f $INST_DIR/generic_unix/.installed/${PATCH_ID}_GBIN
    rm -f $INST_DIR/lcf_bundle/.installed/${PATCH_ID}_LCF
    rm -f $INST_DIR/../msg_cat/.installed/${PATCH_ID}_CAT
  fi
}

#############################################################################
#
#	Setup Tivoli environment variables and call scripts
#	to set up product specific stuff.
#

#
# make sure this script runs in the C locale, but outmsg funcs will look at USER_LANG
#
SAVE_LANG=$LANG
if [ "$LANG" != C ]; then
  USER_LANG=$LANG; export USER_LANG
  LANG=C; export LANG
fi


#
#	Set up environment (similar to old /etc/Tivoli/setup_env.sh)
#
OSERV=`objcall 0.0.0 get_oserv`; export OSERV
INST_DIR=`objcall $OSERV query install_dir | tr "\\\\\\\\" "/"`; export INST_DIR
INTERP=`objcall $OSERV query interp`; export INTERP
BINDIR=$INST_DIR/$INTERP; export BINDIR
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK; export LINKDIR
DBDIR=`objcall $OSERV query db_dir | tr "\\\\\\\\" "/"`; export DBDIR
TEMP=/tmp; export TEMP
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
fi
if [ ! -d $TEMP ]; then
	$LINKDIR/mkdir.sh $TEMP
fi
PATH=$LINKDIR:$PATH; export PATH


ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script
#
if [ -f $ETC/$SCRIPT ]; then
  . $ETC/$SCRIPT
fi


#
#	Set up some other popular environment variables.
#
REGION=`objcall $OSERV query whoami | awk '{print $1}'`
LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR=$TEMP/.plusdebug
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
export DEBUG

#
# The SCRIPTNAME var may be used by logging routines ...
#
THIS_SCRIPT=`echo $0 | tr "\\\\\\\\" "/"`
THIS_SCRIPT=`basename $THIS_SCRIPT`
SCRIPTNAME=${SCRIPTNAME:-$THIS_SCRIPT}

#
# command line processing begins here:
#
OPTSTRING="dujtfsarci"
ALL=true; REGION_ONLY=false; UNDO=false; COPY_FILES_ONLY=false; UNDO_INFRA=false; UNDO_PRODINFO=false
DO_JOBS=false; DO_FILEPACKS=false; DO_SENTRIES=false;
ALL_OPT=false

while getopts $OPTSTRING opt; do
    case $opt in
      d) DEBUG=true;;
      u) UNDO=true; UNDO_INFRA=true;;
      a) ALL_OPT=true; ALL=true;;
      j | t) DO_JOBS=true; ALL=false;;
      f) DO_FILEPACKS=true; ALL=false;;
      s) DO_SENTRIES=true; ALL=false;;
      r) REGION_ONLY=true; ALL=false;;
      c) COPY_FILES_ONLY=true; ALL=false;;
     *?) usage;;
    esac
done
shift `expr $OPTIND - 1`

INFO_SCRIPT=$1
EXPORT_LOC=$2

if [ ! "$INFO_SCRIPT" ]; then
  # assume module and LINK are already in place and we
  # got called from the module dir:
  INFO_SCRIPT="./PLUSproduct-info.sh"
fi
if [ ! "$EXPORT_LOC" ]; then
  EXPORT_LOC="$INST_DIR/.."
fi

if [ ! -d "$EXPORT_LOC/bin" -o ! -f "$INFO_SCRIPT" ]; then
  usage
fi  

#
# locate and source other common utilities that should be in the export location
#
UTIL_SCRIPTS_PATH="$EXPORT_LOC/bin/generic_unix/TME/PLUS/LINK"
if [ -f "${UTIL_SCRIPTS_PATH}/PLUScommon-install.sh" -a \
     -f "${UTIL_SCRIPTS_PATH}/PLUScommon-instruct.sh" ]; then
  . ${UTIL_SCRIPTS_PATH}/PLUScommon-install.sh
  . ${UTIL_SCRIPTS_PATH}/PLUScommon-instruct.sh
else
  errmsg LinkInstallCat 36 "Missing files: %1\$s/PLUScommon*.sh" "${UTIL_SCRIPTS_PATH}"
  exit 1
fi

#
# set some vars that may be referenced by the INFO_SCRIPT before we source it ...
#

if wlookup -r Classes EventServer >/dev/null 2>&1; then 
  # then we know TEC is installed!
	TEC_SENTRY_RESET_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_NORMAL_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_FATAL_CLAUSE="-T FATAL EventServer"
	TEC_SENTRY_CRITICAL_CLAUSE="-T CRITICAL EventServer"
	TEC_SENTRY_SEVERE_CLAUSE="-T MINOR EventServer"
	TEC_SENTRY_WARNING_CLAUSE="-T WARNING EventServer"
	TEC_SENTRY_HARMLESS_CLAUSE="-T HARMLESS EventServer"
fi

#
# Now source the info script!
#
. $INFO_SCRIPT

#
# Make sure the info script included required vars to let us proceed
#
if [ ! "$LINKDIR" -o \
     ! "$PLUSDIR" -o \
     ! "$PRODDIR" ]; then
  errmsg LinkInstallCat 37 "Missing PLUSDIR, LINKDIR, or PRODDIR location information in %1\$s!" "$INFO_SCRIPT"
  exit 1
fi

#
# xlate 'em while they're fresh!
#
xlate_prodinfo_vars

if [ ! "$WINSTRUCTED" = true ]; then
  WINSTRUCTED=false
fi

#
# If we're instructed, then we can't undo the infrastructure
#
if $WINSTRUCTED && $UNDO ; then
  UNDO_INFRA=false
fi

#
# User must use all option if s/he wants to undo app launch, install opts, and sublists ...
#
if $UNDO; then
  if $ALL_OPT; then
    ALL=true
  else
    ALL=false
  fi
fi

if [ ! "$APP_PR_NAME" ] ; then
  if $WINSTRUCTED ; then
  	errmsg LinkInstallCat 38 "Missing APP_PR_NAME information in %1\$s!" "$INFO_SCRIPT"
  	exit 1
  else
	APP_PR_NAME="$MEDIUM_PRODNAME"
  fi
fi
export WINSTRUCTED
export LINKDIR
export PLUSDIR
export PRODDIR
export APP_PR_NAME

#
# Set/resolve/export some important values according to data in the info script
#
if [ ! "$MODULE_VERSION" ]; then
  # a default:
  MODULE_VERSION="3.0"  
fi
if [ "$TOP_COLLECTION" -a ! "$TOP_PR_TO_USE" ]; then
  TOP_PR_TO_USE="$TOP_COLLECTION"
else
  TOP_PR_TO_USE="TivoliPlus"
fi
if [ "$TOP_ICON" -a ! "$COLL_ICON_TO_USE" ]; then
  COLL_ICON_TO_USE="$TOP_ICON"
else
  COLL_ICON_TO_USE="$LINKDIR/Sol_icon.xpm"
fi
if [ "$TOP_STATE" -a ! "NEW_COLL_STATE" ]; then
  NEW_COLL_STATE="$TOP_STATE"
else
  NEW_COLL_STATE="TSCOLL"
fi
export MODULE_VERSION
export TOP_PR_TO_USE
export COLL_ICON_TO_USE
export NEW_COLL_STATE

#
# Set shell flags for trace, abort install if error
#
if $DEBUG; then set -xv; fi
set -e

#
# Start processing info here
#
if $UNDO ; then
   log_init
   undo_instruct || exit 1
   if $UNDO_INFRA ; then
     undo_infra || exit 1
   fi
   undo_prodinfo || exit 1
else
   copy_module_files "$INFO_SCRIPT" "$EXPORT_LOC"
   if [ $? -ne 0 ]; then
     errmsg LinkInstallCat 39 "File installation failed!"
     exit 1
   elif $COPY_FILES_ONLY ; then
     exit 0
   else
     ##################
     #
     # At this point processing is similar to that in PLUSinstall.sh
     #
     if $WINSTRUCTED ; then
       do_instruct || exit 1
     else
       $LINKDIR/PLUSinstall.sh
     fi
   fi
fi

# restore user's locale
LANG=$SAVE_LANG

exit 0
