#!/bin/sh
#
# File:		PLUSinstall_after.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
MODULE_VERSION=;export MODULE_VERSION
NEW_PRODNAME="HP Insight Integration for Tivoli, Revision 4.2"
#-----------------------------------------------------------------------
#	
#	Parameter 1 is the name of the collection to create
#	Parameter 2 is the name of the xpm file to use, assumes in $PRODDIR then $LINKDIR.
#	Parameter 3 is the name of the generic collection state to create
#
create_collection_with_icon()
{
	[ "$DEBUG" = "true" ] && set -x

	if [ $# -lt 3 ] ; then
		echo Usage: collection-name xpm-file collection-state-name
		echo "Example: create_collection_with_icon MyTasks mytasksicon.xpm MYTASKSCOLL"
		return
	fi

	NewColl=$1
	XPMFile=$2
	CollState=$3

	XPMFilePath=""

	# Try the PRODDIR first
	if [ -f "$PRODDIR/$XPMFile" ]; then
		XPMFilePath="$PRODDIR/$XPMFile"

	# Try LINKDIR second
	elif [ -f "$LINKDIR/$XPMFile" ]; then
		XPMFilePath="$LINKDIR/$XPMFile"
	else
		# Could not find the XPM file.
		errecho "Could not find the file $PRODDIR/$XPMFile or $LINKDIR/$XPMFile"
		return
	fi

	# Turn off abort if errors occur
	set +e

	# Create a collection in the plus module's icon view:
	DlgPath=""
	if [ -z "$4" ]; then
		DlgPath="$TEMP/dialog.d"
		wgetdialog -I normal -r GenericCollection > "$DlgPath"
	else
		DlgPath="$PRODDIR/$4"
	fi

	sh "$LINKDIR/waddstate" "GenericCollection" "$CollState" "$DlgPath" "$XPMFilePath"

	sh "$LINKDIR/wcrtscoll" "$NewColl" "$MEDIUM_PRODNAME" "$CollState"

	set -e
	
	[ -z "$4" ] &&	rm -f "$TEMP/dialog.d"

	set +e

}

# Move the icons into collections to unclutter the icon view.
# Note, the names of components are hard coded.  If you change them
# in builder, change them here as well.
#
move_an_icon()
{
	if [ $# -ne 2 ]; then
		return
	fi
	
	# Turn off abort if errors occur.
	set +e

	CHECKICON=""
	CHECKICON="`wls TivoliPlus/\"$MEDIUM_PRODNAME\" | grep -i \"^$1$\" 2> /dev/null`"

	if [ ! -z "$CHECKICON" ]; then
		# Icon was present so move it.
		wmv TivoliPlus/"$MEDIUM_PRODNAME"/"$1" TivoliPlus/"$MEDIUM_PRODNAME"/"$2"
		CHECKICON=""
	fi

	# Turn back on abort if errors occur.
	set -e
}

#-----------------------------------------------------------------------
# 	Move the icons into collections to unclutter the icon view.
#	Note, the names of components are hard coded.  If you change them
#	in builder, change them here as well.
#
cleanup_desktop_collections()
{
	
	CONFIG_TASK_COLL="Insight Administration Tasks"
      #
      #Since we want to use the "generic" icon, we dont need to use these:
	create_collection_with_icon "$CONFIG_TASK_COLL" JLink_icon.xpm PLUSCFGTASKCOLL "cim_admin_collection.d"
	# Clean up (Organize) the icons in the Plus module collection
	#
	# Do not rely on variables set in PLUSproduct-info.sh.
	# wcrtscoll "$CONFIG_TASK_COLL" "$MEDIUM_PRODNAME" PLUSTASKCOLL
	move_an_icon "Configure SNMP Adapter" "$CONFIG_TASK_COLL"
	move_an_icon "Setup TEC Event Server" "$CONFIG_TASK_COLL"
      #
	# Un-comment the following two lines to hide the task-icons for the two Launch components
	# wrm TivoliPlus/"$MEDIUM_PRODNAME"/"Insight Manager 7"
      # wrm TivoliPlus/"$MEDIUM_PRODNAME"/"SANworks Open SAN Manager"

	# Remove Plus Pre-config 
	wrm TivoliPlus/"$MEDIUM_PRODNAME"/"Plus Configuration"


}

#-----------------------------------------------------------------------
#	
#
set_dep_sets()
{

	# Turn off abort if errors occur.
	set +e

	gateways=""
	gateways=`wlookup -ar Gateway`
	if [ -z "$gateways" ]; then
		# Don't set dep sets since there aren't any gateways.
		return
	fi

	#
	# If admins find that oserv fails during installation it is most likely
	# that they don't have framework patches 33 and 38 installed.  If they
	# do it's likely they haven't done odadmin reexec all.
	# If they still have failures, have them try to do the following commands from a Tivoli
	# ready command prompt after installation.
	# Note that $PRODDIR maps to $BINDIR/../generic_unix/TME/PLUS/$SHORT_PRODNAME
	# SHORT_PRODNAME is set in PLUSproduct-info.sh for the plus module.
	#
	. $PRODDIR/PLUSconfig-TMA-utils.sh
	TMA_config_full
	TMA_sync_gateways

	wlookup -r DependencyMgr TMB_tools > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
	
		set +e

		if wlsinst -p | grep -i "TME 10 Framework 3.7" > /dev/null; then
   	 		wdepset -e @DependencyMgr:TMB_tools -a w32-ix86 bin/../../lcf_bundle.40/bin/w32-ix86/tools/cygwin1.dll +a +p %TOOLS%
		elif wlsinst -p | grep -i "Tivoli Management Framework 4.1" > /dev/null; then
    			wdepset -e @DependencyMgr:TMB_tools -a w32-ix86 bin/../../lcf_bundle.40/bin/w32-ix86/tools/cygwin1.dll +a +p %TOOLS%
		fi


	fi

	
	# Turn back on abort if errors occur.
	set -e

}

rename_collection_object()
{
	#------------------------------------------
	# Rename the Top Level Collection object
	NEW_COLNAME="HP Insight Integration for Tivoli"

	LIBRARY=`wlookup Library`
	COLLECTIONGUI=`idlcall "$LIBRARY" lookup_object '"imp_TMF_TGC::CollectionGUI" {0}'`
	COLLOBJ=`idlcall "$COLLECTIONGUI" lookup_object '"'$MEDIUM_PRODNAME'" {0}'`

	idlcall "$COLLOBJ" _set_label '"'$NEW_COLNAME'" {0}'
}



#----------------------------------------------------------
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

#DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

#
#       Process winstall variables 
#
ALL=false; REGION_ONLY=false; UNDO=false; COPY_FILES_ONLY=false; UNDO_INFRA=false
DO_JOBS=false; DO_FILEPACKS=false; DO_SENTRIES=false

# Bug on Solaris.  So try to get around it.
#
if [ ! -z "$UNINSTALL" ]; then

 if [ $UNINSTALL -eq 1 ]; then
  UNDO=true
  UNINSTALL_OPTS=""
 fi
fi

## cue off DOTASKS from winstall being either "0" or "1" to know
## if we're in incremental install mode ...
if [ "$DOTASKS" ]; then
  INCREMENTAL_INSTALL=true
  if [ $DOALL -eq 1 ]; then
    ALL=true
    UNINSTALL_OPTS="a"
  fi
else
  INCREMENTAL_INSTALL=false
  ALL=true
fi

if [ "$ALL" = false ]; then
  if [ $DOTASKS -eq 1 ]; then
    DO_JOBS=true
    UNINSTALL_OPTS="j${UNINSTALL_OPTS}"
  fi
  if [ $DOMONS -eq 1 ]; then
    DO_SENTRIES=true
    UNINSTALL_OPTS="s${UNINSTALL_OPTS}"
  fi
  if [ $DOFPS -eq 1 ]; then
    DO_FILEPACKS=true
    UNINSTALL_OPTS="f${UNINSTALL_OPTS}"
  fi
fi

export INCREMENTAL_INSTALL ALL DO_JOBS DO_SENTRIES DO_FILEPACKS UNDO

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/IM2
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh

#
#	This setting controls the task library creation behavior
#
USE_TLL=true; export USE_TLL

#
#	This setting determines if TMA (LCF endpoints) are supported in this install)
#
TMA_ENABLED=false		# was originally true - this allows us to customise the set_dep_sets
if wlookup -ar Gateway > /dev/null 2>& 1; then
  :
else
  echo "Dataless endpoints are not supported by this version of Tivoli" >& 2
  TMA_ENABLED=false
fi
export TMA_ENABLED

#
#       Use the MODULE setting to determine the patch id (for uninstall)
#
PATCH_ID=IM; export PATCH_ID

#
#	Use the module-level TaskRoles setting to set up a default ROLE for tasks
#
DEFAULT_TASKROLES=super; export DEFAULT_TASKROLES

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug

SCRIPTNAME=`echo $0 | tr "\\\\\\\\" "/"`
SCRIPTNAME=`basename $SCRIPTNAME`

[ -d "$DEBUGDIR" ] && exec > $DEBUGDIR/$SCRIPTNAME && DEBUG=true && set -xv
[ -f "$DEBUGDIR" ] && DEBUG=true && set -xv

chmod +x $LINKDIR/Link.install $LINKDIR/Link.init $LINKDIR/Link.cfg $LINKDIR/w* $LINKDIR/cfgappicon $LINKDIR/faux* $LINKDIR/*.sh
if $UNDO; then
  ## use existing undo interface to PLUSinstruct.sh ...
  $LINKDIR/PLUSinstruct.sh -ud${UNINSTALL_OPTS} ./PLUSproduct-info.sh

else
  ## do install
  . $LINKDIR/PLUSinstall.sh

  ###########################################################################
  #
  #  at this point the plus module has been installed.
  #  insert any code to run after installation here.
  #
  
   cleanup_desktop_collections
   rename_collection_object
   set_dep_sets

fi

wsetjob -j "About_Insight_Tivoli_Module (IM2)" -l "Insight Plus Configuration" -t "About_Insight_Tivoli_Module" -h $MNNAME

#
# Save the ALIDB_after files if $DEBUGDIR exists
#

set +e
if [ -d "$DEBUGDIR" ]; then
	cp $TEMP/IM_ALIDB_after.* $DEBUGDIR/. 2> /dev/null
	cp $TEMP/IM_DB_after.* $DEBUGDIR/. 2> /dev/null
fi
set -e

exit 0

